/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.services;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TopLevelDirectoryService {
    private static final int DEFAULT_EXEC_TIMEOUT = Integer.getInteger("TopLevelDirectoryService.default.exec.timeout", 120) * 1000;
    private static Logger _log = Logger.getLogger(TopLevelDirectoryService.class.getName());
    public static String GDR_SERIES_NAME = "GDR_MAIN_GENERIC";
    public static String GDR_PRODUCT_NAME = "GDR";
    public static String GDR_PATH_PROPERTY = "GDR_PATH";
    public static String ADE_VIEW_ROOT = "ADE_VIEW_ROOT";
    public static String ADE_DISABLED_PROPERTY = "TopLevelDirectoryService.ade.disabled";
    private static boolean _inAdeEnv = false;
    private static boolean _checkedInAdeEnv = false;
    private static Collection<AdeLabel> _adeLabels;
    private static String _backend;

    public static String getBackend() {
        return _backend;
    }

    public static File getTopLevelDirectory(File srchome, String value) throws GdrException {
        return TopLevelDirectoryService.getTopLevelDirectory(srchome, value, null);
    }

    public static File getTopLevelDirectory(File srchome, String value, String defaultTopLevelDir) throws GdrException {
        Path tld = TopLevelDirectoryService.getTopLevelDirectory(NioHelper.getInstance().getPath(srchome), value, defaultTopLevelDir);
        return tld != null ? tld.toFile() : null;
    }

    public static Path getTopLevelDirectory(Path srchome, String value, String defaultTopLevelDir) throws GdrException {
        String topLevelDir;
        if (srchome == null) {
            throw new GdrException("The SRCHOME provided was null.");
        }
        if (StringUtil.isNullOrEmpty((String)value)) {
            throw new GdrException("The product/series/label value provided was null.");
        }
        if (defaultTopLevelDir != null) {
            if (TopLevelDirectoryService.isInAdeEnv()) {
                Collection<AdeLabel> labels = TopLevelDirectoryService.getAdeLabels(value);
                if (labels != null && !labels.isEmpty()) {
                    boolean found = false;
                    for (AdeLabel label : labels) {
                        List<String> dirs = label.getTopLevelDirectories();
                        if (!dirs.contains(defaultTopLevelDir)) continue;
                        found = true;
                    }
                    if (!found) {
                        return null;
                    }
                } else {
                    _log.fine("Unable to verify top level directory \"" + defaultTopLevelDir + "\" for \"" + value + "\" since this is not a dependent product of the current view.");
                }
            }
            topLevelDir = defaultTopLevelDir;
        } else {
            topLevelDir = TopLevelDirectoryService.getTopLevelDirFromAde(value);
        }
        return srchome.resolve(topLevelDir);
    }

    public static File getAdeViewRoot() {
        String avr;
        if (!Boolean.getBoolean(ADE_DISABLED_PROPERTY) && !StringUtil.isNullOrEmpty((String)(avr = System.getenv(ADE_VIEW_ROOT)), (boolean)true)) {
            return new File(avr);
        }
        return null;
    }

    public static File getGdrLabelTopLevelDirectory(File srchome) throws FileNotFoundException, GdrException {
        String path = System.getProperty(GDR_PATH_PROPERTY);
        File dir = !StringUtil.isNullOrEmpty((String)path, (boolean)true) ? new File(path) : (TopLevelDirectoryService.isInAdeEnv() ? TopLevelDirectoryService.getTopLevelDirectory(srchome, GDR_PRODUCT_NAME) : TopLevelDirectoryService.getTopLevelDirectory(srchome, GDR_SERIES_NAME));
        if (dir == null) {
            throw new GdrException("The GDR top level directory did could not be determined.");
        }
        if (!dir.exists()) {
            throw new FileNotFoundException("Top level directory did not exist: " + dir);
        }
        return dir;
    }

    public static String getSeriesFromTopLevelDirectory(File directory) {
        return TopLevelDirectoryService.getSeriesFromTopLevelDirectory(directory.getName());
    }

    public static String getSeriesFromTopLevelDirectory(String dirName) {
        AdeLabel label = TopLevelDirectoryService.getAdeLabelForTopLevelDirectory(dirName);
        if (label != null) {
            return label.getSeries();
        }
        return dirName;
    }

    public static String getLabelFromTopLevelDirectory(File directory) {
        return TopLevelDirectoryService.getSeriesFromTopLevelDirectory(directory.getName());
    }

    public static String getLabelFromTopLevelDirectory(String dirName) {
        AdeLabel label = TopLevelDirectoryService.getAdeLabelForTopLevelDirectory(dirName);
        if (label != null) {
            return label.getLabel();
        }
        return dirName;
    }

    public static String getPrimaryProductLabel() throws GdrException {
        if (TopLevelDirectoryService.isInAdeEnv()) {
            for (AdeLabel label : _adeLabels) {
                if (!label.isPrimary()) continue;
                return label.getLabel();
            }
        } else {
            throw new GdrException("Unable to retrieve primary product label because not currently in an ADE view.");
        }
        return null;
    }

    public static boolean isInAdeEnv() {
        if (Boolean.getBoolean(ADE_DISABLED_PROPERTY)) {
            return false;
        }
        if (!_checkedInAdeEnv) {
            _inAdeEnv = TopLevelDirectoryService.isAdeAvailable();
            _checkedInAdeEnv = true;
        }
        return _inAdeEnv;
    }

    static boolean isAdeAvailable() {
        if (_adeLabels != null) {
            return true;
        }
        try {
            List<String> outputString = TopLevelDirectoryService.getCommandOutput("ade", "showdepprods");
            if (outputString != null && !outputString.isEmpty()) {
                _adeLabels = TopLevelDirectoryService.parseShowDepProds(outputString);
                for (String s : outputString) {
                    if (!s.contains("BACKEND")) continue;
                    int index = s.indexOf(":");
                    if (index <= -1 || s.length() <= index + 1) break;
                    _backend = s.substring(index + 1).trim();
                    break;
                }
                return true;
            }
        }
        catch (IOException e) {
            _log.log(Level.FINEST, "Unable to access ade.", e);
        }
        return false;
    }

    private static Collection<AdeLabel> parseShowDepProds(List<String> output) {
        ArrayList<AdeLabel> labels = null;
        if (output != null && !output.isEmpty()) {
            labels = new ArrayList<AdeLabel>();
            for (int x = 0; x < output.size(); ++x) {
                int index;
                String s = output.get(x);
                if (!s.contains("DEP_PROD") || (index = s.indexOf(":")) <= -1 || s.length() <= index + 1) continue;
                String depProd = s.substring(index + 1).trim();
                if (x >= output.size() - 1) continue;
                if ((s = output.get(++x)).contains("DEP_LABEL")) {
                    index = s.indexOf(":");
                    if (index <= -1 || s.length() <= index + 1) continue;
                    String label = s.substring(index + 1).trim();
                    boolean primary = false;
                    index = label.indexOf(" ");
                    if (index > -1) {
                        primary = label.endsWith(" (Primary Product for the view)");
                        label = label.substring(0, index);
                    }
                    AdeLabel adeLabel = new AdeLabel(depProd, label);
                    if (primary) {
                        adeLabel.setPrimary(true);
                    }
                    for (AdeLabel existingLabel : labels) {
                        if (!existingLabel.matchesSeries(adeLabel)) continue;
                        _log.warning("Current view contains multiple ADE labels from the same series: " + existingLabel + " and " + adeLabel);
                    }
                    labels.add(adeLabel);
                    index = label.lastIndexOf("_");
                    if (index <= -1 || x >= output.size() - 1) continue;
                    if ((s = output.get(++x)).contains("PRODUCT TOPLEVEL DIRS")) {
                        index = s.indexOf(":");
                        if (index <= -1 || s.length() <= index + 1) continue;
                        String topleveldirs = s.substring(index + 1).trim();
                        String[] dirs = topleveldirs.split(",");
                        adeLabel.setTopLevelDirectories(Arrays.asList(dirs));
                        continue;
                    }
                    --x;
                    continue;
                }
                --x;
            }
        }
        return labels;
    }

    public static String getTopLevelDirFromAde(String value) {
        Collection<AdeLabel> labels;
        if (TopLevelDirectoryService.isInAdeEnv() && !StringUtil.isNullOrEmpty((String)value, (boolean)true) && (labels = TopLevelDirectoryService.getAdeLabels(value)) != null && !labels.isEmpty()) {
            for (AdeLabel label : labels) {
                List<String> dirs = label.getTopLevelDirectories();
                if (dirs == null || dirs.isEmpty()) continue;
                return dirs.get(0);
            }
        }
        return value;
    }

    public static Collection<AdeLabel> getAdeLabels(String value) {
        ArrayList<AdeLabel> labels = new ArrayList<AdeLabel>();
        if (TopLevelDirectoryService.isInAdeEnv() && !StringUtil.isNullOrEmpty((String)value, (boolean)true)) {
            for (AdeLabel label : _adeLabels) {
                if (!label.matches(value)) continue;
                labels.add(label);
            }
        }
        return labels;
    }

    public static AdeLabel getAdeLabelForTopLevelDirectory(File directory) {
        return TopLevelDirectoryService.getAdeLabelForTopLevelDirectory(directory.getName());
    }

    public static AdeLabel getAdeLabelForTopLevelDirectory(String dirName) {
        if (TopLevelDirectoryService.isInAdeEnv() && !StringUtil.isNullOrEmpty((String)dirName, (boolean)true)) {
            for (AdeLabel label : _adeLabels) {
                List<String> dirs = label.getTopLevelDirectories();
                if (dirs == null || !dirs.contains(dirName)) continue;
                return label;
            }
        }
        return null;
    }

    public static void dumpLabels(OutputStream os) throws IOException {
        if (os != null && _adeLabels != null && !_adeLabels.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("BACKEND    : ").append(TopLevelDirectoryService.getBackend()).append("\n");
            for (AdeLabel label : _adeLabels) {
                sb.append("  DEP_PROD              : ").append(label.getDepProd()).append("\n");
                sb.append("     DEP_LABEL             : ").append(label);
                if (label.isPrimary()) {
                    sb.append(" (Primary Product for the view)");
                }
                sb.append("\n");
                sb.append("     PRODUCT TOPLEVEL DIRS : ").append(label.getTopLevelDirectoriesString()).append("\n");
            }
            os.write(sb.toString().getBytes());
            os.flush();
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            for (String arg : args) {
                Collection<AdeLabel> labels = TopLevelDirectoryService.getAdeLabels(arg);
                String tlds = "";
                if (labels != null && !labels.isEmpty()) {
                    for (AdeLabel label : labels) {
                        if (tlds.length() > 0) {
                            tlds = tlds + ",";
                        }
                        tlds = tlds + label.getTopLevelDirectoriesString();
                    }
                }
                System.out.println(arg + " : " + tlds);
            }
        } else {
            try {
                TopLevelDirectoryService.dumpLabels(System.out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<String> getCommandOutput(String ... command) throws IOException {
        return TopLevelDirectoryService.getCommandOutput(DEFAULT_EXEC_TIMEOUT, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getCommandOutput(int timeout, String ... command) throws IOException {
        int exitValue = 0;
        List<String> outputString = null;
        Process p = Runtime.getRuntime().exec(command);
        OutputThread output = new OutputThread(p.getInputStream(), "output");
        OutputThread error = new OutputThread(p.getErrorStream(), "error");
        output.start();
        error.start();
        boolean timeoutTriggered = false;
        TimeoutThread thread = new TimeoutThread(p, output);
        thread.start();
        try {
            thread.join(timeout);
            if (thread.getExitValue() != null) {
                exitValue = thread.getExitValue();
            } else {
                timeoutTriggered = true;
            }
            if (timeoutTriggered) {
                _log.fine("Process " + Arrays.asList(command) + " timeout of " + timeout + "ms was exceeded : " + output.getOutput());
                throw new IOException("Process " + Arrays.asList(command) + " timeout of " + timeout + "ms was exceeded : " + output.getOutput());
            }
            if (exitValue != 0) {
                _log.fine("Process " + Arrays.asList(command) + " execution failed: " + output.getOutput());
                throw new IOException("Process " + Arrays.asList(command) + " execution failed: " + output.getOutput());
            }
            outputString = output.getOutput();
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest(outputString.toString());
            }
        }
        catch (InterruptedException ie) {
            _log.log(Level.FINE, "Process interrupted.", ie);
            thread.interrupt();
            output.interrupt();
            error.interrupt();
        }
        finally {
            p.destroy();
        }
        return outputString;
    }

    public static class AdeLabel {
        String _depProd;
        String _product;
        String _version;
        String _platform;
        String _datetimstamp;
        List<String> _tlds = new ArrayList<String>();
        boolean _primary;

        public AdeLabel(String label) {
            this(null, label);
        }

        public AdeLabel(String depProd, String label) {
            String[] split;
            String[] stringArray = split = label != null ? label.trim().split("_") : null;
            if (split == null || split.length != 4) {
                throw new IllegalArgumentException("ADE Label value was in unexpected format: " + label);
            }
            this._product = split[0];
            this._version = split[1];
            this._platform = split[2];
            this._datetimstamp = split[3];
            this._depProd = depProd != null ? depProd : this._product;
        }

        public String getLabel() {
            return this.getSeries() + "_" + this.getDatetimstamp();
        }

        public String getSeries() {
            return this.getVersionedProduct() + "_" + this.getPlatform();
        }

        public String getVersionedProduct() {
            return this.getProduct() + "_" + this.getVersion();
        }

        public String getDepProd() {
            return this._depProd;
        }

        public String getProduct() {
            return this._product;
        }

        public String getVersion() {
            return this._version;
        }

        public String getPlatform() {
            return this._platform;
        }

        public String getDatetimstamp() {
            return this._datetimstamp;
        }

        public List<String> getTopLevelDirectories() {
            return this._tlds;
        }

        public String getTopLevelDirectoriesString() {
            StringBuilder sb = new StringBuilder();
            List<String> tlds = this.getTopLevelDirectories();
            if (tlds != null && !tlds.isEmpty()) {
                for (int x = 0; x < tlds.size(); ++x) {
                    if (x != 0) {
                        sb.append(",");
                    }
                    sb.append(tlds.get(x));
                }
            }
            return sb.toString();
        }

        void setTopLevelDirectories(Collection<String> tlds) {
            if (!this._tlds.isEmpty()) {
                this._tlds.clear();
            }
            if (tlds != null) {
                this._tlds.addAll(tlds);
            }
        }

        public boolean isPrimary() {
            return this._primary;
        }

        public void setPrimary(boolean primary) {
            this._primary = primary;
        }

        public boolean matches(String value) {
            if (value != null && value.length() > 0) {
                String[] split = value.split("_");
                if (split.length == 1) {
                    return value.equals(this.getProduct());
                }
                if (split.length == 2) {
                    return value.equals(this.getVersionedProduct());
                }
                if (split.length == 3) {
                    return value.equals(this.getSeries());
                }
                if (split.length == 4) {
                    return value.equals(this.getLabel());
                }
            }
            return false;
        }

        public boolean matchesSeries(AdeLabel adeLabel) {
            return this.getSeries().equals(adeLabel.getSeries());
        }

        public String toString() {
            return this.getLabel();
        }
    }

    static class OutputThread
    extends Thread {
        private InputStream _is;
        private List<String> _output = new ArrayList<String>();
        private boolean _done = false;

        public OutputThread(InputStream is, String name) {
            super(name);
            this._is = is;
        }

        public List<String> getOutput() {
            return this._output;
        }

        public boolean isDone() {
            return this._done;
        }

        @Override
        public void run() {
            try {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(this._is));
                while ((output = br.readLine()) != null) {
                    this._output.add(output + "\n");
                }
                this._done = true;
            }
            catch (IOException ioe) {
                _log.log(Level.FINE, ioe.getMessage(), ioe);
            }
        }
    }

    static class TimeoutThread
    extends Thread {
        private Process process;
        private OutputThread outputThread;
        private Integer exitValue;

        TimeoutThread(Process process, OutputThread outputThread) {
            this.process = process;
            this.outputThread = outputThread;
        }

        @Override
        public void run() {
            try {
                this.exitValue = this.process.waitFor();
                while (!this.outputThread.isDone()) {
                    TimeoutThread.sleep(1L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public Integer getExitValue() {
            return this.exitValue;
        }
    }
}

