/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.tools;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.gdr.FeatureConsumptionLoader;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.dbd.FeatureSetGroup;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.fsc.DistributionGroup;
import com.oracle.cie.gdr.dao.fsc.FeatureSetConsumption;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;

public class FeatureSetConsumer {
    private FeatureConsumptionLoader _featureConsumptionLoader;
    private Set<FeatureSet> _features;
    private File _gdrMetaDataHome;

    public FeatureSetConsumer(File gdrMetaDataHome, Set<FeatureSet> features) throws GdrException {
        this._gdrMetaDataHome = gdrMetaDataHome;
        this._features = features;
        this.init();
    }

    private void init() throws GdrException {
        this._featureConsumptionLoader = new FeatureConsumptionLoader(new MetaDataHome(this._gdrMetaDataHome), this._features);
    }

    public Set<FeatureSetReference> getConsumerFeatures(FeatureSetReference consumableFeature) throws IOException, DataHandlerException, GdrException {
        LinkedHashSet<FeatureSetReference> restrictedFeaturesRefs = new LinkedHashSet<FeatureSetReference>();
        for (FeatureSetConsumption featureConsumption : this._featureConsumptionLoader.getFeaturesConsumptions()) {
            if (!consumableFeature.getName().equals(featureConsumption.getName()) || !consumableFeature.getVersion().equals(featureConsumption.getVersion())) continue;
            for (FeatureSetGroup featureSetGroup : featureConsumption.getFeatureSetGroups()) {
                restrictedFeaturesRefs.addAll(featureSetGroup.getFeatures());
            }
        }
        return restrictedFeaturesRefs;
    }

    public Set<Reference> getConsumerDistributions(FeatureSetReference consumableFeature) {
        LinkedHashSet<Reference> restrictedDistRefs = new LinkedHashSet<Reference>();
        for (FeatureSetConsumption featureConsumption : this._featureConsumptionLoader.getFeaturesConsumptions()) {
            if (!consumableFeature.getName().equals(featureConsumption.getName()) || !consumableFeature.getVersion().equals(featureConsumption.getVersion())) continue;
            for (DistributionGroup distributionGroup : featureConsumption.getDistributionGroups()) {
                restrictedDistRefs.addAll(distributionGroup.getDistributions());
            }
        }
        return restrictedDistRefs;
    }

    public boolean isConsumer(Reference consumerDistribution, FeatureSetReference restrictedFeature) {
        return this.getConsumerDistributions(restrictedFeature).contains((Object)consumerDistribution);
    }

    public boolean isConsumer(FeatureSetReference consumerFeature, FeatureSetReference restrictedFeature) throws IOException, DataHandlerException, GdrException {
        return this.getConsumerFeatures(restrictedFeature).contains((Object)consumerFeature);
    }

    public Set<Distribution> getConsumerDistributions(Set<Distribution> distributions, FeatureSetReference consumableFeature) {
        LinkedHashSet<Distribution> allowedDistributions = new LinkedHashSet<Distribution>();
        block0: for (Reference allowedDistRef : this.getConsumerDistributions(consumableFeature)) {
            for (Distribution distribution : distributions) {
                if (!allowedDistRef.getName().equals(distribution.getName()) || !allowedDistRef.getVersion().equals(distribution.getVersion())) continue;
                allowedDistributions.add(distribution);
                continue block0;
            }
        }
        return allowedDistributions;
    }

    public Set<FeatureSet> getConsumerFeatures(Set<FeatureSet> features, FeatureSetReference consumableFeature) throws IOException, DataHandlerException, GdrException {
        LinkedHashSet<FeatureSet> allowedFeatures = new LinkedHashSet<FeatureSet>();
        block0: for (FeatureSetReference allowedFtrRef : this.getConsumerFeatures(consumableFeature)) {
            for (FeatureSet feature : features) {
                if (!allowedFtrRef.getName().equals(feature.getName()) || !allowedFtrRef.getVersion().equals(feature.getVersion())) continue;
                allowedFeatures.add(feature);
                continue block0;
            }
        }
        return allowedFeatures;
    }

    public boolean isConsumable(FeatureSet consumableFeature) {
        return !consumableFeature.getConsumptionType().equals("restricted") || this._featureConsumptionLoader.getFeatureConsumption(consumableFeature.getName(), consumableFeature.getVersion()) != null;
    }

    public Set<FeatureSet> getNonConsumableFeatures() {
        return this._featureConsumptionLoader.getNonConsumableFeatures();
    }
}

