/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.utils;

import com.oracle.cie.common.util.Checksum;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class DirectoryCompare {
    private File _dir1;
    private File _dir2;
    private Collection<String> _dir1Delta;
    private Collection<String> _dir2Delta;
    private Collection<String> _checksumDelta;

    public static void main(String[] args) {
        try {
            DirectoryCompare cmp = new DirectoryCompare(new File(args[0]), new File(args[1]));
            System.out.println(cmp.getReport());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public DirectoryCompare(File dir1, File dir2) throws IOException {
        this._dir1 = dir1;
        this._dir2 = dir2;
        TreeMap<String, Integer> dir1Files = new TreeMap<String, Integer>();
        TreeMap<String, Integer> dir2Files = new TreeMap<String, Integer>();
        this.find(dir1, dir1Files, dir1.getPath().length());
        this.find(dir2, dir2Files, dir2.getPath().length());
        this._dir1Delta = new ArrayList(dir1Files.keySet());
        this._dir1Delta.removeAll(dir2Files.keySet());
        this._dir2Delta = new ArrayList(dir2Files.keySet());
        this._dir2Delta.removeAll(dir1Files.keySet());
        this._checksumDelta = new ArrayList<String>();
        for (String path : dir1Files.keySet()) {
            if (!dir2Files.containsKey(path) || ((Integer)dir1Files.get(path)).equals(dir2Files.get(path))) continue;
            this._checksumDelta.add(path);
        }
    }

    public Collection<String> getDirectory1Delta() {
        return this._dir1Delta;
    }

    public Collection<String> getDirectory2Delta() {
        return this._dir2Delta;
    }

    public Collection<String> getChecksumDelta() {
        return this._checksumDelta;
    }

    public String getReport() {
        StringBuffer report = new StringBuffer();
        report.append("** Directory 1 (").append(this._dir1).append(") Delta **\n");
        for (String file : this.getDirectory1Delta()) {
            report.append("  ").append(file).append("\n");
        }
        report.append("\n");
        report.append("** Directory 2 (").append(this._dir2).append(") Delta **\n");
        for (String file : this.getDirectory2Delta()) {
            report.append("  ").append(file).append("\n");
        }
        report.append("\n");
        report.append("** Checksum Delta **\n");
        for (String file : this.getChecksumDelta()) {
            report.append("  ").append(file).append("\n");
        }
        return report.toString();
    }

    private void find(File file, Map<String, Integer> list, int trim) throws IOException {
        String path = file.getPath().substring(trim);
        if (file.isDirectory()) {
            File[] files;
            if (!path.trim().equals("")) {
                list.put(path, -1);
            }
            for (File f : files = file.listFiles()) {
                this.find(f, list, trim);
            }
        } else if (file.exists() && !path.trim().equals("")) {
            list.put(path, Checksum.getFileChksum((File)file));
        }
    }
}

