/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.utils;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.dao.cpd.Variable;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.services.VariableResolverService;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.nextgen.common.utils.UtilityOps;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MsidUtil {
    private static final Logger _log = Logger.getLogger(MsidUtil.class.getName());
    public static final String MSID_TIMESTAMP_KEY = "MSI_TIMESTAMP";
    public static final String MSID_DISABLE_VAR = "oracle.installer.disableMSID";
    private static final String MSID_TIMESTAMP_TAG = "%MSI_TIMESTAMP%";

    public static void initMsidVariables(ComponentTarget target) throws GdrException {
        Variable msidComponentVariable = MsidUtil.getMsidComponentVariable(target);
        if (msidComponentVariable == null) {
            return;
        }
        ServiceHolder serviceHolder = target.getServicesHolder();
        String namespace = serviceHolder.getNamespace();
        VariableResolverService variableResolverService = serviceHolder.getVariableResolverService();
        Variable msidGlobalVariable = variableResolverService.getVariable(MSID_TIMESTAMP_KEY);
        String disableVariable = variableResolverService.get(MSID_DISABLE_VAR);
        String msidValue = "";
        String msidValueOverride = "";
        if (!Boolean.parseBoolean(disableVariable)) {
            msidValueOverride = msidGlobalVariable == null ? "" : msidGlobalVariable.getValue();
            String string = msidValue = StringUtil.isNullOrEmpty((String)msidValueOverride, (boolean)true) ? msidComponentVariable.getValue() : msidValueOverride;
            if (StringUtil.isNullOrEmpty((String)msidValue, (boolean)true)) {
                try {
                    msidValue = UtilityOps.getSessionTimeStamp(null);
                }
                catch (ParseException e) {
                    throw new GdrException("Error generating Session Time Stamp for MSI-D Process.", (Throwable)e);
                }
            }
        }
        msidComponentVariable.setValue(msidValue);
        variableResolverService.set(namespace, MSID_TIMESTAMP_KEY, msidValue);
    }

    private static Variable getMsidComponentVariable(ComponentTarget target) {
        for (Variable variable : target.getComponent().getVariables()) {
            if (!variable.getName().equals(MSID_TIMESTAMP_KEY)) continue;
            return variable;
        }
        return null;
    }

    public static boolean isMSIDTagged(String dest) {
        return dest != null && dest.contains(MSID_TIMESTAMP_TAG);
    }

    public static boolean getMsidTimestampFromPointerFile(ComponentTarget target, String destination, String pointerOriginalName) throws GdrException {
        Objects.requireNonNull(target);
        Objects.requireNonNull(destination);
        Objects.requireNonNull(pointerOriginalName);
        if (StringUtil.isNullOrEmpty((String)destination) || StringUtil.isNullOrEmpty((String)pointerOriginalName)) {
            throw new GdrException("Parameters destination and prefixPointerFile can not be empty!");
        }
        destination = destination.trim();
        Variable msidComponentVariable = MsidUtil.getMsidComponentVariable(target);
        VariableResolverService variableResolverService = target.getServicesHolder().getVariableResolverService();
        String disableVariable = variableResolverService.get(MSID_DISABLE_VAR);
        String msidGlobalVariable = variableResolverService.get(MSID_TIMESTAMP_KEY);
        if (Boolean.parseBoolean(disableVariable) || !StringUtil.isNullOrEmpty((String)msidGlobalVariable, (boolean)true)) {
            return false;
        }
        String oracleHome = variableResolverService.get("ORACLE_HOME");
        String namespace = target.getServicesHolder().getNamespace();
        if (oracleHome == null) {
            oracleHome = "";
        }
        oracleHome = oracleHome.replace("\\", "/");
        Path dir = Paths.get(oracleHome, destination);
        Path msidTimestamp = null;
        if (!Files.exists(dir, new LinkOption[0])) {
            _log.warning("Path [" + dir + "] does not exist.");
            return false;
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            _log.warning("Path [" + dir + "] is not a directory.");
            return false;
        }
        int msiTagIndex = pointerOriginalName.indexOf(MSID_TIMESTAMP_TAG);
        String prefixPointerFile = null;
        if (msiTagIndex == -1) {
            return false;
        }
        prefixPointerFile = pointerOriginalName.substring(0, msiTagIndex);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, prefixPointerFile + "*");){
            for (Path entry : stream) {
                _log.info("Entry:" + entry);
                msidTimestamp = msidTimestamp == null || msidTimestamp.compareTo(entry) < 0 ? entry : msidTimestamp;
            }
        }
        catch (IOException | DirectoryIteratorException e) {
            _log.log(Level.SEVERE, e.getMessage(), e);
        }
        if (msidTimestamp == null) {
            return false;
        }
        String msidValue = msidTimestamp.getFileName().toString().replace(prefixPointerFile, "");
        msidComponentVariable.setValue(msidValue);
        variableResolverService.set(namespace, MSID_TIMESTAMP_KEY, msidValue);
        return true;
    }
}

