/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xml.ws.wsu10.bindings;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import oracle.security.xml.ws.wsu10.bindings.AttributedDateTime;

public class AttributedDateTimeAdapter
extends XmlAdapter<String, AttributedDateTime> {
    private static Logger logger = Logger.getLogger(AttributedDateTimeAdapter.class.getName());
    private static SimpleDateFormat FORMATTER1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'", Locale.getDefault());
    private static SimpleDateFormat FORMATTER2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.getDefault());

    public AttributedDateTimeAdapter() {
        FORMATTER1.setTimeZone(TimeZone.getTimeZone("UTC"));
        FORMATTER2.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String marshal(AttributedDateTime adt) throws Exception {
        try {
            if (adt != null) {
                logger.info(adt.toString());
                SimpleDateFormat simpleDateFormat = FORMATTER1;
                synchronized (simpleDateFormat) {
                    return FORMATTER1.format(adt.getValue());
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, String.format("Failed to format date %s", adt.toString()), e);
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributedDateTime unmarshal(String s_adt) throws Exception {
        logger.info(s_adt);
        AttributedDateTime ad = new AttributedDateTime();
        if (s_adt == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = FORMATTER1;
            synchronized (simpleDateFormat) {
                ad.setValue(FORMATTER1.parse(s_adt));
                return ad;
            }
        }
        catch (ParseException e) {
            try {
                SimpleDateFormat simpleDateFormat = FORMATTER2;
                synchronized (simpleDateFormat) {
                    ad.setValue(FORMATTER2.parse(s_adt));
                    return ad;
                }
            }
            catch (ParseException pex) {
                throw new RuntimeException(pex);
            }
        }
    }
}

