/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.soap;

import java.util.ArrayList;
import java.util.List;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.enc.XEEncryptedData;
import oracle.security.xmlsec.enc.XEEncryptedKey;
import oracle.security.xmlsec.enc.XEException;
import oracle.security.xmlsec.soap.v12.SOAPEnvelope;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSecurity;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WSSOAP12Envelope
extends SOAPEnvelope {
    public WSSOAP12Envelope(Element element) {
        super(element);
    }

    public WSSOAP12Envelope(Element element, String systemId) {
        super(element, systemId);
    }

    public WSSOAP12Envelope(Document document) {
        super(document);
    }

    public void addSecurity(WSSecurity security) {
        Document tDoc;
        WSSecurity sec = security;
        Document doc = this.getOwnerDocument();
        if (doc != (tDoc = security.getOwnerDocument())) {
            sec = new WSSecurity((Element)doc.importNode(security.getNode(), true));
        }
        this.addHeaderElement(sec);
    }

    public List getSecurity() {
        return this.getSecurity(null, false);
    }

    public List getSecuritys() {
        Element header = this.getHeader();
        if (header == null) {
            return new ArrayList();
        }
        NodeList list = XMLElement.getChildElementsByTagNameNS((Element)header, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", (String)"Security");
        ArrayList<WSSecurity> vec = null;
        for (int i = 0; i < list.getLength(); ++i) {
            vec = new ArrayList<WSSecurity>();
            Element element = (Element)list.item(i);
            vec.add(new WSSecurity(element, this.getSystemId()));
        }
        return vec;
    }

    public List getSecurity(String role) {
        Element header = this.getHeader();
        if (header == null) {
            return new ArrayList();
        }
        NodeList list = XMLElement.getChildElementsByTagNameNS((Element)header, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", (String)"Security");
        ArrayList<WSSecurity> vec = null;
        for (int i = 0; i < list.getLength(); ++i) {
            vec = new ArrayList<WSSecurity>();
            Element element = (Element)list.item(i);
            String at = element.getAttributeNS("http://www.w3.org/2003/05/soap-envelope", "role");
            if (role == null || !role.equals(at)) continue;
            vec.add(new WSSecurity(element, this.getSystemId()));
        }
        return vec;
    }

    public List getSecurity(String role, boolean mustUnderstand) {
        Element header = this.getHeader();
        if (header == null) {
            return new ArrayList();
        }
        NodeList list = XMLElement.getChildElementsByTagNameNS((Element)header, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", (String)"Security");
        ArrayList<WSSecurity> vec = null;
        for (int i = 0; i < list.getLength(); ++i) {
            vec = new ArrayList<WSSecurity>();
            Element element = (Element)list.item(i);
            boolean mu = "1".equals(element.getAttributeNS("http://www.w3.org/2003/05/soap-envelope", "mustUnderstand"));
            String at = element.getAttributeNS("http://www.w3.org/2003/05/soap-envelope", "role");
            if ((role != null || at != null && at.length() != 0) && (role == null || !role.equals(at)) || mustUnderstand != mu) continue;
            vec.add(new WSSecurity(element, this.getSystemId()));
        }
        return vec;
    }

    public void removeSecurity(WSSecurity security) {
        Element header = this.getHeader();
        if (header != null) {
            header.removeChild(security.getNode());
        }
    }

    public void addWsuIdToBody(String id) {
        WSSOAP12Envelope.addWsuIdToElement(id, this.getBody());
    }

    public static void addWsuIdToElement(String id, Element element) {
        String name = "Id";
        String prefix = XMLElement.getDefaultNSPrefix((String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        if (prefix != null && prefix.length() != 0) {
            name = prefix + ":" + name;
        }
        element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", name, id);
        XMLElement.addNSPrefixAttrDefault((Element)element, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
    }

    public void decryptAll() throws WSSException {
        int i;
        NodeList list = this.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
        int j = list.getLength();
        if (j != 0) {
            for (i = 0; i < j; ++i) {
                WSSecurity.decrypt(new XEEncryptedKey((Element)list.item(0)));
            }
        }
        if ((j = (list = this.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData")).getLength()) != 0) {
            for (i = 0; i < j; ++i) {
                try {
                    XEEncryptedData.decryptAndReplace((Element)((Element)list.item(0)));
                    continue;
                }
                catch (XEException ex) {
                    throw new WSSException(ex, WSSException.INVALID_SECURITY);
                }
                catch (DOMException ex) {
                    throw new WSSException(ex, WSSException.FAILED_CHECK);
                }
            }
        }
    }

    public void verifyAll() throws WSSException {
        NodeList sigList = this.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        int j = sigList.getLength();
        for (int i = 0; i < j; ++i) {
            XSSignature sig = new XSSignature((Element)sigList.item(i));
            WSSecurity.verify(sig, true);
        }
    }
}

