/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.dao.jaxb;

import com.oracle.cie.common.dao.CachingDataHandler;
import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.jaxb.JaxbDataHandlerSpiImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.util.JAXBSource;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class JaxbDataHandler
extends CachingDataHandler {
    private static final Logger _log = Logger.getLogger(JaxbDataHandler.class.getName());
    private static Map<Class<?>, TypeInfo> _typeInfoCache = new HashMap();
    private Object _object;
    private String _element;
    private TypeInfo _typeInfo;
    private String _encoding;
    private static final boolean dropFileMaps = Boolean.getBoolean("comp.dropFileMapContents");
    private static CompFMMethods s_compFM = null;

    private static synchronized CompFMMethods getCompFMMethods() {
        if (s_compFM != null) {
            return s_compFM;
        }
        s_compFM = new CompFMMethods();
        return s_compFM;
    }

    public JaxbDataHandler(Object object, String element) {
        this._object = object;
        this._element = element;
        this.loadTypeInfo(this._object.getClass());
        if (dropFileMaps && this._object.getClass().getName().equals("com.oracle.cie.gdr.xml.cpd.ComponentDefType")) {
            this.dropFileMapContents(this._object);
        }
    }

    private void loadTypeInfo(Class<?> cls) {
        this._typeInfo = _typeInfoCache.get(cls);
        if (this._typeInfo == null) {
            this._typeInfo = new TypeInfo(cls);
            _typeInfoCache.put(cls, this._typeInfo);
        }
    }

    private void dropFileMapContents(Object component) {
        block4: {
            try {
                CompFMMethods cfm = JaxbDataHandler.getCompFMMethods();
                cfm.initCompMethods(component.getClass());
                String name = (String)cfm.compGetName.invoke(component, new Object[0]);
                String version = (String)cfm.compGetVersion.invoke(component, new Object[0]);
                List filemaps = (List)cfm.compGetFileMap.invoke(component, new Object[0]);
                for (Object fm : filemaps) {
                    cfm.initFMMethods(fm.getClass());
                    String symbol = (String)cfm.fmGetSymbol.invoke(fm, new Object[0]);
                    String source = (String)cfm.fmGetSource.invoke(fm, new Object[0]);
                    List filegroups = (List)cfm.fmGetFileGroupType.invoke(fm, new Object[0]);
                    if (filegroups.isEmpty()) continue;
                    if (_log.isLoggable(Level.FINER)) {
                        _log.log(Level.FINER, "Filemap has " + filegroups.size() + " elements - attempting to zero out element");
                    }
                    cfm.fmFileGroupType.set(fm, new ArrayList());
                }
            }
            catch (Exception ex) {
                if (!_log.isLoggable(Level.FINER)) break block4;
                _log.log(Level.FINER, "Exception in dropFileMapContents", ex);
            }
        }
    }

    @Override
    public String getElement() {
        return this._element;
    }

    @Override
    public String getType() {
        XmlType xmlType = this._object.getClass().getAnnotation(XmlType.class);
        return xmlType != null ? xmlType.name() : null;
    }

    @Override
    public String getNamespace() {
        XmlSchema xmlSchema;
        String namespace = null;
        XmlType xmlType = this._object.getClass().getAnnotation(XmlType.class);
        if (xmlType != null) {
            namespace = xmlType.namespace();
        }
        if ((namespace == null || namespace.length() < 1 || "##default".equals(namespace)) && (xmlSchema = this._object.getClass().getPackage().getAnnotation(XmlSchema.class)) != null) {
            namespace = xmlSchema.namespace();
        }
        return namespace;
    }

    @Override
    public Object getSimpleContent() {
        Object value = null;
        if (this._typeInfo.hasSimpleContentField()) {
            value = this.getValueFromObject(this._typeInfo.getSimpleContentField().getName());
        }
        return value;
    }

    @Override
    public Object getAttributeValueInternal(String name) {
        Object o;
        block3: {
            o = this.getValueFromObject(name);
            if (o != null && o.getClass().isEnum()) {
                try {
                    o = o.getClass().getMethod("value", new Class[0]).invoke(o, new Object[0]);
                }
                catch (Exception e) {
                    if (!_log.isLoggable(Level.FINER)) break block3;
                    _log.log(Level.FINER, "Error getting enum value for " + name, e);
                }
            }
        }
        return o;
    }

    @Override
    public void setAttributeValueInternal(String name, Object value) {
        this.setValueToObject(name, value);
    }

    @Override
    public Object getSimpleValueInternal(String name) {
        Object obj = this.getValueFromObject(name);
        if (obj != null && !obj.getClass().isArray() && List.class.isAssignableFrom(obj.getClass())) {
            Object[] array;
            List list = (List)obj;
            Class<?> typeClass = this.getGenericClass(this._typeInfo.getSimpleElementField(name));
            if (typeClass != null) {
                array = (Object[])Array.newInstance(typeClass, list.size());
            } else if (!list.isEmpty()) {
                array = (Object[])Array.newInstance(list.get(0).getClass(), list.size());
            } else {
                return list.toArray();
            }
            return list.toArray(array);
        }
        return obj;
    }

    @Override
    public void setSimpleValueInternal(String name, Object value) {
        Object object = this.getValueFromObject(name);
        if (object != null && List.class.isAssignableFrom(object.getClass())) {
            List list = (List)object;
            list.clear();
            if (value != null && value.getClass().isArray()) {
                list.addAll(Arrays.asList((Object[])value));
            }
        } else {
            this.setValueToObject(name, value);
        }
    }

    @Override
    public IDataHandler[] getComplexValueInternal(String name) {
        if (this._typeInfo.isUnsequencedComplexType(name)) {
            Class<?> type = this._typeInfo.getComplexElementType(name);
            Field f = this._typeInfo.getComplexElementField(name);
            String property = this.capitalize(f.getName());
            List list = (List)this.getValueFromObject(property);
            ArrayList<Object> typeList = new ArrayList<Object>();
            if (this._typeInfo.isJaxbElementFieldType(name)) {
                for (Object o : list) {
                    JAXBElement jaxbElement = (JAXBElement)o;
                    if (!name.equals(jaxbElement.getName().getLocalPart())) continue;
                    typeList.add(jaxbElement.getValue());
                }
            } else {
                for (Object o : list) {
                    if (!o.getClass().isAssignableFrom(type)) continue;
                    typeList.add(o);
                }
            }
            IDataHandler[] array = new JaxbDataHandler[typeList.size()];
            for (int x = 0; x < typeList.size(); ++x) {
                array[x] = new JaxbDataHandler(typeList.get(x), name);
            }
            return array;
        }
        Object o = this.getValueFromObject(name);
        if (o != null) {
            if (o instanceof List) {
                List list = (List)o;
                IDataHandler[] array = new JaxbDataHandler[list.size()];
                for (int x = 0; x < list.size(); ++x) {
                    array[x] = new JaxbDataHandler(list.get(x), name);
                }
                return array;
            }
            return new JaxbDataHandler[]{new JaxbDataHandler(o, name)};
        }
        return new IDataHandler[0];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setComplexValueInternal(String name, IDataHandler[] value) {
        if (this._typeInfo.isUnsequencedComplexType(name)) {
            IDataHandler handler;
            int n;
            IDataHandler[] iDataHandlerArray;
            Class<?> type = this._typeInfo.getComplexElementType(name);
            Field f = this._typeInfo.getComplexElementField(name);
            String property = this.capitalize(f.getName());
            List list = (List)this.getValueFromObject(property);
            ArrayList<Object> valueObjects = new ArrayList<Object>();
            if (this._typeInfo.isJaxbElementFieldType(name)) {
                if (value != null) {
                    void var10_20;
                    iDataHandlerArray = value;
                    n = iDataHandlerArray.length;
                    boolean bl = false;
                    while (var10_20 < n) {
                        handler = iDataHandlerArray[var10_20];
                        String elementName = handler.getElement();
                        if (!this._typeInfo.isJaxbElementFieldType(elementName)) {
                            elementName = name;
                        }
                        JAXBElement jbe = new JAXBElement(new QName(handler.getNamespace(), elementName), handler.getObject().getClass(), this.getObject().getClass(), handler.getObject());
                        valueObjects.add(jbe);
                        ++var10_20;
                    }
                }
            } else if (value != null) {
                void var10_22;
                iDataHandlerArray = value;
                n = iDataHandlerArray.length;
                boolean bl = false;
                while (var10_22 < n) {
                    handler = iDataHandlerArray[var10_22];
                    valueObjects.add(handler.getObject());
                    ++var10_22;
                }
            }
            Iterator it = list.iterator();
            while (it.hasNext()) {
                void var10_26;
                String elementName;
                Object o = it.next();
                if (o instanceof JAXBElement) {
                    Class clazz = ((JAXBElement)o).getDeclaredType();
                    elementName = ((JAXBElement)o).getName().getLocalPart();
                } else {
                    Class<?> clazz = o.getClass();
                    elementName = name;
                }
                if (!var10_26.isAssignableFrom(type) || !elementName.equals(name)) continue;
                if (valueObjects.contains(o)) {
                    valueObjects.remove(o);
                    continue;
                }
                it.remove();
            }
            for (Object e : valueObjects) {
                list.add(e);
            }
        } else {
            Field field = this._typeInfo.getComplexElementField(name);
            if (List.class.isAssignableFrom(field.getType())) {
                List list = (List)this.getValueFromObject(name);
                list.clear();
                if (value != null && value.length > 0) {
                    for (IDataHandler handler : value) {
                        list.add(handler.getObject());
                    }
                }
            } else {
                Object obj = value != null && value.length > 0 ? value[0].getObject() : null;
                this.setValueToObject(name, obj);
            }
        }
    }

    @Override
    public void setComplexValueInternal(String name, IDataHandler dataHandler) {
        Field f = this._typeInfo.getComplexElementField(name);
        if (dataHandler == null) {
            this.setValueToObject(name, null);
        } else {
            Object obj = this._typeInfo.isJaxbElementFieldType(name) ? new JAXBElement(new QName(dataHandler.getNamespace(), dataHandler.getElement()), dataHandler.getObject().getClass(), this.getObject().getClass(), dataHandler.getObject()) : dataHandler.getObject();
            if (f.getType().isArray()) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(obj);
                this.setValueToObject(name, list);
            } else {
                this.setValueToObject(name, obj);
            }
        }
    }

    @Override
    public IDataHandler createComplexValue(String name) {
        Field f = this._typeInfo.getComplexElementField(name);
        if (f != null) {
            if (!f.getType().isAssignableFrom(List.class)) {
                IDataHandler[] current = this.getComplexValue(name);
                if (current != null && current.length > 0) {
                    return current[0];
                }
                return this.createType(name, f.getType());
            }
            String property = this._typeInfo.isUnsequencedComplexType(name) ? this.capitalize(f.getName()) : f.getName();
            List list = (List)this.getValueFromObject(property);
            IDataHandler dh = null;
            if (this._typeInfo.isUnsequencedComplexType(name)) {
                dh = this.createType(name, this._typeInfo.getComplexElementType(name));
            } else {
                Class<?> genericClass = this.getGenericClass(f);
                if (genericClass != null) {
                    dh = this.createType(name, genericClass);
                }
                if (dh == null) {
                    if (!list.isEmpty()) {
                        dh = this.createType(name, list.get(0).getClass());
                    } else {
                        if (_log.isLoggable(Level.FINEST)) {
                            _log.finest("Unable to determine type for element \"" + name + "\" delegating to SPI.");
                        }
                        dh = new JaxbDataHandlerSpiImpl().create(this.getNamespace(), name, this.getObject().getClass().getClassLoader());
                    }
                }
            }
            return dh;
        }
        return null;
    }

    private Class<?> getGenericClass(Field field) {
        Type t;
        ParameterizedType pType;
        Type[] types;
        Type type;
        if (field != null && (type = field.getGenericType()) != null && type instanceof ParameterizedType && (types = (pType = (ParameterizedType)type).getActualTypeArguments()) != null && types.length > 0 && (t = types[0]) instanceof Class) {
            return (Class)t;
        }
        return null;
    }

    @Override
    public IDataHandler addComplexValueInternal(String name) {
        Field f = this._typeInfo.getComplexElementField(name);
        if (f != null) {
            IDataHandler dh;
            if (!f.getType().isAssignableFrom(List.class)) {
                IDataHandler[] current = this.getComplexValue(name);
                if (current != null && current.length > 0) {
                    return current[0];
                }
                IDataHandler dh2 = this.createType(name, f.getType());
                this.addComplexValue(name, dh2);
                return dh2;
            }
            String property = this._typeInfo.isUnsequencedComplexType(name) ? this.capitalize(f.getName()) : f.getName();
            List list = (List)this.getValueFromObject(property);
            if (this._typeInfo.isUnsequencedComplexType(name)) {
                dh = this.createType(name, this._typeInfo.getComplexElementType(name));
            } else if (!list.isEmpty()) {
                dh = this.createType(name, list.get(0).getClass());
            } else {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("Unable to determine type for element \"" + name + "\" delegating to SPI.");
                }
                dh = new JaxbDataHandlerSpiImpl().create(this.getNamespace(), name, this.getObject().getClass().getClassLoader());
            }
            this.addComplexValueToList(name, list, dh);
            return dh;
        }
        return null;
    }

    @Override
    public void addComplexValueInternal(String name, IDataHandler dataHandler) {
        Field f = this._typeInfo.getComplexElementField(name);
        if (f != null) {
            if (!f.getType().isAssignableFrom(List.class)) {
                this.setComplexValue(name, dataHandler);
            } else {
                String property = this._typeInfo.isUnsequencedComplexType(name) ? this.capitalize(f.getName()) : f.getName();
                List list = (List)this.getValueFromObject(property);
                this.addComplexValueToList(name, list, dataHandler);
            }
        }
    }

    private void addComplexValueToList(String name, List<Object> list, IDataHandler dataHandler) {
        if (this._typeInfo.isJaxbElementFieldType(name)) {
            JAXBElement jbe = new JAXBElement(new QName(dataHandler.getNamespace(), dataHandler.getElement()), dataHandler.getObject().getClass(), dataHandler.getObject());
            list.add(jbe);
        } else {
            list.add(dataHandler.getObject());
        }
    }

    private IDataHandler createType(String name, Class<?> typeClass) {
        block3: {
            if (typeClass != null) {
                try {
                    Class<?> objFactoryClass = typeClass.getClassLoader().loadClass(typeClass.getPackage().getName() + ".ObjectFactory");
                    Object objfac = objFactoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    Object o = objFactoryClass.getMethod("create" + typeClass.getSimpleName(), new Class[0]).invoke(objfac, new Object[0]);
                    return new JaxbDataHandler(o, name);
                }
                catch (Exception e) {
                    if (!_log.isLoggable(Level.WARNING)) break block3;
                    _log.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
        return null;
    }

    public Class<?> getObjectFactoryClass() throws ClassNotFoundException {
        return this.getObjectFactoryClass(null);
    }

    public Class<?> getObjectFactoryClass(Class<?> typeClass) throws ClassNotFoundException {
        if (typeClass == null) {
            typeClass = this.getObject().getClass();
        }
        return this.getObject().getClass().getClassLoader().loadClass(typeClass.getPackage().getName() + ".ObjectFactory");
    }

    @Override
    public String[] getAttributeNames() {
        return this._typeInfo.getAttributeNames();
    }

    @Override
    public boolean hasAttributeName(String name) {
        return this._typeInfo.hasAttributeName(name);
    }

    public Class getAttributeType(String name) {
        return this._typeInfo.getAttributeType(name);
    }

    @Override
    public String[] getSimpleNames() {
        return this._typeInfo.getSimpleNames();
    }

    @Override
    public boolean hasSimpleName(String name) {
        return this._typeInfo.hasSimpleName(name);
    }

    public Class getSimpleType(String name) {
        Class<?> type = this._typeInfo.getSimpleElementType(name);
        if (List.class.isAssignableFrom(type) && (type = this.getGenericClass(this._typeInfo.getSimpleElementField(name))) == null) {
            type = this._typeInfo.getSimpleElementType(name);
        }
        return type;
    }

    @Override
    public String[] getComplexNames() {
        return this._typeInfo.getComplexNames();
    }

    @Override
    public boolean hasComplexName(String name) {
        return this._typeInfo.hasComplexName(name);
    }

    @Override
    public Object getObject() {
        return this._object;
    }

    @Override
    public void save(File file) throws DataHandlerException {
        File parent;
        if (file != null && (parent = file.getParentFile()) != null) {
            parent.mkdirs();
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            this.save(fos);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new DataHandlerException(e);
        }
    }

    @Override
    public void save(OutputStream os) throws DataHandlerException {
        this.save(os, false);
    }

    @Override
    public void save(XMLStreamWriter writer) throws DataHandlerException {
        try {
            Marshaller marshaller = this.getMarshaller();
            JAXBElement element = new JAXBElement(new QName(this.getNamespace(), this.getElement()), this._object.getClass(), this._object);
            marshaller.marshal((Object)element, writer);
        }
        catch (Exception e) {
            throw new DataHandlerException(e);
        }
    }

    protected void save(OutputStream os, boolean fragment) throws DataHandlerException {
        try {
            Marshaller marshaller = this.getMarshaller();
            JAXBElement element = new JAXBElement(new QName(this.getNamespace(), this.getElement()), this._object.getClass(), this._object);
            if (fragment) {
                marshaller.setProperty("jaxb.fragment", (Object)true);
                marshaller.marshal((Object)element, os);
            } else {
                OutputStreamWriter dataWriter = new OutputStreamWriter(os, "UTF-8");
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer t = tf.newTransformer();
                t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                t.setOutputProperty("indent", "yes");
                t.setOutputProperty("standalone", "yes");
                JAXBSource source = new JAXBSource(marshaller, (Object)element);
                StreamResult result = new StreamResult(dataWriter);
                t.transform((Source)source, result);
            }
        }
        catch (Exception e) {
            throw new DataHandlerException(e);
        }
    }

    protected Marshaller getMarshaller() throws DataHandlerException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)this._object.getClass().getPackage().getName(), (ClassLoader)this._object.getClass().getClassLoader());
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            return marshaller;
        }
        catch (Exception e) {
            throw new DataHandlerException(e);
        }
    }

    @Override
    public void save(StringBuffer sb) throws DataHandlerException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.save(baos);
        sb.append(baos.toString());
    }

    @Override
    public void saveJson(File file) throws DataHandlerException {
        try {
            JaxbDataHandler.class.getClassLoader().loadClass("com.oracle.cie.common.dao.jaxb.JaxbJsonHandler").getMethod("saveJson", Object.class, File.class).invoke(null, this.getObject(), file);
        }
        catch (Exception e) {
            throw new DataHandlerException("Failed to save JSON to file " + file, e);
        }
    }

    @Override
    public void saveJson(OutputStream os) throws DataHandlerException {
        try {
            JaxbDataHandler.class.getClassLoader().loadClass("com.oracle.cie.common.dao.jaxb.JaxbJsonHandler").getMethod("saveJson", Object.class, OutputStream.class).invoke(null, this.getObject(), os);
        }
        catch (Exception e) {
            throw new DataHandlerException("Failed to save JSON to output stream.", e);
        }
    }

    @Override
    public IDataHandler copy() {
        if (Cloneable.class.isAssignableFrom(this._object.getClass())) {
            try {
                return new JaxbDataHandler(this._object.getClass().getMethod("clone", new Class[0]).invoke(this._object, new Object[0]), this.getElement());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public boolean validate() {
        try {
            Schema schema = JaxbDataHandlerSpiImpl.getSchema(this.getNamespace(), this.getElement(), this._object.getClass().getClassLoader());
            if (schema != null) {
                JAXBContext jaxbContext = JAXBContext.newInstance((String)this._object.getClass().getPackage().getName(), (ClassLoader)this._object.getClass().getClassLoader());
                Marshaller marshaller = jaxbContext.createMarshaller();
                marshaller.setSchema(schema);
                JAXBElement element = new JAXBElement(new QName(this.getNamespace(), this.getElement()), this._object.getClass(), this._object);
                marshaller.marshal((Object)element, (ContentHandler)new DefaultHandler());
            } else {
                _log.warning("Unable to locate schema for element: " + this.getElement() + "@" + this.getNamespace() + " (Note: The JaxbDataHandler does not currently support validation of xml fragments.)");
            }
        }
        catch (JAXBException e) {
            _log.log(Level.SEVERE, "Validation failed.", e);
            return false;
        }
        catch (Exception e) {
            _log.log(Level.FINE, e.getMessage(), e);
        }
        return true;
    }

    @Override
    public String[] getComments() {
        return new String[0];
    }

    public Object getValueFromObject(String name) {
        try {
            String property = JaxbDataHandlerSpiImpl.getPropertyFromElement(name);
            Class<?> objCls = this._object.getClass();
            Method method = null;
            try {
                method = objCls.getMethod("get" + property, new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                try {
                    method = objCls.getMethod("is" + property, new Class[0]);
                }
                catch (NoSuchMethodException nsme1) {
                    _log.warning("Unable to locate \"get\" or \"is\" method for " + property);
                }
            }
            if (method != null) {
                return method.invoke(this._object, new Object[0]);
            }
        }
        catch (Exception e) {
            _log.warning("Unable to get value for property " + name + " on " + this._object);
        }
        return null;
    }

    public void setValueToObject(String name, Object value) {
        try {
            String methodName = "set" + JaxbDataHandlerSpiImpl.getPropertyFromElement(name);
            Method method = null;
            for (Method m : this._object.getClass().getMethods()) {
                if (!methodName.equals(m.getName()) || m.getParameterTypes() == null || m.getParameterTypes().length != 1) continue;
                method = m;
                break;
            }
            if (method != null) {
                Object actualValue = value;
                if (actualValue != null) {
                    Class<?>[] params = method.getParameterTypes();
                    if (params[0].isEnum() && value instanceof String) {
                        Method enumMethod = params[0].getMethod("fromValue", String.class);
                        if (enumMethod != null) {
                            actualValue = enumMethod.invoke(null, value);
                        }
                    } else if (value instanceof GregorianCalendar) {
                        actualValue = DatatypeFactory.newInstance().newXMLGregorianCalendar((GregorianCalendar)value);
                    } else if (value instanceof Calendar) {
                        GregorianCalendar gcal = new GregorianCalendar();
                        gcal.setTimeInMillis(((Calendar)value).getTimeInMillis());
                        actualValue = DatatypeFactory.newInstance().newXMLGregorianCalendar(gcal);
                    }
                }
                method.invoke(this._object, actualValue);
            } else {
                _log.warning("Unable to locate set method " + methodName + " for element " + name);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Unable to set property " + name + " on " + this._object, e);
        }
    }

    private String capitalize(String s) {
        return s != null ? s.substring(0, 1).toUpperCase() + s.substring(1) : null;
    }

    public String toString() {
        if (this._object != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.save(baos, true);
                return baos.toString();
            }
            catch (DataHandlerException dataHandlerException) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public String getEncoding() {
        return this._encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    private static class CompFMMethods {
        private Method compGetName;
        private Method compGetVersion;
        private Method compGetFileMap;
        private boolean compInit = false;
        private Method fmGetSymbol;
        private Method fmGetSource;
        private Method fmGetFileGroupType;
        private Field fmFileGroupType;
        private boolean fmInit = false;

        CompFMMethods() {
        }

        private void initCompMethods(Class compCls) throws NoSuchMethodException {
            if (this.compInit) {
                return;
            }
            this.compGetName = compCls.getMethod("getName", new Class[0]);
            this.compGetVersion = compCls.getMethod("getVersion", new Class[0]);
            this.compGetFileMap = compCls.getMethod("getFileMap", new Class[0]);
            this.compInit = true;
        }

        private void initFMMethods(Class fmCls) throws NoSuchMethodException, NoSuchFieldException {
            if (this.fmInit) {
                return;
            }
            this.fmGetSymbol = fmCls.getMethod("getSymbol", new Class[0]);
            this.fmGetSource = fmCls.getMethod("getSource", new Class[0]);
            this.fmGetFileGroupType = fmCls.getMethod("getFileGroupType", new Class[0]);
            this.fmFileGroupType = fmCls.getDeclaredField("fileGroupType");
            this.fmFileGroupType.setAccessible(true);
            this.fmInit = true;
        }
    }

    private class TypeInfo {
        private Class<?> _typeClass;
        private Map<String, Field> _simpleElements = new HashMap<String, Field>();
        private Map<String, Field> _complexElements = new HashMap<String, Field>();
        private Map<String, Class<?>> _unsequencedComplexTypes = new HashMap();
        private List<String> _jaxbElements = new ArrayList<String>();
        private Map<String, Field> _attributes = new HashMap<String, Field>();
        private Field _simpleContentField;

        private TypeInfo(Class<?> typeClass) {
            this._typeClass = typeClass;
            this.loadTypeInfo(this._typeClass, this);
        }

        public Class<?> getTypeClass() {
            return this._typeClass;
        }

        private void loadTypeInfo(Class<?> cls, TypeInfo typeInfo) {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                boolean jaxbElement;
                Class type;
                XmlElement[] elements;
                String name;
                if (field.isSynthetic()) continue;
                XmlAttribute attrib = field.getAnnotation(XmlAttribute.class);
                if (attrib != null) {
                    name = attrib.name();
                    if ("##default".equals(name)) {
                        name = field.getName();
                    }
                    typeInfo.addAttribute(name, field);
                    continue;
                }
                name = null;
                XmlElements xmlElements = field.getAnnotation(XmlElements.class);
                XmlElementRefs xmlElementRefs = field.getAnnotation(XmlElementRefs.class);
                XmlValue xmlValue = field.getAnnotation(XmlValue.class);
                if (xmlElements != null) {
                    for (XmlElement element : elements = xmlElements.value()) {
                        name = element.name();
                        type = element.type();
                        jaxbElement = JAXBElement.class.isAssignableFrom(type);
                        if (jaxbElement && (type = JaxbDataHandlerSpiImpl.getClassFromObjectFactory(JaxbDataHandler.this.getNamespace(), name, cls, JaxbDataHandler.this._object.getClass().getClassLoader())) == null) {
                            _log.severe("Unable to determine class type for element \"" + name + "\" which is a child of the element \"" + JaxbDataHandler.this.getElement() + "@" + JaxbDataHandler.this.getNamespace() + "\"");
                        }
                        typeInfo.addElement(name, field, type, jaxbElement);
                    }
                    continue;
                }
                if (xmlElementRefs != null) {
                    for (XmlElement element : elements = xmlElementRefs.value()) {
                        name = element.name();
                        type = element.type();
                        jaxbElement = JAXBElement.class.isAssignableFrom(type);
                        if (jaxbElement && (type = JaxbDataHandlerSpiImpl.getClassFromObjectFactory(JaxbDataHandler.this.getNamespace(), name, cls, JaxbDataHandler.this._object.getClass().getClassLoader())) == null) {
                            _log.severe("Unable to determine class type for element \"" + name + "\" which is a child of the element \"" + JaxbDataHandler.this.getElement() + "@" + JaxbDataHandler.this.getNamespace() + "\"");
                        }
                        typeInfo.addElement(name, field, type, jaxbElement);
                    }
                    continue;
                }
                if (xmlValue != null) {
                    this._simpleContentField = field;
                    continue;
                }
                XmlSchemaType xmlSchemaType = field.getAnnotation(XmlSchemaType.class);
                XmlType xmlType = field.getType().getAnnotation(XmlType.class);
                XmlElement element = field.getAnnotation(XmlElement.class);
                if (xmlSchemaType != null) {
                    name = xmlSchemaType.name();
                } else if (element != null) {
                    name = element.name();
                }
                if (name == null || "##default".equals(name)) {
                    name = field.getName();
                }
                if (xmlSchemaType != null || xmlType == null && !List.class.isAssignableFrom(field.getType())) {
                    typeInfo.addElement(name, field, null, false, true);
                    continue;
                }
                typeInfo.addElement(name, field, null);
            }
            if (cls.getSuperclass() != null && !cls.getSuperclass().equals(Object.class)) {
                this.loadTypeInfo(cls.getSuperclass(), typeInfo);
            }
        }

        public Field getSimpleElementField(String name) {
            return this._simpleElements.get(name);
        }

        public Class<?> getSimpleElementType(String name) {
            return this._simpleElements.get(name).getType();
        }

        public Field getComplexElementField(String name) {
            return this._complexElements.get(name);
        }

        public Class<?> getComplexElementType(String name) {
            if (this._unsequencedComplexTypes.containsKey(name)) {
                return this._unsequencedComplexTypes.get(name);
            }
            return this._complexElements.get(name).getType();
        }

        public Field getAttributeField(String name) {
            return this._attributes.get(name);
        }

        public Class<?> getAttributeType(String name) {
            return this._attributes.get(name).getType();
        }

        void addElement(String name, Field field, Class<?> type) {
            this.addElement(name, field, type, false);
        }

        void addElement(String name, Field field, Class<?> type, boolean jaxbElement) {
            Class genericClass;
            Class fieldType = field.getType();
            if (List.class.isAssignableFrom(fieldType) && (genericClass = JaxbDataHandler.this.getGenericClass(field)) != null) {
                fieldType = genericClass;
            }
            this.addElement(name, field, type, jaxbElement, fieldType.isPrimitive() || fieldType.equals(String.class));
        }

        void addElement(String name, Field field, Class<?> type, boolean jaxbElement, boolean simpleType) {
            Class<?> fieldType;
            if (name != null && field != null && (fieldType = field.getType()) != null) {
                if (simpleType) {
                    this._simpleElements.put(name, field);
                } else {
                    this._complexElements.put(name, field);
                }
            }
            if (type != null) {
                this._unsequencedComplexTypes.put(name, type);
            }
            if (jaxbElement) {
                this._jaxbElements.add(name);
            }
        }

        void addAttribute(String name, Field field) {
            this._attributes.put(name, field);
        }

        boolean isUnsequencedComplexType(String name) {
            return this._unsequencedComplexTypes.containsKey(name);
        }

        boolean isListElementFieldType(String name) {
            return List.class.isAssignableFrom(this._complexElements.get(name).getType());
        }

        boolean isJaxbElementFieldType(String name) {
            return this._jaxbElements.contains(name);
        }

        public String[] getAttributeNames() {
            return this._attributes.keySet().toArray(new String[this._attributes.size()]);
        }

        public boolean hasAttributeName(String name) {
            return this._attributes.containsKey(name);
        }

        public String[] getSimpleNames() {
            return this._simpleElements.keySet().toArray(new String[this._simpleElements.size()]);
        }

        public boolean hasSimpleName(String name) {
            return this._simpleElements.containsKey(name);
        }

        public String[] getComplexNames() {
            return this._complexElements.keySet().toArray(new String[this._complexElements.size()]);
        }

        public boolean hasComplexName(String name) {
            return this._complexElements.containsKey(name);
        }

        public boolean hasSimpleContentField() {
            return this._simpleContentField != null;
        }

        public Field getSimpleContentField() {
            return this._simpleContentField;
        }
    }
}

