/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.helper.util;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.helper.util.OraBaseHomeInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public final class HelperUtility {
    private static Logger logger = Logger.getLogger(HelperUtility.class.getName());
    private static final String BIN_PATH = File.separator + "bin";
    private static final String USR_BIN_PATH = File.separator + "usr" + File.separator + "bin";
    private static final String SSH_CMD = "ssh";

    public static String getHostNameWithoutDomain(String hostName) {
        logger.finest("requestedHostName: " + hostName);
        if (!StringUtil.isNullOrEmpty((String)hostName) && hostName.indexOf(".") != -1) {
            hostName = hostName.substring(0, hostName.indexOf("."));
        }
        logger.finest("formattedHostName: " + hostName);
        return hostName;
    }

    public static String which(String cmd) throws Exception {
        String cmdPath = "";
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("which");
        cmds.add(cmd);
        ExecutionResult executionResult = HelperUtility.execute(cmds);
        if (!executionResult.isOk()) {
            logger.info("Unable to get output for 'which' command : " + cmds.toString());
            throw new Exception("Unable to get output for 'which' command: " + cmds.toString());
        }
        cmdPath = executionResult.getOutputMessage();
        return cmdPath;
    }

    public static String getSSHCmd() throws Exception {
        String ssh = "";
        if (new File(BIN_PATH + File.separator + SSH_CMD).exists()) {
            ssh = BIN_PATH + File.separator + SSH_CMD;
        } else if (new File(USR_BIN_PATH + File.separator + SSH_CMD).exists()) {
            ssh = USR_BIN_PATH + File.separator + SSH_CMD;
        } else {
            ssh = HelperUtility.which(SSH_CMD);
            if (ssh.equals("")) {
                throw new Exception("Failed to find SSH command");
            }
        }
        return ssh;
    }

    public static String detectOraBaseHome() throws OPatchAutoException {
        return HelperUtility.detectOraBaseHome(OPatchAutoHelper.getOPatchAutoHome());
    }

    public static String detectOraBaseHome(String oracleHome, RemoteConnectionHandler handler) throws OPatchAutoException {
        return HelperUtility.detectOraBaseHome(oracleHome);
    }

    public static String detectOraBaseHome(String oracleHome) {
        String oraBaseHome = OraBaseHomeInfo.getOraBaseHome(oracleHome);
        if (oraBaseHome != null) {
            return oraBaseHome;
        }
        oraBaseHome = oracleHome;
        File oraBaseScript = new File(oracleHome + File.separator + "bin" + File.separator + "orabasehome");
        if (!oraBaseScript.exists()) {
            logger.info("The home " + oracleHome + " does not contain the orabasehome script.");
            OraBaseHomeInfo.addOraBaseHome(oracleHome, oracleHome);
            return oracleHome;
        }
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("bash");
        cmds.add("-c");
        cmds.add("ORACLE_HOME=" + oracleHome + " " + oraBaseScript.getPath());
        try {
            List commandOutput = OPatchAutoHelper.runtimeExecAndCaptureOutput(cmds, null, null, (boolean)false);
            if (commandOutput != null && commandOutput.size() > 0) {
                logger.info("Orabasehome Output :\n" + (String)commandOutput.get(0));
                oraBaseHome = ((String)commandOutput.get(0)).trim();
                File oraBaseHomeDir = new File(oraBaseHome);
                if (!oraBaseHomeDir.isDirectory()) {
                    logger.info("Oracle Base Home does not exist.");
                    oraBaseHome = oracleHome;
                }
            } else {
                logger.info("Unable to get output from orabasehome.  Retrying the command..");
                commandOutput = OPatchAutoHelper.runtimeExecAndCaptureOutput(cmds, null, null, (boolean)false);
                if (commandOutput != null && commandOutput.size() > 0) {
                    logger.info("Orabasehome Output after retry :\n" + (String)commandOutput.get(0));
                    oraBaseHome = ((String)commandOutput.get(0)).trim();
                    File oraBaseHomeDir = new File(oraBaseHome);
                    if (!oraBaseHomeDir.isDirectory()) {
                        logger.info("Oracle Base Home does not exist.");
                        oraBaseHome = oracleHome;
                    }
                }
            }
        }
        catch (IOException e) {
            logger.info("Taking the default Oracle Base Home for this home.");
            oraBaseHome = oracleHome;
        }
        OraBaseHomeInfo.addOraBaseHome(oracleHome, oraBaseHome);
        logger.info("Oracle Base Home for " + oracleHome + " is " + oraBaseHome);
        return oraBaseHome;
    }

    public static String detectOraBaseConfig(String oracleHome, RemoteConnectionHandler handler) throws OPatchAutoException {
        return HelperUtility.detectOraBaseConfig(oracleHome);
    }

    public static String detectOraBaseConfig() throws OPatchAutoException {
        return HelperUtility.detectOraBaseConfig(OPatchAutoHelper.getOPatchAutoHome());
    }

    public static String detectOraBaseConfig(String oracleHome) {
        String oraBaseConfig = OraBaseHomeInfo.getOraBaseConfig(oracleHome);
        if (oraBaseConfig != null) {
            return oraBaseConfig;
        }
        oraBaseConfig = oracleHome;
        File oraBaseScript = new File(oracleHome + File.separator + "bin" + File.separator + "orabaseconfig");
        if (!oraBaseScript.exists()) {
            logger.info("The home " + oracleHome + " does not contain the orabaseconfig script.");
            OraBaseHomeInfo.addOraBaseConfig(oracleHome, oracleHome);
            return oracleHome;
        }
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("bash");
        cmds.add("-c");
        cmds.add("ORACLE_HOME=" + oracleHome + " " + oraBaseScript.getPath());
        try {
            List commandOutput = OPatchAutoHelper.runtimeExecAndCaptureOutput(cmds, null, null, (boolean)false);
            if (commandOutput != null && commandOutput.size() > 0) {
                logger.info("Orabaseconfig Output :\n" + (String)commandOutput.get(0));
                oraBaseConfig = ((String)commandOutput.get(0)).trim();
                File oraBaseConfigDir = new File(oraBaseConfig);
                if (!oraBaseConfigDir.isDirectory()) {
                    logger.info("Oracle Base Config does not exist.");
                    oraBaseConfig = oracleHome;
                }
            } else {
                logger.info("Unable to get output from orabaseconfig.  Retrying the command..");
                commandOutput = OPatchAutoHelper.runtimeExecAndCaptureOutput(cmds, null, null, (boolean)false);
                if (commandOutput != null && commandOutput.size() > 0) {
                    logger.info("Orabaseconfig Output after retry :\n" + (String)commandOutput.get(0));
                    oraBaseConfig = ((String)commandOutput.get(0)).trim();
                    File oraBaseConfigDir = new File(oraBaseConfig);
                    if (!oraBaseConfigDir.isDirectory()) {
                        logger.info("Oracle Base Config does not exist.");
                        oraBaseConfig = oracleHome;
                    }
                }
            }
        }
        catch (IOException e) {
            logger.info("Taking the default Oracle Base config for this home.");
            oraBaseConfig = oracleHome;
        }
        OraBaseHomeInfo.addOraBaseConfig(oracleHome, oraBaseConfig);
        logger.info("Oracle Base Config for " + oracleHome + " is " + oraBaseConfig);
        return oraBaseConfig;
    }

    public static ExecutionResult execute(List<String> cmds) {
        ExecutionResult ret = new ExecutionResult(cmds);
        ProcessBuilder pb = new ProcessBuilder(cmds);
        int retValue = -1;
        try {
            Process process = pb.start();
            InputStreamReader errorStream = new InputStreamReader(process.getErrorStream());
            InputStreamReader inputStream = new InputStreamReader(process.getInputStream());
            ReaderThread rerror = new ReaderThread(errorStream);
            ReaderThread rinput = new ReaderThread(inputStream);
            rinput.start();
            rerror.start();
            retValue = process.waitFor();
            try {
                rerror.join();
                rinput.join();
                ret.setOutputMessage(rinput.outputString);
                ret.setErrorMessage(rerror.outputString);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ret.setReturnCode(retValue);
        }
        catch (Throwable t) {
            ret.setErrorMessage(t.getMessage());
            ret.setReturnCode(-1);
        }
        if (!StringUtil.isNullOrEmpty((String)ret.getErrorMessage(), (boolean)true)) {
            logger.info("Error message (from helper execute cmd): " + ret.getErrorMessage());
        }
        logger.info("Output message (from helper execute cmd): " + ret.getOutputMessage());
        logger.info("Return code (from helper execute cmd): " + ret.getReturnCode());
        return ret;
    }

    public static void setSLibLocn(String defaultValue) {
        String SYSTEM_PROPERTY_LIB_LOC = "oracle.installer.library_loc";
        String ld_lib_path = System.getProperty(SYSTEM_PROPERTY_LIB_LOC);
        logger.fine("SYSTEM_PROPERTY_LIB_LOC set to " + ld_lib_path);
        if (StringUtil.isNullOrEmpty((String)ld_lib_path)) {
            System.setProperty(SYSTEM_PROPERTY_LIB_LOC, defaultValue);
        }
    }

    public static class ExecutionResult {
        List<String> commands;
        String errorMessage;
        String outputMessage;
        int retCode;
        boolean ok;

        public ExecutionResult(List<String> cmds) {
            this.commands = cmds;
            this.errorMessage = "";
            this.outputMessage = "";
            this.retCode = 0;
            this.ok = true;
        }

        public List<String> getCommands() {
            return this.commands;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getOutputMessage() {
            return this.outputMessage;
        }

        public boolean isOk() {
            return this.ok;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public void setOutputMessage(String outputMessage) {
            this.outputMessage = outputMessage;
        }

        protected void setReturnCode(int ret) {
            this.retCode = ret;
            this.ok = this.retCode == 0;
        }

        public int getReturnCode() {
            return this.retCode;
        }
    }

    static class ReaderThread
    extends Thread {
        private InputStreamReader isr;
        public String outputString;

        public ReaderThread(InputStreamReader isr) {
            this.isr = isr;
        }

        @Override
        public void run() {
            try {
                BufferedReader br = new BufferedReader(this.isr);
                StringBuffer sb = new StringBuffer();
                String line = "";
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
                this.outputString = sb.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

