/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency.mgmt;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.Dependency;
import com.oracle.cie.dependency.mgmt.DependencyFileHandler;
import com.oracle.cie.dependency.mgmt.DependencyFileHandlerCallBack;
import com.oracle.cie.dependency.mgmt.DependencyFileType;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementHelper;
import com.oracle.cie.dependency.mgmt.LegalInformation;
import com.oracle.cie.dependency.mgmt.Module;
import com.oracle.cie.dependency.mgmt.Version;
import com.oracle.cie.dependency.mgmt.impl.DependencyManagementFactoryImpl;
import com.oracle.cie.rest.Build;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public abstract class DependencyManagementFactory {
    public static final DependencyFileType DEFAULT_DEPENDENCY_FILE_TYPE = DependencyFileType.ivy;
    private static DependencyManagementFactory _instance = new DependencyManagementFactoryImpl();

    public static DependencyManagementFactory getInstance() {
        return _instance;
    }

    public DependencyFileHandler getDependencyFileHandler() throws DependencyManagementException {
        return this.getDependencyFileHandler(DEFAULT_DEPENDENCY_FILE_TYPE);
    }

    public abstract DependencyFileHandler getDependencyFileHandler(DependencyFileType var1) throws DependencyManagementException;

    public Module readDependenciesFile(File file) throws DependencyManagementException, IOException {
        return this.readDependenciesFile(file, null);
    }

    public Module readDependenciesFile(File file, DependencyFileType defaultType) throws DependencyManagementException, IOException {
        return this.readDependenciesFile(file, defaultType, null);
    }

    public Module readDependenciesFile(File file, DependencyFileType defaultType, DependencyFileHandlerCallBack callBack) throws DependencyManagementException, IOException {
        if (file == null) {
            throw new DependencyManagementException("The dependencies file specified was null.");
        }
        if (!file.exists() || !file.isFile()) {
            throw new DependencyManagementException("The dependencies file specified did not exist or was not a file " + file);
        }
        DependencyFileType fileType = null;
        String fileName = file.getName();
        for (DependencyFileType type : DependencyFileType.values()) {
            if (!fileName.endsWith("." + type.name())) continue;
            fileType = type;
            break;
        }
        if (fileType == null) {
            fileType = DependencyManagementHelper.detectDependencyFileType(file);
        }
        if (fileType == null) {
            if (defaultType != null) {
                fileType = defaultType;
            } else {
                throw new DependencyManagementException("Unable to determine dependencies file type from file extension " + file);
            }
        }
        return this.getDependencyFileHandler(fileType).readDependenciesFile(file, callBack);
    }

    public abstract Module getModule(String var1, String var2);

    public abstract Module getModule(String var1, String var2, String var3);

    public abstract Module getModule(String var1, String var2, String var3, String var4);

    public abstract Module getModule(String var1, String var2, String var3, String var4, String ... var5);

    public abstract Module getModule(String var1, String var2, String var3, String var4, LegalInformation var5, String ... var6);

    public abstract Module getModule(String var1, String var2, Version var3);

    public abstract Module getModule(String var1, String var2, Version var3, String var4);

    public abstract Module getModule(Artifact var1, String var2);

    public abstract Artifact getArtifact(String var1, String var2, String var3);

    public abstract Artifact getArtifact(String var1, String var2, String var3, String var4);

    public abstract Artifact getArtifact(String var1, String var2, String var3, String var4, String ... var5);

    public abstract Artifact getArtifact(String var1, String var2, Version var3);

    public abstract Artifact getArtifact(String var1, String var2, Version var3, String var4);

    public static Artifact getArtifact(String gav) throws DependencyManagementException {
        if (StringUtil.isNullOrEmpty((String)gav)) {
            throw new DependencyManagementException("The GAV specified was null or empty.");
        }
        String[] tokens = gav.trim().split(":");
        if (tokens == null || tokens.length == 0) {
            throw new DependencyManagementException("GAV [groupId:artifactId:version] has not been specified " + gav);
        }
        for (int x = 0; x < tokens.length; ++x) {
            tokens[x] = tokens[x].trim();
        }
        if (tokens.length == 3) {
            return DependencyManagementFactory.getInstance().getArtifact(tokens[0], tokens[1], tokens[2]);
        }
        if (tokens.length == 4 || tokens.length == 5) {
            Artifact artifact = DependencyManagementFactory.getInstance().getArtifact(tokens[0], tokens[1], tokens[2], tokens[3]);
            if (tokens.length == 5) {
                artifact.setClassifier(tokens[4]);
            }
            return artifact;
        }
        throw new DependencyManagementException("Invalid GAV [groupId:artifactId:version] specified " + gav);
    }

    public static Artifact[] parse(String string) throws DependencyManagementException {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return new Artifact[0];
        }
        String[] gavs = string.split(",");
        if (gavs == null || gavs.length == 0) {
            return new Artifact[0];
        }
        ArrayList<Artifact> coordinates = new ArrayList<Artifact>();
        for (String gav : gavs) {
            Artifact c = DependencyManagementFactory.getArtifact(gav);
            coordinates.add(c);
        }
        return coordinates.toArray(new Artifact[coordinates.size()]);
    }

    public abstract Dependency getDependency(String var1, String var2, String var3);

    public abstract Dependency getDependency(String var1, String var2, String var3, String var4);

    public abstract Dependency getDependency(String var1, String var2, String var3, String var4, String ... var5);

    public abstract Dependency getDependency(String var1, String var2, Version var3);

    public abstract Dependency getDependency(String var1, String var2, Version var3, String var4);

    public abstract Dependency getDependency(Artifact var1);

    public abstract Version getVersion();

    public abstract Version getVersion(String var1);

    public abstract Version getVersion(String var1, String ... var2);

    public abstract Build getBuild(String var1, String var2);

    public abstract Build getBuild(String var1, String var2, String var3);
}

