/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.impl;

import com.oracle.cie.common.comdev.Base64;
import com.oracle.cie.common.net.DownloadEvent;
import com.oracle.cie.common.net.DownloadFile;
import com.oracle.cie.common.net.DownloadListener;
import com.oracle.cie.common.net.DownloadListenerAdapter;
import com.oracle.cie.common.net.DownloadRequest;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.IOUtil;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.Wildcard;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.DependencyManagementHelper;
import com.oracle.cie.dependency.mgmt.Version;
import com.oracle.cie.rest.ArtifactVersionsResult;
import com.oracle.cie.rest.Build;
import com.oracle.cie.rest.BuildInfo;
import com.oracle.cie.rest.BuildRuns;
import com.oracle.cie.rest.Builds;
import com.oracle.cie.rest.Checksum;
import com.oracle.cie.rest.ChecksumSearchResult;
import com.oracle.cie.rest.CopyOrMoveResult;
import com.oracle.cie.rest.FileInfo;
import com.oracle.cie.rest.FolderInfo;
import com.oracle.cie.rest.GavcSearchResult;
import com.oracle.cie.rest.ItemCreated;
import com.oracle.cie.rest.ItemProperties;
import com.oracle.cie.rest.MetadataSearchResult;
import com.oracle.cie.rest.PromotionResult;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RepositoryType;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import com.oracle.cie.rest.RestHandler;
import com.oracle.cie.rest.RestHandlerConfig;
import com.oracle.cie.rest.RestVerifyException;
import com.oracle.cie.rest.impl.ArtifactDownloadFileImpl;
import com.oracle.cie.rest.impl.ArtifactoryRestHandlerConfigImpl;
import com.oracle.cie.rest.impl.BuildImpl;
import com.oracle.cie.rest.impl.RestHelperImpl;
import com.oracle.cie.rest.wadl.provider.BuildBuildInfo;
import com.oracle.cie.rest.wadl.provider.BuildBuildRuns;
import com.oracle.cie.rest.wadl.provider.BuildBuilds;
import com.oracle.cie.rest.wadl.provider.BuildPromotionRequest;
import com.oracle.cie.rest.wadl.provider.ChecksumImpl;
import com.oracle.cie.rest.wadl.provider.RepositoryDetailsList;
import com.oracle.cie.rest.wadl.provider.SearchArtifactVersionSearchResult;
import com.oracle.cie.rest.wadl.provider.SearchChecksumSearchResult;
import com.oracle.cie.rest.wadl.provider.SearchGavcSearchResult;
import com.oracle.cie.rest.wadl.provider.SearchMetadataSearchResult;
import com.oracle.cie.rest.wadl.provider.StorageCopyOrMoveResult;
import com.oracle.cie.rest.wadl.provider.StorageFileInfo;
import com.oracle.cie.rest.wadl.provider.StorageFolderInfo;
import com.oracle.cie.rest.wadl.provider.StorageItemCreated;
import com.oracle.cie.rest.wadl.provider.StorageItemProperties;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.ws.rs.core.MultivaluedMap;

public class ArtifactoryRestHandlerImpl
implements RestHandler {
    private static final Logger _log = Logger.getLogger(ArtifactoryRestHandlerImpl.class.getName());
    private Client _theClient;
    private HTTPBasicAuthFilter _httpBasicAuthFilter;
    private Map<Repository, String> _repositoryVersionInfo = new HashMap<Repository, String>();
    private static Map<String, Repository[]> _repositoriesCache = new HashMap<String, Repository[]>();
    private RestHandlerConfig _restHandlerConfig = RestFactory.getRestHandlerConfig();

    public ArtifactoryRestHandlerImpl() {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getClasses().add(StorageFileInfo.class);
        clientConfig.getClasses().add(StorageFolderInfo.class);
        clientConfig.getClasses().add(RepositoryDetailsList.class);
        clientConfig.getClasses().add(StorageItemCreated.class);
        clientConfig.getClasses().add(StorageCopyOrMoveResult.class);
        clientConfig.getClasses().add(StorageItemProperties.class);
        clientConfig.getClasses().add(BuildBuilds.class);
        clientConfig.getClasses().add(BuildBuildRuns.class);
        clientConfig.getClasses().add(BuildBuildInfo.class);
        clientConfig.getClasses().add(BuildPromotionRequest.class);
        clientConfig.getClasses().add(SearchChecksumSearchResult.class);
        clientConfig.getClasses().add(SearchArtifactVersionSearchResult.class);
        clientConfig.getClasses().add(SearchMetadataSearchResult.class);
        clientConfig.getClasses().add(SearchGavcSearchResult.class);
        this._theClient = Client.create((ClientConfig)clientConfig);
        this._theClient.setConnectTimeout(Integer.valueOf(this._restHandlerConfig.getConnectionTimeout()));
        this._theClient.setReadTimeout(Integer.valueOf(this._restHandlerConfig.getReadTimeout()));
        if (_log.isLoggable(Level.FINEST)) {
            this._theClient.addFilter((ClientFilter)new LoggingFilter(_log));
        }
    }

    private WebResource getWebResource(Repository repository, String url) {
        String username = repository != null ? repository.getUsername() : null;
        String password = repository != null ? repository.getPassword() : null;
        return this.getWebResource(url, username, password);
    }

    private WebResource getWebResource(String url, String username, String password) {
        if (this._httpBasicAuthFilter != null) {
            this._theClient.removeFilter((ClientFilter)this._httpBasicAuthFilter);
            this._httpBasicAuthFilter = null;
        }
        if (!StringUtil.isNullOrEmpty((String)username) && !StringUtil.isNullOrEmpty((String)password)) {
            this._httpBasicAuthFilter = new HTTPBasicAuthFilter(username, password);
            this._theClient.addFilter((ClientFilter)this._httpBasicAuthFilter);
        }
        if (_log.isLoggable(Level.FINEST)) {
            _log.finest("Creating WebResource for URL " + url);
        }
        return this._theClient.resource(url);
    }

    @Override
    public Map<Artifact, File> retrieveArtifacts(Collection<Artifact> artifacts, List<Repository> sourceRepositories, boolean verify, int maxConcurrent) throws RestException, IOException {
        return this.retrieveArtifacts(artifacts, sourceRepositories, null, verify, maxConcurrent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Artifact, File> retrieveArtifacts(Collection<Artifact> artifacts, List<Repository> sourceRepositories, Repository destRepository, boolean verify, int maxConcurrent) throws RestException, IOException {
        LinkedHashMap<Artifact, File> artifactFileMap = new LinkedHashMap<Artifact, File>();
        if (artifacts != null && !artifacts.isEmpty()) {
            final LinkedHashMap failed = new LinkedHashMap();
            DownloadRequest downloadRequest = null;
            if (maxConcurrent > 1 && artifacts.size() > 1) {
                downloadRequest = new DownloadRequest("retrieveArtifacts");
                downloadRequest.setConnectTimeout(this._restHandlerConfig.getConnectionTimeout());
                downloadRequest.setReadTimeout(this._restHandlerConfig.getReadTimeout());
                downloadRequest.setBegunTimeout((long)this._restHandlerConfig.getConnectionTimeout());
                downloadRequest.setRetryAttempts(this._restHandlerConfig.getRetryCount());
                downloadRequest.addDownloaderDownloadListener((DownloadListener)new DownloadListenerAdapter(){

                    public synchronized void downloadInit(DownloadEvent event) {
                        ArtifactDownloadFileImpl downloadFile = (ArtifactDownloadFileImpl)event.getDownloader().getDownloadFile();
                        _log.info("Retrieving artifact : " + downloadFile.getArtifact() + " from repository : " + downloadFile.getSourceRepository());
                    }
                });
                downloadRequest.addDownloadListener((DownloadListener)new DownloadListenerAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public synchronized void downloadFailed(DownloadEvent event) {
                        ArtifactDownloadFileImpl downloadFile = (ArtifactDownloadFileImpl)event.getDownloader().getDownloadFile();
                        _log.finest("The download failed " + downloadFile);
                        failed.put(downloadFile, event.getRootCause());
                        ArtifactoryRestHandlerImpl artifactoryRestHandlerImpl = ArtifactoryRestHandlerImpl.this;
                        synchronized (artifactoryRestHandlerImpl) {
                            ArtifactoryRestHandlerImpl.this.notify();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public synchronized void downloadComplete(DownloadEvent e) {
                        _log.finest("The download completed.");
                        ArtifactoryRestHandlerImpl artifactoryRestHandlerImpl = ArtifactoryRestHandlerImpl.this;
                        synchronized (artifactoryRestHandlerImpl) {
                            ArtifactoryRestHandlerImpl.this.notify();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public synchronized void downloadCanceled(DownloadEvent e) {
                        _log.finest("The download was canceled.");
                        ArtifactoryRestHandlerImpl artifactoryRestHandlerImpl = ArtifactoryRestHandlerImpl.this;
                        synchronized (artifactoryRestHandlerImpl) {
                            ArtifactoryRestHandlerImpl.this.notify();
                        }
                    }
                });
            }
            for (Artifact artifact : artifacts) {
                if (artifactFileMap.containsKey(artifact)) continue;
                artifactFileMap.put(artifact, this.retrieveArtifact(artifact, sourceRepositories, destRepository, verify, downloadRequest));
            }
            if (downloadRequest != null && downloadRequest.getDownloadCount() > 0) {
                downloadRequest.download(maxConcurrent);
                ArtifactoryRestHandlerImpl artifactoryRestHandlerImpl = this;
                synchronized (artifactoryRestHandlerImpl) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RestException("Artifact download was interrupted.", e);
                    }
                }
                if (!failed.isEmpty()) {
                    ArtifactDownloadFileImpl downloadFile = (ArtifactDownloadFileImpl)failed.keySet().iterator().next();
                    Exception e = (Exception)failed.get(downloadFile);
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.log(Level.FINEST, "Retrieved artifact failed.", e);
                    }
                    throw new RestException("Unable to retrieve artifact [" + downloadFile.getArtifact() + "] from repository [" + downloadFile.getSourceRepository() + "]", e);
                }
                if (downloadRequest.getCompleteCount() != downloadRequest.getDownloadCount()) {
                    throw new RestException("The completed download count (" + downloadRequest.getCompleteCount() + ") did not match the expected download count (" + downloadRequest.getDownloadCount() + "), most likely due to the download being aborted or cancelled");
                }
            }
        }
        return artifactFileMap;
    }

    @Override
    public File retrieveArtifact(Artifact artifact, Repository sourceRepository, boolean verify) throws RestException, IOException {
        return this.retrieveArtifact(artifact, sourceRepository, null, verify);
    }

    @Override
    public File retrieveArtifact(Artifact artifact, List<Repository> sourceRepositories, boolean verify) throws RestException, IOException {
        return this.retrieveArtifact(artifact, sourceRepositories, null, verify);
    }

    @Override
    public File retrieveArtifact(Artifact artifact, Repository sourceRepository, Repository destRepository, boolean verify) throws RestException, IOException {
        if (sourceRepository == null) {
            throw new RestException("Source repository has not been specified, unable to retrieve artifact : " + artifact);
        }
        ArrayList<Repository> sourceRepositories = new ArrayList<Repository>();
        sourceRepositories.add(sourceRepository);
        return this.retrieveArtifact(artifact, sourceRepositories, destRepository, verify);
    }

    @Override
    public File retrieveArtifact(Artifact artifact, List<Repository> sourceRepositories, Repository destRepository, boolean verify) throws RestException, IOException {
        return this.retrieveArtifact(artifact, sourceRepositories, destRepository, verify, null);
    }

    private File retrieveArtifact(Artifact artifact, List<Repository> sourceRepositories, Repository destRepository, boolean verify, DownloadRequest downloadRequest) throws RestException, IOException {
        if (destRepository == null) {
            destRepository = this._restHandlerConfig.getDefaultCacheRepository();
        }
        if (!destRepository.getType().isCache()) {
            throw new RestException("The destination repository specified was not of type " + (Object)((Object)RepositoryType.CACHE));
        }
        File destination = artifact.getLocalLocation(destRepository.getCacheLocation());
        if (destination.exists()) {
            _log.info("Found cached artifact : " + destination.getAbsolutePath());
            return destination;
        }
        if (sourceRepositories == null) {
            throw new RestException("Source repository has not been specified, unable to retrieve artifact : " + artifact);
        }
        FileInfo fileInfo = null;
        Object sourceRepository = null;
        for (Repository repository : sourceRepositories) {
            fileInfo = this.getFileInfo(artifact, repository, true, false);
            if (fileInfo == null) continue;
            sourceRepository = repository;
            break;
        }
        if (sourceRepository == null) {
            throw new RestException("Unable to locate artifact " + artifact + " in any of the specified source repositories : " + sourceRepositories);
        }
        if (sourceRepository.equals(destRepository)) {
            throw new RestException("The source repository and destination repository specified cannot be the same.");
        }
        if (sourceRepository.getType().isCache() && sourceRepository.isLocalRepository()) {
            destination = artifact.getLocalLocation(sourceRepository.getCacheLocation());
            _log.info("Using local source repository artifact : " + destination.getAbsolutePath());
            return destination;
        }
        if (destRepository.isReadOnly()) {
            throw new RestException("The destination repository is read-only.");
        }
        try {
            URL source = artifact.getRemoteLocation(sourceRepository.getURL().toString());
            File tmpFile = new File(destRepository.getCacheLocation(), artifact.getRepoPath() + ".tmp");
            if (tmpFile.exists() && !tmpFile.delete()) {
                throw new IOException("Unable to delete file : " + tmpFile.getAbsolutePath());
            }
            if (destination.exists() && !destination.delete()) {
                throw new IOException("Unable to delete file : " + destination.getAbsolutePath());
            }
            this.writeChecksumFile(fileInfo, destination);
            if (downloadRequest == null) {
                Exception initialException = null;
                for (int x = 1; x <= this._restHandlerConfig.getRetryCount(); ++x) {
                    try {
                        _log.info("Retrieving artifact : " + artifact + " from repository : " + sourceRepository);
                        IOUtil.copyURLToFile((URL)source, (File)tmpFile, (int)this._restHandlerConfig.getConnectionTimeout(), (int)this._restHandlerConfig.getReadTimeout(), (String)sourceRepository.getUsername(), (String)sourceRepository.getPassword());
                        this.verifyRetrievedArtifact(artifact, (Repository)sourceRepository, destRepository, tmpFile, destination, fileInfo, verify);
                        initialException = null;
                        break;
                    }
                    catch (Exception e) {
                        if (_log.isLoggable(Level.FINEST)) {
                            _log.finest("Failed to retrieve artifact " + artifact + " from repository " + sourceRepository + " for attempt #" + x + " with error: " + e.getMessage());
                        }
                        if (initialException != null) continue;
                        initialException = e;
                        continue;
                    }
                }
                if (initialException != null) {
                    throw initialException;
                }
            } else {
                ArtifactDownloadFileImpl downloadFile = new ArtifactDownloadFileImpl(this, artifact, (Repository)sourceRepository, destRepository, fileInfo, destination, tmpFile, verify);
                downloadFile.setUsername(sourceRepository.getUsername());
                downloadFile.setPassword(sourceRepository.getPassword());
                downloadRequest.addMember((DownloadFile)downloadFile, false);
            }
        }
        catch (Exception e) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.log(Level.FINEST, "Retrieved artifact failed.", e);
            }
            if (e instanceof RestException) {
                throw (RestException)e;
            }
            throw new RestException("Unable to retrieve artifact [" + artifact + "] from repository [" + sourceRepository + "]", e);
        }
        return destination;
    }

    void verifyRetrievedArtifact(Artifact artifact, Repository sourceRepository, Repository destRepository, File tmpFile, File destination, FileInfo fileInfo, boolean verifyChecksum) throws RestException, IOException {
        boolean renameSuccessful;
        if (!tmpFile.exists()) {
            throw new RestException("Unable to retrieve artifact: " + artifact);
        }
        long size = tmpFile.length();
        if (fileInfo.getSize() != size) {
            tmpFile.delete();
            throw new IOException("The retrieved artifact was not the correct size.  Expected : " + fileInfo.getSize() + " Actual : " + size);
        }
        if (verifyChecksum) {
            try {
                this.verifyArtifact(artifact, tmpFile, fileInfo, destRepository, false);
            }
            catch (RestVerifyException e) {
                _log.warning("Failed to verify checksum of artifact " + artifact + ", deleting cached file " + tmpFile);
                tmpFile.delete();
                throw e;
            }
        }
        if (destination.exists() && !destination.delete()) {
            _log.warning("Failed to delete existing destination file " + destination);
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Renaming " + tmpFile + " to " + destination);
        }
        if (!(renameSuccessful = tmpFile.renameTo(destination))) {
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Failed to rename " + tmpFile + " to " + destination + ", retrying before failing...");
            }
            int retry = this._restHandlerConfig.getRetryCount();
            while (!renameSuccessful) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                renameSuccessful = tmpFile.renameTo(destination);
                if (retry-- != 0) continue;
            }
            if (!renameSuccessful) {
                throw new IOException("Unable to rename file : " + tmpFile.getAbsolutePath() + " -> " + destination.getAbsolutePath());
            }
        }
        _log.info("Retrieved artifact: " + destination.getAbsolutePath());
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Retrieved artifact [" + artifact + "] from repository [" + sourceRepository + "] to repository [" + destRepository + "]");
        }
    }

    @Override
    public FileInfo getFileInfo(Artifact artifact, List<Repository> repositories) throws RestException {
        if (artifact == null) {
            throw new RestException("The artifact provided was null.");
        }
        if (repositories == null || repositories.isEmpty()) {
            throw new RestException("No repositories were specified.");
        }
        FileInfo fileInfo = null;
        for (Repository repository : repositories) {
            block9: {
                try {
                    fileInfo = this.getFileInfo(artifact, repository);
                }
                catch (Exception e) {
                    if (!_log.isLoggable(Level.FINEST)) break block9;
                    _log.finest("Failed to get file info for artifact " + artifact + " from repository " + repository + " due to " + e.getMessage());
                }
            }
            if (fileInfo == null) continue;
            break;
        }
        if (fileInfo != null) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("Located file info " + fileInfo + " for artifact " + artifact + " in repository " + fileInfo.getRepository());
            }
        } else if (_log.isLoggable(Level.FINEST)) {
            _log.finest("Unable to locate file info (null) for artifact " + artifact + " in repositories " + repositories);
        }
        return fileInfo;
    }

    @Override
    public FileInfo getFileInfo(Artifact artifact, Repository repository) throws RestException, IOException {
        return this.getFileInfo(artifact, repository, true, true);
    }

    public FileInfo getFileInfo(Artifact artifact, Repository repository, boolean useHeadRequest, boolean failOnNonFatalError) throws RestException, IOException {
        FileInfo fileInfo;
        block29: {
            if (artifact == null) {
                throw new RestException("Unable to retrieve file info, the artifact specified was null.");
            }
            if (repository == null) {
                throw new RestException("The repository specified was null.");
            }
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Getting file info for artifact [" + artifact + "] from repository [" + repository + "]");
            }
            fileInfo = null;
            if (repository.getType().isCache()) {
                File file = artifact.getLocalLocation(repository.getCacheLocation());
                if (!file.exists()) {
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.log(Level.FINEST, "Unable to retrieve file info for artifact [" + artifact + "] from repository [" + repository + "]");
                    }
                    if (failOnNonFatalError) {
                        throw new FileNotFoundException("File not found " + file);
                    }
                    return null;
                }
                File checksumFile = this.getChecksumFile(file);
                String checksum = this.readChecksumFile(checksumFile);
                if (StringUtil.isNullOrEmpty((String)checksum, (boolean)true)) {
                    try {
                        checksum = com.oracle.cie.common.util.Checksum.getMD5Checksum((File)file);
                        if (!repository.isReadOnly()) {
                            this.writeChecksumFile(checksumFile, checksum);
                        }
                    }
                    catch (NoSuchAlgorithmException e) {
                        if (_log.isLoggable(Level.FINER)) {
                            _log.log(Level.FINER, "Failed to calculate checksum for file " + file, e);
                        }
                        checksum = null;
                    }
                    catch (Exception e) {
                        if (_log.isLoggable(Level.FINER)) {
                            _log.log(Level.FINER, "Failed to write checksum file " + checksumFile + " for artifact " + artifact, e);
                        }
                        checksum = null;
                    }
                }
                fileInfo = new FileInfoImpl(file.toURI().toString(), file.length(), new ChecksumImpl(checksum, null), repository);
            } else if (useHeadRequest) {
                RestException initialException = null;
                for (int x = 1; x <= this._restHandlerConfig.getRetryCount(); ++x) {
                    try {
                        fileInfo = this.getFileInfoUsingHeadRequest(artifact, repository, failOnNonFatalError);
                        initialException = null;
                        break;
                    }
                    catch (RestException e) {
                        if (failOnNonFatalError) {
                            throw e;
                        }
                        if (_log.isLoggable(Level.FINEST)) {
                            _log.finest("Failed to get file info for artifact " + artifact + " from repository " + repository + " for attempt #" + x + " with error: " + e.getMessage());
                        }
                        if (initialException != null) continue;
                        initialException = e;
                        continue;
                    }
                }
                if (initialException != null) {
                    throw initialException;
                }
            } else {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("Using REST API method to get file info for artifact " + artifact + " from repository " + repository);
                }
                try {
                    WebResource webResource = this.getWebResource(repository, repository.getBaseURL() + "/api/storage/" + repository.getName() + "/" + artifact.getRepoPath());
                    MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
                    fileInfo = (FileInfo)webResource.queryParams((MultivaluedMap)queryParams).get(StorageFileInfo.FileInfoImpl.class);
                    if (fileInfo != null) {
                        fileInfo.setRepository(repository);
                    }
                }
                catch (Exception e) {
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.log(Level.FINEST, "Get file info failed.", e);
                    }
                    if (e instanceof RestException) {
                        throw (RestException)e;
                    }
                    if (!failOnNonFatalError) break block29;
                    throw new RestException("Unable to retrieve file info for artifact [" + artifact + "] from repository [" + repository + "]", e);
                }
            }
        }
        return fileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInfo getFileInfoUsingHeadRequest(Artifact artifact, Repository repository, boolean failOnNonFatalError) throws RestException {
        if (_log.isLoggable(Level.FINEST)) {
            _log.finest("Using HEAD method to get file info for artifact " + artifact + " from repository " + repository);
        }
        FileInfoImpl fileInfo = null;
        HttpURLConnection connection = null;
        try {
            String credentialEncoding = null;
            if (!StringUtil.isNullOrEmpty((String)repository.getUsername(), (boolean)true) && !StringUtil.isNullOrEmpty((String)repository.getPassword(), (boolean)true)) {
                String userPassword = repository.getUsername() + ":" + repository.getPassword();
                credentialEncoding = Base64.bytesToBase64((byte[])userPassword.getBytes());
                credentialEncoding = credentialEncoding.replaceAll("\n", "");
            }
            URL url = artifact.getRemoteLocation(repository.getURL().toString());
            int responseCode = -1;
            String responseMessage = "";
            IOException initialException = null;
            for (int x = 1; x <= this._restHandlerConfig.getRetryCount(); ++x) {
                try {
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setConnectTimeout(this._restHandlerConfig.getConnectionTimeout());
                    connection.setReadTimeout(this._restHandlerConfig.getReadTimeout());
                    connection.setInstanceFollowRedirects(false);
                    connection.setRequestMethod("HEAD");
                    if (credentialEncoding != null) {
                        connection.setRequestProperty("Authorization", "Basic " + credentialEncoding);
                    }
                    responseCode = connection.getResponseCode();
                    responseMessage = connection.getResponseMessage();
                    initialException = null;
                    break;
                }
                catch (IOException e) {
                    _log.log(Level.FINEST, "Unable to get file info due to IO exception from repository [" + repository + "] for url [" + url + "], attempt #" + x, e);
                    if (initialException != null) continue;
                    initialException = e;
                    continue;
                }
            }
            if (initialException != null) {
                throw initialException;
            }
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("Received response code " + responseCode + " (" + responseMessage + ") from server for URL " + url);
            }
            if (responseCode == 200) {
                String contentLength = connection.getHeaderField("Content-Length");
                if (StringUtil.isNullOrEmpty((String)contentLength, (boolean)true)) {
                    throw new RestException("Failed to get file info for artifact due to \"Content-Length\" header field being null or empty from URL " + url + " which returned connection header fields " + connection.getHeaderFields());
                }
                String md5Checksum = connection.getHeaderField("X-Checksum-Md5");
                if (StringUtil.isNullOrEmpty((String)md5Checksum, (boolean)true)) {
                    throw new RestException("Failed to get file info for artifact due to \"X-Checksum-Md5\" header field being null or empty for URL " + url + " which returned connection header fields " + connection.getHeaderFields());
                }
                String sha1Checksum = connection.getHeaderField("X-Checksum-Sha1");
                if (StringUtil.isNullOrEmpty((String)sha1Checksum, (boolean)true)) {
                    throw new RestException("Failed to get file info for artifact due to \"X-Checksum-Sha1\" header field being null or empty for URL " + url + " which returned connection header fields " + connection.getHeaderFields());
                }
                fileInfo = new FileInfoImpl(url.toString(), Long.parseLong(contentLength), new ChecksumImpl(md5Checksum, sha1Checksum), repository);
            } else if (responseCode != 404 || failOnNonFatalError) {
                if (responseCode != 404) {
                    _log.log(Level.WARNING, "Failed to get file info for artifact due to unexpected response code " + responseCode + " (" + responseMessage + ") from URL " + url);
                }
                throw new RestException("Failed to get file info for artifact due to response code " + responseCode + " (" + responseMessage + ") from URL " + url);
            }
        }
        catch (IOException e) {
            _log.log(Level.WARNING, "An unexpected exception occurred while trying to retrieve file info for artifact [" + artifact + "] from repository [" + repository + "]", e);
            if (failOnNonFatalError) {
                throw new RestException(e);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return fileInfo;
    }

    @Override
    public FolderInfo getFolderInfo(Repository repository, String repoPath) throws RestException, IOException {
        return this.getFolderInfo(repository, repoPath, true);
    }

    @Override
    public FolderInfo getFolderInfo(Repository repository, String repoPath, boolean failIfNotFound) throws RestException, IOException {
        if (repository == null) {
            throw new RestException("The repository specified was null.");
        }
        if (repoPath == null) {
            throw new RestException("The repo path specified was null.");
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Getting folder info for path [" + repoPath + "] from repository [" + repository + "]");
        }
        FolderInfo folderInfo = null;
        if (repository.getType().isCache()) {
            File dir = new File(repository.getCacheLocation(), repoPath);
            folderInfo = new FolderInfoImpl(dir.listFiles());
        } else {
            try {
                WebResource webResource = this.getWebResource(repository, repository.getBaseURL() + "/api/storage/" + repository.getName() + "/" + repoPath);
                MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
                folderInfo = (FolderInfo)webResource.queryParams((MultivaluedMap)queryParams).get(StorageFolderInfo.FolderInfoImpl.class);
            }
            catch (UniformInterfaceException e) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.log(Level.FINEST, "Get folder info failed.", e);
                }
                if (failIfNotFound || e.getResponse().getStatus() != 404) {
                    throw new RestException("Unable to retrieve folder info from repository [" + repository + "] for path [" + repoPath + "]", e);
                }
            }
            catch (Exception e) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.log(Level.FINEST, "Get folder info failed.", e);
                }
                if (e instanceof RestException) {
                    throw (RestException)e;
                }
                if (e instanceof IOException) {
                    _log.log(Level.WARNING, "Unable to retrieve folder info due to IO exception from repository [" + repository + "] for path [" + repoPath + "]", e);
                }
                throw new RestException("Unable to retrieve folder info from repository [" + repository + "] for path [" + repoPath + "]", e);
            }
        }
        return folderInfo;
    }

    @Override
    public URI deployArtifact(Artifact artifact, Repository destRepository, File file) throws RestException, IOException {
        return this.deployArtifact(artifact, destRepository, null, file);
    }

    @Override
    public URI deployArtifact(Artifact artifact, Repository destRepository) throws RestException, IOException {
        return this.deployArtifact(artifact, destRepository, null, null);
    }

    @Override
    public URI deployArtifact(Artifact artifact, Repository destRepository, Repository sourceRepository) throws RestException, IOException {
        return this.deployArtifact(artifact, destRepository, sourceRepository, null);
    }

    @Override
    public URI deployArtifact(Artifact artifact, Repository destRepository, Repository sourceRepository, File file) throws RestException, IOException {
        ItemCreated itemCreated;
        if (destRepository == null) {
            throw new RestException("The destination repository specified was null.");
        }
        if (destRepository.isReadOnly()) {
            throw new RestException("The destination repository is read-only.");
        }
        if (file == null) {
            if (sourceRepository == null) {
                sourceRepository = this._restHandlerConfig.getDefaultCacheRepository();
            }
            if (!sourceRepository.getType().isCache()) {
                throw new RestException("The source repository was not of type " + (Object)((Object)RepositoryType.CACHE) + " : " + sourceRepository);
            }
            if (destRepository.equals(sourceRepository)) {
                throw new RestException("The source repository and destination repository specified cannot be the same repository.");
            }
            file = artifact.getLocalLocation(sourceRepository.getCacheLocation());
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File not found : " + file.getAbsolutePath());
        }
        if (!this.repositoryExists(destRepository)) {
            throw new RestException("Could not find repository : " + destRepository.getName());
        }
        if (destRepository.getType().isCache()) {
            File f = this.installArtifact(artifact, file, destRepository);
            return f.toURI();
        }
        try {
            WebResource webResource = this.getWebResource(destRepository, destRepository.getBaseURL() + "/" + destRepository.getName() + "/" + artifact.getRepoPath());
            itemCreated = (ItemCreated)((WebResource.Builder)((WebResource.Builder)webResource.entity((Object)file).header("X-Checksum-Sha1", (Object)com.oracle.cie.common.util.Checksum.getSHAChecksum((File)file))).header("X-Checksum-Md5", (Object)com.oracle.cie.common.util.Checksum.getMD5Checksum((File)file))).put(StorageItemCreated.ItemCreatedImpl.class);
            _log.info("Deployed artifact " + itemCreated.getURI());
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Deployed artifact [" + artifact + "] to repository [" + destRepository + "] ItemCreated [" + itemCreated + "]");
            }
        }
        catch (Exception e) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.log(Level.FINEST, "Deploy artifact failed.", e);
            }
            if (e instanceof RestException) {
                throw (RestException)e;
            }
            throw new RestException("Unable to deploy artifact [" + artifact + "] to destination repository [" + destRepository + "]", e);
        }
        return URI.create(itemCreated.getURI());
    }

    @Override
    public void verifyArtifact(Artifact artifact, Repository remoteRepository) throws RestException, IOException {
        this.verifyArtifact(artifact, null, remoteRepository, null);
    }

    @Override
    public void verifyArtifact(Artifact artifact, File file, Repository remoteRepository) throws IOException, RestException {
        this.verifyArtifact(artifact, file, remoteRepository, null);
    }

    @Override
    public void verifyArtifact(Artifact artifact, Repository remoteRepository, Repository cacheRepository) throws IOException, RestException {
        this.verifyArtifact(artifact, null, remoteRepository, cacheRepository);
    }

    @Override
    public void verifyArtifact(Artifact artifact, File file, Repository remoteRepository, Repository cacheRepository) throws IOException, RestException {
        FileInfo fileInfo = null;
        if (remoteRepository != null) {
            fileInfo = this.getFileInfo(artifact, remoteRepository);
        }
        this.verifyArtifact(artifact, file, fileInfo, cacheRepository, true);
    }

    @Override
    public void verifyArtifact(Artifact artifact, File file, FileInfo fileInfo, Repository cacheRepository, boolean writeChecksumFile) throws IOException, RestException {
        String expectedChecksum = null;
        if (file == null) {
            if (cacheRepository == null) {
                cacheRepository = this._restHandlerConfig.getDefaultCacheRepository();
            }
            if (!cacheRepository.getType().isCache()) {
                throw new RestException("The cache repository was not of type " + (Object)((Object)RepositoryType.CACHE) + " : " + cacheRepository);
            }
            file = artifact.getLocalLocation(cacheRepository.getCacheLocation());
        }
        File checksumFile = this.getChecksumFile(file);
        if (fileInfo != null) {
            expectedChecksum = fileInfo.getChecksum().getMD5Checksum();
            if (!(!writeChecksumFile || checksumFile.exists() || cacheRepository != null && cacheRepository.isReadOnly())) {
                this.writeChecksumFile(checksumFile, expectedChecksum);
            }
        } else if (cacheRepository != null && checksumFile.exists()) {
            expectedChecksum = this.readChecksumFile(checksumFile);
        }
        if (expectedChecksum == null || expectedChecksum.trim().length() < 1) {
            throw new RestException("Unable to determine expected checksum for artifact : " + artifact);
        }
        try {
            String checksum = com.oracle.cie.common.util.Checksum.getMD5Checksum((File)file);
            if (!StringUtil.isNullOrEmpty((String)expectedChecksum, (boolean)true)) {
                if (!expectedChecksum.equalsIgnoreCase(checksum)) {
                    throw new RestVerifyException("Checksum mismatch for artifact : " + file.getAbsolutePath() + ", expected: " + expectedChecksum + ", but got : " + checksum);
                }
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Checksum verified for file : " + file.getAbsolutePath());
                }
                _log.info("Checksum verified for artifact : " + artifact);
            }
        }
        catch (NoSuchAlgorithmException e) {
            _log.throwing(ArtifactoryRestHandlerImpl.class.getName(), "verifyArtifact", e);
            throw new RestException("Unable to verify artifact : " + artifact, e);
        }
    }

    @Override
    public File installArtifact(Artifact artifact, File file) throws RestException, IOException {
        return this.installArtifact(artifact, file, null);
    }

    @Override
    public File installArtifact(Artifact artifact, File file, Repository cacheRepository) throws RestException, IOException {
        boolean deleted;
        if (file == null) {
            throw new RestException("Please specify a File to install");
        }
        if (!file.exists()) {
            throw new RestException("File not found : " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new RestException("Cannot install directory : " + file.getAbsolutePath());
        }
        if (cacheRepository == null) {
            cacheRepository = this._restHandlerConfig.getDefaultCacheRepository();
        }
        if (!cacheRepository.getType().isCache()) {
            throw new RestException("Can only install into a cache repository : " + cacheRepository);
        }
        if (cacheRepository.isReadOnly()) {
            throw new RestException("The destination repository is read-only.");
        }
        File destination = artifact.getLocalLocation(cacheRepository.getCacheLocation());
        if (destination.exists() && !(deleted = destination.delete())) {
            throw new IOException("Unable to delete file : " + destination.getAbsolutePath());
        }
        File checksumFile = this.getChecksumFile(destination);
        if (checksumFile.exists()) {
            checksumFile.delete();
        }
        if (!destination.getParentFile().exists() && !destination.getParentFile().mkdirs()) {
            throw new IOException("Unable to create dir : " + destination.getParentFile().getAbsolutePath());
        }
        FileCopy.copy((File)file, (File)destination);
        _log.info("Installed artifact to " + destination.getAbsolutePath());
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Installed artifact [" + artifact + "] to repository [" + cacheRepository + "]");
        }
        return destination;
    }

    @Override
    public Repository[] getRepositories(RepositoryType repositoryType, String username, String password) throws RestException {
        return this.getRepositories(repositoryType, null, username, password);
    }

    @Override
    public Repository[] getRepositories(RepositoryType repositoryType, String baseURL, String username, String password) throws RestException {
        Repository[] repositories;
        if (repositoryType != null && repositoryType.isCache()) {
            return new Repository[]{this._restHandlerConfig.getDefaultCacheRepository()};
        }
        if (StringUtil.isNullOrEmpty((String)baseURL, (boolean)true)) {
            baseURL = ArtifactoryRestHandlerConfigImpl.getInstance().getDefaultRepositoryBaseURL();
        }
        String cacheKey = baseURL;
        if (repositoryType != null) {
            cacheKey = cacheKey + "-" + (Object)((Object)repositoryType);
        }
        if ((repositories = _repositoriesCache.get(cacheKey)) == null) {
            try {
                RepositoryDetailsList.MyRepositoryDetailList details;
                WebResource webResource = this.getWebResource(baseURL + "/api/repositories", username, password);
                MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
                if (repositoryType != null) {
                    queryParams.add((Object)"type", (Object)repositoryType.toString());
                }
                if ((repositories = (details = (RepositoryDetailsList.MyRepositoryDetailList)webResource.queryParams((MultivaluedMap)queryParams).get(RepositoryDetailsList.MyRepositoryDetailList.class)).getRepositories()) != null) {
                    _repositoriesCache.put(cacheKey, repositories);
                }
            }
            catch (Exception e) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.log(Level.FINEST, "Get repositories failed.", e);
                }
                if (e instanceof RestException) {
                    throw (RestException)e;
                }
                throw new RestException("Unable to retrieve repository details from [" + baseURL + "]", e);
            }
        }
        return repositories;
    }

    @Override
    public boolean repositoryExists(Repository repository) throws RestException {
        if (repository == null) {
            throw new RestException("The repository specified was null.");
        }
        if (repository.getType().isCache()) {
            return true;
        }
        Repository[] repositoryDetails = this.getRepositories(null, repository.getBaseURL(), repository.getUsername(), repository.getPassword());
        if (repositoryDetails != null) {
            for (Repository rd : repositoryDetails) {
                if (rd == null || !rd.getName().equalsIgnoreCase(repository.getName())) continue;
                if (repository.getType() != rd.getType()) {
                    repository.setType(rd.getType());
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean artifactExists(Artifact artifact, Repository repository) throws RestException {
        if (artifact == null) {
            throw new RestException("The artifact specified was null.");
        }
        if (repository == null) {
            throw new RestException("The repository specified was null.");
        }
        try {
            return this.getFileInfo(artifact, repository, true, false) != null;
        }
        catch (Exception e) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("Unable to retrieve file info for artifact [" + artifact + "] from repository [" + repository + "]");
            }
            return false;
        }
    }

    @Override
    public boolean artifactExists(Artifact artifact, List<Repository> repositories) throws RestException {
        if (artifact == null) {
            throw new RestException("The artifact provided was null.");
        }
        if (repositories == null || repositories.isEmpty()) {
            throw new RestException("No repositories were specified.");
        }
        for (Repository repository : repositories) {
            if (!this.artifactExists(artifact, repository)) continue;
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("Located artifact " + artifact + " in repository " + repository);
            }
            return true;
        }
        return false;
    }

    @Override
    public void deleteArtifact(Artifact artifact, Repository repository) throws RestException {
        this.deleteArtifact(artifact, repository, true);
    }

    @Override
    public void deleteArtifact(Artifact artifact, Repository repository, boolean deleteParents) throws RestException {
        if (artifact == null) {
            throw new RestException("The artifact specified was null.");
        }
        if (repository == null) {
            throw new RestException("The repository specified was null.");
        }
        if (repository.isReadOnly()) {
            throw new RestException("The repository is read-only.");
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Deleting artifact [" + artifact + "] from repository [" + repository + "]");
        }
        if (repository.getType().isCache()) {
            File file = new File(repository.getCacheLocation(), artifact.getRepoPath());
            this.deleteWithRetry(file);
            this.deleteWithRetry(this.getChecksumFile(file));
        } else {
            try {
                WebResource webResource = this.getWebResource(repository, repository.getBaseURL() + "/" + repository.getName() + "/" + artifact.getRepoPath());
                webResource.delete();
                _log.info("Deleted artifact " + artifact.getRemoteLocation(repository.getURL().toString()));
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Deleted artifact [" + artifact + "] from repository [" + repository + "]");
                }
            }
            catch (Exception e) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.log(Level.FINEST, "Delete artifact failed.", e);
                }
                if (e instanceof RestException) {
                    throw (RestException)e;
                }
                throw new RestException("Unable to delete artifact [" + artifact + "] from repository [" + repository + "]", e);
            }
        }
        try {
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("Attempting to delete artifact's version directory " + artifact.getGroupIdNameVersionRepoPath());
            }
            if (this.deleteIfEmpty(artifact.getGroupIdNameVersionRepoPath(), repository)) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("Attempting to delete artifact's name directory " + artifact.getGroupIdNameRepoPath());
                }
                this.deleteIfEmpty(artifact.getGroupIdNameRepoPath(), repository);
            }
        }
        catch (Exception e) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.log(Level.FINEST, "Delete of artifact's parent directories failed.", e);
            }
            if (e instanceof RestException) {
                throw (RestException)e;
            }
            throw new RestException("Unable to delete artifact's parent directories [" + artifact + "] from repository [" + repository + "]", e);
        }
    }

    private boolean deleteIfEmpty(String path, Repository repository) throws IOException, RestException {
        if (repository.getType().isCache()) {
            File file = new File(repository.getCacheLocation(), path);
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null && files.length < 0) {
                    this.deleteWithRetry(file);
                }
            } else {
                this.deleteWithRetry(file);
            }
        } else {
            List<String> folders;
            FolderInfo folderInfo = this.getFolderInfo(repository, path);
            List<String> list = folders = folderInfo != null ? folderInfo.getFolders() : null;
            if (folders == null || folders.isEmpty()) {
                WebResource webResource = this.getWebResource(repository, repository.getBaseURL() + "/" + repository.getName() + "/" + path);
                webResource.delete();
                return true;
            }
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("Location was not deleted because it was not empty " + path);
            }
        }
        return false;
    }

    private void deleteWithRetry(File file) throws RestException {
        if (file != null && file.exists()) {
            boolean deleteSuccessful = false;
            int retry = this._restHandlerConfig.getRetryCount();
            while (file.exists() && !(deleteSuccessful = file.delete()) && retry-- != 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!deleteSuccessful && file.exists()) {
                String message = "Unable to delete";
                message = message + (file.isDirectory() ? " directory " : " file ");
                message = message + message + file;
                throw new RestException(message);
            }
        }
    }

    @Override
    public byte[] getArchiveEntryContents(Artifact artifact, String entry, List<Repository> sourceRepositories) throws RestException {
        if (this.artifactExists(artifact, this._restHandlerConfig.getDefaultCacheRepository())) {
            return this.getArchiveEntryContents(artifact, entry, this._restHandlerConfig.getDefaultCacheRepository());
        }
        if (sourceRepositories != null) {
            for (Repository repository : sourceRepositories) {
                if (!this.artifactExists(artifact, repository)) continue;
                return this.getArchiveEntryContents(artifact, entry, repository);
            }
        }
        throw new RestException("Unable to retrieve entry [" + entry + "] from artifact [" + artifact + "] in repositories " + sourceRepositories + " because the artifact could not be located.");
    }

    @Override
    public byte[] getArchiveEntryContents(Artifact artifact, String entry, Repository repository) throws RestException {
        byte[] bytes;
        if (repository == null) {
            throw new RestException("The repository specified was null.");
        }
        if (StringUtil.isNullOrEmpty((String)entry, (boolean)true)) {
            throw new RestException("The entry provided was null or empty.");
        }
        if (!repository.getType().isCache()) {
            try {
                if (this.getRepositoryVersionInfo(repository).contains("filtered-resources")) {
                    if (!entry.startsWith("/")) {
                        entry = "/" + entry;
                    }
                    URL source = new URL(artifact.getRemoteLocation(repository.getURL().toString()).toString() + "!" + entry);
                    bytes = IOUtil.toByteArray((URL)source);
                }
                File file = this.retrieveArtifact(artifact, repository, true);
                bytes = this.getZipEntryContents(file, entry);
            }
            catch (Exception e) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.log(Level.FINEST, "Archive entry retrieval failed.", e);
                }
                if (e instanceof RestException) {
                    throw (RestException)e;
                }
                throw new RestException("Unable to retrieve entry [" + entry + "] from artifact [" + artifact + "] in repository [" + repository + "]", e);
            }
        } else {
            try {
                bytes = this.getZipEntryContents(artifact.getLocalLocation(repository.getCacheLocation()), entry);
            }
            catch (IOException e) {
                throw new RestException(e);
            }
        }
        return bytes;
    }

    @Override
    public void copyArtifact(Artifact artifact, Repository sourceRepository, Repository destRepository) throws RestException, IOException {
        this.copyArtifact(artifact, null, sourceRepository, destRepository);
    }

    @Override
    public void copyArtifact(Artifact artifact, Repository sourceRepository, Repository destRepository, boolean dryRun) throws RestException, IOException {
        this.copyArtifact(artifact, null, sourceRepository, destRepository, dryRun);
    }

    @Override
    public void copyArtifact(Artifact sourceArtifact, Artifact destArtifact, Repository sourceRepository, Repository destRepository) throws RestException, IOException {
        this.copyArtifact(sourceArtifact, destArtifact, sourceRepository, destRepository, false);
    }

    @Override
    public void copyArtifact(Artifact sourceArtifact, Artifact destArtifact, Repository sourceRepository, Repository destRepository, boolean dryRun) throws RestException, IOException {
        block23: {
            if (sourceArtifact == null) {
                throw new RestException("The artifact specified was null.");
            }
            if (sourceRepository == null) {
                throw new RestException("The sourceRepository specified was null.");
            }
            if (destRepository == null) {
                throw new RestException("The destRepository specified was null.");
            }
            if (destRepository.isReadOnly()) {
                throw new RestException("The destination repository is read-only.");
            }
            if (destArtifact == null) {
                destArtifact = sourceArtifact;
            }
            boolean manualCopy = false;
            if (sourceRepository.getType().isCache() || destRepository.getType().isCache() || !sourceRepository.getBaseURL().equals(destRepository.getBaseURL()) || !this.getRepositoryVersionInfo(destRepository).contains("license")) {
                manualCopy = true;
            }
            _log.info("Copying artifact [" + sourceArtifact.getRepoPath() + "] from source repository [" + sourceRepository.getName() + "] to artifact [" + destArtifact.getRepoPath() + "] in destination repository [" + destRepository.getName() + "]");
            if (manualCopy) {
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Copying artifact [" + sourceArtifact + "] from source repository [" + sourceRepository + "] to artifact [" + destArtifact + "] in destination repository [" + destRepository + "] using standard retrieve/deploy calls.");
                }
                if (destRepository.getType().isCache()) {
                    if (!dryRun) {
                        this.retrieveArtifact(sourceArtifact, sourceRepository, destRepository, true);
                    }
                } else {
                    File file = sourceRepository.getType().isCache() ? sourceArtifact.getLocalLocation(sourceRepository.getCacheLocation()) : this.retrieveArtifact(sourceArtifact, sourceRepository, true);
                    if (!dryRun) {
                        this.deployArtifact(sourceArtifact, destRepository, file);
                    }
                }
            } else {
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Copying artifact [" + sourceArtifact + "] from source repository [" + sourceRepository + "] to artifact [" + destArtifact + "] in destination repository [" + destRepository + "] using Artifatory rest call.");
                }
                try {
                    List<CopyOrMoveResult.Message> messages;
                    String additionalOptions = "";
                    if (dryRun) {
                        additionalOptions = additionalOptions + "&dry=1";
                    }
                    WebResource webResource = this.getWebResource(destRepository, sourceRepository.getBaseURL() + "/api/copy/" + sourceRepository.getName() + "/" + sourceArtifact.getRepoPath() + "?to=/" + destRepository.getName() + "/" + destArtifact.getRepoPath() + additionalOptions);
                    CopyOrMoveResult copyOrMoveResult = (CopyOrMoveResult)webResource.post(StorageCopyOrMoveResult.CopyOrMoveResultImpl.class);
                    if (_log.isLoggable(Level.FINER)) {
                        _log.finer("Copied artifact [" + sourceArtifact + "] from repository [" + sourceRepository + "] to [" + destRepository + "] CopyOrMoveResult [" + copyOrMoveResult + "]");
                    }
                    if ((messages = copyOrMoveResult.getMessages()) != null && !messages.isEmpty()) {
                        String messagesStr = null;
                        for (CopyOrMoveResult.Message message : messages) {
                            if (!"INFO".equals(message.getLevel())) {
                                throw new RestException("Unexpected result while copying artifact [" + message + "]");
                            }
                            messagesStr = messagesStr == null ? message.getMessage() : " : " + message.getMessage();
                            _log.info("Copied artifact [" + messagesStr + "]");
                        }
                        break block23;
                    }
                    throw new RestException("Unable to verify artifact copy was successful because no confirmation messages were returned by the Artifactory server.");
                }
                catch (Exception e) {
                    if (_log.isLoggable(Level.FINEST)) {
                        _log.log(Level.FINEST, "Copy artifact failed.", e);
                    }
                    if (e instanceof RestException) {
                        throw (RestException)e;
                    }
                    throw new RestException("Unable to copy artifact [" + sourceArtifact + "] from repository [" + sourceRepository + "] to destination repository [" + destRepository + "]", e);
                }
            }
        }
    }

    @Override
    public Properties getArtifactProperties(Artifact artifact, List<Repository> repositories) throws RestException {
        if (repositories != null && !repositories.isEmpty()) {
            for (Repository repository : repositories) {
                if (!this.artifactExists(artifact, repository)) continue;
                return this.getArtifactProperties(artifact, repository);
            }
        }
        return new Properties();
    }

    @Override
    public Properties getArtifactProperties(Artifact artifact, Repository repository) throws RestException {
        Properties properties;
        if (artifact == null) {
            throw new RestException("The artifact specified was null.");
        }
        if (!this.repositoryExists(repository)) {
            throw new RestException("Could not find repository : " + repository.getName());
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Retrieving properties for artifact [" + artifact + "] from repository [" + repository + "]");
        }
        try {
            if (repository.getType().isCache()) {
                properties = new Properties();
                File artifactPropertiesFile = new File(repository.getCacheLocation(), artifact.getGroupIdNameVersionRepoPath() + File.separator + ".artifact.properties");
                if (artifactPropertiesFile.exists()) {
                    FileReader fr = new FileReader(artifactPropertiesFile);
                    properties.load(fr);
                    fr.close();
                }
            } else {
                WebResource webResource = this.getWebResource(repository, repository.getBaseURL() + "/api/storage/" + repository.getName() + "/" + artifact.getRepoPath() + "?properties");
                MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
                ItemProperties itemProperties = (ItemProperties)webResource.queryParams((MultivaluedMap)queryParams).get(StorageItemProperties.ItemPropertiesImpl.class);
                properties = itemProperties.getProperties();
            }
            _log.info("Retrieved properties [" + properties + "] for artifact [" + artifact + "] from repository [" + repository + "]");
        }
        catch (UniformInterfaceException e) {
            if (e.getResponse().getStatus() == 404 && this.artifactExists(artifact, repository)) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.log(Level.FINEST, "Received 404 from repository " + repository + " for artifact " + artifact + " which exists but has no properties, returning empty properties...");
                }
                properties = new Properties();
            }
            throw new RestException("Unable to retrieve properties from repository [" + repository + "] for artifact [" + artifact + "]", e);
        }
        catch (Exception e) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.log(Level.FINEST, "Get properties failed.", e);
            }
            if (e instanceof RestException) {
                throw (RestException)e;
            }
            throw new RestException("Unable to retrieve properties from repository [" + repository + "] for artifact [" + artifact + "]", e);
        }
        return properties;
    }

    @Override
    public void setArtifactProperties(Artifact artifact, Repository repository, Properties properties) throws RestException {
        if (artifact == null) {
            throw new RestException("The artifact specified was null.");
        }
        if (properties == null || properties.isEmpty()) {
            throw new RestException("The properties specified was null or empty.");
        }
        if (!this.repositoryExists(repository)) {
            throw new RestException("Could not find repository : " + repository.getName());
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Setting properties [" + properties + "] for artifact [" + artifact + "] in repository [" + repository + "]");
        }
        if (repository.getType().isVirtual()) {
            throw new RestException("Properties cannot be set on an artifact using a " + (Object)((Object)RepositoryType.VIRTUAL) + " repository [" + repository + "]");
        }
        if (repository.isReadOnly()) {
            throw new RestException("The repository is read-only.");
        }
        try {
            if (repository.getType().isCache()) {
                if (!this.artifactExists(artifact, repository)) {
                    throw new FileNotFoundException("Unable to set properties in repository [" + repository + "] for artifact [" + artifact + "] since it didn't exist.");
                }
                File artifactPropertiesFile = new File(repository.getCacheLocation(), artifact.getGroupIdNameVersionRepoPath() + File.separator + ".artifact.properties");
                Properties artifactProperties = new Properties();
                if (artifactPropertiesFile.exists()) {
                    FileReader fr = new FileReader(artifactPropertiesFile);
                    artifactProperties.load(fr);
                    fr.close();
                }
                artifactProperties.putAll((Map<?, ?>)properties);
                FileWriter fw = new FileWriter(artifactPropertiesFile);
                artifactProperties.store(fw, null);
                fw.close();
            } else {
                String propertiesString = null;
                for (String propertyName : properties.stringPropertyNames()) {
                    propertiesString = propertiesString == null ? "" : propertiesString + "|";
                    propertiesString = propertiesString + this.escapeForProperties(propertyName) + "=" + this.escapeForProperties(properties.getProperty(propertyName));
                }
                WebResource webResource = this.getWebResource(repository, repository.getBaseURL() + "/api/storage/" + repository.getName() + "/" + artifact.getRepoPath() + "?properties=" + propertiesString);
                webResource.put();
            }
            _log.info("Set properties [" + properties + "] for artifact [" + artifact + "] in repository [" + repository + "]");
        }
        catch (Exception e) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.log(Level.FINEST, "Set properties failed.", e);
            }
            if (e instanceof RestException) {
                throw (RestException)e;
            }
            throw new RestException("Unable to set properties in repository [" + repository + "] for artifact [" + artifact + "]", e);
        }
    }

    private String escapeForProperties(String s) {
        String escaped = s.replace(",", "\\,");
        escaped = escaped.replace("\\", "\\\\");
        escaped = escaped.replace("|", "\\|");
        return !(escaped = escaped.replace("=", "\\=")).equals(s) ? escaped : s;
    }

    @Override
    public void deleteArtifactProperties(Artifact artifact, Repository repository, String ... propertyNames) throws RestException {
        if (artifact == null) {
            throw new RestException("The artifact specified was null.");
        }
        if (propertyNames == null || propertyNames.length < 0) {
            throw new RestException("The properties names specified was null or empty.");
        }
        if (!this.repositoryExists(repository)) {
            throw new RestException("Could not find repository : " + repository.getName());
        }
        if (repository.isReadOnly()) {
            throw new RestException("The repository is read-only.");
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Deleting properties [" + Arrays.toString(propertyNames) + "] from artifact [" + artifact + "] from repository [" + repository + "]");
        }
        if (repository.getType().isVirtual()) {
            throw new RestException("Properties cannot be deleted from an artifact using a " + (Object)((Object)RepositoryType.VIRTUAL) + " repository [" + repository + "]");
        }
        try {
            if (repository.getType().isCache()) {
                File artifactPropertiesFile = new File(repository.getCacheLocation(), artifact.getGroupIdNameVersionRepoPath() + File.separator + ".artifact.properties");
                if (artifactPropertiesFile.exists()) {
                    Properties artifactProperties = new Properties();
                    FileReader fr = new FileReader(artifactPropertiesFile);
                    artifactProperties.load(fr);
                    fr.close();
                    for (String propertyName : propertyNames) {
                        artifactProperties.remove(propertyName);
                    }
                    if (!artifactProperties.isEmpty()) {
                        FileWriter fw = new FileWriter(artifactPropertiesFile);
                        artifactProperties.store(fw, null);
                        fw.close();
                    } else if (!artifactPropertiesFile.delete()) {
                        throw new IOException("Unable to delete local artifact properties file " + artifactPropertiesFile);
                    }
                }
            } else {
                String propertiesString = null;
                for (String propertyName : propertyNames) {
                    propertiesString = propertiesString == null ? "" : propertiesString + ",";
                    propertiesString = propertiesString + propertyName;
                }
                WebResource webResource = this.getWebResource(repository, repository.getBaseURL() + "/api/storage/" + repository.getName() + "/" + artifact.getRepoPath() + "?properties=" + propertiesString);
                webResource.delete();
            }
            _log.info("Deleted properties [" + Arrays.toString(propertyNames) + "] from artifact [" + artifact + "] from repository [" + repository + "]");
        }
        catch (Exception e) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.log(Level.FINEST, "Delete properties failed.", e);
            }
            if (e instanceof RestException) {
                throw (RestException)e;
            }
            throw new RestException("Unable to delete properties from repository [" + repository + "] for artifact [" + artifact + "]", e);
        }
    }

    @Override
    public Collection<String> getBuildNames(Repository repository) throws RestException {
        Collection<String> buildNames;
        if (!this.repositoryExists(repository)) {
            throw new RestException("Could not find repository : " + repository.getName());
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Getting build names from repository [" + repository + "]");
        }
        if (repository.getType().isCache()) {
            buildNames = new ArrayList<String>();
        } else {
            try {
                WebResource webResource = this.getWebResource(repository, repository.getBaseURL() + "/api/build");
                MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
                Builds builds = (Builds)webResource.queryParams((MultivaluedMap)queryParams).get(BuildBuilds.BuildsImpl.class);
                buildNames = builds.getBuildNames();
            }
            catch (Exception e) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.log(Level.FINEST, "Get build names failed.", e);
                }
                if (e instanceof RestException) {
                    throw (RestException)e;
                }
                throw new RestException("Unable to retrieve build names from repository [" + repository + "]", e);
            }
        }
        return buildNames;
    }

    @Override
    public Collection<Build> getBuilds(String buildName, Repository repository) throws RestException {
        if (StringUtil.isNullOrEmpty((String)buildName, (boolean)true)) {
            throw new RestException("The build name specified was null or empty.");
        }
        if (!this.repositoryExists(repository)) {
            throw new RestException("Could not find repository : " + repository.getName());
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Getting build numbers for build [" + buildName + "] from repository [" + repository + "]");
        }
        ArrayList<Build> builds = new ArrayList<Build>();
        if (!repository.getType().isCache()) {
            try {
                WebResource webResource = this.getWebResource(repository, repository.getBaseURL() + "/api/build/" + buildName);
                MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
                BuildRuns buildRuns = (BuildRuns)webResource.queryParams((MultivaluedMap)queryParams).get(BuildBuildRuns.BuildRunsImpl.class);
                Collection<String> buildNumbers = buildRuns.getBuildNumbers();
                if (buildNumbers != null && !buildNumbers.isEmpty()) {
                    for (String buildNumber : buildNumbers) {
                        String buildURI = buildRuns.getURI() + "/" + buildNumber;
                        builds.add(new BuildImpl(buildName, buildNumber, buildURI));
                    }
                }
            }
            catch (Exception e) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.log(Level.FINEST, "Get build numbers failed.", e);
                }
                if (e instanceof RestException) {
                    throw (RestException)e;
                }
                throw new RestException("Unable to retrieve build numbers from repository [" + repository + "] for build [" + buildName + "]", e);
            }
        }
        return builds;
    }

    @Override
    public BuildInfo getBuildInfo(Build build, Repository repository) throws RestException {
        if (build == null) {
            throw new RestException("The build specified was null.");
        }
        if (!this.repositoryExists(repository)) {
            throw new RestException("Could not find repository : " + repository.getName());
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Getting build info for build [" + build + "] from repository [" + repository + "]");
        }
        BuildInfo buildInfo = null;
        if (!repository.getType().isCache()) {
            try {
                WebResource webResource = this.getWebResource(repository, repository.getBaseURL() + "/api/build/" + build.getName() + "/" + build.getNumber());
                MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
                buildInfo = (BuildInfo)webResource.queryParams((MultivaluedMap)queryParams).get(BuildBuildInfo.BuildInfoImpl.class);
            }
            catch (Exception e) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.log(Level.FINEST, "Get build numbers failed.", e);
                }
                if (e instanceof RestException) {
                    throw (RestException)e;
                }
                throw new RestException("Unable to retrieve build numbers from repository [" + repository + "] for build [" + build + "]", e);
            }
        }
        return buildInfo;
    }

    @Override
    public void promoteBuild(Build build, Repository sourceRepository, Repository destRepository, String status, String comment, Properties properties, boolean copy, boolean dryRun) throws RestException {
        this.promoteBuild(build, sourceRepository, destRepository, status, comment, properties, copy, dryRun, false);
    }

    @Override
    public void promoteBuild(Build build, Repository sourceRepository, Repository destRepository, String status, String comment, Properties properties, boolean copy, boolean dryRun, boolean passSourceRepo) throws RestException {
        if (build == null) {
            throw new RestException("The build specified was null.");
        }
        if (sourceRepository == null) {
            throw new RestException("The sourceRepository specified was null.");
        }
        if (destRepository != null && !sourceRepository.getBaseURL().equals(destRepository.getBaseURL())) {
            throw new RestException("The sourceRepository and destRepository specified were not on the same server.");
        }
        if (!sourceRepository.getType().isCache()) {
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Promoting build [" + build + "] to destination repository [" + destRepository + "] with status [" + status + "] comment [" + comment + "] properties [" + properties + "] copy [" + copy + "] dryRun [" + dryRun + "] sourceRepo [" + sourceRepository.getName() + "] passSourceRepo [" + passSourceRepo + "]");
            }
            try {
                WebResource webResource = this.getWebResource(sourceRepository, sourceRepository.getBaseURL() + "/api/build/promote/" + build.getName() + "/" + build.getNumber());
                BuildPromotionRequest.PromotionRequestImpl promotionRequest = new BuildPromotionRequest.PromotionRequestImpl();
                if (passSourceRepo) {
                    promotionRequest.setSourceRepo(sourceRepository.getName());
                }
                if (destRepository != null) {
                    promotionRequest.setTargetRepo(destRepository.getName());
                }
                if (!StringUtil.isNullOrEmpty((String)status)) {
                    promotionRequest.setStatus(status);
                }
                if (!StringUtil.isNullOrEmpty((String)comment)) {
                    promotionRequest.setComment(comment);
                }
                if (properties != null && !properties.isEmpty()) {
                    promotionRequest.setProperties(properties);
                }
                if (copy) {
                    promotionRequest.setCopy(true);
                }
                if (dryRun) {
                    promotionRequest.setDryRun(true);
                }
                PromotionResult promotionResult = (PromotionResult)((WebResource.Builder)webResource.type("application/vnd.org.jfrog.artifactory.build.PromotionRequest+json").accept(new String[]{"application/vnd.org.jfrog.artifactory.build.PromotionResult+json"})).post(BuildPromotionRequest.PromotionResultImpl.class, (Object)promotionRequest);
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Promoted build [" + build + "] to destination repository [" + destRepository + "] with status [" + status + "] comment [" + comment + "] properties [" + properties + "] copy [" + copy + "] dryRun [" + dryRun + "] sourceRepo [" + sourceRepository.getName() + "] passSourceRepo [" + passSourceRepo + "]");
                }
                List<PromotionResult.Message> messages = promotionResult.getMessages();
                String messagesStr = null;
                if (messages != null && !messages.isEmpty()) {
                    for (PromotionResult.Message message : messages) {
                        if ("INFO".equals(message.getLevel())) {
                            messagesStr = messagesStr == null ? message.getMessage() : " : " + message.getMessage();
                            continue;
                        }
                        throw new RestException("Unexpected result while promoting build [" + message + "]");
                    }
                } else if (_log.isLoggable(Level.FINEST)) {
                    _log.finest("Unable to verify build promotion was successful because no confirmation messages were returned by the Artifactory server.");
                }
                if (messagesStr == null) {
                    _log.info("Promoted build [" + build + "]");
                } else {
                    _log.info("Promoted build [" + build + "] with resulting messages [" + messagesStr + "]");
                }
            }
            catch (Exception e) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.log(Level.FINEST, "Build promotion failed.", e);
                }
                if (e instanceof RestException) {
                    throw (RestException)e;
                }
                throw new RestException("Unable to promote build [" + build + "] from repository [" + sourceRepository + "] to destination repository [" + destRepository + "]", e);
            }
        }
    }

    @Override
    public void deleteBuild(Build build, Repository repository, boolean deleteArtifacts) throws RestException {
        if (repository == null) {
            throw new RestException("The repository specified was null.");
        }
        if (!repository.getType().isCache()) {
            try {
                String buildNumber = build.getNumber();
                if (StringUtil.isNullOrEmpty((String)buildNumber)) {
                    throw new RestException("The build number was not set.");
                }
                String params = "?buildNumbers=" + buildNumber;
                if (deleteArtifacts) {
                    params = params + "&artifacts=1";
                }
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Deleting build [" + build + "] from repository [" + repository + "]");
                }
                WebResource webResource = this.getWebResource(repository, repository.getBaseURL() + "/api/build/" + build.getName() + params);
                webResource.delete();
            }
            catch (Exception e) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.log(Level.FINEST, "Delete build failed.", e);
                }
                if (e instanceof RestException) {
                    throw (RestException)e;
                }
                throw new RestException("Unable to delete build [" + build + "] from repository [" + repository + "]", e);
            }
        }
    }

    @Override
    public ChecksumSearchResult checksumSearch(Checksum checksum, Repository repository) throws RestException {
        if (checksum == null) {
            throw new RestException("The checksum provided was null");
        }
        if (!this.repositoryExists(repository)) {
            throw new RestException("Could not find repository : " + repository.getName());
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Performing checksum search for [" + checksum + "] from repository [" + repository.getBaseURL() + "]");
        }
        ChecksumSearchResult checksumSearchResult = null;
        if (!repository.getType().isCache()) {
            try {
                WebResource webResource = this.getWebResource(repository, repository.getBaseURL() + "/api/search/checksum?md5=" + checksum.getMD5Checksum());
                MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
                checksumSearchResult = (ChecksumSearchResult)webResource.queryParams((MultivaluedMap)queryParams).get(SearchChecksumSearchResult.ChecksumSearchResultImpl.class);
            }
            catch (Exception e) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.log(Level.FINEST, "Checksum search failed.", e);
                }
                if (e instanceof RestException) {
                    throw (RestException)e;
                }
                throw new RestException("Unable to performing checksum search for [" + checksum + "] from repository [" + repository.getBaseURL() + "]", e);
            }
        }
        return checksumSearchResult;
    }

    @Override
    public ArtifactVersionsResult artifactVersionsSearch(Artifact artifact, Repository repository) throws RestException {
        if (artifact == null) {
            throw new RestException("The artifact provided was null");
        }
        return this.artifactVersionsSearch(artifact.getGroup(), artifact.getName(), repository);
    }

    @Override
    public ArtifactVersionsResult artifactVersionsSearch(String groupId, String artifactName, Repository repository) throws RestException {
        if (StringUtil.isNullOrEmpty((String)groupId, (boolean)true)) {
            throw new RestException("The group id provided was null or empty");
        }
        if (StringUtil.isNullOrEmpty((String)artifactName, (boolean)true)) {
            throw new RestException("The artifact name provided was null or empty");
        }
        if (!this.repositoryExists(repository)) {
            throw new RestException("Could not find repository : " + repository.getName());
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Performing artifact version search for [" + groupId + ":" + artifactName + "] from repository [" + repository.getBaseURL() + "]");
        }
        ArtifactVersionsResult artifactVersionsResult = null;
        if (!repository.getType().isCache()) {
            try {
                WebResource webResource = this.getWebResource(repository, repository.getBaseURL() + "/api/search/versions?g=" + groupId + "&a=" + artifactName + "&repos=" + repository.getName());
                MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
                artifactVersionsResult = (ArtifactVersionsResult)webResource.queryParams((MultivaluedMap)queryParams).get(SearchArtifactVersionSearchResult.ArtifactVersionsResultImpl.class);
            }
            catch (Exception e) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.log(Level.FINEST, "Artifact version search failed.", e);
                }
                if (e instanceof RestException) {
                    throw (RestException)e;
                }
                throw new RestException("Unable to performing artifact version search for [" + groupId + ":" + artifactName + "] from repository [" + repository.getBaseURL() + "]", e);
            }
        }
        return artifactVersionsResult;
    }

    @Override
    public Set<Version> artifactVersionsSearch(String groupId, String artifactName, String version, Repository repository, boolean searchAllRepositories) throws RestException {
        ArrayList<Repository> repositories = null;
        if (repository != null) {
            repositories = new ArrayList<Repository>();
            repositories.add(repository);
        }
        return this.artifactVersionsSearch(groupId, artifactName, version, repositories, searchAllRepositories);
    }

    @Override
    public Set<Version> artifactVersionsSearch(String groupId, String artifactName, String version, List<Repository> repositories, boolean searchAllRepositories) throws RestException {
        return this.versionSearch(groupId, artifactName, version, repositories, searchAllRepositories, false);
    }

    @Override
    public Version latestVersionSearch(String groupId, String artifactName, String version, Repository repository, boolean searchAllRepositories) throws RestException {
        ArrayList<Repository> repositories = null;
        if (repository != null) {
            repositories = new ArrayList<Repository>();
            repositories.add(repository);
        }
        return this.latestVersionSearch(groupId, artifactName, version, repositories, searchAllRepositories);
    }

    @Override
    public Version latestVersionSearch(String groupId, String artifactName, String version, List<Repository> repositories) throws RestException {
        return this.latestVersionSearch(groupId, artifactName, version, repositories, false);
    }

    protected Version latestVersionSearch(String groupId, String artifactName, String version, List<Repository> repositories, boolean searchAllRepositories) throws RestException {
        Set<Version> versions = this.versionSearch(groupId, artifactName, version, repositories, searchAllRepositories, true);
        int size = versions.size();
        if (size > 0) {
            ArrayList<Version> versionsList = new ArrayList<Version>();
            versionsList.addAll(versions);
            Collections.sort(versionsList);
            return (Version)versionsList.get(size - 1);
        }
        return null;
    }

    protected Set<Version> versionSearch(String groupId, String artifactName, String version, List<Repository> repositories, boolean searchAllRepositories, boolean latest) throws RestException {
        TreeSet<Version> versions;
        block31: {
            if (StringUtil.isNullOrEmpty((String)groupId, (boolean)true)) {
                throw new RestException("The group id provided was null or empty");
            }
            groupId = groupId.trim();
            if (StringUtil.isNullOrEmpty((String)(artifactName = this._restHandlerConfig.getArtifactId(artifactName)), (boolean)true)) {
                throw new RestException("The artifact name provided was null or empty");
            }
            if (repositories == null || repositories.isEmpty()) {
                throw new RestException("The repositories list specified was null or empty.");
            }
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Performing version search for [" + groupId + ":" + artifactName + ":" + version + "] from repositories " + repositories);
            }
            ArrayList<Repository> cacheRepositories = new ArrayList<Repository>();
            LinkedHashMap<String, ArrayList<Repository>> otherRepositories = new LinkedHashMap<String, ArrayList<Repository>>();
            for (Repository repository : repositories) {
                if (repository.getType().isCache()) {
                    cacheRepositories.add(repository);
                    continue;
                }
                String baseUrl = repository.getBaseURL();
                ArrayList<Repository> repos = (ArrayList<Repository>)otherRepositories.get(baseUrl);
                if (repos == null) {
                    repos = new ArrayList<Repository>();
                    otherRepositories.put(baseUrl, repos);
                }
                repos.add(repository);
            }
            versions = new TreeSet<Version>();
            try {
                if (!cacheRepositories.isEmpty()) {
                    for (Repository cacheRepository : cacheRepositories) {
                        versions.addAll(RestHelperImpl.getVersionsUsingFolderInfo(this, cacheRepository, groupId, artifactName, version));
                    }
                }
                if (otherRepositories.isEmpty()) break block31;
                for (Map.Entry entry : otherRepositories.entrySet()) {
                    String baseUrl = (String)entry.getKey();
                    List repos = (List)entry.getValue();
                    String urlString = baseUrl;
                    urlString = urlString + (latest ? "/api/search/latestVersion" : "/api/search/versions");
                    urlString = urlString + "?g=" + groupId + "&a=" + artifactName;
                    if (!StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
                        urlString = urlString + "&v=" + version;
                    }
                    if (!searchAllRepositories) {
                        String repoList = "";
                        for (Repository repository : repos) {
                            if (!repoList.isEmpty()) {
                                repoList = repoList + ",";
                            }
                            repoList = repoList + repository.getName();
                        }
                        urlString = urlString + "&repos=" + repoList;
                    }
                    Exception initialException = null;
                    for (int x = 1; x <= this._restHandlerConfig.getRetryCount(); ++x) {
                        try {
                            block36: {
                                List<String> results;
                                ArtifactVersionsResult artifactVersionsResult;
                                block32: {
                                    block33: {
                                        ByteArrayOutputStream baos;
                                        block34: {
                                            block35: {
                                                URL queryURL;
                                                int responseCode;
                                                if (!latest) break block33;
                                                if (_log.isLoggable(Level.FINEST)) {
                                                    _log.finest("Performing latest version search with URL " + urlString);
                                                }
                                                if ((responseCode = IOUtil.copyURLToOutputStream((URL)(queryURL = new URL(urlString)), (OutputStream)(baos = new ByteArrayOutputStream()), (int)this._restHandlerConfig.getConnectionTimeout(), (int)this._restHandlerConfig.getReadTimeout(), (String)((Repository)repos.get(0)).getUsername(), (String)((Repository)repos.get(0)).getPassword())) == 200) break block34;
                                                if (responseCode == 404) break block35;
                                                _log.warning("Failed to performing latest version search for [" + groupId + ":" + artifactName + ":" + version + "] from repositories " + repos + " due to response code " + responseCode);
                                                break block36;
                                            }
                                            if (!_log.isLoggable(Level.FINEST)) break block36;
                                            _log.finest("Ignoring 404 while performing version search for [" + groupId + ":" + artifactName + ":" + version + "] from repositories " + repos);
                                            break block36;
                                        }
                                        String s = baos.toString();
                                        if (StringUtil.isNullOrEmpty((String)s, (boolean)true)) break block36;
                                        versions.add(DependencyManagementFactory.getInstance().getVersion(s));
                                        break block36;
                                    }
                                    if (_log.isLoggable(Level.FINEST)) {
                                        _log.finest("Performing version search with URL " + urlString);
                                    }
                                    WebResource webResource = this.getWebResource((Repository)repos.get(0), urlString);
                                    MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
                                    artifactVersionsResult = null;
                                    try {
                                        artifactVersionsResult = (ArtifactVersionsResult)webResource.queryParams((MultivaluedMap)queryParams).get(SearchArtifactVersionSearchResult.ArtifactVersionsResultImpl.class);
                                    }
                                    catch (UniformInterfaceException e) {
                                        if (e.getResponse().getStatus() != 404) {
                                            String message = "Failed to performing version search for [" + groupId + ":" + artifactName + ":" + version + "] from repositories " + repos + " due to response code " + e.getResponse().getStatus();
                                            if (_log.isLoggable(Level.FINEST)) {
                                                _log.log(Level.FINEST, message, e);
                                            } else {
                                                _log.warning(message);
                                            }
                                        }
                                        if (!_log.isLoggable(Level.FINEST)) break block32;
                                        _log.finest("Ignoring 404 while performing version search for [" + groupId + ":" + artifactName + ":" + version + "] from repositories " + repos);
                                    }
                                }
                                if (artifactVersionsResult != null && (results = artifactVersionsResult.getResults()) != null && !results.isEmpty()) {
                                    for (String s : results) {
                                        if (StringUtil.isNullOrEmpty((String)s, (boolean)true)) continue;
                                        versions.add(DependencyManagementFactory.getInstance().getVersion(s));
                                    }
                                }
                            }
                            initialException = null;
                            break;
                        }
                        catch (Exception e) {
                            if (_log.isLoggable(Level.FINEST)) {
                                _log.finest("Failed to execute version search (latest=" + latest + ") for artifact [" + groupId + ":" + artifactName + ":" + version + "] from repositories " + repos + " for attempt #" + x + " with error: " + e.getMessage());
                            }
                            if (initialException != null) continue;
                            initialException = e;
                            continue;
                        }
                    }
                    if (initialException == null) continue;
                    throw initialException;
                }
            }
            catch (Exception exception) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.log(Level.FINEST, "Version search failed.", exception);
                }
                if (exception instanceof RestException) {
                    throw (RestException)exception;
                }
                throw new RestException("Unable to performing version search for [" + groupId + ":" + artifactName + ":" + version + "] from repository " + repositories, exception);
            }
        }
        return versions;
    }

    @Override
    public MetadataSearchResult propertySearch(Properties properties, Repository repository) throws RestException {
        return this.propertySearch(properties, repository, false);
    }

    @Override
    public MetadataSearchResult propertySearch(Properties properties, Repository repository, boolean searchAllRepositories) throws RestException {
        if (properties == null || properties.isEmpty()) {
            throw new RestException("The properties specified was null or empty.");
        }
        if (!this.repositoryExists(repository)) {
            throw new RestException("Could not find repository : " + repository.getName());
        }
        if (_log.isLoggable(Level.FINER)) {
            String repoStr = searchAllRepositories ? repository.getBaseURL() : repository.toString();
            _log.finer("Performing property version search for [" + properties + "] in repository [" + repoStr + "]");
        }
        if (!searchAllRepositories && repository.getType().isVirtual()) {
            throw new RestException("A property search cannot be executed using a " + (Object)((Object)RepositoryType.VIRTUAL) + " repository [" + repository + "]");
        }
        MetadataSearchResult propertySearchResult = null;
        if (!repository.getType().isCache()) {
            try {
                String queryString = null;
                for (String propertyName : properties.stringPropertyNames()) {
                    queryString = queryString == null ? "" : queryString + "&";
                    queryString = queryString + propertyName + "=" + properties.getProperty(propertyName);
                }
                if (!searchAllRepositories) {
                    queryString = queryString + "&repos=" + repository.getName();
                }
                WebResource webResource = this.getWebResource(repository, repository.getBaseURL() + "/api/search/prop?" + queryString);
                propertySearchResult = (MetadataSearchResult)webResource.header("X-Result-Detail", (Object)"info, properties").get(SearchMetadataSearchResult.MetadataSearchResultImpl.class);
            }
            catch (Exception e) {
                if (_log.isLoggable(Level.FINEST)) {
                    _log.log(Level.FINEST, "Property search failed.", e);
                }
                if (e instanceof RestException) {
                    throw (RestException)e;
                }
                throw new RestException("Unable to performing property search for [" + properties + "] in repository [" + repository + "]", e);
            }
        }
        return propertySearchResult;
    }

    @Override
    public GavcSearchResult gavcSearch(String group, String artifact, String version, String classifier, Repository repository) throws RestException {
        return this.gavcSearch(group, artifact, version, classifier, repository, false);
    }

    @Override
    public GavcSearchResult gavcSearch(String group, String artifact, String version, String classifier, Repository repository, boolean searchAllRepositories) throws RestException {
        GavcSearchResult gavcSearchResult;
        if (StringUtil.isNullOrEmpty((String)group, (boolean)true) && StringUtil.isNullOrEmpty((String)artifact, (boolean)true) && StringUtil.isNullOrEmpty((String)version, (boolean)true) && StringUtil.isNullOrEmpty((String)classifier, (boolean)true)) {
            throw new RestException("At least one value must be provided for GAVC search (group, artifact, version or classifier).");
        }
        if (!this.repositoryExists(repository)) {
            throw new RestException("Could not find repository : " + repository.getName());
        }
        if (_log.isLoggable(Level.FINER)) {
            String repoStr = searchAllRepositories ? repository.getBaseURL() : repository.toString();
            _log.finer("Performing GAVC search for group [" + group + "] artifact [" + artifact + "] version [" + version + "] classifier [" + classifier + "] in repository [" + repoStr + "]");
        }
        if (!searchAllRepositories && repository.getType().isVirtual()) {
            throw new RestException("A GAVC search cannot be executed using a " + (Object)((Object)RepositoryType.VIRTUAL) + " repository [" + repository + "]");
        }
        try {
            if (repository.getType().isCache()) {
                Set<Artifact> repositoryArtifacts = DependencyManagementHelper.getArtifacts(repository);
                if (!repositoryArtifacts.isEmpty()) {
                    Wildcard groupWildcard = !StringUtil.isNullOrEmpty((String)group, (boolean)true) ? new Wildcard(group) : null;
                    Wildcard artifactWildcard = !StringUtil.isNullOrEmpty((String)artifact, (boolean)true) ? new Wildcard(artifact) : null;
                    Wildcard versionWildcard = !StringUtil.isNullOrEmpty((String)version, (boolean)true) ? new Wildcard(version) : null;
                    Wildcard classifierWildcard = !StringUtil.isNullOrEmpty((String)classifier, (boolean)true) ? new Wildcard(classifier) : null;
                    Iterator<Artifact> it = repositoryArtifacts.iterator();
                    while (it.hasNext()) {
                        Artifact a = it.next();
                        if (!(groupWildcard != null && !groupWildcard.matches(a.getGroup()) || artifactWildcard != null && !artifactWildcard.matches(a.getName()) || versionWildcard != null && !versionWildcard.matches(a.getVersionString())) && (classifierWildcard == null || !StringUtil.isNullOrEmpty((String)a.getClassifier(), (boolean)true) && classifierWildcard.matches(classifier))) continue;
                        it.remove();
                    }
                }
                final HashMap artifactMap = new HashMap();
                final ArrayList results = new ArrayList();
                if (!repositoryArtifacts.isEmpty()) {
                    for (Artifact repositoryArtifact : repositoryArtifacts) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("path", repositoryArtifact.getRepoPath());
                        map.put("uri", repositoryArtifact.getLocalLocation(repository.getCacheLocation()).toURI().toString());
                        results.add(map);
                        artifactMap.put(repositoryArtifact, map);
                    }
                }
                gavcSearchResult = new GavcSearchResult(){

                    @Override
                    public List<Map> getResults() {
                        return results;
                    }

                    @Override
                    public Map<Artifact, Map> getArtifactMap() {
                        return artifactMap;
                    }

                    @Override
                    public Set<Artifact> getArtifacts() {
                        return new HashSet<Artifact>(artifactMap.keySet());
                    }

                    public String toString() {
                        return "" + this.getResults();
                    }
                };
            } else {
                String queryString = "";
                if (!StringUtil.isNullOrEmpty((String)group, (boolean)true)) {
                    if (!queryString.isEmpty()) {
                        queryString = queryString + "&";
                    }
                    queryString = queryString + "g=" + group;
                }
                if (!StringUtil.isNullOrEmpty((String)artifact, (boolean)true)) {
                    if (!queryString.isEmpty()) {
                        queryString = queryString + "&";
                    }
                    queryString = queryString + "a=" + artifact;
                }
                if (!StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
                    if (!queryString.isEmpty()) {
                        queryString = queryString + "&";
                    }
                    queryString = queryString + "v=" + version;
                }
                if (!StringUtil.isNullOrEmpty((String)classifier, (boolean)true)) {
                    if (!queryString.isEmpty()) {
                        queryString = queryString + "&";
                    }
                    queryString = queryString + "c=" + classifier;
                }
                if (!searchAllRepositories) {
                    queryString = queryString + "&repos=" + repository.getName();
                }
                WebResource webResource = this.getWebResource(repository, repository.getBaseURL() + "/api/search/gavc?" + queryString);
                gavcSearchResult = (GavcSearchResult)webResource.header("X-Result-Detail", (Object)"info, properties").get(SearchGavcSearchResult.GavcSearchResultImpl.class);
            }
        }
        catch (Exception e) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.log(Level.FINEST, "GAVC search failed.", e);
            }
            if (e instanceof RestException) {
                throw (RestException)e;
            }
            throw new RestException("Unable to performing GAVC search for [" + group + "] artifact [" + artifact + "] version [" + version + "] classifier [" + classifier + "] in repository [" + repository + "]", e);
        }
        return gavcSearchResult;
    }

    public String getRepositoryVersionInfo(Repository repository) throws RestException {
        if (repository == null) {
            throw new RestException("The repository specified was null.");
        }
        if (repository.getType().isCache()) {
            return "";
        }
        String info = this._repositoryVersionInfo.get(repository);
        if (info != null) {
            return info;
        }
        try {
            URL url = new URL(repository.getBaseURL() + "/api/system/version");
            info = IOUtil.toString((URL)url);
            if (info == null) {
                info = "";
            }
            this._repositoryVersionInfo.put(repository, info);
            return info;
        }
        catch (Exception e) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.log(Level.FINEST, "Get repository version info failed.", e);
            }
            if (e instanceof RestException) {
                throw (RestException)e;
            }
            throw new RestException("Unable to retrieve version info from repository [" + repository + "]", e);
        }
    }

    private byte[] getZipEntryContents(File file, String entry) throws IOException {
        ZipEntry zipEntry;
        byte[] bytes = null;
        ZipFile zipFile = new ZipFile(file);
        if (entry.startsWith("/")) {
            entry = entry.substring(1);
        }
        if ((zipEntry = zipFile.getEntry(entry)) != null) {
            InputStream is = zipFile.getInputStream(zipEntry);
            bytes = IOUtil.toByteArray((InputStream)is);
            is.close();
        }
        zipFile.close();
        return bytes;
    }

    private File getChecksumFile(File artifactFile) {
        return artifactFile != null ? new File(artifactFile.getPath() + ".md5") : null;
    }

    private String readChecksumFile(File checksumFile) throws IOException {
        String expectedChecksum = null;
        if (checksumFile.exists()) {
            FileReader fr = new FileReader(checksumFile);
            BufferedReader br = new BufferedReader(fr);
            expectedChecksum = br.readLine();
            br.close();
            fr.close();
        }
        return expectedChecksum != null ? expectedChecksum.trim().toLowerCase() : null;
    }

    private void writeChecksumFile(FileInfo fileInfo, File file) throws IOException, RestException {
        if (fileInfo == null) {
            throw new RestException("The file info specified was null for file " + file);
        }
        if (file == null) {
            throw new RestException("The file specified was null for " + fileInfo);
        }
        File checksumFile = new File(file.getPath() + ".md5");
        if (checksumFile.exists() && !checksumFile.delete()) {
            throw new IOException("Unable to delete checksum file : " + checksumFile.getAbsolutePath());
        }
        Checksum checksum = fileInfo.getChecksum();
        if (checksum == null) {
            throw new RestException("The checksum was null in the file info specified [" + fileInfo + "] for file " + file);
        }
        String md5Checksum = fileInfo.getChecksum().getMD5Checksum();
        this.writeChecksumFile(checksumFile, md5Checksum);
    }

    private void writeChecksumFile(File checksumFile, String checksum) throws IOException, RestException {
        if (checksumFile == null) {
            throw new RestException("Checksum file cannot be null.");
        }
        if (StringUtil.isNullOrEmpty((String)checksum, (boolean)true)) {
            throw new RestException("Checksum value provided was null or empty when writing checksum file : " + checksumFile.getAbsolutePath());
        }
        if (checksumFile.exists() && !checksumFile.delete()) {
            throw new IOException("Unable to delete existing checksum file : " + checksumFile.getAbsolutePath());
        }
        if (_log.isLoggable(Level.FINE)) {
            _log.fine("Writing checksum file : " + checksumFile.getAbsolutePath() + " with value " + checksum);
        }
        checksumFile.getParentFile().mkdirs();
        FileWriter fw = new FileWriter(checksumFile);
        fw.write(checksum.trim().toLowerCase());
        fw.flush();
        fw.close();
    }

    public static class FileInfoImpl
    implements FileInfo {
        String _downloadURI;
        long _size;
        Checksum _checksum;
        Repository _repository;

        public FileInfoImpl(String downloadURI, long size, Checksum checksum, Repository repository) {
            this._downloadURI = downloadURI;
            this._size = size;
            this._checksum = checksum;
            this._repository = repository;
        }

        @Override
        public long getSize() {
            return this._size;
        }

        @Override
        public Checksum getChecksum() {
            return this._checksum;
        }

        @Override
        public void setRepository(Repository repository) {
            this._repository = repository;
        }

        @Override
        public String getDownloadUri() {
            return this._downloadURI;
        }

        @Override
        public Repository getRepository() {
            return this._repository;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("downloadURI:").append(this.getDownloadUri());
            buf.append(", size:").append(this.getSize());
            buf.append(", ").append(this.getChecksum());
            return buf.toString();
        }
    }

    public static class FolderInfoImpl
    implements FolderInfo {
        private List<String> _folderNames = new ArrayList<String>();
        private List<String> _fileNames = new ArrayList<String>();

        FolderInfoImpl(File[] files) {
            if (files != null && files.length > 0) {
                for (File f : files) {
                    if (f.isDirectory()) {
                        this._folderNames.add(f.getName());
                        continue;
                    }
                    this._fileNames.add(f.getName());
                }
            }
        }

        @Override
        public List<String> getFolders() {
            return Collections.unmodifiableList(this._folderNames);
        }

        @Override
        public List<String> getFiles() {
            return Collections.unmodifiableList(this._fileNames);
        }
    }
}

