/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.impl;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RepositoryType;
import com.oracle.cie.rest.RestFactory;
import com.oracle.cie.rest.RestHandlerType;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

public class RepositoryImpl
implements Repository {
    private String _name;
    private RepositoryType _type = RepositoryType.REMOTE;
    private RestHandlerType _restHandlerType = RestHandlerType.Artifactory;
    private String _description;
    private URL _url;
    private String _baseURL;
    private File _cacheLocation;
    private String _username;
    private String _password;
    private boolean _localRepository;
    private boolean _readOnly;

    public RepositoryImpl(String name, RepositoryType type, String location, String description) {
        this(name, type, location, description, null);
    }

    public RepositoryImpl(String name, RepositoryType type, String location, String description, String username, String password) {
        this(name, type, location, description, null, username, password);
    }

    public RepositoryImpl(String name, RepositoryType type, String location, String description, RestHandlerType restHandlerType) {
        this(name, type, location, description, restHandlerType, null, null);
    }

    public RepositoryImpl(String name, RepositoryType type, String location, String description, RestHandlerType restHandlerType, String username, String password) {
        this._name = name;
        this._type = type;
        if (location != null) {
            String path;
            try {
                if (location.startsWith("file:") || location.replace("\\", "/").startsWith("/") || location.charAt(1) == ':') {
                    this._type = RepositoryType.CACHE;
                }
                if (!this._type.isCache() || this._type.isCache() && location.startsWith("file:")) {
                    this.setURL(new URL(location));
                } else if (this._type.isCache()) {
                    this._cacheLocation = new File(location);
                    this._url = this._cacheLocation.toURI().toURL();
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            if (StringUtil.isNullOrEmpty((String)this._name, (boolean)true) && (path = this._url.getPath()) != null) {
                int index;
                if (path.endsWith("/") && path.length() > 1) {
                    path = path.substring(0, path.length() - 1);
                }
                if ((index = path.lastIndexOf("/")) > -1) {
                    this._name = path.substring(index + 1);
                }
            }
        }
        this._description = description;
        this._restHandlerType = restHandlerType != null ? restHandlerType : RestFactory.DEFAULT_REST_HANDLER_TYPE;
        this._username = username;
        this._password = password;
    }

    @Override
    public RestHandlerType getRestHandlerType() {
        return this._restHandlerType;
    }

    void setRestHandlerType(RestHandlerType handlerType) {
        this._restHandlerType = handlerType;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public RepositoryType getType() {
        return this._type;
    }

    @Override
    public void setType(RepositoryType type) {
        this._type = type;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    @Override
    public void setUsername(String username) {
        this._username = username;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public void setPassword(String password) {
        this._password = password;
    }

    @Override
    public URL getURL() {
        return this._url;
    }

    @Override
    public void setURL(URL url) {
        this._url = url;
        if (this._url != null) {
            int index;
            String artifactoryPath;
            if (this.getType().isCache()) {
                try {
                    this._cacheLocation = new File(this._url.toURI());
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            String portString = "";
            int port = url.getPort();
            if (port > -1 && port != 80) {
                portString = ":" + port;
            }
            if ((artifactoryPath = url.getPath()).endsWith("/")) {
                artifactoryPath = artifactoryPath.substring(0, artifactoryPath.length() - 1);
            }
            if ((index = this._url.getPath().lastIndexOf("/")) > -1) {
                artifactoryPath = artifactoryPath.substring(0, index);
            }
            this._baseURL = this._url.getProtocol() + "://" + this._url.getHost() + portString + artifactoryPath;
        } else {
            this._cacheLocation = null;
            this._baseURL = null;
        }
    }

    @Override
    public String getBaseURL() {
        return this._baseURL;
    }

    @Override
    public File getCacheLocation() {
        return this._cacheLocation;
    }

    @Override
    public void setCacheLocation(File cacheLocation) {
        if (!this.getType().isCache()) {
            throw new IllegalArgumentException("Cannot set cache location on non cache type repository.");
        }
        this._cacheLocation = cacheLocation;
        try {
            this._url = cacheLocation.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean isLocalRepository() {
        return this._localRepository;
    }

    @Override
    public void setLocalRepository(boolean localRepository) {
        if (localRepository && !this.getType().isCache()) {
            throw new IllegalStateException("A local repository may only of type " + (Object)((Object)RepositoryType.CACHE));
        }
        this._localRepository = localRepository;
    }

    @Override
    public boolean isReadOnly() {
        return this._readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this._readOnly = readOnly;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Repository");
        buf.append(" name[").append(this.getName()).append("]");
        buf.append(", type[").append((Object)this.getType()).append("]");
        if (this.getType().isCache()) {
            buf.append(", location[").append(this.getCacheLocation()).append("]");
        } else {
            buf.append(", location[").append(this.getURL()).append("]");
        }
        buf.append(", description[").append(this.getDescription()).append("]");
        return buf.toString();
    }

    public int hashCode() {
        int result;
        if (this.getType().isCache()) {
            result = this.getCacheLocation() != null ? this.getCacheLocation().hashCode() : 0;
        } else {
            try {
                result = this.getURL() != null ? this.getURL().toURI().hashCode() : 0;
            }
            catch (URISyntaxException e) {
                result = 0;
            }
        }
        result = 31 * result + (this._name != null ? this._name.hashCode() : 0);
        result = 31 * result + (this._type != null ? this._type.hashCode() : 0);
        result = 31 * result + (this._description != null ? this._description.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryImpl that = (RepositoryImpl)o;
        if (this._cacheLocation != null ? !this._cacheLocation.equals(that._cacheLocation) : that._cacheLocation != null) {
            return false;
        }
        if (this._description != null ? !this._description.equals(that._description) : that._description != null) {
            return false;
        }
        if (this._name != null ? !this._name.equals(that._name) : that._name != null) {
            return false;
        }
        if (this._type != that._type) {
            return false;
        }
        try {
            if (this._url != null ? !this._url.toURI().equals(that._url.toURI()) : that._url != null) {
                return false;
            }
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }
}

