/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class RestConnectionProxy
extends ProxySelector {
    private static final Logger _log = Logger.getLogger(RestConnectionProxy.class.getName());
    private ProxySelector _defSelector = ProxySelector.getDefault();
    private List<Proxy> _proxyList;

    public RestConnectionProxy() {
    }

    public RestConnectionProxy(String uri, int port) {
        this();
        this._proxyList = new ArrayList<Proxy>();
        this._proxyList.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(uri, port)));
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        _log.warning("Unable to establish a proxy connection to " + uri.toString());
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (this._proxyList != null && !this._proxyList.isEmpty()) {
            return this._proxyList;
        }
        return this._defSelector.select(uri);
    }
}

