/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.wadl.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oracle.cie.common.util.IOUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.rest.MetadataSearchResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/vnd.org.jfrog.artifactory.search.MetadataSearchResult+json"})
public class SearchMetadataSearchResult
implements MessageBodyReader<MetadataSearchResult> {
    private static ObjectMapper mapper = new ObjectMapper();

    public boolean isReadable(Class arg, Type type, Annotation[] annotations, MediaType mediaType) {
        return "application".equalsIgnoreCase(mediaType.getType()) && "vnd.org.jfrog.artifactory.search.MetadataSearchResult+json".equalsIgnoreCase(mediaType.getSubtype());
    }

    public MetadataSearchResult readFrom(Class arg, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap multivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtil.bufferedCopy((InputStream)inputStream, (OutputStream)baos);
        baos.close();
        return (MetadataSearchResult)mapper.readValue(baos.toByteArray(), MetadataSearchResultImpl.class);
    }

    public static class MetadataSearchResultImpl
    extends HashMap
    implements MetadataSearchResult {
        private Map<Artifact, Map> _artifactMap;

        @Override
        public List<Map> getResults() {
            return (List)this.get("results");
        }

        @Override
        public Map<Artifact, Map> getArtifactMap() {
            if (this._artifactMap == null) {
                this._artifactMap = new HashMap<Artifact, Map>();
                List<Map> results = this.getResults();
                if (results != null && !results.isEmpty()) {
                    for (Map result : results) {
                        String path = (String)result.get("path");
                        if (path.startsWith("/")) {
                            path = path.substring(1);
                        }
                        String[] split = path.split("/");
                        String type = split[split.length - 1].substring(split[split.length - 1].lastIndexOf(".") + 1);
                        String version = split[split.length - 2];
                        String artifact = split[split.length - 3];
                        String group = null;
                        for (int x = 0; x < split.length - 3; ++x) {
                            group = group == null ? "" : group + ".";
                            group = group + split[x];
                        }
                        this._artifactMap.put(DependencyManagementFactory.getInstance().getArtifact(group, artifact, version, type), result);
                    }
                }
            }
            return this._artifactMap;
        }

        @Override
        public String toString() {
            return "" + this.getResults();
        }
    }
}

