/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.helper.util.HelperUtility;
import dbmodel.common.OracleHome;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class SessionData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String sessionID = "";
    private Map<String, ArrayList<OPatchPatchInfo>> analyzedResultsMap = new HashMap<String, ArrayList<OPatchPatchInfo>>();
    private HashMap<String, HashMap<String, String>> homePatchDataMap = new HashMap();
    private static String customConfigDir = "";
    private boolean validationCompleted = false;
    private boolean isSIDBDown = false;
    private boolean isListenerDown = false;
    private String crsHome = "";
    private String strSID = "";
    private ClusterInformationLoader.CrsType crsType;
    private String walletLoc = "";
    private char[] walletPwd;
    private static SessionData data;
    public ArrayList<String> autoRollbackPatchIDs = new ArrayList();
    private ArrayList<String> runningHosts = null;
    private String[] initiatedHosts = null;
    private ArrayList<String> remoteList = new ArrayList();
    private boolean localCRSStatus;
    private String RHPPatching = "";
    private String JDKPatching = "";
    private String TomcatPatching = "";
    private boolean multi_node = true;
    private HashMap<String, String> active_sessions = new HashMap();
    private boolean patchingCompletedOnAllNodes = false;
    private boolean isSelectedFinalHost = false;
    private String station_host = "";
    private String OOPApplySwitch = "";
    private boolean OOPPatchingSession = false;
    private boolean rollbackPatchID = false;
    private boolean isOOPSQLPatch = false;
    private boolean isRHPServerRunning = false;
    private boolean isRHPClientRunning = false;
    private boolean isQOSMServerRunning = false;
    private boolean isExtremePerf = false;
    private boolean _deleteSessionXml = false;
    private File _sessionFile;
    private String isSqlPatchAvailable = "";
    private boolean lastNode = false;
    private String drainTimeout = " -drain_timeout 300 ";
    private String twoStageRollingPatching = "";
    private boolean remoteStateUnknown = false;
    private boolean crsStateValidated = false;

    private SessionData() {
    }

    public static SessionData getInstance() {
        if (data == null) {
            data = new SessionData();
            data.collectCrsInfo();
        }
        return data;
    }

    public static SessionData getSerializedInstance(String sessionID) {
        block5: {
            try {
                String location = SessionData.getSerializedLocation();
                File f = new File(location);
                if (!f.exists()) {
                    return null;
                }
                SessionData oldSession = (SessionData)FileUtility.deserializeDataObj((String)location);
                if (sessionID == null) {
                    data = oldSession;
                    break block5;
                }
                if (oldSession.getSessionID() != null && oldSession.getSessionID().equals(sessionID)) {
                    data = oldSession;
                    break block5;
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return data;
    }

    public static void setConfigDir(String dir) {
        if (null != dir) {
            customConfigDir = dir;
        } else {
            try {
                customConfigDir = HelperUtility.detectOraBaseConfig() + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR;
                SessionData.getInstance().saveDataObject();
            }
            catch (OPatchAutoException e) {
                customConfigDir = "";
            }
        }
    }

    public static String getConfigDir() {
        return customConfigDir;
    }

    private static String getSerializedLocation() {
        return customConfigDir + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + "sessionData_" + OUIDriver.extractHostName((String)OPatchAutoHelper.getOPatchAutoHost());
    }

    public void saveDataObject() {
        String location = SessionData.getSerializedLocation();
        Logger logger = Logger.getLogger(SessionData.class.getName());
        try {
            FileUtility.persistDataObj((String)location, (Object)this, (boolean)true);
            logger.fine("Session ID: " + this.getSessionID());
            logger.fine("Config Dir: " + customConfigDir);
            logger.fine("CRS running on: " + this.getRunningHosts().toString());
            logger.fine("Remote Nodes list: " + this.getRemoteList().toString());
            logger.fine("Hosts with a session already initiated: " + Arrays.asList(this.getInitiatedHosts()).toString());
            logger.fine("Local CRS running: " + this.isLocalCRSUp());
            logger.fine("Validation completed: " + this.isCrsStateValidated());
            logger.fine("RHP Patching session: " + this.isRHPPatching());
            logger.fine("JDK Patching session: " + this.isJDKPatching());
            logger.fine("Two Stage Rolling Patch session: " + this.isTwoStageRollingPatching());
            logger.fine("OOP Apply switch Patch session: " + this.isOOPApplySwitch());
            logger.fine("OOP Patching session: " + this.isOOPPatchingSession());
            logger.fine("Patching Completed on all nodes: " + this.isPatchingCompletedOnAllNodes());
            logger.fine("Selected as final node: " + this.isSelectedFinalHost());
            logger.fine("RHP Server Running: " + this.isRHPServerRunning());
            logger.fine("RHP Client Running: " + this.isRHPClientRunning());
            logger.fine("QOSM Server Running: " + this.isQOSMServerRunning());
            logger.fine("SQL Patch in session: " + this.isSqlPatchAvailable());
            logger.fine("Last node of patching " + this.isLastNode());
            logger.fine("Oracle SID " + this.getSID());
            logger.fine("Drain Timeout " + this.getDrainTimeout());
        }
        catch (IOException e) {
            logger.warning(e.toString());
            logger.warning("Failed to serialize session data");
        }
    }

    public void cleanup() {
        String location = SessionData.getSerializedLocation();
        File f = new File(location);
        if (f.exists()) {
            f.delete();
        }
        data = null;
    }

    public String getCrsHome() {
        return this.crsHome;
    }

    private void setCrsHome(String crsHome) {
        this.crsHome = crsHome;
        SessionData.getInstance().saveDataObject();
    }

    public String getSID() {
        return this.strSID;
    }

    public void setSID(String strSID) {
        this.strSID = strSID;
        SessionData.getInstance().saveDataObject();
    }

    public ClusterInformationLoader.CrsType getCrsType() {
        return this.crsType;
    }

    private void setCrsType(ClusterInformationLoader.CrsType crsType) {
        this.crsType = crsType;
        SessionData.getInstance().saveDataObject();
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
        SessionData.getInstance().saveDataObject();
    }

    public void addToAnalyzedResultsMap(String home, ArrayList<OPatchPatchInfo> opatchpatchinfo) {
        this.analyzedResultsMap.put(home, opatchpatchinfo);
        Logger logger = Logger.getLogger(SessionData.class.getName());
        logger.finest("analyzed results map size : " + this.analyzedResultsMap.size());
        logger.finest("Target Home: " + home);
        for (OPatchPatchInfo info : opatchpatchinfo) {
            logger.finest("analyzed patch Id: " + info.getPatchID());
            logger.finest("analyzed patch Location: " + info.getPatchLocation());
            if (!info.isSQLPatch()) continue;
            this.setSqlPatchAvailable(true);
            logger.finest("Identified as a SQL patch");
        }
        SessionData.getInstance().saveDataObject();
    }

    public void addToHomePatchDataMap(String Home2, HashMap<String, String> hostPatchMap) {
        Logger logger = Logger.getLogger(SessionData.class.getName());
        this.homePatchDataMap.put(Home2, hostPatchMap);
        SessionData.getInstance().saveDataObject();
        logger.info("HomePatchDataMap: " + this.homePatchDataMap);
    }

    public ArrayList<OPatchPatchInfo> getAnalyzedPatchList(String home) {
        return this.analyzedResultsMap.get(home);
    }

    public HashMap<String, String> getHostPatchDataMap(String home) {
        return this.homePatchDataMap.get(home);
    }

    public String getHostPatchList(String host, String home) {
        return this.homePatchDataMap.get(home).get(host);
    }

    public HashMap<String, HashMap<String, String>> getHomePatchDataMap() {
        return this.homePatchDataMap;
    }

    public ArrayList<String> getAutoRollbackPatchIDs() {
        return this.autoRollbackPatchIDs;
    }

    public void setAutoRollbackPatchIDs(ArrayList<String> autoRollbackPatchIDs) {
        this.autoRollbackPatchIDs = autoRollbackPatchIDs;
        SessionData.getInstance().saveDataObject();
    }

    public void setRunningHosts(ArrayList<String> runningHosts) {
        this.runningHosts = runningHosts;
        SessionData.getInstance().saveDataObject();
    }

    public ArrayList<String> getRunningHosts() {
        if (this.runningHosts == null) {
            this.runningHosts = new ArrayList();
        }
        return this.runningHosts;
    }

    public void setInitiatedHosts(String[] initiatedHosts) {
        this.initiatedHosts = initiatedHosts;
        SessionData.getInstance().saveDataObject();
    }

    public String[] getInitiatedHosts() {
        if (this.initiatedHosts == null) {
            this.initiatedHosts = new String[0];
        }
        return this.initiatedHosts;
    }

    public ArrayList<String> getRemoteList() {
        return this.remoteList;
    }

    public void setRemoteList(ArrayList<String> remoteList) {
        this.remoteList = remoteList;
        SessionData.getInstance().saveDataObject();
    }

    public void setLocalCRSStatus(boolean localCRSStatus) {
        this.localCRSStatus = localCRSStatus;
    }

    public boolean isLocalCRSUp() {
        return this.localCRSStatus;
    }

    public void setRHPPatching(boolean RHPPatching) {
        this.RHPPatching = String.valueOf(RHPPatching);
        SessionData.getInstance().saveDataObject();
    }

    public String isRHPPatching() {
        return this.RHPPatching;
    }

    public void setJDKPatching(boolean JDKPatching) {
        this.JDKPatching = String.valueOf(JDKPatching);
        SessionData.getInstance().saveDataObject();
    }

    public String isJDKPatching() {
        return this.JDKPatching;
    }

    public void setTomcatPatching(boolean TomcatPatching) {
        this.TomcatPatching = String.valueOf(TomcatPatching);
        SessionData.getInstance().saveDataObject();
    }

    public String isTomcatPatching() {
        return this.TomcatPatching;
    }

    public void setMultiNodeEnv(boolean multi_node) {
        this.multi_node = multi_node;
        SessionData.getInstance().saveDataObject();
    }

    public boolean isMultiNodeEnv() {
        return this.multi_node;
    }

    public HashMap<String, String> getActiveSessions() {
        return this.active_sessions;
    }

    public void setActiveSessions(HashMap<String, String> active_sessions) {
        this.active_sessions = active_sessions;
        SessionData.getInstance().saveDataObject();
    }

    public boolean isPatchingCompletedOnAllNodes() {
        return this.patchingCompletedOnAllNodes;
    }

    public void setPatchingCompletedOnAllNodes(boolean patchingCompletedOnAllNodes) {
        this.patchingCompletedOnAllNodes = patchingCompletedOnAllNodes;
        SessionData.getInstance().saveDataObject();
    }

    public boolean isSelectedFinalHost() {
        return this.isSelectedFinalHost;
    }

    public void setSelectedFinalHost(boolean isSelectedFinalHost) {
        this.isSelectedFinalHost = isSelectedFinalHost;
        SessionData.getInstance().saveDataObject();
    }

    public String getStationHost() {
        return this.station_host;
    }

    public void setStationHost(String station_host) {
        this.station_host = station_host;
        SessionData.getInstance().saveDataObject();
    }

    public void setOOPApplySwitch(boolean OOPApplySwitch) {
        this.OOPApplySwitch = String.valueOf(OOPApplySwitch);
        SessionData.getInstance().saveDataObject();
    }

    public String isOOPApplySwitch() {
        return this.OOPApplySwitch;
    }

    public void setOOPPatchingSession(boolean OOPSession) {
        this.OOPPatchingSession = OOPSession;
        SessionData.getInstance().saveDataObject();
    }

    public boolean isOOPPatchingSession() {
        return this.OOPPatchingSession;
    }

    public void setRollbackPatchID(boolean rbPatchID) {
        this.rollbackPatchID = rbPatchID;
        SessionData.getInstance().saveDataObject();
    }

    public boolean isRollbackPatchID() {
        return this.rollbackPatchID;
    }

    public void setOOPSQLPatch(boolean isOOPSQLPatch) {
        this.isOOPSQLPatch = isOOPSQLPatch;
        SessionData.getInstance().saveDataObject();
    }

    public boolean isOOPSQLPatch() {
        return this.isOOPSQLPatch;
    }

    public void setRHPServerRunning(boolean isRunning) {
        this.isRHPServerRunning = isRunning;
        SessionData.getInstance().saveDataObject();
    }

    public boolean isRHPServerRunning() {
        return this.isRHPServerRunning;
    }

    public void setRHPClientRunning(boolean isRunning) {
        this.isRHPClientRunning = isRunning;
        SessionData.getInstance().saveDataObject();
    }

    public boolean isRHPClientRunning() {
        return this.isRHPClientRunning;
    }

    public void setQOSMServerRunning(boolean isRunning) {
        this.isQOSMServerRunning = isRunning;
        SessionData.getInstance().saveDataObject();
    }

    public boolean isQOSMServerRunning() {
        return this.isQOSMServerRunning;
    }

    public void setExtremePerf(boolean extremePerf) {
        this.isExtremePerf = extremePerf;
        SessionData.getInstance().saveDataObject();
    }

    public boolean isExtremePerf() {
        return this.isExtremePerf;
    }

    public void setDeleteSessionXML(boolean deletesessionxml) {
        this._deleteSessionXml = deletesessionxml;
        SessionData.getInstance().saveDataObject();
    }

    public boolean getDeleteSessionXML() {
        return this._deleteSessionXml;
    }

    public File getSessionFile() {
        return this._sessionFile;
    }

    public void setSessionFile(File sessionfile) {
        this._sessionFile = sessionfile;
        SessionData.getInstance().saveDataObject();
    }

    public void setSqlPatchAvailable(boolean isSqlPatchAvailable) {
        this.isSqlPatchAvailable = String.valueOf(isSqlPatchAvailable);
        SessionData.getInstance().saveDataObject();
    }

    public String isSqlPatchAvailable() {
        return this.isSqlPatchAvailable;
    }

    public boolean isValidationCompleted() {
        return this.validationCompleted;
    }

    public void setValidationCompleted(boolean validationCompleted) {
        this.validationCompleted = validationCompleted;
        SessionData.getInstance().saveDataObject();
    }

    public boolean getIsSIDBDown() {
        return this.isSIDBDown;
    }

    public void setIsSIDBDown(boolean isSIDBDown) {
        this.isSIDBDown = isSIDBDown;
        SessionData.getInstance().saveDataObject();
    }

    public boolean getListenerDown() {
        return this.isListenerDown;
    }

    public void setListenerDown(boolean listenerdown) {
        this.isListenerDown = listenerdown;
        SessionData.getInstance().saveDataObject();
    }

    public void setLastNode(boolean lastNode) {
        this.lastNode = lastNode;
        SessionData.getInstance().saveDataObject();
    }

    public boolean isLastNode() {
        return this.lastNode;
    }

    public void setDrainTimeout(String dt) {
        this.drainTimeout = dt;
        SessionData.getInstance().saveDataObject();
    }

    public String getDrainTimeout() {
        return this.drainTimeout;
    }

    public void setTwoStageRollingPatching(boolean twoStageRollingPatching) {
        this.twoStageRollingPatching = String.valueOf(twoStageRollingPatching);
        SessionData.getInstance().saveDataObject();
    }

    public String isTwoStageRollingPatching() {
        return this.twoStageRollingPatching;
    }

    public void setRemoteStateUnknown(boolean remoteStateUnknown) {
        this.remoteStateUnknown = remoteStateUnknown;
        SessionData.getInstance().saveDataObject();
    }

    public boolean isRemoteStateUnknown() {
        return this.remoteStateUnknown;
    }

    public void setCrsStateValidated(boolean crsStateValidated) {
        this.crsStateValidated = crsStateValidated;
        SessionData.getInstance().saveDataObject();
    }

    public boolean isCrsStateValidated() {
        return this.crsStateValidated;
    }

    public String getWalletLoc() {
        return this.walletLoc;
    }

    public void setWalletLoc(String walletLoc) {
        this.walletLoc = walletLoc;
        SessionData.getInstance().saveDataObject();
    }

    public char[] getWalletPwd() {
        return this.walletPwd;
    }

    public void setWalletPwd(char[] walletPwd) {
        this.walletPwd = walletPwd;
        SessionData.getInstance().saveDataObject();
    }

    public void collectCrsInfo() {
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<OracleHome> oracleHomes = configGraph.getTargets(OracleHome.class);
        String crsHome = null;
        for (OracleHome oh : oracleHomes) {
            if (oh.getHomeType().equals("crs")) {
                crsHome = oh.getPath();
                break;
            }
            if (!oh.getHomeType().equals("siha")) continue;
            crsHome = oh.getPath();
            break;
        }
        if (crsHome != null) {
            this.setCrsHome(crsHome);
            this.crsType = ClusterInformationLoader.getInstance().getCRSType();
            this.setCrsType(this.crsType);
        }
    }
}

