/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.core.oplan;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.framework.sdk.PatchPlanException;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanUserException;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.helper.util.HelperUtility;
import dbmodel.common.OracleHome;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;

public class IOUtils {
    private static Logger logger = Logger.getLogger(IOUtils.class.getName());

    public static void copyOwnerGroup(File src, File dst) {
        try {
            String ownerSrcFile = OUIDriver.checkFileOwner((File)src);
            String groupSrcFile = OUIDriver.checkFileGroup((File)src);
            logger.config("Copying owner/group: " + ownerSrcFile + "/" + groupSrcFile + "of " + src.getAbsolutePath() + " to " + dst.getAbsolutePath());
            ProcessBuilder chown = new ProcessBuilder(new String[0]);
            chown.command("chown", ownerSrcFile + ":" + groupSrcFile, dst.getAbsolutePath());
            Process ch = chown.start();
            int chown_failed = ch.waitFor();
            if (chown_failed != 0) {
                throw new PatchPlanUserException("UNABLE_TO_CHANGE_FILE_OWNER", dst.getAbsolutePath());
            }
        }
        catch (InterruptedException e) {
            throw new PatchPlanException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PatchPlanException(e.getMessage(), e);
        }
    }

    public static void copyOwnerGroupForAllFiles(File src, File dir) {
        try {
            String ownerSrcFile = OUIDriver.checkFileOwner((File)src);
            String groupSrcFile = OUIDriver.checkFileGroup((File)src);
            logger.config("Copying owner/group: " + ownerSrcFile + "/" + groupSrcFile + " of " + src.getAbsolutePath() + " to all files under " + dir.getAbsolutePath());
            byte[] pwd = null;
            GISystemCall.ExecReturn retVal = GISystemCall.process("chown -R " + ownerSrcFile + ":" + groupSrcFile + " " + dir.getAbsolutePath(), null, pwd);
            if (!retVal.isOK()) {
                throw new PatchPlanUserException("UNABLE_TO_CHANGE_FILE_OWNER", dir.getAbsolutePath());
            }
        }
        catch (Exception e) {
            throw new PatchPlanException(e.getMessage(), e);
        }
    }

    public static void chmodTo775(File file, byte[] passwd) {
        if (!ComdevHelper.isWindows()) {
            logger.info("Change the permission of the file " + file.getAbsolutePath() + "to 775");
            String ownerSrcFile = OUIDriver.checkFileOwner((File)file);
            GISystemCall.ExecReturn retVal = GISystemCall.process("chmod 775 " + file.getAbsolutePath(), ownerSrcFile, passwd);
            if (!retVal.isOK()) {
                throw new PatchPlanUserException("UNABLE_TO_CHANGE_FILE_PERMISSION", file.getAbsolutePath());
            }
        }
    }

    public static void chmodFile(File file, String perm, byte[] passwd) {
        if (!ComdevHelper.isWindows()) {
            logger.info("Change the permission of the file " + file.getAbsolutePath() + " to " + perm);
            String ownerSrcFile = OUIDriver.checkFileOwner((File)file);
            GISystemCall.ExecReturn retVal = GISystemCall.process("chmod " + perm + " " + file.getAbsolutePath(), ownerSrcFile, passwd);
            if (!retVal.isOK()) {
                throw new PatchPlanUserException("UNABLE_TO_CHANGE_FILE_PERMISSION", file.getAbsolutePath());
            }
        }
    }

    public static void chmodTo775WithSuPrevilage(File file) {
        if (!ComdevHelper.isWindows()) {
            logger.info("Change the permission of the file " + file.getAbsolutePath() + "to 775");
            byte[] pwd = null;
            GISystemCall.ExecReturn retVal = GISystemCall.process("chmod 775 " + file.getAbsolutePath(), null, pwd);
            if (!retVal.isOK()) {
                throw new PatchPlanUserException("UNABLE_TO_CHANGE_FILE_PERMISSION", file.getAbsolutePath());
            }
        }
    }

    public static void chmodAllFilesOfDirectory(File directory, String permission, String homeOwner, byte[] passwd) throws OPatchAutoException {
        if (!ComdevHelper.isWindows() && directory.isDirectory()) {
            logger.info("Changing the permission of the directory " + directory.getAbsolutePath() + " to " + permission + " as " + homeOwner);
            String command = "chmod -R " + permission.trim() + " " + directory.getAbsolutePath();
            GISystemCall.ExecReturn retVal = GISystemCall.process(command, homeOwner, passwd);
            if (!retVal.isOK()) {
                throw new OPatchAutoException(Integer.toString(72149), new Object[]{directory});
            }
        }
    }

    public static void chownAllLogFiles() {
        try {
            String oracleHome = System.getProperty("OPatch.ORACLE_HOME");
            File src = new File(oracleHome, "oraInst.loc");
            String logDir = HelperUtility.detectOraBaseHome((String)oracleHome) + File.separator + "cfgtoollogs" + File.separator + "opatchautodb";
            File opatchautodb = new File(logDir);
            if (opatchautodb.isDirectory()) {
                IOUtils.copyOwnerGroupForAllFiles(src, opatchautodb);
            }
            if ((opatchautodb = new File(logDir = oracleHome + File.separator + "cfgtoollogs" + File.separator + "opatchautodb")).isDirectory()) {
                IOUtils.copyOwnerGroupForAllFiles(src, opatchautodb);
            }
        }
        catch (Exception e) {
            logger.info("Warning: Unable to change ownership of log files");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStream(InputStream is, OutputStream os) throws IOException {
        try {
            byte[] buff = new byte[1024];
            int bytesread = is.read(buff);
            while (bytesread != -1) {
                os.write(buff, 0, bytesread);
                bytesread = is.read(buff);
            }
        }
        finally {
            is.close();
            if (!os.equals(System.out)) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer getContent(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        StringWriter sw = new StringWriter();
        char[] buff = new char[1024];
        int len = 0;
        try {
            while ((len = isr.read(buff, 0, buff.length)) != -1) {
                sw.write(buff, 0, len);
            }
        }
        finally {
            sw.close();
            isr.close();
        }
        return sw.getBuffer();
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        IOUtils.writeStream(is, os);
    }

    public static void copyFile(File in, File out) throws IOException {
        IOUtils.copyStream(new FileInputStream(in), new FileOutputStream(out));
    }

    public static void tryCopyFile(File in, File out) {
        try {
            IOUtils.copyFile(in, out);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to copy file", e);
        }
    }

    public static void zipLogFiles() {
        try {
            ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
            List<OracleHome> oracleHomes = configGraph.getTargets(OracleHome.class);
            for (OracleHome oh : oracleHomes) {
                String home = oh.getPath();
                IOUtils.zipLogFiles(home);
            }
        }
        catch (Exception e) {
            logger.info("Failed to create a zip of the opatchauto log folders : " + e.getMessage());
        }
    }

    public static void zipLogFiles(String home) {
        Credential cred;
        GISystemCall.ExecReturn retVal;
        String cfgtoollogs = HelperUtility.detectOraBaseHome((String)home) + File.separator + "cfgtoollogs";
        String opatchautodb = cfgtoollogs + File.separator + "opatchautodb";
        String opatchauto = cfgtoollogs + File.separator + "opatchauto";
        File reference = new File(home, "oraInst.loc");
        String cmd1 = "cd " + cfgtoollogs + "; zip -rq opatchautodb_diag.zip opatchautodb ";
        File f1 = new File(cfgtoollogs, "opatchautodb_diag.zip");
        if (f1.exists()) {
            f1.delete();
        }
        if ((retVal = GISystemCall.process(cmd1, "root", cred = null)).isOK()) {
            logger.info("Collected zip file " + f1.getAbsolutePath() + " for diagnosis of the problem.");
            IOUtils.copyOwnerGroup(reference, f1);
        } else {
            logger.info("Unable to create the zip file for logs" + retVal.getErrorMessage());
        }
        String cmd2 = "cd " + cfgtoollogs + "; zip -rq opatchauto_diag.zip opatchauto ";
        File f2 = new File(cfgtoollogs, "opatchauto_diag.zip");
        if (f2.exists()) {
            f2.delete();
        }
        if ((retVal = GISystemCall.process(cmd2, "root", cred)).isOK()) {
            logger.info("Collected zip file " + f2.getAbsolutePath() + " for diagnosis of the problem.");
            IOUtils.copyOwnerGroup(reference, f2);
        } else {
            logger.info("Unable to create the zip file for logs" + retVal.getErrorMessage());
        }
    }
}

