/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.core.patch;

import com.oracle.glcm.patch.auto.db.framework.core.oplan.IOUtils;
import com.oracle.glcm.patch.auto.db.framework.core.patch.OPatchSingletonPatchValidatorAndGenerator;
import com.oracle.glcm.patch.auto.db.framework.core.patch.PatchCompositeXML;
import com.oracle.glcm.patch.auto.db.framework.core.patch.PatchInventory;
import com.oracle.glcm.patch.auto.db.framework.core.patch.PatchUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import dbmodel.patchmodel.CompositePatch;
import dbmodel.patchmodel.GenericSingletonPatch;
import dbmodel.patchmodel.OPatchSingleton;
import dbmodel.patchmodel.PatchPackage;
import dbmodel.patchmodel.PatchingTool;
import dbmodel.util.BundleValidationException;
import dbmodel.util.BundleXmlException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.patchsdk.PatchPackageException;
import oracle.dbsysmodel.patchsdk.PatchValidatorAndGenerator;

public class CompositePatchValidatorAndGenerator
implements PatchValidatorAndGenerator {
    static Logger logger = Logger.getLogger(CompositePatchValidatorAndGenerator.class.getName());
    private final String INV_XML = "etc" + File.separator + "config" + File.separator + "inventory.xml";
    private final String COMPOSITE_XML = "etc" + File.separator + "config" + File.separator + "composite.xml";
    private final String PATCHMD_XML = "patchmd.xml";
    private final String AUTOMATIONXML_FOLDER = "automation";
    private final String BUNDLE_XML = "bundle.xml";
    private final String RESOURCE_BUNDLE = "messages.properties";

    public boolean isPatchValid(String patchLocation) throws PatchPackageException {
        assert (patchLocation != null);
        File patchDir = new File(patchLocation);
        if (!patchDir.exists()) {
            throw new PatchPackageException("Patch Location " + patchLocation + " does not exist.");
        }
        if (!patchDir.isDirectory()) {
            throw new PatchPackageException("Patch Location " + patchLocation + " does not represent a directory");
        }
        StringBuffer bundleXmlLoc = new StringBuffer(patchLocation);
        bundleXmlLoc.append(File.separator);
        bundleXmlLoc.append("bundle.xml");
        File bxml = new File(bundleXmlLoc.toString());
        if (bxml.exists()) {
            logger.log(Level.FINE, "bundle.xml found at " + bundleXmlLoc.toString() + " which implies it is either a system patch or a bundle patch.");
            return false;
        }
        StringBuffer inventoryXMLLoc = new StringBuffer(patchLocation);
        inventoryXMLLoc.append(File.separator);
        inventoryXMLLoc.append(this.INV_XML);
        File invxml = new File(inventoryXMLLoc.toString());
        if (invxml.exists()) {
            logger.log(Level.FINE, "inventory.xml found at " + inventoryXMLLoc.toString() + " which implies it is an OPatch Singleton patch");
            return false;
        }
        if (!invxml.exists()) {
            for (File subPatch : patchDir.listFiles()) {
                if (!subPatch.isDirectory()) continue;
                File subPatchinvxml = new File(subPatch, this.INV_XML);
                File compositeXml = new File(subPatch, this.COMPOSITE_XML);
                if (!subPatchinvxml.isFile() || !compositeXml.isFile()) continue;
                logger.log(Level.INFO, "Inventory.xml found at " + subPatchinvxml.getAbsolutePath() + " which implies it contains a valid OPatch Singleton patch. Also contains patch with composite.xml at " + compositeXml.getAbsolutePath());
                return true;
            }
        }
        return false;
    }

    public boolean isMethodValid(Class className, String method, Class[] parameterTypes) {
        try {
            className.getMethod(method, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    public PatchPackage generate(String patchLocation) throws PatchPackageException {
        File automationXmlFolderLocation;
        assert (patchLocation != null);
        File patchDir = new File(patchLocation);
        if (!patchDir.exists()) {
            throw new PatchPackageException("The given patchLocation " + patchLocation + " does not exist");
        }
        if (!patchDir.isDirectory()) {
            throw new PatchPackageException("The given patchLocation " + patchLocation + " does not represent a directory");
        }
        CompositePatch patch = new CompositePatch();
        patch.setPatchLocation(patchLocation);
        patch.setPatchTool(this.getPatchTool());
        ArrayList subpatches = new ArrayList();
        patch.setSubPatches(subpatches);
        OPatchSingletonPatchValidatorAndGenerator osvg = new OPatchSingletonPatchValidatorAndGenerator();
        File[] subPatchLocList = patchDir.listFiles();
        ArrayList<String> patchLocationList = new ArrayList<String>();
        for (File subPatch : subPatchLocList) {
            if (!subPatch.isDirectory() || !osvg.isPatchValid(subPatch.getAbsolutePath())) continue;
            patchLocationList.add(subPatch.getAbsolutePath());
        }
        if (!patchLocationList.isEmpty()) {
            List<PatchPackage> subPatchList = osvg.generate(patchLocationList);
            for (PatchPackage subPatch : subPatchList) {
                File compositeXml = new File(subPatch.getPatchLocation(), this.COMPOSITE_XML);
                patch.getSubPatches().add((GenericSingletonPatch)subPatch);
                if (!compositeXml.exists() || !compositeXml.isFile()) continue;
                patch.setPatchID(subPatch.getPatchID());
                patch.setPatchIdOfRollbackPatch(subPatch.getPatchID());
            }
        }
        String minOPatchVersion = null;
        boolean isRollingPatch = true;
        boolean isInstanceShutdownPatch = false;
        boolean instanceShutdownPatchIsNull = true;
        boolean isSqlPatch = false;
        List supportedPlatforms = null;
        for (GenericSingletonPatch spatch : patch.getSubPatches()) {
            if (!(spatch instanceof OPatchSingleton)) continue;
            OPatchSingleton subPatch = (OPatchSingleton)spatch;
            if (subPatch.getMinimumOPatchVersion() != null) {
                if (minOPatchVersion == null) {
                    minOPatchVersion = subPatch.getMinimumOPatchVersion();
                } else if (subPatch.getMinimumOPatchVersion().compareToIgnoreCase(minOPatchVersion) > 0) {
                    minOPatchVersion = subPatch.getMinimumOPatchVersion();
                }
            }
            isRollingPatch &= subPatch.getRollingPatch().booleanValue();
            if (subPatch.getInstanceShutdownPatch() != null) {
                instanceShutdownPatchIsNull = false;
                isInstanceShutdownPatch |= subPatch.getInstanceShutdownPatch().booleanValue();
            }
            isSqlPatch |= subPatch.getSqlPatch().booleanValue();
            if (supportedPlatforms == null) {
                supportedPlatforms = subPatch.getSupportedPlatforms();
                continue;
            }
            if (supportedPlatforms.equals(subPatch.getSupportedPlatforms())) continue;
            throw new PatchPackageException("The composite patch at location " + patchLocation + "containssub patches with different supported platforms");
        }
        if (instanceShutdownPatchIsNull) {
            isInstanceShutdownPatch = true;
        }
        patch.setMinimumOPatchVersion(minOPatchVersion);
        patch.setRollingPatch(new Boolean(isRollingPatch));
        patch.setInstanceShutdownPatch(new Boolean(isInstanceShutdownPatch));
        patch.setSqlPatch(new Boolean(isSqlPatch));
        patch.setSupportedPlatforms(supportedPlatforms);
        File patchmdxml = new File(patchDir, "patchmd.xml");
        if (patchmdxml.isFile()) {
            try {
                patch.setPatchMDxml(IOUtils.getContent(new FileInputStream(patchmdxml)).toString());
            }
            catch (IOException e) {
                throw new PatchPackageException("Exception while reading patchmd.xml", (Throwable)e);
            }
        }
        if ((automationXmlFolderLocation = new File(patchDir, "automation")).exists()) {
            if (!automationXmlFolderLocation.isDirectory()) {
                throw new PatchPackageException(automationXmlFolderLocation.getAbsolutePath() + " exists but is not a folder");
            }
            if (automationXmlFolderLocation.listFiles() == null || automationXmlFolderLocation.listFiles().length == 0) {
                throw new PatchPackageException(automationXmlFolderLocation.getAbsolutePath() + " exists but does not contain any automationXmls.");
            }
            ArrayList<String> automationXmls = new ArrayList<String>();
            patch.setAutomationXmlLocation(automationXmlFolderLocation.getAbsolutePath());
            for (File file : automationXmlFolderLocation.listFiles()) {
                if (!file.isFile()) continue;
                try {
                    if ("messages.properties".equals(file.getName())) {
                        patch.setResourceBundle(IOUtils.getContent(new FileInputStream(file)).toString());
                        continue;
                    }
                    automationXmls.add(IOUtils.getContent(new FileInputStream(file)).toString());
                }
                catch (IOException e) {
                    throw new PatchPackageException("Couldn't read the file from automation folder", (Throwable)e);
                }
            }
            patch.setAutoXmls(automationXmls);
        } else {
            patch.setAutomationXmlLocation(null);
        }
        ArrayList applicableTargets = new ArrayList();
        patch.setApplicableTargets(applicableTargets);
        return patch;
    }

    public CompositePatch generate(String patchLocation, List<String> applicableTargets) throws PatchPackageException {
        CompositePatch patch = (CompositePatch)this.generate(patchLocation);
        patch.setApplicableTargets(PatchPlanner.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTargets));
        return patch;
    }

    public static CompositePatch addApplicabilityTargets(CompositePatch patch, List<String> applicableTargets) throws PatchPackageException {
        patch.setApplicableTargets(PatchPlanner.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTargets));
        return patch;
    }

    public CompositePatch generate(String patchID, String patchLocation, List<String> applicableTargets) throws PatchPackageException {
        CompositePatch patch = new CompositePatch();
        patch.setPatchLocation(patchLocation);
        patch.setPatchID(patchID);
        patch.setPatchIdOfRollbackPatch(patchID);
        patch.setApplicableTargets(PatchPlanner.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTargets));
        patch.setPatchTool(this.getPatchTool());
        return patch;
    }

    public String getPatchTool() {
        return PatchingTool.OPATCH.toString();
    }

    public boolean isPatchValid(Map map) throws PatchPackageException {
        String[] bundleXml = PatchUtils.getBundleXmlFromZipStreamMap(map);
        if (bundleXml != null && bundleXml.length != 0) {
            return false;
        }
        Map compositeMap = (Map)map.get("COMPOSITE_XML");
        int compositeXMLNum = compositeMap.size();
        return compositeXMLNum == 1;
    }

    public PatchPackage generate(Map map) throws PatchPackageException {
        CompositePatch compositePatch = new CompositePatch();
        compositePatch.setAutoXmls(PatchUtils.getAutoXmlsFromZipStreamMap(map));
        compositePatch.setResourceBundle(PatchUtils.getMessagePropertyFromZipStreamMap(map));
        compositePatch.setPatchMDxml(PatchUtils.getPatchmdFromZipMap(map));
        String compositeXML = PatchUtils.getCompositeXMlFromZipStreamMap(map);
        if (compositeXML == null) {
            logger.log(Level.FINE, "composite.xml was not found in the given patch zip file");
            throw new PatchPackageException("composite.xml was not found in the given patch zip file");
        }
        PatchCompositeXML pcxml = null;
        try {
            pcxml = new PatchCompositeXML(compositeXML);
        }
        catch (BundleValidationException e) {
            throw new PatchPackageException("The given compositexml context does not represent a valid ", (Throwable)e);
        }
        catch (IOException e) {
            throw new PatchPackageException("Exception while reading the composite.xml", (Throwable)e);
        }
        catch (BundleXmlException e) {
            throw new PatchPackageException("Exception occured while trying to get compositexml object", (Throwable)e);
        }
        List<String> subPatchIDs = pcxml.getSubPatches();
        ArrayList<OPatchSingleton> subPatches = new ArrayList<OPatchSingleton>();
        PatchInventory[] inventoryList = PatchUtils.getPatchInventoryFromZipMap(map);
        boolean isInstanceShutdownPatch = false;
        boolean instanceShutdownPatchIsNull = true;
        block4: for (String subPatchID : subPatchIDs) {
            for (int i = 0; i < inventoryList.length; ++i) {
                PatchInventory inventory = inventoryList[i];
                if (subPatchID.equals(inventory.getPatchID())) {
                    OPatchSingleton subPatch = new OPatchSingleton();
                    PatchUtils.setSingletonPatchInfoByPatchInventory(subPatch, inventory);
                    if (subPatch.getInstanceShutdownPatch() != null) {
                        instanceShutdownPatchIsNull = false;
                        isInstanceShutdownPatch |= subPatch.getInstanceShutdownPatch().booleanValue();
                    }
                    subPatches.add(subPatch);
                    continue block4;
                }
                if (compositePatch.getPatchID() != null) continue;
                compositePatch.setPatchID(inventory.getConstituentID());
                compositePatch.setPatchIdOfRollbackPatch(inventory.getConstituentID());
            }
        }
        if (instanceShutdownPatchIsNull) {
            isInstanceShutdownPatch = true;
        }
        compositePatch.setSubPatches(subPatches);
        compositePatch.setInstanceShutdownPatch(Boolean.valueOf(isInstanceShutdownPatch));
        return compositePatch;
    }
}

