/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.core.patch;

import com.oracle.glcm.patch.auto.db.framework.core.patch.DefaultPatchValidatorAndGenerator;
import com.oracle.glcm.patch.auto.db.framework.core.patch.OPatchSingletonPatchValidatorAndGenerator;
import com.oracle.glcm.patch.auto.db.framework.core.patch.PatchInventory;
import com.oracle.glcm.patch.auto.db.framework.core.patch.PatchPlanZipStreamMapConstructor;
import com.oracle.glcm.patch.auto.db.framework.core.patch.PatchUtils;
import com.oracle.glcm.patch.auto.db.framework.core.patch.TarArchiveInputStreamMapConstructor;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import dbmodel.bundle_xml.Subpatch;
import dbmodel.bundle_xml.SystemPatchBundleXML;
import dbmodel.bundle_xml.TargetType;
import dbmodel.patchmodel.EngineeredSystemPatch;
import dbmodel.patchmodel.GenericPatch;
import dbmodel.patchmodel.OPatchSingleton;
import dbmodel.patchmodel.PatchPackage;
import dbmodel.patchmodel.PatchingTool;
import dbmodel.util.BundleValidationException;
import dbmodel.util.BundleXmlException;
import dbmodel.util.BundleXmlHelper;
import dbmodel.util.BundleXmlUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import oracle.dbsysmodel.patchsdk.PatchPackageException;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class EngineeredSystemPatchGeneratorForZip {
    static Logger logger = Logger.getLogger(EngineeredSystemPatchGeneratorForZip.class.getName());

    public PatchPackage generate(String bundleXmlContent, String patchLocationWhilePatching, List<String> automationXmls) throws PatchPackageException {
        return this.generate(bundleXmlContent, null, patchLocationWhilePatching, automationXmls);
    }

    public PatchPackage generate(String bundleXmlContent, InputStream patchZip, String patchLocationWhilePatching, List<String> automationXmls) throws PatchPackageException {
        EngineeredSystemPatch patch = new EngineeredSystemPatch();
        patch.setPatchLocation(patchLocationWhilePatching);
        patch.setBundleXml(bundleXmlContent);
        patch.setAutoXmls(automationXmls);
        try {
            BundleXmlHelper bhxml = new BundleXmlHelper();
            SystemPatchBundleXML esysbundle = bhxml.readBundle(bundleXmlContent);
            patch.setSystemPatchBundleXML(esysbundle);
            patch.setMinOPlanVersion(esysbundle.getAutomation().getOplanVersion());
            patch.setPatchID(esysbundle.getPatchID());
            patch.setSubPatches(new ArrayList());
            for (Subpatch subpatch : esysbundle.getSubpatches()) {
                PatchingTool patchingTool = subpatch.getPatchingTool();
                logger.log(Level.INFO, "Engineered System contains a patch that is supported with patch tool" + patchingTool.toString());
                String subPatchVersion = this.getTargetVersion(subpatch.getTargetTypes());
                if (patchZip instanceof TarArchiveInputStream) {
                    patch.getSubPatches().add(this.instantiatePatch((TarArchiveInputStream)patchZip, subpatch, patchingTool, patchLocationWhilePatching, esysbundle.getFvalue().getMinOpatchVersion(), subPatchVersion));
                    continue;
                }
                patch.getSubPatches().add(this.instantiatePatch((ZipInputStream)patchZip, subpatch, patchingTool, patchLocationWhilePatching, esysbundle.getFvalue().getMinOpatchVersion(), subPatchVersion));
            }
        }
        catch (BundleXmlException e) {
            throw new PatchPackageException("Exception thrown while trying to create bundle object.", (Throwable)e);
        }
        catch (BundleValidationException e) {
            throw new PatchPackageException("The given bundle.xml couldn't be validated", (Throwable)e);
        }
        return patch;
    }

    private GenericPatch instantiatePatch(ZipInputStream patchZip, Subpatch subpatch, PatchingTool patchTool, String patchLocationWhilePatching, String minOpatchVer, String subPatchVersion) throws PatchPackageException {
        String FileSeparator = PatchPlanner.getInstance().getOPlanEnv().isTargetOnWindows() ? "\\" : "/";
        GenericPatch patch = null;
        if (patchTool == PatchingTool.OPATCH) {
            PatchPlanZipStreamMapConstructor constructor;
            HashMap<String, Object> map;
            PatchInventory inventory;
            patch = new GenericPatch();
            String subPatchDir = patchLocationWhilePatching + FileSeparator + subpatch.getLocation();
            logger.log(Level.INFO, "Found an opatch patch at location " + subPatchDir);
            ArrayList<String> applicableTargets = new ArrayList<String>();
            for (TargetType target : subpatch.getTargetTypes()) {
                applicableTargets.add(target.getType().toString());
            }
            logger.info("Found sub-patch " + subPatchDir + " applicable to home types " + applicableTargets + " in the bundle.");
            OPatchSingletonPatchValidatorAndGenerator osvg = new OPatchSingletonPatchValidatorAndGenerator();
            patch = osvg.generate(subpatch.getPatchID(), subPatchDir, applicableTargets);
            patch.setVersion(subPatchVersion);
            if (patchZip != null && (inventory = PatchUtils.getPatchInventoryByPatchIDFromMap(map = (constructor = new PatchPlanZipStreamMapConstructor()).ConstructMap(patchZip), subpatch.getPatchID())) != null) {
                Boolean isUpgrade = inventory.issqlPatchInUpgradeMode();
                if (isUpgrade != null) {
                    ((OPatchSingleton)patch).setSqlPatchUpgradeMode(isUpgrade);
                } else {
                    ((OPatchSingleton)patch).setSqlPatchUpgradeMode(Boolean.valueOf(false));
                }
            }
            assert (patch instanceof OPatchSingleton);
            constructor = (OPatchSingleton)patch;
        } else {
            String subPatchDir = patchLocationWhilePatching + FileSeparator + subpatch.getLocation();
            logger.log(Level.INFO, "Found an non opatch patch at location " + subPatchDir);
            ArrayList<String> applicableTargets = new ArrayList<String>();
            for (TargetType target : subpatch.getTargetTypes()) {
                applicableTargets.add(target.getType().toString());
            }
            logger.info("Found sub-patch " + subPatchDir + " applicable to home types " + applicableTargets + " in the bundle.");
            DefaultPatchValidatorAndGenerator osvg = new DefaultPatchValidatorAndGenerator();
            patch = (GenericPatch)osvg.generate(subPatchDir);
            patch.setApplicableTargets(PatchPlanner.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTargets));
            patch.setVersion(subPatchVersion);
            patch.setPatchID(subpatch.getPatchID());
            BundleXmlUtil.setMetadata((Subpatch)subpatch, (GenericPatch)patch);
        }
        return patch;
    }

    private GenericPatch instantiatePatch(TarArchiveInputStream patchTarGZ, Subpatch subpatch, PatchingTool patchTool, String patchLocationWhilePatching, String minOpatchVer, String subPatchVersion) throws PatchPackageException {
        String FileSeparator = PatchPlanner.getInstance().getOPlanEnv().isTargetOnWindows() ? "\\" : "/";
        GenericPatch patch = null;
        if (patchTool == PatchingTool.OPATCH) {
            TarArchiveInputStreamMapConstructor constructor;
            HashMap<String, Object> map;
            PatchInventory inventory;
            patch = new GenericPatch();
            String subPatchDir = patchLocationWhilePatching + FileSeparator + subpatch.getLocation();
            logger.log(Level.INFO, "Found an opatch patch at location " + subPatchDir);
            ArrayList<String> applicableTargets = new ArrayList<String>();
            for (TargetType target : subpatch.getTargetTypes()) {
                applicableTargets.add(target.getType().toString());
            }
            logger.info("Found sub-patch " + subPatchDir + " applicable to home types " + applicableTargets + " in the bundle.");
            OPatchSingletonPatchValidatorAndGenerator osvg = new OPatchSingletonPatchValidatorAndGenerator();
            patch = osvg.generate(subpatch.getPatchID(), subPatchDir, applicableTargets);
            patch.setVersion(subPatchVersion);
            if (patchTarGZ != null && (inventory = PatchUtils.getPatchInventoryByPatchIDFromMap(map = (constructor = new TarArchiveInputStreamMapConstructor()).ConstructMap(patchTarGZ), subpatch.getPatchID())) != null) {
                Boolean isUpgrade = inventory.issqlPatchInUpgradeMode();
                if (isUpgrade != null) {
                    ((OPatchSingleton)patch).setSqlPatchUpgradeMode(isUpgrade);
                } else {
                    ((OPatchSingleton)patch).setSqlPatchUpgradeMode(Boolean.valueOf(false));
                }
            }
            assert (patch instanceof OPatchSingleton);
            constructor = (OPatchSingleton)patch;
        } else {
            String subPatchDir = patchLocationWhilePatching + FileSeparator + subpatch.getLocation();
            logger.log(Level.INFO, "Found an non opatch patch at location " + subPatchDir);
            ArrayList<String> applicableTargets = new ArrayList<String>();
            for (TargetType target : subpatch.getTargetTypes()) {
                applicableTargets.add(target.getType().toString());
            }
            logger.info("Found sub-patch " + subPatchDir + " applicable to home types " + applicableTargets + " in the bundle.");
            DefaultPatchValidatorAndGenerator osvg = new DefaultPatchValidatorAndGenerator();
            patch = (GenericPatch)osvg.generate(subPatchDir);
            patch.setApplicableTargets(PatchPlanner.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTargets));
            patch.setVersion(subPatchVersion);
            patch.setPatchID(subpatch.getPatchID());
            BundleXmlUtil.setMetadata((Subpatch)subpatch, (GenericPatch)patch);
        }
        return patch;
    }

    private String getTargetVersion(List<TargetType> subPatchTargetTypes) throws PatchPackageException {
        String version = null;
        if (subPatchTargetTypes != null && !subPatchTargetTypes.isEmpty()) {
            Iterator<TargetType> iterator = subPatchTargetTypes.iterator();
            if (iterator.hasNext()) {
                TargetType subPatchTarget = iterator.next();
                version = subPatchTarget.getVersion();
            }
        } else {
            throw new PatchPackageException("The given patch has no target types.");
        }
        logger.info("sub patch version: " + version);
        return version;
    }
}

