/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.core.patch;

import com.oracle.glcm.patch.auto.db.framework.core.patch.PatchInventory;
import com.oracle.glcm.patch.auto.db.framework.core.patch.PatchUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.dbsysmodel.patchsdk.PatchPackageException;
import oracle.dbsysmodel.patchsdk.ZipStreamMapConstructor;

public class PatchPlanZipStreamMapConstructor
implements ZipStreamMapConstructor {
    Object[] bundleXMLArray = new Object[0];
    HashMap<String, byte[]> autosMap;
    HashMap<String, byte[]> patchmdMap = new HashMap();
    HashMap<String, byte[]> compositeMap;
    HashMap<String, Object> totalMap;
    String topDirName = "";
    Object[] messageArray;
    HashMap<String, byte[]> actionMap;
    HashMap<String, byte[]> invMap;
    HashMap<String, PatchInventory> patchInventoryMap;
    Object[] applyAutoStreamArray;
    Object[] rollbackAutoStreamArray;

    public PatchPlanZipStreamMapConstructor() {
        this.autosMap = new HashMap();
        this.actionMap = new HashMap();
        this.invMap = new HashMap();
        this.compositeMap = new HashMap();
        this.messageArray = new Object[0];
        this.totalMap = new HashMap();
        this.patchInventoryMap = new HashMap();
        this.applyAutoStreamArray = new Object[0];
        this.rollbackAutoStreamArray = new Object[0];
    }

    public HashMap<String, Object> ConstructMap(ZipInputStream zStream) throws PatchPackageException {
        if (zStream == null) {
            throw new PatchPackageException("The input stream of OPatch compatible patch is <null>. Please check input.");
        }
        try {
            byte[] tempBytes = null;
            ZipEntry ze = null;
            boolean topLevel = true;
            while ((ze = zStream.getNextEntry()) != null) {
                String entryName = ze.getName();
                if (topLevel) {
                    this.topDirName = entryName;
                    int divZeName = this.topDirName.indexOf("/");
                    if (divZeName != -1) {
                        String dirName;
                        this.topDirName = dirName = this.topDirName.substring(0, divZeName);
                    }
                    topLevel = false;
                    continue;
                }
                String patternStr = "((" + this.topDirName + "/)?((\\d+)((/\\d+)|(_.+)|(/custom/server/(\\d+).*))?)?)";
                String etcConfig = "/etc/config/";
                String actionPtrnStr = patternStr + etcConfig + "actions(\\.xml)";
                String invPtrnStr = patternStr + etcConfig + "inventory(\\.xml)";
                Pattern actionPattern = Pattern.compile(actionPtrnStr);
                Pattern invPattern = Pattern.compile(invPtrnStr);
                Matcher actionMatcher = actionPattern.matcher(entryName);
                Matcher invMatcher = invPattern.matcher(entryName);
                String patchmdStr = patternStr + "/patchmd(\\.xml)";
                Pattern patchmdPattern = Pattern.compile(patchmdStr);
                Matcher patchmdMatcher = patchmdPattern.matcher(entryName);
                String compositeStr = patternStr + etcConfig + "composite(\\.xml)";
                Pattern compositePattern = Pattern.compile(compositeStr);
                Matcher compositeMatcher = compositePattern.matcher(entryName);
                String bundleEntry = this.topDirName + "/" + "bundle.xml";
                String giBundleEntry = "bundle.xml";
                String applyAutoEntry = this.topDirName + "/automation/apply_automation.xml";
                String rollbackAutoEntry = this.topDirName + "/automation/rollback_automation.xml";
                String messageEntry = this.topDirName + "/automation/messages.properties";
                String gimessageEntry = "automation/messages.properties";
                String autosStream = "(" + this.topDirName + "/)?automation/(.+)\\.xml";
                Pattern autosPattern = Pattern.compile(autosStream);
                Matcher autosMatcher = autosPattern.matcher(entryName);
                if (actionMatcher.matches()) {
                    this.actionMap.put(entryName, PatchPlanZipStreamMapConstructor.readBytes(ze, zStream));
                }
                if (invMatcher.matches()) {
                    tempBytes = PatchPlanZipStreamMapConstructor.readBytes(ze, zStream);
                    PatchInventory patchInventory = new PatchInventory(PatchUtils.getContent(new ByteArrayInputStream(tempBytes)));
                    this.patchInventoryMap.put(entryName, patchInventory);
                    this.invMap.put(entryName, tempBytes);
                }
                if (patchmdMatcher.matches()) {
                    tempBytes = PatchPlanZipStreamMapConstructor.readBytes(ze, zStream);
                    Pattern locationPattern = Pattern.compile("(.*)(/patchmd\\.xml)");
                    Matcher locationMatcher = locationPattern.matcher(entryName);
                    String patchDir = "";
                    if (locationMatcher.matches()) {
                        patchDir = locationMatcher.group(1);
                    }
                    this.patchmdMap.put(patchDir, tempBytes);
                }
                if (compositeMatcher.matches()) {
                    String comPatchLocation = compositeMatcher.group(1);
                    Pattern comPatchPattern = Pattern.compile("(.*)(/.*)");
                    Matcher comPatchMatcher = comPatchPattern.matcher(comPatchLocation);
                    if (comPatchMatcher.matches()) {
                        this.compositeMap.put(comPatchMatcher.group(1), PatchPlanZipStreamMapConstructor.readBytes(ze, zStream));
                    }
                }
                if (autosMatcher.matches()) {
                    tempBytes = PatchPlanZipStreamMapConstructor.readBytes(ze, zStream);
                    this.autosMap.put(entryName, tempBytes);
                    if (entryName.equals(applyAutoEntry)) {
                        this.applyAutoStreamArray = new Object[2];
                        this.applyAutoStreamArray[0] = applyAutoEntry;
                        this.applyAutoStreamArray[1] = tempBytes;
                    }
                    if (entryName.equals(rollbackAutoEntry)) {
                        this.rollbackAutoStreamArray = new Object[2];
                        this.rollbackAutoStreamArray[0] = rollbackAutoEntry;
                        this.rollbackAutoStreamArray[1] = tempBytes;
                    }
                }
                if (entryName.equals(bundleEntry) || entryName.equals(giBundleEntry)) {
                    this.bundleXMLArray = new Object[2];
                    this.bundleXMLArray[0] = entryName;
                    this.bundleXMLArray[1] = PatchPlanZipStreamMapConstructor.readBytes(ze, zStream);
                }
                if (!entryName.equals(messageEntry) && !entryName.equals(gimessageEntry)) continue;
                this.messageArray = new Object[2];
                this.messageArray[0] = entryName;
                this.messageArray[1] = PatchPlanZipStreamMapConstructor.readBytes(ze, zStream);
            }
            this.totalMap.put("PATCHMD_XML", this.patchmdMap);
            this.totalMap.put("ACTION_XMLS", this.actionMap);
            this.totalMap.put("INVENTORY_XMLS", this.invMap);
            this.totalMap.put("PATCH_INVENTORY", this.patchInventoryMap);
            this.totalMap.put("TOP_DIR_NAME", this.topDirName);
            this.totalMap.put("BUNDLE_XML", this.bundleXMLArray);
            this.totalMap.put("AUTOMATION_XMLS", this.autosMap);
            this.totalMap.put("COMPOSITE_XML", this.compositeMap);
            this.totalMap.put("MESSAGE_PROPERTIES", this.messageArray);
            this.totalMap.put("APPLY_AUTOMATION_XMLS", this.applyAutoStreamArray);
            this.totalMap.put("ROLLBACK_AUTOMATION_XMLS", this.rollbackAutoStreamArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            PatchPackageException oe = new PatchPackageException(e.getMessage());
            throw oe;
        }
        return this.totalMap;
    }

    private static byte[] readBytes(ZipEntry ze, ZipInputStream zStream) throws Exception {
        if (ze.getSize() < 0L) {
            return PatchPlanZipStreamMapConstructor.readBytesForNegativeSizeZipEntry(zStream);
        }
        int off = 0;
        int len = -1;
        byte[] data = new byte[(int)ze.getSize()];
        while ((len = zStream.read(data, off, (int)ze.getSize() - off)) > 0) {
            off += len;
        }
        return data;
    }

    private static byte[] readBytesForNegativeSizeZipEntry(ZipInputStream zStream) throws Exception {
        String line;
        BufferedReader bufferReader = new BufferedReader(new InputStreamReader(zStream));
        StringBuilder builder = new StringBuilder();
        while ((line = bufferReader.readLine()) != null) {
            builder.append(line);
        }
        return builder.toString().getBytes();
    }
}

