/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.idprocessor;

import com.oracle.glcm.patch.auto.db.framework.idprocessor.AnalyzedpatchInfoList;
import com.oracle.glcm.patch.auto.db.framework.patchtarget.PatchApplicableTarget;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

@XmlType(name="analyzed-patchid-details", propOrder={"sessionID", "patchInformation"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="analyzed-patchid-details")
class AnalyzedPatchInfoStore {
    @XmlElement(name="sessionid", required=true)
    private String sessionID = "";
    @XmlElement(name="patching-information-list", required=true)
    @XmlElementWrapper(name="patching-information-list")
    private ConcurrentMap<PatchApplicableTarget, AnalyzedpatchInfoList> patchInformation = new ConcurrentHashMap<PatchApplicableTarget, AnalyzedpatchInfoList>();

    AnalyzedPatchInfoStore() {
    }

    void init(String sessionID) {
        this.sessionID = sessionID;
    }

    void storePatchInformation(PatchApplicableTarget target, OPatchPatchInfo patchInfo) {
        if (this.patchInformation.containsKey(target)) {
            AnalyzedpatchInfoList appliedPatchList = (AnalyzedpatchInfoList)this.patchInformation.get(target);
            if (!appliedPatchList.containsPatchInfo(patchInfo)) {
                appliedPatchList.addPatchDetailsToList(patchInfo);
            }
        } else {
            AnalyzedpatchInfoList analyzedList = new AnalyzedpatchInfoList();
            analyzedList.addPatchDetailsToList(patchInfo);
            this.patchInformation.put(target, analyzedList);
        }
    }

    CopyOnWriteArrayList<OPatchPatchInfo> getListofAppliedPatches(PatchApplicableTarget target) {
        CopyOnWriteArrayList<OPatchPatchInfo> patchList = new CopyOnWriteArrayList<OPatchPatchInfo>();
        if (this.patchInformation.containsKey(target)) {
            patchList = ((AnalyzedpatchInfoList)this.patchInformation.get(target)).getPatchList();
        }
        return patchList;
    }

    Set<PatchApplicableTarget> getPatchTargetList() {
        return this.patchInformation.keySet();
    }

    String getSessionID() {
        return this.sessionID;
    }

    void clear() {
        this.patchInformation.clear();
    }

    public int size() {
        return this.patchInformation.size();
    }
}

