/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.sdk.readme;

import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.readme.ReadmeDecorator;
import com.oracle.glcm.patch.auto.db.framework.sdk.readme.ReadmeFactory;
import com.oracle.glcm.patch.auto.db.framework.sdk.readme.ReadmeGeneratorBase;
import com.oracle.glcm.patch.auto.db.framework.sdk.readme.TextTreeGenerator;
import com.oracle.glcm.patch.auto.db.framework.sdk.resource.PatchPlanBundle;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OUIComponent;
import dbmodel.common.OracleHome;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;

public class TextReadmeGenerator
extends ReadmeGeneratorBase {
    static Logger logger = Logger.getLogger(TextReadmeGenerator.class.getName());
    protected static final String TAB_CHAR = "   ";
    private File readme;
    private ArrayList<File> readmeList;
    private FileWriter fw;
    private int stepNo = 1;
    private boolean isConfigLogged = false;

    public TextReadmeGenerator(ReadmeFactory rf) {
        super(rf);
        this.setDecoratorContext(new ReadmeDecorator());
    }

    public void initialize() throws IOException {
        this.readmeList = new ArrayList();
        this.readme = null;
        this.readme = this.getReadmeFile();
        if (!this.readmeList.contains(this.readme)) {
            this.readmeList.add(this.readme);
        }
        assert (!this.readme.isFile());
        this.fw = new FileWriter(this.readme, true);
    }

    public void deInitialize() throws IOException {
        this.fw.close();
        this.fw = null;
    }

    @Override
    public List<File> logStepsInReadme(List<ExecutionStep> steps) throws IOException {
        if (!this.isConfigLogged) {
            this.writePatchTitle();
            this.writeConfigImage();
            this.isConfigLogged = true;
        }
        if (this.readme != null) {
            this.writeSteps(this.readme, steps);
        }
        return this.readmeList;
    }

    protected void writeSteps(File readme, List<ExecutionStep> steps) throws IOException {
        this.writeMessageBody(this.fw, steps, this.STEP, 1);
    }

    @Override
    protected File getReadmeFile() {
        return PatchPlanner.getInstance().getLogInfo().getReadmeTxt();
    }

    protected File getReadmeFile(int index) {
        return PatchPlanner.getInstance().getLogInfo().getReadmeTxt(index);
    }

    protected void writeMessageBody(FileWriter fw, List<ExecutionStep> steps, String stepPrefix, int indent) throws IOException {
        for (ExecutionStep step : steps) {
            List<ExecutionStep.Command> shellCommands;
            if (step.getCommand() == null || step.getCommand().size() == 0) {
                return;
            }
            String stepTitle = this.getTitle(step);
            if (stepTitle == null) {
                stepTitle = "";
            }
            fw.write(this.indt(indent) + stepPrefix + "." + this.stepNo + ": " + stepTitle + "\n\n");
            if (this.getMessage(step) != null) {
                fw.write(this.indt(indent + 1) + this.getMessage(step) + "\n\n");
            }
            if ((shellCommands = step.getCommand()) != null) {
                String userName = "";
                if (step.getUser() != null && step.getUser().getValue() != null) {
                    userName = step.getUser().getValue();
                }
                String prefixToken = shellCommands.size() > 1 ? "COMMANDS_USER_HOST_INFO" : "COMMAND_USER_HOST_INFO";
                String prefix = PatchPlanBundle.getReadmeMessage(prefixToken, userName, step.getHost().getDisplayName(), "'", "'");
                boolean haveWritten = false;
                String ind = this.indt(indent + 2);
                for (ExecutionStep.Command cmd : shellCommands) {
                    if (cmd == null || cmd.getValue() == null || cmd.getValue().trim().equals("")) continue;
                    if (!haveWritten) {
                        fw.write(ind + prefix);
                        fw.write("\n\n");
                        haveWritten = true;
                    }
                    if (cmd.getType().isNonShellPrompt()) {
                        fw.write(ind + cmd.getType().getPrompt(step) + " ");
                    } else {
                        fw.write(ind + "[" + userName + "@" + step.getHost().getName() + "]" + cmd.getType().getPrompt(step) + " ");
                    }
                    fw.write("\n");
                    fw.write(ind + cmd.getValue() + "\n\n");
                    String error = this.getCommandErrorMessage(cmd, step);
                    if (error == null) continue;
                    fw.write(ind + error + "\n");
                }
            }
            fw.write("\n");
            if (this.getTroubleshoot(step) != null) {
                fw.write(this.indt(indent + 1) + this.TROUBLE + ":" + this.getTroubleshoot(step) + "\n\n\n");
            }
            ++this.stepNo;
        }
    }

    protected String indt(int i) {
        StringBuilder sb = new StringBuilder();
        while (i > 0) {
            sb.append(TAB_CHAR);
            --i;
        }
        return sb.toString();
    }

    public void writePatchTitle() throws IOException {
        String operation = ReadmeFactory.getOperationBundlePropertySuffixKey(PatchPlanner.getInstance().getOPlanEnv());
        this.fw.write("\n\n");
        String msg = PatchPlanBundle.getPrefixedMessage(TextReadmeGenerator.class, this.rf.getBundleMessagePrefix(), "DETAILED_" + operation + "_STEPS_HEADER", new Object[0]);
        this.fw.write(msg + "\n" + this.underline(msg));
        this.fw.write("\n\n");
    }

    private String underline(String msg) {
        if (msg == null || msg.equals("")) {
            return "";
        }
        return this.underline(msg.length());
    }

    private String underline(int len) {
        StringBuilder buffer = new StringBuilder();
        for (int i = len; i >= 0; --i) {
            buffer.append("-");
        }
        buffer.append("\n");
        return buffer.toString();
    }

    protected void writeConfigImage() throws IOException {
        String str = PatchPlanBundle.getReadmeMessage("CONFIG_IMAGE_HEADER", new Object[0]);
        this.fw.write(str + "\n" + this.underline(str));
        this.fw.write("\n");
        this.fw.write(PatchPlanBundle.getReadmeMessage("CONFIG_IMAGE_DESCRIPTION", "*", "*", ""));
        this.fw.write("\n\n");
        this.writeStatMessage();
        String textTree = this.getConfigTextTree();
        this.fw.write(textTree);
        this.fw.write("\n");
    }

    protected void writeStatMessage() throws IOException {
        this.fw.write(PatchPlanBundle.getReadmeMessage("README_CONTENT_STATS", "'" + this.rf.getSystemInstanceEntityCount() + "'"));
        this.fw.write("\n\n");
    }

    protected String getConfigTextTree() {
        logger.finest("Starting: generate config tree text.");
        TextTreeGenerator tg = new TextTreeGenerator();
        TextTreeGenerator.TreeNodeLabelResolver res = new TextTreeGenerator.TreeNodeLabelResolver(){

            @Override
            public String getLabel(DefaultMutableTreeNode node) {
                AbstractBaseTarget abt;
                AbstractBaseTarget abstractBaseTarget = abt = node.getUserObject() instanceof AbstractBaseTarget ? (AbstractBaseTarget)node.getUserObject() : null;
                if (abt == null) {
                    return "unknown entity";
                }
                String prefix = PatchPlanner.getInstance().getOPlanIntgFactory().getSystemInstance2UI().getDisplayString(abt);
                prefix = prefix == null ? abt.getClass().getSimpleName() + ": " : prefix + ": ";
                String str = abt.getDisplayName();
                if (abt instanceof OracleHome) {
                    str = ((OracleHome)abt).getPath() + " (" + ((OracleHome)abt).getDescription() + ")";
                    if (((OracleHome)abt).getTopLevelOUI() != null && ((OracleHome)abt).getTopLevelOUI().size() > 0) {
                        str = str + "(Version: " + ((OUIComponent)((OracleHome)abt).getTopLevelOUI().get(0)).getVersion() + ")";
                    }
                }
                str = prefix + str;
                return str;
            }
        };
        tg.setTreeNodeLabelResolver(res);
        String tree = tg.getTreeText(this.rf.getConfigTree());
        logger.finest("End: generate config tree text.");
        return tree;
    }
}

