/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.sdk.resource;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.db.framework.sdk.ExecutionMode;
import com.oracle.glcm.patch.auto.db.framework.sdk.intg.PatchPlanIntgFactory;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanEnv;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanInternalException;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.readme.TextReadmeGenerator;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.db_crs.CRSCluster;
import dbmodel.patchmodel.PatchPackage;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.Automation;
import oracle.opatch.system.db.automation.jaxb.Readme;
import oracle.opatch.system.db.automation.jaxb.SqlCommand;
import oracle.sysman.oii.oiii.OiiiVersion;

public class PatchPlanBundle {
    public static final String LOOK = "LOOK(";
    public static final String LOOK_E = ")";
    static Logger logger = Logger.getLogger(PatchPlanBundle.class.getName());
    static Map<String, String> msgMapForEM = new HashMap<String, String>();

    public static String getMessage(Class clazz, String resName, Object ... params) throws MissingResourceException {
        String message = BundleUtils.getMessage(clazz, resName, null);
        if (message == null) {
            return null;
        }
        String trim = message.trim();
        if (trim.startsWith(LOOK) && trim.endsWith(LOOK_E)) {
            String newKey = trim.substring(LOOK.length());
            newKey = newKey.substring(0, newKey.length() - LOOK_E.length());
            return PatchPlanBundle.getMessage(clazz, newKey, params);
        }
        if (params == null || params.length == 0) {
            return PatchPlanBundle.replaceOPatchautoMessageFor12(message);
        }
        return PatchPlanBundle.replaceOPatchautoMessageFor12(MessageFormat.format(message, params));
    }

    public static String getReadmeMessage(String resName, Object ... params) throws MissingResourceException {
        return PatchPlanBundle.getMessage(TextReadmeGenerator.class, resName, params);
    }

    public static String getPrefixedReadmeMessage(String prefix, String resName, Object ... params) throws MissingResourceException {
        if (prefix == null || prefix.equals("")) {
            return PatchPlanBundle.getReadmeMessage(resName, params);
        }
        return PatchPlanBundle.getPrefixedMessage(TextReadmeGenerator.class, prefix, resName, params);
    }

    public static boolean checkIfMessageExisted(Class clazz, String resName) throws MissingResourceException {
        String message = BundleUtils.getMessage(clazz, resName, null);
        return !StringUtil.isNullOrEmpty((String)message);
    }

    public static String getMessage(String resName, Object ... params) throws MissingResourceException, FileNotFoundException, IOException {
        Automation e;
        PatchPlanEnv oplanenv = PatchPlanner.getInstance().getOPlanEnv();
        URL rburl = null;
        if (oplanenv.getAutomationFileMap() != null) {
            e = oplanenv.getAutomationFileMap().entrySet().iterator().next();
            rburl = new URL((URL)e.getValue(), ((Automation)e.getKey()).getBundleFile());
        } else if (oplanenv.getAutomations() != null) {
            e = oplanenv.getAutomations().iterator().next();
            rburl = new URL(e.getBundleFile());
        }
        InputStream fis = rburl.openStream();
        PropertyResourceBundle rb = new PropertyResourceBundle(fis);
        String output = rb.getString(resName);
        return PatchPlanBundle.replaceOPatchautoMessageFor12(MessageFormat.format(output, params));
    }

    public static String getPrefixedMessage(Class clazz, String prefix, String resName, Object ... params) throws MissingResourceException {
        if (prefix == null || prefix.equals("")) {
            return PatchPlanBundle.getMessage(clazz, resName, params);
        }
        String message = null;
        try {
            message = PatchPlanBundle.getMessage(clazz, prefix + "-" + resName, params);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (message == null) {
            return PatchPlanBundle.getMessage(clazz, resName, params);
        }
        return message;
    }

    private static String replaceOPatchautoMessageFor12(String message) {
        OiiiVersion baseVersionObj;
        OiiiVersion versionToCompareObj;
        String version;
        AbstractBaseTarget rootTarget;
        if (message != null && PatchPlanner.getInstance().haveInitIntgFactory() && PatchPlanner.getInstance().getOPlanEnv().getExecutionMode().equals(ExecutionMode.OPATCH.toString()) && (rootTarget = PatchPlanner.getInstance().getConfigGraph().getRootVertex()) != null && rootTarget instanceof CRSCluster && (version = PatchPlanner.getInstance().getConfigGraph().getRootVertex().getVersion()) != null && ((versionToCompareObj = new OiiiVersion(version)).equals(baseVersionObj = new OiiiVersion("12.1")) || versionToCompareObj.laterThan(baseVersionObj))) {
            message = message.replaceAll("OPatch [a|A]uto", "OPatchauto");
        }
        return message;
    }

    public static String getPrefixedMessageNE(Class clazz, String prefix, String resName, Object ... params) {
        String res = null;
        try {
            res = PatchPlanBundle.getPrefixedMessage(clazz, prefix, resName, params);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return res;
    }

    public static String getMessageNE(Class clazz, String resName, Object ... params) {
        String res = null;
        try {
            res = PatchPlanBundle.getMessage(clazz, resName, params);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return res;
    }

    public static String getATitle(Readme readme) {
        String res;
        if (readme == null) {
            return null;
        }
        if (readme.getTitle() == null) {
            return null;
        }
        if (readme.getTitle().getPropertyKey() != null && (res = PatchPlanBundle.getFromAutomationResourceBundle(readme.getTitle().getPropertyKey())) != null) {
            return res;
        }
        if (readme.getTitle().getValue() == null) {
            return null;
        }
        if (readme.getTitle().getValue().equals("")) {
            return null;
        }
        return readme.getTitle().getValue();
    }

    public static String getStepMessage(Readme readme) {
        String res;
        if (readme == null) {
            return null;
        }
        if (readme.getMessage() == null) {
            return null;
        }
        ExecutionMode executionMode = PatchPlanner.getInstance().getOPlanEnv().getExecutionMode();
        if (readme.getMessage().getPropertyKey() != null && (res = PatchPlanBundle.getFromAutomationResourceBundle(readme.getMessage().getPropertyKey())) != null) {
            if (executionMode.equals((Object)ExecutionMode.EM)) {
                return MessageFormat.format(res, "'", "'");
            }
            return res;
        }
        if (readme.getMessage().getValue() == null) {
            return null;
        }
        if (readme.getMessage().getValue().equals("")) {
            return null;
        }
        if (executionMode.equals((Object)ExecutionMode.EM)) {
            return MessageFormat.format(readme.getMessage().getValue(), "'", "'");
        }
        return readme.getMessage().getValue();
    }

    public static String getStepTroubleshoot(Readme readme) {
        String res;
        if (readme == null) {
            return null;
        }
        if (readme.getTroubleshoot() == null) {
            return null;
        }
        ExecutionMode executionMode = PatchPlanner.getInstance().getOPlanEnv().getExecutionMode();
        if (readme.getTroubleshoot().getPropertyKey() != null && (res = PatchPlanBundle.getFromAutomationResourceBundle(readme.getTroubleshoot().getPropertyKey())) != null) {
            if (executionMode.equals((Object)ExecutionMode.EM)) {
                return MessageFormat.format(res, "'", "'");
            }
            return res;
        }
        if (readme.getTroubleshoot().getValue() == null) {
            return null;
        }
        if (readme.getTroubleshoot().getValue().equals("")) {
            return null;
        }
        if (executionMode.equals((Object)ExecutionMode.EM)) {
            return MessageFormat.format(readme.getTroubleshoot().getValue(), "'", "'");
        }
        return readme.getTroubleshoot().getValue();
    }

    public static String getErrorMessage(SqlCommand.ErrorHandling.FatalError error) {
        String res;
        if (error == null) {
            return null;
        }
        if (error.getMessage() == null) {
            return null;
        }
        if (error.getMessage().getPropertyKey() != null && (res = PatchPlanBundle.getFromAutomationResourceBundle(error.getMessage().getPropertyKey())) != null) {
            return res;
        }
        if (error.getMessage().getValue() == null) {
            return null;
        }
        if (error.getMessage().getValue().equals("")) {
            return null;
        }
        return error.getMessage().getValue();
    }

    public static String getFromAutomationResourceBundle(String resName) {
        ResourceBundle rb;
        String message = null;
        PatchPlanIntgFactory oplanIntgFactory = PatchPlanner.getInstance().getOPlanIntgFactory();
        String automationResource = oplanIntgFactory.getAutomationResourceBundleLocation();
        int index = automationResource.indexOf(".properties");
        if (index != -1) {
            automationResource = automationResource.substring(0, index);
        }
        if (automationResource != null) {
            try {
                rb = ResourceBundle.getBundle(automationResource, Locale.getDefault(), PatchPlanBundle.class.getClassLoader());
                message = rb.getString(resName);
            }
            catch (MissingResourceException e) {
                message = null;
            }
        }
        if (message == null) {
            try {
                String name = PatchPlanBundle.class.getPackage().getName() + ".AutomationBundle";
                rb = ResourceBundle.getBundle(name, Locale.getDefault(), PatchPlanBundle.class.getClassLoader());
                message = rb.getString(resName);
            }
            catch (MissingResourceException e) {
                message = null;
            }
        }
        if (message == null) {
            try {
                String rbFile;
                PatchPackage primaryPatch = PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getPrimaryPatchPackage();
                if (primaryPatch != null && primaryPatch.getAutoXmls() != null && !primaryPatch.getAutoXmls().isEmpty() && (rbFile = primaryPatch.getResourceBundle()) != null) {
                    rb = new PropertyResourceBundle(new ByteArrayInputStream(rbFile.getBytes()));
                    message = rb.getString(resName);
                }
            }
            catch (IOException e) {
                throw new PatchPlanInternalException("Fail to get the message string " + resName + " from the resource bundle ", e);
            }
        }
        message = PatchPlanBundle.replaceMsgForEM(message);
        return PatchPlanBundle.replaceOPatchautoMessageFor12(message);
    }

    private static String replaceMsgForEM(String message) {
        ExecutionMode executionMode;
        String result = message;
        if (result != null && ExecutionMode.EM.equals((Object)(executionMode = PatchPlanner.getInstance().getOPlanEnv().getExecutionMode()))) {
            Set<String> matchKeys = msgMapForEM.keySet();
            for (String matchKey : matchKeys) {
                result = result.replace(matchKey, msgMapForEM.get(matchKey));
            }
        }
        return result;
    }

    static {
        msgMapForEM.put("%Host.hostName%", PatchPlanBundle.getMessage(PatchPlanner.class, "HOST_NAME_REPLACE", new Object[0]));
        msgMapForEM.put("%OracleHome.description%", PatchPlanBundle.getMessage(PatchPlanner.class, "ORACLE_HOME_DESC_REPLACE", new Object[0]));
        msgMapForEM.put("%RACDatabase.databaseName%", "");
        msgMapForEM.put("%OracleHome.homeName%", "");
    }
}

