/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.validation;

import com.oracle.cie.common.util.ResourceBundleManager;
import dbmodel.BaseClass;
import dbmodel.common.AbstractBaseTarget;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;

public class BundleUtils {
    public static String getMessage(Class clazz, String resName, Object ... params) throws MissingResourceException {
        String message = ResourceBundleManager.getString((String)"opatchauto", (String)resName);
        if (message == null) {
            return null;
        }
        if (params == null || params.length == 0) {
            return message;
        }
        return MessageFormat.format(message, params);
    }

    public static String makeStringOutOfList(List<BaseClass> listOfOffendingObjects) {
        String list = "\n";
        for (BaseClass object : listOfOffendingObjects) {
            AbstractBaseTarget abt = (AbstractBaseTarget)object;
            list = list + "\t" + abt.getName() + "\n";
        }
        return list;
    }

    public static String makeStringForFailedResultMap(Map<AbstractBaseTarget, List<Method>> failedResultMap) {
        String mapMessage = "\n";
        for (AbstractBaseTarget abt : failedResultMap.keySet()) {
            mapMessage = mapMessage + "\n\t" + abt.getClass().getSimpleName() + "{" + abt.getName() + "}:";
            for (Method meth : failedResultMap.get(abt)) {
                String name = meth.getName();
                name = name.startsWith("get") ? name.substring(3) : name;
                mapMessage = mapMessage + "\n\t\t" + name;
            }
        }
        return mapMessage;
    }
}

