/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller;

import com.oracle.glcm.patch.auto.db.integration.controller.CommandExecutionThread;
import com.oracle.glcm.patch.auto.db.integration.controller.ExecutionCommand;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ParallelExecution {
    protected final Logger _logger = Logger.getLogger(this.getClass().getName());
    private ArrayList<ExecutionCommand> commands = new ArrayList();
    private String owner;
    private ArrayList<CommandExecutionThread> results = new ArrayList();

    public ArrayList<CommandExecutionThread> getResults() {
        return this.results;
    }

    public ParallelExecution(ArrayList<ExecutionCommand> commands, String owner) {
        this.commands = commands;
        this.owner = owner;
    }

    public void execute() {
        ArrayList<CommandExecutionThread> cmdExecThreads = new ArrayList<CommandExecutionThread>();
        for (ExecutionCommand ec : this.commands) {
            CommandExecutionThread cet = new CommandExecutionThread(ec.getCommand(), this.owner, ec.getHostname());
            cmdExecThreads.add(cet);
        }
        this._logger.info("\nStarting parallel execution of the steps\n");
        for (CommandExecutionThread cet : cmdExecThreads) {
            cet.start();
        }
        for (CommandExecutionThread cet : cmdExecThreads) {
            try {
                cet.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        for (CommandExecutionThread cet : cmdExecThreads) {
            this.results.add(cet);
        }
    }
}

