/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller;

import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;

public class RemoteContentTransferHandler {
    private final Logger _logger = Logger.getLogger(RemoteContentTransferHandler.class.getName());
    private boolean isSharedLocation = false;

    private RemoteContentTransferHandler() {
    }

    public static RemoteContentTransferHandler getInstance() {
        return Loader._handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferFileToRemoteHost(String location, File contentFile, RemoteConnectionHandler handler, DeleteStatus deleteStatus) throws RemoteConnectionException {
        if (this.isSharedLocation()) {
            RemoteContentTransferHandler remoteContentTransferHandler = this;
            synchronized (remoteContentTransferHandler) {
                this.transfer(location, contentFile, handler, deleteStatus);
            }
        } else {
            this.transfer(location, contentFile, handler, deleteStatus);
        }
    }

    private void transfer(String location, File contentFile, RemoteConnectionHandler handler, DeleteStatus deleteStatus) throws RemoteConnectionException {
        boolean isTransferRequired = false;
        String locationToDelete = null;
        if (handler != null) {
            if (!handler.exists(location)) {
                isTransferRequired = true;
                locationToDelete = location;
            } else if (!this.ifFileExists(location, contentFile, handler)) {
                isTransferRequired = true;
                locationToDelete = new File(location + File.separator + contentFile.getName()).getAbsolutePath();
            }
            if (isTransferRequired) {
                if (this._logger.isLoggable(Level.INFO)) {
                    this._logger.info("Pushing file " + contentFile.getName() + " to location " + location + " on remote host " + handler.getHost());
                }
                handler.put(location, contentFile);
                if (deleteStatus == DeleteStatus.DELETE_ON_EXIT) {
                    handler.deleteOnClose(locationToDelete);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mkDirOnRemoteHost(String location, RemoteConnectionHandler handler, DeleteStatus deleteStatus) throws RemoteConnectionException {
        if (this.isSharedLocation()) {
            RemoteContentTransferHandler remoteContentTransferHandler = this;
            synchronized (remoteContentTransferHandler) {
                this.mkDirOnRemote(location, handler, deleteStatus);
            }
        } else {
            this.mkDirOnRemote(location, handler, deleteStatus);
        }
    }

    private void mkDirOnRemote(String location, RemoteConnectionHandler handler, DeleteStatus deleteStatus) throws RemoteConnectionException {
        if (handler != null && !handler.exists(location)) {
            if (this._logger.isLoggable(Level.INFO)) {
                this._logger.info("Creating directory " + location + " on remote host " + handler.getHost());
            }
            handler.mkdir(location);
            if (deleteStatus == DeleteStatus.DELETE_ON_EXIT) {
                handler.deleteOnClose(location);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mkDirOnRemoteHost(String location, RemoteConnectionHandler handler, DeleteStatus deleteStatus, String owner, Credential credential) throws RemoteConnectionException {
        if (this.isSharedLocation()) {
            RemoteContentTransferHandler remoteContentTransferHandler = this;
            synchronized (remoteContentTransferHandler) {
                this.mkDirOnRemoteAsDifferentUser(location, handler, deleteStatus, owner, credential);
            }
        } else {
            this.mkDirOnRemoteAsDifferentUser(location, handler, deleteStatus, owner, credential);
        }
    }

    private void mkDirOnRemoteAsDifferentUser(String location, RemoteConnectionHandler handler, DeleteStatus deleteStatus, String owner, Credential credential) throws RemoteConnectionException {
        if (handler != null && !handler.exists(location)) {
            if (this._logger.isLoggable(Level.INFO)) {
                this._logger.info("Creating directory " + location + " on remote host " + handler.getHost());
            }
            String password = null;
            try {
                password = new String(credential.getPassword());
            }
            catch (OPatchAutoException e) {
                password = null;
            }
            String executor = handler.getHost().getUsername();
            String cmd = "";
            cmd = executor.equalsIgnoreCase(owner) ? " mkdir -p " + location : "echo '" + new String(password) + "' | sudo -S -u " + owner + " mkdir -p " + location;
            this.execute(cmd, handler);
            if (deleteStatus == DeleteStatus.DELETE_ON_EXIT) {
                handler.deleteOnClose(location);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chmod(String location, int mode, RemoteConnectionHandler handler, String owner, Credential credential) throws RemoteConnectionException {
        String password = null;
        try {
            password = new String(credential.getPassword());
        }
        catch (OPatchAutoException e) {
            password = null;
        }
        if (this.isSharedLocation()) {
            RemoteContentTransferHandler remoteContentTransferHandler = this;
            synchronized (remoteContentTransferHandler) {
                this.chmodAsOwner(location, mode, handler, owner, password);
            }
        } else {
            this.chmodAsOwner(location, mode, handler, owner, password);
        }
    }

    private void chmodAsOwner(String location, int mode, RemoteConnectionHandler handler, String owner, String password) throws RemoteConnectionException {
        if (handler != null && handler.exists(location)) {
            if (this._logger.isLoggable(Level.INFO)) {
                this._logger.info("Changing permission of " + location + " on remote host " + handler.getHost());
            }
            String command = "echo '" + password + "' | sudo -S -u " + owner + " chmod " + mode + " " + location;
            this.execute(command, handler);
            this._logger.info("Changing permission completed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chmod(String location, int mode, RemoteConnectionHandler handler) throws RemoteConnectionException {
        if (this.isSharedLocation()) {
            RemoteContentTransferHandler remoteContentTransferHandler = this;
            synchronized (remoteContentTransferHandler) {
                this.chmodOnLocation(location, mode, handler);
            }
        } else {
            this.chmodOnLocation(location, mode, handler);
        }
    }

    private void chmodOnLocation(String location, int mode, RemoteConnectionHandler handler) throws RemoteConnectionException {
        if (handler != null && handler.exists(location)) {
            if (this._logger.isLoggable(Level.INFO)) {
                this._logger.info("Changing permission of " + location + " on remote host " + handler.getHost());
            }
            handler.chmod(location, mode);
            this._logger.info("Changing permission completed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chown(String location, String home, RemoteConnectionHandler handler, String owner, Credential credential) throws RemoteConnectionException {
        String password = null;
        try {
            password = new String(credential.getPassword());
        }
        catch (OPatchAutoException e) {
            password = null;
        }
        if (this.isSharedLocation()) {
            RemoteContentTransferHandler remoteContentTransferHandler = this;
            synchronized (remoteContentTransferHandler) {
                this.chownAsOwner(location, home, handler, owner, password);
            }
        } else {
            this.chownAsOwner(location, home, handler, owner, password);
        }
    }

    private void chownAsOwner(String location, String home, RemoteConnectionHandler handler, String owner, String password) throws RemoteConnectionException {
        if (handler != null && handler.exists(location)) {
            if (this._logger.isLoggable(Level.INFO)) {
                this._logger.info("Changing owner of " + location + " on remote host " + handler.getHost());
            }
            String homeOwner = FileUtility.checkFileOwner((File)new File(home, "oraInst.loc"));
            String group = OiixEnvironmentOps.ssgetCurrentGroupOfUserux((String)homeOwner);
            String command = "echo '" + password + "' | sudo -S -u " + owner + " chown -R " + homeOwner + ":" + group + " " + location + "  > /dev/null";
            this.execute(command, handler);
            this._logger.info("Changing Owner completed.");
        }
    }

    private void execute(String command, RemoteConnectionHandler handler) throws RemoteConnectionException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this._logger.info("Executing command through handler: " + command);
            handler.exec(command, (OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException e) {
            this._logger.warning("IOException: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzipPatchOnRemote(RemoteConnectionHandler handler, String oracleHomePath, String patchZipLocation, String sourceZipLocation, String perlLibPath) throws RemoteConnectionException {
        if (this.isSharedLocation()) {
            RemoteContentTransferHandler remoteContentTransferHandler = this;
            synchronized (remoteContentTransferHandler) {
                this.unZipPatch(handler, oracleHomePath, patchZipLocation, sourceZipLocation, "", perlLibPath);
            }
        } else {
            this.unZipPatch(handler, oracleHomePath, patchZipLocation, sourceZipLocation, "", perlLibPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzipPatchOnRemote(RemoteConnectionHandler handler, String oracleHomePath, String patchZipLocation, String sourceZipLocation, String owner, Credential credential, String perlLibPath) throws RemoteConnectionException {
        String password = null;
        try {
            password = new String(credential.getPassword());
        }
        catch (OPatchAutoException e) {
            password = null;
        }
        String sudoCommand = "echo '" + new String(password) + "' | sudo -S -u " + owner + " ";
        if (this.isSharedLocation()) {
            RemoteContentTransferHandler remoteContentTransferHandler = this;
            synchronized (remoteContentTransferHandler) {
                this.unZipPatch(handler, oracleHomePath, patchZipLocation, sourceZipLocation, sudoCommand, perlLibPath);
            }
        } else {
            this.unZipPatch(handler, oracleHomePath, patchZipLocation, sourceZipLocation, sudoCommand, perlLibPath);
        }
    }

    private void unZipPatch(RemoteConnectionHandler handler, String oracleHomePath, String patchZipLocation, String sourceZipLocation, String sudoCommand, String perlLibPathStr) throws RemoteConnectionException {
        if (handler != null) {
            if (!handler.exists(patchZipLocation)) {
                throw new RemoteConnectionException("Unable to find the patch zip file " + patchZipLocation);
            }
            if (!handler.exists(sourceZipLocation)) {
                String command = sudoCommand + this.getRemoteCommand(oracleHomePath, patchZipLocation, new File(sourceZipLocation).getParent(), perlLibPathStr);
                this._logger.info("Unzipping patch at host " + handler.getHost().getHost() + ", location " + sourceZipLocation);
                this.execute(command, handler);
                this._logger.info("Unzipping completed.");
            }
        }
    }

    private String getRemoteCommand(String oracleHomePath, String patchZipLocation, String sourceZipLocation, String perlLibPathStr) {
        if (perlLibPathStr == null) {
            perlLibPathStr = oracleHomePath;
        }
        String perlPath = perlLibPathStr + File.separator + "perl" + File.separator + "bin" + File.separator + "perl";
        String scriptPath = oracleHomePath + File.separator + "OPatch" + File.separator + "auto" + File.separator + "database" + File.separator + "bin" + File.separator + "ZipUnzip.pl unzip";
        String command = perlPath + " " + scriptPath + " " + this.createArgumentsForRemoteScript(patchZipLocation, sourceZipLocation);
        return command;
    }

    private String createArgumentsForRemoteScript(String patchZipLocation, String sourceZipLocation) {
        StringBuilder sb = new StringBuilder();
        sb.append(patchZipLocation);
        sb.append(" ");
        sb.append(sourceZipLocation);
        return sb.toString();
    }

    public synchronized void writeContentToFile(String content, File f) {
        try {
            if (f.exists() && this.isSameContent(content, f)) {
                return;
            }
            if (f.exists()) {
                f.delete();
            }
            f.createNewFile();
            f.deleteOnExit();
            BufferedWriter output = new BufferedWriter(new FileWriter(f));
            output.write(content);
            output.close();
        }
        catch (IOException e) {
            this._logger.info("IOException: " + e.getMessage());
        }
    }

    private boolean isSameContent(String content, File f) throws IOException {
        boolean isSame = false;
        BufferedReader reader = new BufferedReader(new FileReader(f));
        String tempContent = reader.readLine();
        if (content.equals(tempContent.trim())) {
            isSame = true;
        }
        reader.close();
        return isSame;
    }

    public boolean isSharedLocation() {
        return this.isSharedLocation;
    }

    public void setSharedLocation(boolean isSharedLocation) {
        this.isSharedLocation = isSharedLocation;
    }

    private boolean ifFileExists(String location, File contentFile, RemoteConnectionHandler handler) throws RemoteConnectionException {
        boolean isExist = true;
        if (contentFile.isFile() && handler.isDirectory(location) && !handler.exists(location + File.separator + contentFile.getName())) {
            isExist = false;
        }
        return isExist;
    }

    public String findRemoteHomeOwner(String oracleHomePath, String filePath, RemoteConnectionHandler handler) throws RemoteConnectionException {
        String perlPath = oracleHomePath + File.separator + "perl" + File.separator + "bin" + File.separator + "perl -I " + oracleHomePath + File.separator + DBCommonPatchingConstants.OPATCHAUTO_DB_BIN_MODULE + " ";
        String cmdToExecute = perlPath + oracleHomePath + DBCommonPatchingConstants.OPATCHAUTO_DB_IDENTIFY_OWNER_SCRIPT + " -filepath " + filePath;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        handler.exec(cmdToExecute, (OutputStream)outputStream);
        return outputStream.toString();
    }

    private static class Loader {
        static RemoteContentTransferHandler _handler = new RemoteContentTransferHandler();

        private Loader() {
        }
    }

    public static enum DeleteStatus {
        NONE,
        DELETE_ON_EXIT,
        DELETE_ON_SUCCESS;

    }
}

