/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.patchinfostore.PatchingSessionInfoStore;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandActionType;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.CommandDetailsGenerator;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandParameters;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.lifecycle.ShutdownPhase;
import com.oracle.glcm.patch.auto.lifecycle.StartupPhase;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.remote.RemoteNodes;
import oracle.dbsysmodel.driver.sdk.util.OsysUtility;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.PatchingPhase;
import oracle.opatch.system.db.automation.jaxb.PhaseType;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public abstract class CRSShutDownStartupAction
extends DBCommonPatchAction {
    private static final String ROOTADD_RDBMS_COMMAND = "%OracleHome.path%/rdbms/install/rootadd_rdbms.sh";
    private static final String ROOT_CRS_COMMAND = "%OracleHome.path%/crs/install/rootcrs.pl";
    private static final String ROOT_HAS_COMMAND = "%OracleHome.path%/crs/install/roothas.pl";
    private static final String ROOT_CRS_LOG_LOC = "root_crs_log_location";
    protected ConfigGraph configGraph = null;
    private String logBaseDir = null;
    private boolean isOOPPatchingSession = false;

    public CRSShutDownStartupAction(Goal ... goal) {
        super(goal);
    }

    public int getOrderingWeight(Goal goal) {
        if (goal.equals(OfflinePhase.Goal.prepare)) {
            return 30;
        }
        return super.getOrderingWeight(goal);
    }

    public boolean isRemoteParallelExecutionSupported() {
        if (this.getCurrentGoal().equals(OfflinePhase.Goal.prepare)) {
            return false;
        }
        return super.isRemoteParallelExecutionSupported();
    }

    public boolean isLocalParallelExecutionSupported() {
        if (this.getCurrentGoal().equals(OfflinePhase.Goal.prepare)) {
            return false;
        }
        return super.isRemoteParallelExecutionSupported();
    }

    public boolean isLocalTargetsToBeExecutedFirst() {
        if (this.getCurrentGoal().equals(OfflinePhase.Goal.prepare)) {
            return true;
        }
        return super.isLocalTargetsToBeExecutedFirst();
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        boolean softwareOnlyInstallation = ClusterInformationLoader.getInstance().getCRSType().equals((Object)ClusterInformationLoader.CrsType.SOFTWARE_INSTALLATION_ONLY);
        if (primarypatchVersion.startsWith("12.1.0.1") && softwareOnlyInstallation) {
            return false;
        }
        isActionRequired = false;
        boolean oopPreparePatchingSession = DBPatchingHelper.isOOPPreparePatchingSession(this.getPatchSession().getOptions());
        boolean oopPatchingSession = DBPatchingHelper.isOOPPatchingSession(this.getPatchSession().getOptions());
        boolean oopSwitchPatchingSession = DBPatchingHelper.isOOPSwitchPatchingSession(this.getPatchSession().getOptions());
        boolean oopSinglePatchingSession = DBPatchingHelper.isSingleOOPPatchingSession(this.getPatchSession().getOptions());
        if (oopPatchingSession) {
            if ((oopSinglePatchingSession || oopPreparePatchingSession) && this.getCurrentGoal().getPhaseGoal().equals(OfflinePhase.Goal.prepare.getPhaseGoal())) {
                isActionRequired = true;
            } else if ((oopSinglePatchingSession || oopSwitchPatchingSession) && this.getCurrentGoal().getPhaseGoal().equals(StartupPhase.Goal.startup.getPhaseGoal())) {
                isActionRequired = true;
            } else if (this.getPatchSession().isRollback() && this.getCurrentGoal().getPhaseGoal().equals(OfflinePhase.Goal.finalize_binary_patching.getPhaseGoal())) {
                isActionRequired = true;
            }
        } else if (this.getCurrentGoal().getPhaseGoal().equals(ShutdownPhase.Goal.shutdown.getPhaseGoal()) || this.getCurrentGoal().getPhaseGoal().equals(StartupPhase.Goal.startup.getPhaseGoal())) {
            boolean isGIOnlinePatching;
            String home_loc = patchTarget.getHome().getLocation();
            boolean isRHPPatching = DBPatchingHelper.isRHPPatchingSession(home_loc, this.getPatchSession(), SessionData.getInstance().getAnalyzedPatchList(home_loc));
            this._logger.info("RHP Patching session check in CRS Shutdown patch action : " + isRHPPatching);
            boolean isTomcatPatching = DBPatchingHelper.isTomcatPatchingSession(home_loc, this.getPatchSession(), SessionData.getInstance().getAnalyzedPatchList(home_loc));
            this._logger.info("Tomcat/Micronaut Patching session check in CRS Shutdown patch action : " + isTomcatPatching);
            boolean isJDKPatching = DBPatchingHelper.isJDKPatchingSession(home_loc, this.getPatchSession(), SessionData.getInstance().getAnalyzedPatchList(home_loc));
            this._logger.info("JDK Patching session check in CRS Shutdown patch action : " + isJDKPatching);
            boolean isEmptyPatchList = SessionData.getInstance().getAnalyzedPatchList(home_loc) == null || SessionData.getInstance().getAnalyzedPatchList(home_loc).isEmpty();
            boolean bl = isGIOnlinePatching = isRHPPatching || isTomcatPatching || isJDKPatching;
            if (patchTarget.getType().equals(DBProductTypes.PRODUCT_TYPE_SIHA.getValue()) && !isTomcatPatching && !isEmptyPatchList) {
                return true;
            }
            if (patchTarget.getType().equals(DBProductTypes.PRODUCT_TYPE_SIHA.getValue()) && isEmptyPatchList) {
                return false;
            }
            if (patchTarget.getType().equals(DBProductTypes.PRODUCT_TYPE_CRS.getValue()) || patchTarget.getType().equals(DBProductTypes.PRODUCT_TYPE_SIHA.getValue())) {
                if (!isEmptyPatchList) {
                    isActionRequired = !isGIOnlinePatching;
                } else if (!DBPatchingHelper.isFirstNodeGIPatching()) {
                    isActionRequired = !isGIOnlinePatching;
                }
            }
        }
        return isActionRequired;
    }

    @Override
    protected boolean isPatchApplicabilityCheckRequired(PatchTarget patchTarget) {
        boolean isRequired = true;
        boolean oopPatchingSession = DBPatchingHelper.isOOPPatchingSession(this.getPatchSession().getOptions());
        if (!oopPatchingSession && (this.getCurrentGoal().getPhaseGoal().equals(ShutdownPhase.Goal.shutdown.getPhaseGoal()) || this.getCurrentGoal().getPhaseGoal().equals(StartupPhase.Goal.startup.getPhaseGoal()))) {
            PatchingSessionInfoStore sessionInfoStore = PatchingSessionInfoStore.getInstance();
            boolean bl = isRequired = !patchTarget.getHome().isSharedHome() && !Boolean.parseBoolean(sessionInfoStore.getUpdatedProperty(patchTarget, PatchingSessionInfoStore.PatchTargetProperty.SHARED));
            if (isRequired) {
                ClusterInformationLoader clusterInfoLoader = ClusterInformationLoader.getInstance();
                String gridHome = clusterInfoLoader.getGridHome();
                boolean isCusUp = clusterInfoLoader.isStackRunning();
                if (!isCusUp && clusterInfoLoader.getCRSType().equals((Object)ClusterInformationLoader.CrsType.CRS)) {
                    this._logger.info("Trying to check crs status using cluvy as crs is down");
                    RemoteNodes remoteObj = RemoteNodes.getSerializedInstance((String)gridHome);
                    ArrayList<String> nodeList = new ArrayList<String>();
                    if (remoteObj != null) {
                        ArrayList remoteNodeList = remoteObj.getRemoteNodes();
                        nodeList.addAll(remoteNodeList);
                        nodeList.add(patchTarget.getHost().getHost());
                        this._logger.info("Node list::" + nodeList);
                        String[] nodeListArr = nodeList.toArray(new String[nodeList.size()]);
                        try {
                            Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"CRSShutDownStartupAction.sharedhome.update.message", (Object[])new Object[0]));
                            boolean isShared = OsysUtility.isSharedPath((String)gridHome, (String)patchTarget.getHome().getLocation(), (String[])nodeListArr, (boolean)isCusUp, (String)this.getPatchSession().getOptions().getOption("wallet").getValue(), (char[])this.getPatchSession().getOptions().getOption("wallet.password").getPasswordValue());
                            if (isShared) {
                                sessionInfoStore.updatePatchTargetProperty(patchTarget, PatchingSessionInfoStore.PatchTargetProperty.SHARED, Boolean.TRUE.toString());
                            }
                            isRequired = !isShared;
                        }
                        catch (OPatchAutoException oPatchAutoException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        this._logger.info("Is patch applicability check required for CRS:" + isRequired);
        return isRequired;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    @Override
    public List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        boolean isOOPBootstrapingRequired;
        this.configGraph = PatchPlanner.getInstance().getConfigGraph();
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        boolean bl = isOOPBootstrapingRequired = DBPatchingUtil.isVersionEqalOrlater(patchTarget.getHome().getVersion(), "19.0.0.0.0") && this.isOOPPatchingSession();
        if (isOOPBootstrapingRequired) {
            steps.addAll(this.handleBootStrapInClone(patchTarget, DBPatchingHelper.getTargetHomeFromProductType(patchTarget), true));
        }
        steps.addAll(this.generateCRSSteps(patchTarget));
        if (isOOPBootstrapingRequired) {
            steps.addAll(this.handleBootStrapInClone(patchTarget, DBPatchingHelper.getTargetHomeFromProductType(patchTarget), false));
        }
        return steps;
    }

    public List<ExecutionStep> generateCRSSteps(PatchTarget patchTarget) throws OPatchAutoException {
        this.logBaseDir = this.getLogBaseDir(patchTarget);
        return new ArrayList<ExecutionStep>();
    }

    @Override
    protected PatchActionResult executeSteps(List<ExecutionStep> executionSteps, PatchTarget patchTarget) throws OPatchAutoException {
        String rootCrsPath = System.getProperty("OPatchauto.ROOTCRS_PL_FILE_TEMP_LOC");
        String xagPath = System.getProperty("OPatchauto.XAG_FILE_TEMP_LOC");
        this._logger.info("rootCrsPath: " + rootCrsPath);
        this._logger.info("xagPath: " + xagPath);
        if (DBPatchingUtil.isVersionEqalOrlater(patchTarget.getHome().getVersion(), "19.0.0.0.0") && this.isOOPPatchingSession()) {
            String originalHome = patchTarget.getHome(true).getLocation();
            String cloneHome = patchTarget.getHomeClone().getLocation();
            this._logger.info("cloneHome: " + cloneHome);
            rootCrsPath = rootCrsPath.replace(originalHome, cloneHome);
            xagPath = xagPath.replace(originalHome, cloneHome);
            this._logger.info("After update rootCrsPath: " + rootCrsPath);
            this._logger.info("After update xagPath: " + xagPath);
        }
        for (ExecutionStep executionStep : executionSteps) {
            List<ExecutionStep.Command> commands = executionStep.getCommand();
            for (ExecutionStep.Command cmd : commands) {
                if (cmd.getValue().indexOf(DBCommandParameters.ROOT_CRS_PL_PATH.getValue()) != -1) {
                    cmd.setValue(cmd.getValue().replaceAll(DBCommandParameters.ROOT_CRS_PL_PATH.getValue(), rootCrsPath));
                    this._logger.info("Updated root crs location is " + rootCrsPath);
                }
                if (cmd.getValue().indexOf(DBCommandParameters.XAG_PL_PATH.getValue()) == -1) continue;
                cmd.setValue(cmd.getValue().replaceAll(DBCommandParameters.XAG_PL_PATH.getValue(), xagPath));
                this._logger.info("Updated xag file location is " + xagPath);
            }
        }
        String prePost = "postpatch";
        String logMsgConstant = "CRSShutdownStartupAction.start.logfile.message";
        if (this.getCurrentGoal().equals(ShutdownPhase.Goal.shutdown) || this.getCurrentGoal().equals(OfflinePhase.Goal.prepare) || this.getCurrentGoal().equals(OfflinePhase.Goal.finalize_binary_patching)) {
            logMsgConstant = "CRSShutdownStartupAction.stop.logfile.message";
            prePost = "prepatch";
        }
        PatchActionResult result = super.executeSteps(executionSteps, patchTarget);
        String crsLogFileLocation = this.getLogFile(patchTarget, prePost);
        if (!StringUtil.isNullOrEmpty((String)crsLogFileLocation)) {
            String crsLogMsg = this.getLocalizedString(logMsgConstant, crsLogFileLocation);
            Reporting.report((String)crsLogMsg);
            this._logger.info(crsLogMsg);
        }
        return result;
    }

    private boolean isOOPPatchingSession() {
        return this.getPatchSession().isActionSession() ? this.isOOPPatchingSession : DBPatchingHelper.isOOPPatchingSession(this.getPatchSession().getOptions());
    }

    protected List<ExecutionStep> getUpdateBootStrappingInClone(PatchTarget patchTarget, String targetHome) throws OPatchAutoException {
        List<ExecutionStep> steps = null;
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, CommandActionType.shell.toString());
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON_CLONE, Boolean.TRUE);
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Update-BootStrap-Title");
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_TARGETHOME, targetHome);
        String stripeName = DBPatchingHelper.getStripeName(patchTarget);
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_NAME, stripeName);
        ArrayList params = new ArrayList();
        LinkedHashMap commandDetails = new LinkedHashMap();
        boolean nonrollingMode = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.NONROLLING_MODE_KEY.getValue()).isSwitchEnabled();
        if (this.getCurrentGoal().equals(StartupPhase.Goal.startup) && nonrollingMode) {
            String cp = patchTarget.getHome(true).getLocation() + "/OPatch/auto/database/modules/oracle.glcm.opatchauto.db.utils.classpath.jar";
            String currentJavaPath = System.getProperty("java.home") + "/bin/java";
            String updateNodeListScript = currentJavaPath + " -cp " + cp + " com.oracle.glcm.patch.auto.db.util.UpdatePropertiesFile " + patchTarget.getHome(true).getLocation() + " " + patchTarget.getHomeClone().getLocation();
            commandDetails.put(updateNodeListScript, new ArrayList());
        }
        String rootSHScript = "cp " + patchTarget.getHomeClone().getLocation() + "/crs/install/crsconfig_params " + DBCommandParameters.ROOT_CRS_PL_PATH.getValue();
        ArrayList paramList = new ArrayList();
        paramList.addAll(params);
        commandDetails.put(rootSHScript, paramList);
        argList.put(CommandDetailsGenerator.ActionTypeParams.COMMAND_DETAILS, commandDetails);
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        PatchingPhase phase = this.getpatchingPhase();
        Command rootSHCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        steps = this.getsteps(this.configGraph, patchTarget, actionType, rootSHCommand);
        return steps;
    }

    protected List<ExecutionStep> handleBootStrapInClone(PatchTarget patchTarget, String targetHome, boolean isCopy) throws OPatchAutoException {
        List<ExecutionStep> steps = null;
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, CommandActionType.shell.toString());
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON_CLONE, Boolean.TRUE);
        if (isCopy) {
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Copy-BootStrap-Title");
        } else {
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Remove-BootStrap-Title");
        }
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_TARGETHOME, targetHome);
        String stripeName = DBPatchingHelper.getStripeName(patchTarget);
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_NAME, stripeName);
        ArrayList params = new ArrayList();
        LinkedHashMap commandDetails = new LinkedHashMap();
        String originalHome = patchTarget.getHome(true).getLocation();
        String cloneHome = patchTarget.getHomeClone().getLocation();
        this._logger.info("cloneHome: " + cloneHome);
        String srcBootstrap = originalHome + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_DBTMP_DIR + "*";
        String destBootstrap = cloneHome + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_DBTMP_DIR;
        String rootSHScript = isCopy ? "cp -Rf " + srcBootstrap + " " + destBootstrap : "rm -rf  " + destBootstrap + "*";
        ArrayList paramList = new ArrayList();
        paramList.addAll(params);
        commandDetails.put(rootSHScript, paramList);
        argList.put(CommandDetailsGenerator.ActionTypeParams.COMMAND_DETAILS, commandDetails);
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        PatchingPhase phase = this.getpatchingPhase();
        Command rootSHCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        steps = this.getsteps(this.configGraph, patchTarget, actionType, rootSHCommand);
        return steps;
    }

    protected List<ExecutionStep> getrootCRSCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget, String targetHome, ServiceStatus status, List<String> readMeMsg, String type, boolean actsOnClone, String ... params) throws OPatchAutoException {
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, type);
        argList.put(CommandDetailsGenerator.ActionTypeParams.RUN_AS, DBCommandParameters.GLOBAL_ROOT_USER.getValue());
        argList.put(CommandDetailsGenerator.ActionTypeParams.SERVICE_STATUS, status);
        String rootCRSCommandSource = null;
        if (targetHome.equals("siha")) {
            argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_NAME, "oracle.siha");
            rootCRSCommandSource = ROOT_HAS_COMMAND;
        } else {
            argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_NAME, "oracle.crs");
            rootCRSCommandSource = ROOT_CRS_COMMAND;
        }
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_TARGETHOME, targetHome);
        HashMap commandDetails = new HashMap();
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.addAll(Arrays.asList(params));
        if (actsOnClone) {
            argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON_CLONE, true);
            paramList.add(DBCommandParameters.DST_CRS_HOME.getValue());
        }
        commandDetails.put(rootCRSCommandSource, paramList);
        argList.put(CommandDetailsGenerator.ActionTypeParams.COMMAND_DETAILS, commandDetails);
        this.setReadMe(argList, readMeMsg);
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        PatchingPhase phase = this.getpatchingPhase();
        Command rootcrsCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(configGraph, patchTarget, actionType, rootcrsCommand);
        boolean initialStateUp = SessionData.getInstance().getRunningHosts().contains(patchTarget.getHost().getHost());
        for (ExecutionStep step : steps) {
            for (ExecutionStep.Command command : step.getCommand()) {
                String ldLibPath;
                if (command.getValue().indexOf("rootcrs.pl") == -1 && command.getValue().indexOf("roothas.pl") == -1) continue;
                String crsCommand = command.getValue();
                if (this.isOOPRollbackAbove19c()) {
                    this._logger.info("Original command : " + crsCommand);
                    crsCommand = this.generate19cOOPRollback(patchTarget, crsCommand);
                    this._logger.info("Modified command : " + crsCommand);
                    command.setValue(crsCommand);
                }
                if (DBPatchingHelper.isNoRestartEnable(this.getPatchSession().getOptions()) || !initialStateUp && command.getValue().indexOf(DBCommandParameters.POSTPATCH.getValue()) != -1 && command.getValue().indexOf(DBCommandParameters.NONROLLING.getValue()) == -1) {
                    crsCommand = crsCommand + " " + DBCommandParameters.NORESTART.getValue();
                    command.setValue(crsCommand);
                }
                if (command.getValue().indexOf(DBCommandParameters.POSTPATCH.getValue()) != -1 && command.getValue().indexOf(DBCommandParameters.DST_CRS_HOME.getValue()) != -1) {
                    crsCommand = command.getValue();
                    ldLibPath = DBPatchingUtil.getLibPathEnv(patchTarget.getHome().getLocation());
                    System.setProperty("NEW_GRID_HOME", patchTarget.getHome().getLocation());
                    crsCommand = ldLibPath + " " + crsCommand;
                    command.setValue(crsCommand);
                }
                if (command.getValue().indexOf(DBCommandParameters.PREPATCH.getValue()) != -1 && command.getValue().indexOf(DBCommandParameters.DST_CRS_HOME.getValue()) != -1) {
                    String osname = System.getProperty("os.name", "");
                    crsCommand = command.getValue();
                    String ldLibPath2 = DBPatchingUtil.getLibPathEnv(patchTarget.getHome().getLocation());
                    System.setProperty("NEW_GRID_HOME", patchTarget.getHome().getLocation());
                    crsCommand = ldLibPath2 + " " + crsCommand;
                    command.setValue(crsCommand);
                }
                if (command.getValue().indexOf(DBCommandParameters.DST_CRS_HOME.getValue()) != -1) continue;
                crsCommand = command.getValue();
                this._logger.info("Handling LD_LIBRARY_PATH for in-place mode of patching.");
                ldLibPath = DBPatchingUtil.getLibPathEnv(patchTarget.getHome().getLocation());
                crsCommand = ldLibPath + " " + crsCommand;
                command.setValue(crsCommand);
            }
        }
        return steps;
    }

    private boolean isOOPRollbackAbove19c() {
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        boolean value = DBPatchingHelper.isOOPSwitchbackSession(this.getPatchSession().getOptions()) && DBPatchingUtil.isVersionEqalOrlater(primarypatchVersion, "19.0.0.0.0");
        this._logger.info("Session for 19c and higher version OOP rollback : " + value);
        return value;
    }

    private String generate19cOOPRollback(PatchTarget patchTarget, String command) {
        String dest_home = patchTarget.getHome().getLocation();
        String script = command.indexOf("roothas.pl ") == -1 ? "rootcrs.sh" : "roothas.sh";
        String prepost = command.indexOf("-prepatch ") == -1 ? "-postpatch" : "-prepatch";
        String nonrolling = command.indexOf(" -nonrolling") == -1 ? "" : "-nonrolling";
        String cmd = dest_home + "/crs/install/" + script + " " + prepost + " " + nonrolling + " -dstcrshome " + dest_home;
        return cmd;
    }

    private void setReadMe(Map<CommandDetailsGenerator.ActionTypeParams, Object> argList, List<String> readMeMsg) {
        if (readMeMsg != null && !readMeMsg.isEmpty()) {
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, readMeMsg.get(0));
            if (readMeMsg.size() > 1) {
                argList.put(CommandDetailsGenerator.ActionTypeParams.README_MSG_KEY, readMeMsg.get(1));
            }
        }
    }

    protected List<ExecutionStep> getRootAddRDBMSCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget, String targetHome) throws OPatchAutoException {
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, CommandActionType.shell.toString());
        argList.put(CommandDetailsGenerator.ActionTypeParams.RUN_AS, DBCommandParameters.GLOBAL_ROOT_USER.getValue());
        if (targetHome.equals("siha")) {
            argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_NAME, "oracle.siha");
        } else {
            argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_NAME, "oracle.crs");
        }
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_TARGETHOME, targetHome);
        String rootAddRDBMSCommandStr = ROOTADD_RDBMS_COMMAND;
        HashMap commandDetails = new HashMap();
        ArrayList paramList = new ArrayList();
        commandDetails.put(rootAddRDBMSCommandStr, paramList);
        argList.put(CommandDetailsGenerator.ActionTypeParams.COMMAND_DETAILS, commandDetails);
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Rootadd-Script-Title");
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_MSG_KEY, "Rootadd-Script-Message");
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        PatchingPhase phase = this.getpatchingPhase();
        Command rootAddRDBMSCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(configGraph, patchTarget, actionType, rootAddRDBMSCommand);
        return steps;
    }

    protected PatchingPhase getpatchingPhase() {
        PatchingPhase phase = null;
        boolean oopSwitchPatchingSession = DBPatchingHelper.isOOPSwitchPatchingSession(this.getPatchSession().getOptions());
        boolean oopSinglePatchingSession = DBPatchingHelper.isSingleOOPPatchingSession(this.getPatchSession().getOptions());
        phase = this.getPatchSession().isRollback() ? (oopSinglePatchingSession || oopSwitchPatchingSession ? CommandDetailsGenerator.generatePatchingPhase(PhaseType.SWITCHBACK, ServiceStatus.LIMITED) : CommandDetailsGenerator.generatePatchingPhase(PhaseType.ROLLBACK, ServiceStatus.LIMITED)) : ((oopSinglePatchingSession || oopSwitchPatchingSession) && this.getCurrentGoal().equals(StartupPhase.Goal.startup) ? CommandDetailsGenerator.generatePatchingPhase(PhaseType.MIGRATE, ServiceStatus.LIMITED) : CommandDetailsGenerator.generatePatchingPhase(PhaseType.APPLY, ServiceStatus.LIMITED));
        return phase;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        String formatStr = "\n********************\n";
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("CRSShutDownStartupAction." + this.getCurrentGoal().getName() + ".start.message", patchTarget.toReportingString());
                this._logger.info(formatStr + "Begin CRS " + this.getCurrentGoal().getName() + " on " + patchTarget.toReportingString() + formatStr);
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("CRSShutDownStartupAction." + this.getCurrentGoal().getName() + ".failure.message", patchTarget.toReportingString());
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("CRSShutDownStartupAction." + this.getCurrentGoal().getName() + ".warning.message", patchTarget.toReportingString());
                this._logger.info(formatStr + "End CRS " + this.getCurrentGoal().getName() + " on " + patchTarget.toReportingString() + formatStr);
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("CRSShutDownStartupAction." + this.getCurrentGoal().getName() + ".success.message", patchTarget.toReportingString());
                this._logger.info(formatStr + "End CRS " + this.getCurrentGoal().getName() + " on " + patchTarget.toReportingString() + formatStr);
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        statusMsg = this.addTag(statusMsg);
        return statusMsg;
    }

    @Override
    public void prepareRemoteActionExecutionHost(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws RemoteConnectionException, PatchActionException {
        super.prepareRemoteActionExecutionHost(handler, container);
        if (this.logBaseDir != null) {
            container.addPatchActionParameter(ROOT_CRS_LOG_LOC, (Object)this.logBaseDir);
        }
    }

    @Override
    public void setupRemoteActionExecutionEnvironment(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws PatchActionException {
        super.setupRemoteActionExecutionEnvironment(patchSession, container);
        this.logBaseDir = (String)container.getPatchActionParameterValue(ROOT_CRS_LOG_LOC);
        Boolean oopPatching = (Boolean)container.getPatchActionParameterValue(DBProductParameterConstants.OOP_PATCHING_SESSION.getValue());
        this.isOOPPatchingSession = oopPatching == null ? false : oopPatching;
    }

    @Override
    public PatchAction clone() throws CloneNotSupportedException {
        PatchAction patchAction = super.clone();
        ((CRSShutDownStartupAction)patchAction).logBaseDir = this.logBaseDir;
        ((CRSShutDownStartupAction)patchAction).isOOPPatchingSession = this.isOOPPatchingSession;
        return patchAction;
    }

    private String getLogFile(PatchTarget target, String prepost) {
        File dirFile;
        String type = target.getType();
        String logFilePrefix = "crs";
        String logFilePrefixNineteen = "crs_";
        if (type.equals(DBProductTypes.PRODUCT_TYPE_SIHA.getValue())) {
            logFilePrefix = "hapatch_";
        }
        String logFile = null;
        if (!StringUtil.isNullOrEmpty((String)this.logBaseDir, (boolean)true) && (dirFile = new File(this.logBaseDir)).exists()) {
            File[] files = dirFile.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile();
                }
            });
            long lastMod = Long.MIN_VALUE;
            File lastModifedFile = null;
            if (files != null && files.length > 0) {
                for (File file : files) {
                    if (file.lastModified() <= lastMod || !file.getName().startsWith(logFilePrefix)) continue;
                    lastModifedFile = file;
                    lastMod = file.lastModified();
                }
                if (lastModifedFile != null) {
                    logFile = lastModifedFile.getAbsolutePath();
                    if (lastModifedFile.getName().startsWith(logFilePrefixNineteen) && !lastModifedFile.getName().contains(prepost)) {
                        logFile = null;
                    }
                }
            }
        }
        return logFile;
    }

    private String getLogBaseDir(PatchTarget target) {
        String crsConfigConst = "crsconfig";
        String cfgToolsConst = "cfgtoollogs";
        String crsDataConst = "crsdata";
        String parentDir = target.getHome().getLocation() + File.separator + cfgToolsConst + File.separator + crsConfigConst;
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        if (DBPatchingUtil.isVersionEqalOrlater(primarypatchVersion, "12.2.0.0")) {
            String oracleBase = OUIDriver.checkOracleBase((String)target.getHome().getLocation());
            parentDir = oracleBase + File.separator + crsDataConst + File.separator + target.getHost().getHost() + File.separator + crsConfigConst;
        }
        return parentDir;
    }
}

