/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandActionType;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.CommandDetailsGenerator;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.PatchingPhase;
import oracle.opatch.system.db.automation.jaxb.PhaseType;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class CloneOracleHomeStartupAction
extends DBCommonPatchAction {
    private ConfigGraph configGraph = null;
    private static final String RUN_INSTALLER = "%OracleHome.path%/oui/bin/runInstaller";
    private static final String UPDATE_NODELIST_PARAM = "-updateNodeList";
    public static final String LOCAL_PARAM = "-local";

    public CloneOracleHomeStartupAction() {
        super(new Goal[]{OfflinePhase.Goal.finalize_binary_patching});
    }

    public int getOrderingWeight(Goal goal) {
        return 20;
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        if (DBPatchingUtil.isVersionEqalOrlater(patchTarget.getHome().getVersion(), "23.0.0.0.0")) {
            return false;
        }
        if (DBPatchingHelper.isSingleOOPPatchingSession(this.getPatchSession().getOptions()) || DBPatchingHelper.isOOPSwitchPatchingSession(this.getPatchSession().getOptions())) {
            boolean softwareOnlyInstallation = ClusterInformationLoader.getInstance().getCRSType().equals((Object)ClusterInformationLoader.CrsType.SOFTWARE_INSTALLATION_ONLY);
            return !softwareOnlyInstallation;
        }
        return false;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        return targetList;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        this.configGraph = PatchPlanner.getInstance().getConfigGraph();
        ArrayList<ExecutionStep> generatedSteps = new ArrayList<ExecutionStep>();
        List<ExecutionStep> steps = null;
        steps = this.getUpdateNodeListExecutionStep(patchTarget, DBPatchingHelper.getTargetHomeFromProductType(patchTarget), false);
        generatedSteps.addAll(steps);
        steps = this.getUpdateNodeListExecutionStep(patchTarget, DBPatchingHelper.getTargetHomeFromProductType(patchTarget), true);
        generatedSteps.addAll(steps);
        return generatedSteps;
    }

    private List<ExecutionStep> getUpdateNodeListExecutionStep(PatchTarget patchTarget, String targetHome, boolean actsOnClone) throws OPatchAutoException {
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, CommandActionType.shell.toString());
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON_CLONE, actsOnClone);
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Set-Nodelist-Title");
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_TARGETHOME, targetHome);
        ArrayList<String> params = new ArrayList<String>();
        params.add(UPDATE_NODELIST_PARAM);
        params.add("ORACLE_HOME=%OracleHome.path%");
        params.add("CRS=\"" + actsOnClone + "\"");
        params.add(LOCAL_PARAM);
        if (targetHome.equals("siha")) {
            argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_NAME, "oracle.siha");
        } else if (targetHome.equals("crs")) {
            argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_NAME, "oracle.crs");
        }
        String runInstaller = RUN_INSTALLER;
        HashMap commandDetails = new HashMap();
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.addAll(params);
        commandDetails.put(runInstaller, paramList);
        argList.put(CommandDetailsGenerator.ActionTypeParams.COMMAND_DETAILS, commandDetails);
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        PatchingPhase phase = this.getpatchingPhase();
        Command clonePLCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(this.configGraph, patchTarget, actionType, clonePLCommand);
        return steps;
    }

    private PatchingPhase getpatchingPhase() {
        PatchingPhase phase = CommandDetailsGenerator.generatePatchingPhase(PhaseType.MIGRATE, ServiceStatus.LIMITED);
        return phase;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        String formatStr = "\n********************\n";
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("CloneOracleHomeStartupAction.start.message", patchTarget.toReportingString());
                this._logger.info(formatStr + "Begin Update Nodelist for oracle " + patchTarget.toReportingString() + formatStr);
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("CloneOracleHomeStartupAction.success.message", patchTarget.toReportingString());
                this._logger.info(formatStr + "End Update Nodelist for oracle " + patchTarget.toReportingString() + formatStr);
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("CloneOracleHomeStartupAction.failure.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }

    public boolean isRollbackSupported() {
        return true;
    }
}

