/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.User;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.util.PatchPlanUtils;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.InitPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.common.Host;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.opatch.system.db.automation.jaxb.ActionType;

public class DeleteInactivePatchesInPlace
extends DBCommonPatchAction {
    Logger _logger = Logger.getLogger(DeleteInactivePatchesInPlace.class.getName());

    public DeleteInactivePatchesInPlace() {
        super(new Goal[]{InitPhase.Goal.init});
    }

    public int getOrderingWeight(Goal goal) {
        return 70;
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        OPatchAutoOptions options = this.getPatchSession().getOptions();
        if (this.getPatchSession().isAnalyze()) {
            this._logger.info("Inactive patches will not be deleted in analyze mode.");
            return false;
        }
        if (this.getPatchSession().isRollback()) {
            this._logger.info("Inactive patches will not be deleted in rollback session.");
            return false;
        }
        if (DBPatchingHelper.isOOPPatchingSession(options)) {
            this._logger.info("This action will be skipped for OOP patching.");
            return false;
        }
        try {
            String minVersion = "23.0.0.0.0";
            String primaryVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
            if (!this.getPatchSession().getProductSupportManager().getOptions().getOption("delete.inactive").isSwitchEnabled()) {
                this._logger.info("The option to delete inactive patches was not provided, hence skipping the action.");
                return false;
            }
            if (DBPatchingUtil.isVersionEqalOrlater(primaryVersion, minVersion)) {
                this._logger.info("This Patch Action will not be run on 23ai and higher version targets.");
                return false;
            }
        }
        catch (Exception e) {
            this._logger.info("Hit an error in isActionRequired, hence, skipping the patch action.");
            this._logger.info(e.toString());
            return false;
        }
        this._logger.info("Inactive patches will be deleted.");
        return true;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        return targetList;
    }

    @Override
    public final PatchActionResult execute(PatchTarget patchTarget) {
        PatchActionResult patchActionResult = new PatchActionResult();
        try {
            patchActionResult = super.execute(patchTarget);
        }
        catch (Exception e) {
            patchActionResult = new PatchActionResult((Throwable)e);
            return patchActionResult;
        }
        return patchActionResult;
    }

    public boolean isRollbackSupported() {
        return false;
    }

    public boolean isAnalyzeSupported() {
        return false;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ArrayList<ExecutionStep> executionList = new ArrayList<ExecutionStep>();
        String oracleHome = patchTarget.getHome(true).getLocation();
        oracleHome = PatchPlanUtils.removeFileSeperatorAtEnd(oracleHome);
        this._logger.info("Deleting inactive patches on home " + oracleHome);
        String invPtrLoc = null;
        OPatchAutoOption invPtrOpt = this.getPatchSession().getProductSupportManager().getOptions().getOption("inventory.pointer.location");
        invPtrLoc = invPtrOpt.getValue();
        if (StringUtil.isNullOrEmpty((String)invPtrLoc)) {
            invPtrLoc = oracleHome + File.separator + "oraInst.loc";
        }
        String deleteCmd = oracleHome + File.separator + DBCommonPatchingConstants.OPATCHAUTO_SCRIPT + " -binary -deleteInactivePatches -oh " + oracleHome + " -invPtrLoc " + invPtrLoc;
        this._logger.info("Command generated ::" + deleteCmd);
        ActionType actionType = new ActionType();
        ExecutionStep executionStep = new ExecutionStep(actionType);
        executionStep.getCommand().add(new ExecutionStep.Command(deleteCmd));
        String ohOwner = null;
        ohOwner = !DBPatchingHelper.isStaticConfiguration(this.getPatchSession().getOptions()) ? OUIDriver.checkFileOwner((File)new File(patchTarget.getHome(true).getLocation(), "oraInst.loc")) : System.getProperty("user.name");
        User user = new User();
        user.setValue(ohOwner);
        executionStep.setUser(user);
        Host host = new Host();
        host.setDisplayName(patchTarget.getHost().getHost());
        host.setName(patchTarget.getHost().getHost());
        executionStep.setHost(host);
        executionList.add(executionStep);
        return executionList;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("DeleteInactivePatches.start.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("DeleteInactivePatches.success.message", patchTarget.toReportingString());
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("DeleteInactivePatches.warning.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("DeleteInactivePatches.failure.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }

    @Override
    public PatchAction clone() throws CloneNotSupportedException {
        PatchAction patchAction = super.clone();
        return patchAction;
    }
}

