/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.ApplySqlAction;
import oracle.opatch.system.db.automation.jaxb.CommandAction;

class ExecutionThread
extends Thread {
    public GISystemCall.ExecReturn er;
    ExecutionStep step;
    Logger _log;
    Credential cred;
    public String normalMsg = "";
    public String errorMsg = "";
    public String command = "";
    public boolean successfull = true;

    ExecutionThread(ExecutionStep step, Credential cred, Logger logger) {
        this.step = step;
        this._log = logger;
        this.cred = cred;
    }

    @Override
    public void run() {
        ActionType automationAction = this.step.getAutomationAction();
        for (ExecutionStep.Command cmd : this.step.getCommand()) {
            this.command = cmd.getValue();
            this.command = this.formatCommand(this.command, automationAction);
            this._log.info(OPatchAutoHelper.getLocalizedString((String)"StepExecutor.command.info", (Object[])new Object[]{this.step.getUser().getValue(), this.command}));
            this._log.log(Level.INFO, "Starting command execution...\n" + this.command + "\n");
            this.er = GISystemCall.process(this.command, this.step.getUser().getValue(), this.cred, this.getTestEnv());
            this._log.log(Level.INFO, "status: " + this.er.getReturnCode());
            if (this.er.isOK()) {
                this._log.info("Successfully executed the command:\n" + this.command + "\n");
                this._log.log(Level.INFO, "Output from the command:" + this.command + "\n");
                this._log.log(Level.INFO, this.er.getNormalMessage());
                continue;
            }
            this.successfull = false;
            this.normalMsg = this.er.getNormalMessage();
            this.errorMsg = this.er.getErrorMessage();
            this._log.info("Failed in executing the command:\n" + this.command + "\n");
            this._log.log(Level.INFO, "\nCOMMAND EXECUTION FAILURE :\n" + this.normalMsg + "\nERROR:\n" + this.errorMsg);
            return;
        }
    }

    public ExecutionStep getStep() {
        return this.step;
    }

    public String getCommand() {
        return this.command;
    }

    private String formatCommand(String command, ActionType automationAction) {
        if (command.startsWith("ORACLE_HOME=") || command.startsWith("ORACLE_UNQNAME=") || automationAction instanceof CommandAction && (automationAction.getType().startsWith("SqlPatch") || automationAction.getType().equals(DBCommandActionType.SPFilePreReqForUpgradeMode.toString())) || automationAction instanceof ApplySqlAction && !command.startsWith("echo") || command.startsWith("echo")) {
            command = GISystemCall.formatSHCommand(command, true);
        }
        return command;
    }

    private Map<String, String> getTestEnv() {
        HashMap<String, String> envMap = null;
        try {
            File testEnvPropertiesFile = new File(OPatchAutoHelper.getOPatchAutoHome() + DBCommonPatchingConstants.TEST_ENV_PROP_FILE_PATH);
            if (testEnvPropertiesFile.exists()) {
                envMap = new HashMap<String, String>();
                Properties properties = new Properties();
                properties.load(new FileInputStream(testEnvPropertiesFile));
                Set<String> keySet = properties.stringPropertyNames();
                for (String key : keySet) {
                    String value = properties.getProperty(key);
                    envMap.put(key, value);
                }
            }
        }
        catch (Exception e) {
            this._log.log(Level.WARNING, "\nFailed to read test enviroment file.EXCEPTION CAUGHT:\n" + e.getMessage());
        }
        return envMap;
    }
}

