/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.User;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.ShutdownPhase;
import com.oracle.glcm.patch.auto.lifecycle.StartupPhase;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.common.Host;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.opatch.system.db.automation.jaxb.ActionType;

public class GILockPatchAction
extends DBCommonPatchAction {
    Logger logger = Logger.getLogger(GILockPatchAction.class.getName());

    public GILockPatchAction() {
        super(new Goal[]{StartupPhase.Goal.startup});
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        return targetList;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ArrayList<ExecutionStep> executionList = new ArrayList<ExecutionStep>();
        String sourceHome = patchTarget.getHome(true).getLocation();
        sourceHome = sourceHome.replaceAll("/+$", "");
        File src = new File(sourceHome, "oraInst.loc");
        String ohOwner = OUIDriver.checkFileOwner((File)src);
        String group = OUIDriver.checkFileGroup((File)src);
        String targetHome = DBPatchingHelper.getTargetHomeFromProductType(patchTarget);
        User user = new User();
        user.setValue(ohOwner);
        User root = new User();
        root.setValue("root");
        Host host = new Host();
        host.setDisplayName(patchTarget.getHost().getHost());
        host.setName(patchTarget.getHost().getHost());
        String JDKLockCmd = "chown -R root:" + group + " " + sourceHome + "/jdk/";
        this.logger.info("GI/jdk directory lock command generated : " + JDKLockCmd);
        ActionType actionType1 = new ActionType();
        ExecutionStep executionStep1 = new ExecutionStep(actionType1);
        executionStep1.getCommand().add(new ExecutionStep.Command(JDKLockCmd));
        executionStep1.setUser(root);
        executionStep1.setHost(host);
        executionList.add(executionStep1);
        String GILockCmd = "chown root:" + group + " " + sourceHome;
        this.logger.info("GI Home lock command generated : " + GILockCmd);
        ActionType actionType2 = new ActionType();
        ExecutionStep executionStep2 = new ExecutionStep(actionType2);
        executionStep2.getCommand().add(new ExecutionStep.Command(GILockCmd));
        executionStep2.setUser(root);
        executionStep2.setHost(host);
        executionList.add(executionStep2);
        if (targetHome.equals("crs")) {
            String StartCVUCmd = sourceHome + "/bin/srvctl start cvu";
            this.logger.info("Start cvu command generated : " + StartCVUCmd);
            ActionType actionType3 = new ActionType();
            ExecutionStep executionStep3 = new ExecutionStep(actionType3);
            executionStep3.getCommand().add(new ExecutionStep.Command(StartCVUCmd));
            executionStep3.setUser(root);
            executionStep3.setHost(host);
            executionList.add(executionStep3);
        }
        boolean isRHPServerRunning = SessionData.getInstance().isRHPServerRunning();
        boolean isRHPClientRunning = SessionData.getInstance().isRHPClientRunning();
        StringBuilder srvctlRHPCmd = new StringBuilder();
        srvctlRHPCmd.append(sourceHome + File.separator + DBCommonPatchingConstants.SRVCTL_COMMAND);
        srvctlRHPCmd.append(" start ");
        if (isRHPServerRunning) {
            srvctlRHPCmd.append("rhpserver -n " + patchTarget.getHost().getHost());
        } else if (isRHPClientRunning) {
            srvctlRHPCmd.append("rhpclient -n " + patchTarget.getHost().getHost());
        } else {
            srvctlRHPCmd = new StringBuilder();
            this.logger.info("No RHP resources are configured and running");
        }
        String RHPCmd = srvctlRHPCmd.toString();
        if (!StringUtil.isNullOrEmpty((String)RHPCmd, (boolean)true)) {
            this.logger.info("RHP Command generated ::" + RHPCmd);
            ActionType actionType = new ActionType();
            ExecutionStep executionStep4 = new ExecutionStep(actionType);
            executionStep4.getCommand().add(new ExecutionStep.Command(RHPCmd));
            executionStep4.setUser(user);
            executionStep4.setHost(host);
            executionList.add(executionStep4);
        }
        return executionList;
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        if (!DBPatchingUtil.isVersionEqalOrlater(primarypatchVersion, "19.0.0.0.0")) {
            return false;
        }
        OPatchAutoOptions options = this.getPatchSession().getOptions();
        String home_loc = patchTarget.getHome().getLocation();
        if (DBPatchingHelper.isOOPPatchingSession(options) || this.getPatchSession().isAnalyze()) {
            isActionRequired = false;
        } else if (SessionData.getInstance().getAnalyzedPatchList(home_loc) != null && !SessionData.getInstance().getAnalyzedPatchList(home_loc).isEmpty()) {
            isActionRequired = DBPatchingHelper.isJDKPatchingSession(patchTarget.getHome().getLocation(), this.getPatchSession(), SessionData.getInstance().getAnalyzedPatchList(home_loc));
            this.logger.info("OH/jdk lock action required : " + isActionRequired);
        } else {
            isActionRequired = false;
        }
        if (patchTarget.getHome().isSharedHome()) {
            isActionRequired = isActionRequired && DBPatchingHelper.isFirstNodeGIPatching();
        }
        return isActionRequired;
    }

    public boolean isAnalyzeSupported() {
        boolean isAnalyzeSupported = false;
        return isAnalyzeSupported;
    }

    public int getOrderingWeight(Goal goal) {
        if (goal.equals(ShutdownPhase.Goal.shutdown)) {
            return 58;
        }
        return super.getOrderingWeight(goal);
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        String formatStr = "\n********************\n";
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("GILockPatchAction.start.message", patchTarget.toReportingString());
                this._logger.info(formatStr + "Begin GI home locking on " + patchTarget.toReportingString() + formatStr);
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("GILockPatchAction.success.message", patchTarget.toReportingString());
                this._logger.info(formatStr + "End GI home locking on " + patchTarget.toReportingString() + formatStr);
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("GILockPatchAction.warning.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("GILockPatchAction.failure.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    public boolean isLocalParallelExecutionSupported() {
        return true;
    }

    @Override
    public void prepareRemoteActionExecutionHost(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws RemoteConnectionException, PatchActionException {
        super.prepareRemoteActionExecutionHost(handler, container);
    }

    @Override
    public void setupRemoteActionExecutionEnvironment(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws PatchActionException {
        super.setupRemoteActionExecutionEnvironment(patchSession, container);
    }

    @Override
    public PatchAction clone() throws CloneNotSupportedException {
        PatchAction patchAction = super.clone();
        return patchAction;
    }
}

