/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.User;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.StartupPhase;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.PatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.HomeImpl;
import dbmodel.common.Host;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.opatch.system.db.automation.jaxb.ActionType;

public class GIMRPostPatchAction
extends DBCommonPatchAction {
    Logger logger = Logger.getLogger(GIMRPostPatchAction.class.getName());

    public GIMRPostPatchAction() {
        super(new Goal[]{StartupPhase.Goal.startup});
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC_SHARED.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC_NONSHARED.getValue());
        return targetList;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ArrayList<ExecutionStep> executionList = new ArrayList<ExecutionStep>();
        String targetHome = DBPatchingHelper.getTargetHomeFromProductType(patchTarget);
        String sourceHome = patchTarget.getHome(true).getLocation();
        sourceHome = sourceHome.replaceAll("/+$", "");
        StringBuilder postPatchGIMRcmd = new StringBuilder();
        postPatchGIMRcmd.append(sourceHome + "/bin/mgmtca applyDatapatch ");
        if (this.getPatchSession().isRollback()) {
            postPatchGIMRcmd.append(" -postPatchRollback ");
        } else {
            postPatchGIMRcmd.append(" -postPatchApply ");
        }
        PatchSession patchSession = this.getPatchSession();
        String idList = DBPatchingHelper.getPatchIDList(SessionData.getInstance().getAnalyzedPatchList(sourceHome));
        if (idList != null) {
            postPatchGIMRcmd.append(" -id " + idList);
        }
        String cmd = postPatchGIMRcmd.toString();
        if (!StringUtil.isNullOrEmpty((String)idList, (boolean)true)) {
            this.logger.info("Command generated ::" + cmd);
            ActionType actionType = new ActionType();
            ExecutionStep executionStep = new ExecutionStep(actionType);
            executionStep.getCommand().add(new ExecutionStep.Command(cmd));
            String ohOwner = null;
            ohOwner = !DBPatchingHelper.isStaticConfiguration(this.getPatchSession().getOptions()) ? OUIDriver.checkFileOwner((File)new File(patchTarget.getHome(true).getLocation(), "oraInst.loc")) : System.getProperty("user.name");
            User user = new User();
            user.setValue(ohOwner);
            executionStep.setUser(user);
            Host host = new Host();
            host.setDisplayName(patchTarget.getHost().getHost());
            host.setName(patchTarget.getHost().getHost());
            executionStep.setHost(host);
            executionList.add(executionStep);
            return executionList;
        }
        this.logger.info("Skipping action to run GIMR Postpatch command since no step got generated");
        return null;
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        if (!((HomeImpl)patchTarget.getHome()).isGIMRHome()) {
            return false;
        }
        OPatchAutoOptions options = this.getPatchSession().getOptions();
        isActionRequired = !DBPatchingHelper.isOOPPatchingSession(options) && !this.getPatchSession().isAnalyze();
        return isActionRequired;
    }

    public boolean isAnalyzeSupported() {
        boolean isAnalyzeSupported = false;
        return isAnalyzeSupported;
    }

    public int getOrderingWeight(Goal goal) {
        if (goal.equals(StartupPhase.Goal.startup)) {
            return 60;
        }
        return super.getOrderingWeight(goal);
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        String formatStr = "\n********************\n";
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("GIMRPostPatchAction.start.message", patchTarget.toReportingString());
                this._logger.info(formatStr + "Begin GIMR postpatch on " + patchTarget.toReportingString() + formatStr);
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("GIMRPostPatchAction.success.message", patchTarget.toReportingString());
                this._logger.info(formatStr + "End GIMR postpatch on " + patchTarget.toReportingString() + formatStr);
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("GIMRPostPatchAction.warning.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("GIMRPostPatchAction.failure.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    public boolean isLocalParallelExecutionSupported() {
        return true;
    }

    @Override
    public void prepareRemoteActionExecutionHost(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws RemoteConnectionException, PatchActionException {
        super.prepareRemoteActionExecutionHost(handler, container);
    }

    @Override
    public void setupRemoteActionExecutionEnvironment(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws PatchActionException {
        super.setupRemoteActionExecutionEnvironment(patchSession, container);
    }

    @Override
    public PatchAction clone() throws CloneNotSupportedException {
        PatchAction patchAction = super.clone();
        return patchAction;
    }
}

