/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.User;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.StartupPhase;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.common.Host;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.opatch.system.db.automation.jaxb.ActionType;

public class GIOnlinePostPatchAction
extends DBCommonPatchAction {
    Logger logger = Logger.getLogger(GIOnlinePostPatchAction.class.getName());

    public GIOnlinePostPatchAction() {
        super(new Goal[]{StartupPhase.Goal.startup});
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        return targetList;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        Host host;
        User user;
        String ohOwner;
        ExecutionStep executionStep;
        ActionType actionType;
        boolean isRHPServerRunning = SessionData.getInstance().isRHPServerRunning();
        boolean isRHPClientRunning = SessionData.getInstance().isRHPClientRunning();
        boolean isQOSMServerRunning = SessionData.getInstance().isQOSMServerRunning();
        ArrayList<ExecutionStep> executionList = new ArrayList<ExecutionStep>();
        String sourceHome = patchTarget.getHome(true).getLocation();
        sourceHome = sourceHome.replaceAll("/+$", "");
        StringBuilder srvctlRHPCmd = new StringBuilder();
        StringBuilder srvctlQOSCmd = new StringBuilder();
        srvctlRHPCmd.append(sourceHome + File.separator + DBCommonPatchingConstants.SRVCTL_COMMAND);
        srvctlRHPCmd.append(" start ");
        if (isRHPServerRunning) {
            srvctlRHPCmd.append("rhpserver");
        } else if (isRHPClientRunning) {
            srvctlRHPCmd.append("rhpclient");
        } else {
            srvctlRHPCmd = new StringBuilder();
            this.logger.info("No RHP resources are configured and running");
        }
        if (isQOSMServerRunning) {
            srvctlQOSCmd.append(sourceHome + File.separator + DBCommonPatchingConstants.SRVCTL_COMMAND + " start qosmserver ");
        } else {
            this.logger.info("No QOSMServer resources are configured and running");
        }
        String QOSCmd = srvctlQOSCmd.toString();
        String RHPCmd = srvctlRHPCmd.toString();
        if (StringUtil.isNullOrEmpty((String)RHPCmd, (boolean)true) && StringUtil.isNullOrEmpty((String)QOSCmd, (boolean)true)) {
            this.logger.info("Skipping action to run GIOnline Prepatch command since no step got generated");
            return null;
        }
        if (!StringUtil.isNullOrEmpty((String)RHPCmd, (boolean)true)) {
            this.logger.info("RHP Command generated ::" + RHPCmd);
            actionType = new ActionType();
            executionStep = new ExecutionStep(actionType);
            executionStep.getCommand().add(new ExecutionStep.Command(RHPCmd));
            ohOwner = null;
            ohOwner = !DBPatchingHelper.isStaticConfiguration(this.getPatchSession().getOptions()) ? OUIDriver.checkFileOwner((File)new File(patchTarget.getHome(true).getLocation(), "oraInst.loc")) : System.getProperty("user.name");
            user = new User();
            user.setValue(ohOwner);
            executionStep.setUser(user);
            host = new Host();
            host.setDisplayName(patchTarget.getHost().getHost());
            host.setName(patchTarget.getHost().getHost());
            executionStep.setHost(host);
            executionList.add(executionStep);
        }
        if (!StringUtil.isNullOrEmpty((String)QOSCmd, (boolean)true)) {
            this.logger.info("QOS Command generated ::" + QOSCmd);
            actionType = new ActionType();
            executionStep = new ExecutionStep(actionType);
            executionStep.getCommand().add(new ExecutionStep.Command(QOSCmd));
            ohOwner = null;
            ohOwner = !DBPatchingHelper.isStaticConfiguration(this.getPatchSession().getOptions()) ? OUIDriver.checkFileOwner((File)new File(patchTarget.getHome(true).getLocation(), "oraInst.loc")) : System.getProperty("user.name");
            user = new User();
            user.setValue(ohOwner);
            executionStep.setUser(user);
            host = new Host();
            host.setDisplayName(patchTarget.getHost().getHost());
            host.setName(patchTarget.getHost().getHost());
            executionStep.setHost(host);
            executionList.add(executionStep);
        }
        return executionList;
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        OPatchAutoOptions options = this.getPatchSession().getOptions();
        String home_loc = patchTarget.getHome().getLocation();
        if (DBPatchingHelper.isOOPPatchingSession(options) || this.getPatchSession().isAnalyze()) {
            isActionRequired = false;
        } else if (SessionData.getInstance().getAnalyzedPatchList(home_loc) != null && !SessionData.getInstance().getAnalyzedPatchList(home_loc).isEmpty()) {
            isActionRequired = DBPatchingHelper.isTomcatPatchingSession(patchTarget.getHome().getLocation(), this.getPatchSession(), SessionData.getInstance().getAnalyzedPatchList(home_loc)) && !DBPatchingHelper.isJDKPatchingSession(patchTarget.getHome().getLocation(), this.getPatchSession(), SessionData.getInstance().getAnalyzedPatchList(home_loc));
            this.logger.info("Tomcat/Micronaut Patching session RHP start : " + isActionRequired);
        } else {
            isActionRequired = false;
        }
        if (patchTarget.getHome().isSharedHome()) {
            isActionRequired = isActionRequired && DBPatchingHelper.isFirstNodeGIPatching();
        }
        return isActionRequired;
    }

    public boolean isAnalyzeSupported() {
        boolean isAnalyzeSupported = false;
        return isAnalyzeSupported;
    }

    public int getOrderingWeight(Goal goal) {
        if (goal.equals(StartupPhase.Goal.startup)) {
            return 57;
        }
        return super.getOrderingWeight(goal);
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("GIOnlinePostPatchAction.start.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("GIOnlinePostPatchAction.success.message", patchTarget.toReportingString());
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("GIOnlinePostPatchAction.warning.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("GIOnlinePostPatchAction.failure.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    public boolean isLocalParallelExecutionSupported() {
        return true;
    }

    @Override
    public void prepareRemoteActionExecutionHost(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws RemoteConnectionException, PatchActionException {
        super.prepareRemoteActionExecutionHost(handler, container);
    }

    @Override
    public void setupRemoteActionExecutionEnvironment(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws PatchActionException {
        super.setupRemoteActionExecutionEnvironment(patchSession, container);
    }

    @Override
    public PatchAction clone() throws CloneNotSupportedException {
        PatchAction patchAction = super.clone();
        return patchAction;
    }
}

