/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.User;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.ShutdownPhase;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.common.Host;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.opatch.system.db.automation.jaxb.ActionType;

public class GIUnlockPatchAction
extends DBCommonPatchAction {
    Logger logger = Logger.getLogger(GIUnlockPatchAction.class.getName());

    public GIUnlockPatchAction() {
        super(new Goal[]{ShutdownPhase.Goal.shutdown});
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        return targetList;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ArrayList<ExecutionStep> executionList = new ArrayList<ExecutionStep>();
        String sourceHome = patchTarget.getHome(true).getLocation();
        sourceHome = sourceHome.replaceAll("/+$", "");
        File src = new File(sourceHome, "oraInst.loc");
        String ohOwner = OUIDriver.checkFileOwner((File)src);
        String group = OUIDriver.checkFileGroup((File)src);
        String targetHome = DBPatchingHelper.getTargetHomeFromProductType(patchTarget);
        User user = new User();
        user.setValue(ohOwner);
        User root = new User();
        root.setValue("root");
        Host host = new Host();
        host.setDisplayName(patchTarget.getHost().getHost());
        host.setName(patchTarget.getHost().getHost());
        boolean isRHPServerRunning = DBPatchingHelper.isRHPServerInstanceUp(patchTarget.getHost().getHost());
        boolean isRHPClientRunning = DBPatchingHelper.isRHPClientInstanceUp(patchTarget.getHost().getHost());
        StringBuilder srvctlRHPCmd = new StringBuilder();
        StringBuilder srvctlQOSCmd = new StringBuilder();
        srvctlRHPCmd.append(sourceHome + File.separator + DBCommonPatchingConstants.SRVCTL_COMMAND);
        srvctlRHPCmd.append(" stop ");
        if (isRHPServerRunning) {
            SessionData.getInstance().setRHPServerRunning(isRHPServerRunning);
            srvctlRHPCmd.append("rhpserver");
        } else if (isRHPClientRunning) {
            SessionData.getInstance().setRHPClientRunning(isRHPClientRunning);
            srvctlRHPCmd.append("rhpclient");
        } else {
            srvctlRHPCmd = new StringBuilder();
            this.logger.info("RHP resources are not configured and running on this node");
        }
        String RHPCmd = srvctlRHPCmd.toString();
        if (!StringUtil.isNullOrEmpty((String)RHPCmd, (boolean)true)) {
            this.logger.info("RHP stop command generated :: " + RHPCmd);
            ActionType actionType = new ActionType();
            ExecutionStep executionStep = new ExecutionStep(actionType);
            executionStep.getCommand().add(new ExecutionStep.Command(RHPCmd));
            executionStep.setUser(user);
            executionStep.setHost(host);
            executionList.add(executionStep);
        }
        if (targetHome.equals("crs")) {
            String StopCVUCmd = sourceHome + "/bin/srvctl stop cvu";
            this.logger.info("Stop cvu command generated : " + StopCVUCmd);
            ActionType actionType1 = new ActionType();
            ExecutionStep executionStep1 = new ExecutionStep(actionType1);
            executionStep1.getCommand().add(new ExecutionStep.Command(StopCVUCmd));
            executionStep1.setUser(root);
            executionStep1.setHost(host);
            executionList.add(executionStep1);
        }
        String GIUnlockCmd = "chown " + ohOwner + ":" + group + " " + sourceHome;
        this.logger.info("GI Home unlock command generated : " + GIUnlockCmd);
        ActionType actionType2 = new ActionType();
        ExecutionStep executionStep2 = new ExecutionStep(actionType2);
        executionStep2.getCommand().add(new ExecutionStep.Command(GIUnlockCmd));
        executionStep2.setUser(root);
        executionStep2.setHost(host);
        executionList.add(executionStep2);
        String JDKUnlockCmd = "chown -R " + ohOwner + ":" + group + " " + sourceHome + "/jdk/";
        this.logger.info("GI/jdk directory unlock command generated : " + JDKUnlockCmd);
        ActionType actionType3 = new ActionType();
        ExecutionStep executionStep3 = new ExecutionStep(actionType2);
        executionStep3.getCommand().add(new ExecutionStep.Command(JDKUnlockCmd));
        executionStep3.setUser(root);
        executionStep3.setHost(host);
        executionList.add(executionStep3);
        return executionList;
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        if (!DBPatchingUtil.isVersionEqalOrlater(primarypatchVersion, "19.0.0.0.0")) {
            return false;
        }
        OPatchAutoOptions options = this.getPatchSession().getOptions();
        String home_loc = patchTarget.getHome().getLocation();
        if (DBPatchingHelper.isOOPPatchingSession(options) || this.getPatchSession().isAnalyze()) {
            isActionRequired = false;
        } else if (SessionData.getInstance().getAnalyzedPatchList(home_loc) != null && !SessionData.getInstance().getAnalyzedPatchList(home_loc).isEmpty()) {
            isActionRequired = DBPatchingHelper.isJDKPatchingSession(patchTarget.getHome().getLocation(), this.getPatchSession(), SessionData.getInstance().getAnalyzedPatchList(home_loc));
            this.logger.info("OH/jdk unlock action needed : " + isActionRequired);
        } else {
            isActionRequired = false;
        }
        if (patchTarget.getHome().isSharedHome()) {
            isActionRequired = isActionRequired && DBPatchingHelper.isFirstNodeGIPatching();
        }
        return isActionRequired;
    }

    public boolean isAnalyzeSupported() {
        boolean isAnalyzeSupported = false;
        return isAnalyzeSupported;
    }

    public int getOrderingWeight(Goal goal) {
        if (goal.equals(ShutdownPhase.Goal.shutdown)) {
            return 58;
        }
        return super.getOrderingWeight(goal);
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        String formatStr = "\n********************\n";
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("GIUnlockPatchAction.start.message", patchTarget.toReportingString());
                this._logger.info(formatStr + "Begin GI home unlocking on " + patchTarget.toReportingString() + formatStr);
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("GIUnlockPatchAction.success.message", patchTarget.toReportingString());
                this._logger.info(formatStr + "End GI home unlocking on " + patchTarget.toReportingString() + formatStr);
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("GIUnlockPatchAction.warning.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("GIUnlockPatchAction.failure.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    public boolean isLocalParallelExecutionSupported() {
        return true;
    }

    @Override
    public void prepareRemoteActionExecutionHost(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws RemoteConnectionException, PatchActionException {
        super.prepareRemoteActionExecutionHost(handler, container);
    }

    @Override
    public void setupRemoteActionExecutionEnvironment(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws PatchActionException {
        super.setupRemoteActionExecutionEnvironment(patchSession, container);
    }

    @Override
    public PatchAction clone() throws CloneNotSupportedException {
        PatchAction patchAction = super.clone();
        return patchAction;
    }
}

