/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.User;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.ExecutionThread2;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.InitPhase;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.common.Host;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.opatch.system.db.automation.jaxb.ActionType;

public class OJVMPatchAction
extends DBCommonPatchAction {
    Logger logger = Logger.getLogger(OJVMPatchAction.class.getName());
    static HashMap<String, String> homeOJVMLib = new HashMap();

    public OJVMPatchAction() {
        super(new Goal[]{InitPhase.Goal.init});
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        return targetList;
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        OPatchAutoOptions options = this.getPatchSession().getOptions();
        String home = patchTarget.getHome(true).getLocation();
        HashMap<String, String> hostPatchMap = SessionData.getInstance().getHostPatchDataMap(home);
        if (!DBPatchingHelper.isOOPPatchingSession(options)) {
            if (hostPatchMap != null && hostPatchMap.size() > 0 && !DBPatchingHelper.isFirstNodeOfPatchingForAnyPatch(home, hostPatchMap, this.getPatchSession().isRollback())) {
                this.logger.info("This is not the first node of patching for any applicable patch for the home " + home + ". Hence, skipping the patch action.");
                return false;
            }
        } else if (!OOPSessionInfoHandler.getInstance().isFirstNode(patchTarget)) {
            this.logger.info("This is not the first node of OOP patching. Hence, skipping the patch action.");
            return false;
        }
        if (!this.getPatchSession().isAnalyze() && !DBPatchingHelper.isOOPApplySwitchCloneSession(options)) {
            String patchPathOrID = DBPatchingHelper.getOJVMPatchPathOrID(home, this.getPatchSession());
            if (StringUtil.isNullOrEmpty((String)patchPathOrID)) {
                this.logger.info("No OJVM patch found in the patch list");
                isActionRequired = false;
            } else {
                String ojvmLib = "";
                if (this.getPatchSession().isRollback()) {
                    this.logger.info("Identifying OJVM Lib for home " + home);
                    this.deObfuscateOJVMPatch(home, patchPathOrID);
                    ojvmLib = DBPatchingHelper.getOJVMLibForRollback(home, patchPathOrID);
                } else {
                    ojvmLib = DBPatchingHelper.getOJVMLibForApply(patchPathOrID);
                }
                if (StringUtil.isNullOrEmpty((String)ojvmLib)) {
                    this.logger.info("OJVM library not found inside the OJVM patch");
                    isActionRequired = false;
                } else {
                    homeOJVMLib.put(home, ojvmLib);
                    this.logger.info("OJVM library found inside the OJVM patch at " + ojvmLib);
                    isActionRequired = true;
                }
            }
        } else {
            this.logger.info("This patch action is not required during switch-clone phase of apply operation.");
            isActionRequired = false;
        }
        return isActionRequired;
    }

    private void deObfuscateOJVMPatch(String home, String patchPathOrID) {
        File patch = new File(patchPathOrID);
        String patchID = patch.getName();
        StringBuffer deobfCmd = new StringBuffer();
        deobfCmd.append(home).append(File.separator).append("OPatch").append(File.separator);
        deobfCmd.append("opatch util Deobfuscate -id ").append(patchID);
        deobfCmd.append(" -oh ").append(home);
        String ohOwner = null;
        ohOwner = !DBPatchingHelper.isStaticConfiguration(this.getPatchSession().getOptions()) ? OUIDriver.checkFileOwner((File)new File(home, "oraInst.loc")) : System.getProperty("user.name");
        Credential cred = null;
        GISystemCall.ExecReturn er = GISystemCall.process(deobfCmd.toString(), ohOwner, cred);
        if (er.isOK()) {
            this.logger.info("Deobfuscated the OJVM patch " + patchID);
        } else {
            this.logger.info("Failed to deobfuscate the OJVM patch " + patchID);
        }
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    @Override
    public PatchActionResult execute(PatchTarget patchTarget) {
        PatchActionResult patchActionResult = new PatchActionResult();
        if (!DBPatchingUtil.isVersionEqalOrlater(patchTarget.getHome().getVersion(), "21.0.0.0.0") || DBPatchingHelper.getTargetHomeFromProductType(patchTarget).equals("sidb")) {
            patchActionResult = super.execute(patchTarget);
        } else {
            this.logger.info("For RAC DBs of versions older than 21c, jvm script will be executed in parallel across the DB instances.\n");
            ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
            List<RACDatabase> racDBs = configGraph.getTargets(RACDatabase.class);
            for (RACDatabase racDB : racDBs) {
                this.logger.info("racDB.getOracleHome(): " + racDB.getOracleHome());
                this.logger.info("racDB.getDatabaseName(): " + racDB.getDatabaseName());
                if (!DBPatchingHelper.compareFilePath(racDB.getOracleHome(), patchTarget.getHome(true).getLocation())) continue;
                ArrayList<ExecutionThread2> instanceThreads = new ArrayList<ExecutionThread2>();
                List instances = racDB.getDbInstances();
                for (RACDBInstance inst : instances) {
                    if (inst.getIsRunning().equals("yes")) {
                        ArrayList<ExecutionStep> racDBSteps = new ArrayList<ExecutionStep>();
                        racDBSteps.addAll(this.generateStep(patchTarget, inst.getHost().getHostName(), patchTarget.getHome(true).getLocation(), inst.getInstanceName()));
                        ExecutionThread2 threadForInstance = new ExecutionThread2(racDBSteps, null, this.logger);
                        instanceThreads.add(threadForInstance);
                        continue;
                    }
                    this.logger.info("[Warning] Skipping OJVM steps for inactive RAC database instance " + inst.getInstanceName());
                }
                for (ExecutionThread2 et : instanceThreads) {
                    et.start();
                }
                for (ExecutionThread2 et : instanceThreads) {
                    try {
                        et.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                for (ExecutionThread2 et : instanceThreads) {
                    if (et.successfull) continue;
                    return new PatchActionResult(false);
                }
            }
        }
        return patchActionResult;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ArrayList<ExecutionStep> executionList = new ArrayList<ExecutionStep>();
        String targetHome = DBPatchingHelper.getTargetHomeFromProductType(patchTarget);
        if (targetHome.equals("sidb")) {
            executionList.addAll(this.generateStepsForSIDatabase(patchTarget));
        } else if (targetHome.equals("rac")) {
            executionList.addAll(this.generateStepsForRACDatabase(patchTarget));
        }
        if (executionList.size() == 0) {
            this.logger.info("Skipping action to update OJVM libraries since no step got generated.");
        }
        return executionList;
    }

    private List<ExecutionStep> generateStepsForSIDatabase(PatchTarget patchTarget) {
        ArrayList<ExecutionStep> sidbSteps = new ArrayList<ExecutionStep>();
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<SIDatabase> sidbs = configGraph.getTargets(SIDatabase.class);
        for (SIDatabase sidb : sidbs) {
            if (!DBPatchingHelper.compareFilePath(sidb.getOracleHome(), patchTarget.getHome(true).getLocation())) continue;
            if (sidb.getAvailability().equals("yes")) {
                sidbSteps.addAll(this.generateStep(patchTarget, patchTarget.getHost().getHost(), patchTarget.getHome(true).getLocation(), sidb.getInstanceName()));
                continue;
            }
            this.logger.info("[Warning] Skipping OJVM steps for inactive database instance " + sidb.getInstanceName());
        }
        return sidbSteps;
    }

    private List<ExecutionStep> generateStepsForRACDatabase(PatchTarget patchTarget) {
        ArrayList<ExecutionStep> racDBSteps = new ArrayList<ExecutionStep>();
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<RACDatabase> racDBs = configGraph.getTargets(RACDatabase.class);
        for (RACDatabase racDB : racDBs) {
            this.logger.info("racDB.getOracleHome(): " + racDB.getOracleHome());
            this.logger.info("racDB.getDatabaseName(): " + racDB.getDatabaseName());
            if (!DBPatchingHelper.compareFilePath(racDB.getOracleHome(), patchTarget.getHome(true).getLocation())) continue;
            List instances = racDB.getDbInstances();
            for (RACDBInstance inst : instances) {
                if (inst.getIsRunning().equals("yes")) {
                    racDBSteps.addAll(this.generateStep(patchTarget, inst.getHost().getHostName(), patchTarget.getHome(true).getLocation(), inst.getInstanceName()));
                    continue;
                }
                this.logger.info("[Warning] Skipping OJVM steps for inactive RAC database instance " + inst.getInstanceName());
            }
        }
        return racDBSteps;
    }

    private List<ExecutionStep> generateStep(PatchTarget patchTarget, String hostname, String home, String sid) {
        ArrayList<ExecutionStep> copyAndRun = new ArrayList<ExecutionStep>();
        StringBuilder copyAndRunOJVM = new StringBuilder();
        String ohOwner = null;
        ohOwner = !DBPatchingHelper.isStaticConfiguration(this.getPatchSession().getOptions()) ? OUIDriver.checkFileOwner((File)new File(home, "oraInst.loc")) : System.getProperty("user.name");
        String ojvmLib = homeOJVMLib.get(home);
        this.logger.info("OJVM lib is located at " + ojvmLib);
        if (StringUtil.isNullOrEmpty((String)ojvmLib)) {
            this.logger.info("Skipping the action since the OJVM lib location is not available");
            return null;
        }
        String destLoc = home + "/javavm/admin/";
        String destFile = destLoc + "classes.bin.patch";
        String ojvmScript = home + "/javavm/install/jvmpreinst.pl";
        copyAndRunOJVM.append(PatchActionUtil.getBashCmd());
        copyAndRunOJVM.append(" -c '");
        if (patchTarget.getHost().getHost().equals(hostname)) {
            copyAndRunOJVM.append("cp " + ojvmLib + " " + destFile + " ; ");
            copyAndRunOJVM.append("ORACLE_HOME=" + home + " ORACLE_SID=" + sid + " ");
            copyAndRunOJVM.append(home + "/perl/bin/perl " + ojvmScript);
            if (this.getPatchSession().isRollback()) {
                copyAndRunOJVM.append(" -rollback");
            }
            copyAndRunOJVM.append("'");
        } else {
            copyAndRunOJVM.append("scp " + ojvmLib + " " + ohOwner + "@" + hostname + ":" + destFile + "'");
        }
        String cmd = copyAndRunOJVM.toString();
        if (!StringUtil.isNullOrEmpty((String)cmd, (boolean)true)) {
            this.logger.info("Command generated ::" + cmd);
            ActionType actionType = new ActionType();
            ExecutionStep executionStep = new ExecutionStep(actionType);
            executionStep.getCommand().add(new ExecutionStep.Command(cmd));
            User user = new User();
            user.setValue(ohOwner);
            executionStep.setUser(user);
            Host host = new Host();
            host.setDisplayName(hostname);
            host.setName(hostname);
            executionStep.setHost(host);
            copyAndRun.add(executionStep);
            if (!patchTarget.getHost().getHost().equals(hostname)) {
                copyAndRunOJVM = new StringBuilder();
                copyAndRunOJVM.append("ssh " + ohOwner + "@" + hostname + " \"");
                copyAndRunOJVM.append(PatchActionUtil.getBashCmd());
                copyAndRunOJVM.append(" -c '");
                copyAndRunOJVM.append("ORACLE_HOME=" + home + " ORACLE_SID=" + sid + " ");
                copyAndRunOJVM.append(home + "/perl/bin/perl " + ojvmScript);
                if (this.getPatchSession().isRollback()) {
                    copyAndRunOJVM.append(" -rollback");
                }
                copyAndRunOJVM.append("'\"");
                String cmd2 = copyAndRunOJVM.toString();
                this.logger.info("Command generated ::" + cmd2);
                ActionType actionType2 = new ActionType();
                ExecutionStep executionStep2 = new ExecutionStep(actionType2);
                executionStep2.getCommand().add(new ExecutionStep.Command(cmd2));
                executionStep2.setUser(user);
                executionStep2.setHost(host);
                copyAndRun.add(executionStep2);
            }
            return copyAndRun;
        }
        this.logger.info("Skipping action to update OJVM libraries for SID " + sid);
        return null;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    public boolean isAnalyzeSupported() {
        boolean isAnalyzeSupported = false;
        return isAnalyzeSupported;
    }

    public boolean isLocalParallelExecutionSupported() {
        return false;
    }

    public int getOrderingWeight(Goal goal) {
        return 94;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        String formatStr = "\n********************\n";
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("OJVMPatchAction.start.message", patchTarget.getHome(true).getLocation());
                this._logger.info(formatStr + "Begin updating OJVM libraries for home " + patchTarget.getHome(true).getLocation() + formatStr);
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("OJVMPatchAction.success.message", new Object[0]);
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("OJVMPatchAction.warning.message", patchTarget.toReportingString());
                this._logger.info(formatStr + "End updating OJVM libraries for home " + patchTarget.getHome(true).getLocation() + formatStr);
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("OJVMPatchAction.failure.message", patchTarget.toReportingString());
                this._logger.info(formatStr + "End updating OJVM libraries for home " + patchTarget.getHome(true).getLocation() + formatStr);
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }

    @Override
    public void prepareRemoteActionExecutionHost(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws RemoteConnectionException, PatchActionException {
        super.prepareRemoteActionExecutionHost(handler, container);
    }

    @Override
    public void setupRemoteActionExecutionEnvironment(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws PatchActionException {
        super.setupRemoteActionExecutionEnvironment(patchSession, container);
    }

    @Override
    public PatchAction clone() throws CloneNotSupportedException {
        PatchAction patchAction = super.clone();
        return patchAction;
    }

    private boolean isFirstNode(PatchTarget patchTarget, RACDatabase racDB) {
        return true;
    }

    private boolean isLastNode(PatchTarget patchTarget, RACDatabase racDB) {
        return true;
    }
}

