/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PDBActions;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.CommandFailureException;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.CommandDetailsGenerator;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.executor.ExecutionResult;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHelper;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.HomeImpl;
import dbmodel.SystemInstance;
import dbmodel.db_crs.SIDatabase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.PatchingPhase;
import oracle.opatch.system.db.automation.jaxb.PhaseType;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public abstract class OnlineAction
extends DBCommonPatchAction {
    protected boolean sqlActionNotRequired = false;

    public OnlineAction(Goal goal) {
        super(goal);
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        if (((HomeImpl)patchTarget.getHome()).isGIMRHome()) {
            return false;
        }
        OPatchAutoOptions optAutoOptions = this.getPatchSession().getOptions();
        try {
            if (DBPatchingHelper.isOOPPatchingSession(optAutoOptions) && (DBPatchingHelper.isOOPPreparePatchingSession(optAutoOptions) || !OOPSessionInfoHelper.canExecuteDBSteps(patchTarget, this.getPatchSession().getOptions().getOption(DBProductParameterConstants.REMOTE_KEY.getValue()).isSwitchEnabled()))) {
                isActionRequired = false;
            }
        }
        catch (OPatchAutoException e) {
            throw new PatchActionException((Throwable)e);
        }
        return isActionRequired;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    @Override
    protected ExecutionResult runCommand(PatchTarget patchTarget, ExecutionStep executionStep) throws CommandFailureException {
        ExecutionResult result = null;
        try {
            result = super.runCommand(patchTarget, executionStep);
        }
        catch (CommandFailureException e) {
            String command = e.getCommand();
            if (command.indexOf("datapatch") != -1 || command.indexOf(".sql") != -1) {
                String session = this.getPatchSession().isRollback() ? this.getLocalizedString("rolledback.session.value", new Object[0]) : this.getLocalizedString("applied.session.value", new Object[0]);
                Reporting.report((String)this.getLocalizedString("SQLAction.sql.patch.warning", command, session));
                ExecutionResult executionResult = result = new ExecutionResult(new ArrayList<ExecutionResult.CommandExecutionResult>());
                executionResult.getClass();
                result.addCommandResult(executionResult.new ExecutionResult.CommandExecutionResult(ExecutionResult.ExecutionStatus.SUCCESS, e.getMessage(), e.getMessage(), e.getCommand()));
            }
            throw e;
        }
        return result;
    }

    protected List<ExecutionStep> getStartRedoApplyCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget, String commandTag, String actsOn) throws OPatchAutoException {
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, DBCommandActionType.StartRedoApply.toString());
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON, actsOn);
        if (commandTag != null) {
            argList.put(CommandDetailsGenerator.ActionTypeParams.COMMAND_TAG, commandTag);
        }
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Start-Recover-Managed-Title");
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_MSG_KEY, "Start-Recover-Managed-Message");
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        PatchingPhase phase = this.getPatchingPhase();
        Command startRedoApplyCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(configGraph, patchTarget, actionType, startRedoApplyCommand);
        return steps;
    }

    protected List<ExecutionStep> getSQLpatchCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget, String commandType, String acts_on, boolean actsOnClone) throws OPatchAutoException {
        String readMeTitle = "SQL-Step-Title";
        if (DBCommandActionType.SqlPatchRollback.toString().equals(commandType)) {
            readMeTitle = "SQL-Rollback-Step-Title";
        } else if (DBCommandActionType.SqlPatchSwitchback.toString().equals(commandType)) {
            readMeTitle = "SQL-Rollback-ClonedHome";
        }
        return this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, commandType, acts_on, readMeTitle, actsOnClone);
    }

    protected List<ExecutionStep> getSQLpatchCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget, String commandType, String acts_on, String readmeTitle, boolean actsOnClone) throws OPatchAutoException {
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, commandType);
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON, acts_on);
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON_CLONE, actsOnClone);
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, readmeTitle);
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        PatchingPhase phase = this.getPostPatchingPhase();
        Command sqlPatchApplyCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(configGraph, patchTarget, actionType, sqlPatchApplyCommand);
        block0: for (ExecutionStep step : steps) {
            if (!step.getAutomationAction().getType().startsWith("SqlPatch")) continue;
            for (ExecutionStep.Command command : step.getCommand()) {
                String version = DBPatchingHelper.getDBVersion(step.getActsOnTarget());
                if (!this.isCommandContainsDBInformation(command.getValue()) || this.isDataPatchRequired(patchTarget, step.getRunsOnOracleHome().getPath(), step.getHost().getName(), step.getUser().getValue(), command.getValue(), acts_on, version)) continue;
                step.getCommand().clear();
                continue block0;
            }
        }
        return steps;
    }

    private boolean isCommandContainsDBInformation(String command) {
        return command.contains("ORACLE_HOME=") && command.contains("ORACLE_SID=");
    }

    protected PatchingPhase getPostPatchingPhase() {
        PatchingPhase phase = null;
        phase = this.getPatchSession().isRollback() ? CommandDetailsGenerator.generatePatchingPhase(PhaseType.POST_ROLLBACK, ServiceStatus.UP) : CommandDetailsGenerator.generatePatchingPhase(PhaseType.POST_APPLY, ServiceStatus.UP);
        return phase;
    }

    protected PatchingPhase getPatchingPhase() {
        PatchingPhase phase = null;
        phase = this.getPatchSession().isRollback() ? CommandDetailsGenerator.generatePatchingPhase(PhaseType.ROLLBACK, ServiceStatus.LIMITED) : CommandDetailsGenerator.generatePatchingPhase(PhaseType.APPLY, ServiceStatus.LIMITED);
        return phase;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    protected boolean isSQLCOmmandAvailable(List<ExecutionStep> steps) {
        boolean isAvailable = true;
        if (steps == null || steps.isEmpty()) {
            return false;
        }
        for (ExecutionStep step : steps) {
            if (!step.getAutomationAction().getType().startsWith("SqlPatch")) continue;
            List<ExecutionStep.Command> commandList = step.getCommand();
            if (commandList != null && !commandList.isEmpty()) break;
            isAvailable = false;
            break;
        }
        return isAvailable;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        String formatStr = "\n********************\n";
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("OnlineAction.start.message", this.getSessionString(), patchTarget.toReportingString());
                this._logger.info(formatStr + "Begin Datapatch on " + patchTarget.toReportingString() + formatStr);
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("OnlineAction.failure.message", this.getSessionString(), patchTarget.toReportingString());
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("OnlineAction.warning.message", this.getCompletedSessionString(), patchTarget.toReportingString());
                this._logger.info(formatStr + "End Datapatch on " + patchTarget.toReportingString() + formatStr);
                break;
            }
            case success: {
                if (!this.sqlActionNotRequired) {
                    statusMsg = this.getLocalizedString("OnlineAction.success.message", this.getCompletedSessionString(), patchTarget.toReportingString());
                    this._logger.info(formatStr + "End Datapatch on " + patchTarget.toReportingString() + formatStr);
                    break;
                }
                statusMsg = this.getLocalizedString("OnlineAction.notrequired.message", new Object[0]);
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        statusMsg = this.addTag(statusMsg);
        return statusMsg;
    }

    private String getSessionString() {
        String sessionVal = this.getPatchSession().isRollback() ? this.getLocalizedString("rollback.value", new Object[0]) : this.getLocalizedString("apply.value", new Object[0]);
        return sessionVal;
    }

    private String getCompletedSessionString() {
        String sessionVal = this.getPatchSession().isRollback() ? this.getLocalizedString("rolledback.session.value", new Object[0]) : this.getLocalizedString("applied.session.value", new Object[0]);
        return sessionVal;
    }

    private boolean isDataPatchRequired(PatchTarget target, String homePath, String host, String user, String command, String actOn, String version) {
        boolean isRequired = true;
        String instName = DBPatchingUtil.getInstNameUsingCommand(command);
        boolean isDBUp = true;
        String dbname = "";
        if (actOn.equals("SIDatabase")) {
            dbname = DBPatchingUtil.getSIDBNameFromInstancename(instName, target);
            if (!DBPatchingHelper.isStaticConfiguration(this.getPatchSession().getOptions())) {
                isDBUp = DBPatchingUtil.isDBUpOnSIHA(homePath, dbname, user, target, version);
            }
        } else {
            dbname = DBPatchingUtil.getRACDBNameFromInstancename(instName, target);
            if (!DBPatchingHelper.isStaticConfiguration(this.getPatchSession().getOptions())) {
                isDBUp = DBPatchingUtil.isRACOneDB(dbname) ? DBPatchingUtil.isRACOneDBUp(homePath, dbname, target.getHost().getHost(), user, target, version) : DBPatchingUtil.isDBInstanceUp(homePath, dbname, target.getHost().getHost(), user, target, version);
            }
        }
        boolean isNoRestart = DBPatchingHelper.isNoRestartEnable(this.getPatchSession().getOptions());
        try {
            if (DBPatchingHelper.isStandByDatabase(dbname, this.getPatchSession().getOptions(), actOn)) {
                Reporting.report((String)this.addTag(this.getLocalizedString("PrereqAction.command.standby.skipped", dbname)));
                return false;
            }
            Boolean isSidbOnly = Boolean.parseBoolean(this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB_ONLY.getValue()).getValue());
            Boolean isSidb = Boolean.parseBoolean(this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB.getValue()).getValue());
            if (isSidbOnly.booleanValue()) {
                SystemInstance systemInstance = PatchPlanner.getInstance().getSystemInstance();
                SIDatabase siDatabase = (SIDatabase)systemInstance.getTargetsOfType(SIDatabase.class).get(0);
                String sidbDbUp = siDatabase.getShardProperty().getIsDatabaseUp();
                isDBUp = "Y".equalsIgnoreCase(sidbDbUp);
            } else if (this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB.getValue()).isSwitchEnabled()) {
                this._logger.info("SIDB switch enabled");
                isDBUp = true;
            }
            if (isSidb != null && isSidb.booleanValue()) {
                isDBUp = !SessionData.getInstance().getIsSIDBDown();
                this._logger.info("isDBUp " + isDBUp);
            }
        }
        catch (OPatchAutoException ex) {
            this._logger.warning("Exception while reading opatchauto options :  " + ex.getMessage());
        }
        isRequired = isDBUp && !isNoRestart;
        this._logger.info("Is SQL patching required = " + isRequired);
        if (!isDBUp) {
            this.generateSqlPatchWarning(target, 1, command, homePath, host, user, instName, dbname);
        }
        if (isNoRestart) {
            this.generateSqlPatchWarning(target, 0, command, homePath, host, user, instName, dbname);
        }
        return isRequired;
    }

    private void generateSqlPatchWarning(PatchTarget patchTarget, int warnType, String command, String oh, String host, String owner, String instName, String dbname) {
        StringBuilder buff = new StringBuilder("[WARNING] ");
        if (warnType == 0) {
            buff.append("The database instances will not be brought up under the 'norestart' option. ");
        }
        this._logger.log(Level.INFO, "Executing command:\n" + command);
        if (DBPatchingUtil.isRACOneDB(dbname)) {
            buff.append("This is a RACOne Database.");
            buff.append(" After completing patching on all the nodes, apply the datapatch step manually on the node where database instance is running.");
            buff.append(" Please refer to the log file for more details.\n");
            buff.append(" To find out the node where database instance is running, execute the following command,\n");
            buff.append("$ORACLE_HOME/bin/srvctl status database -d ");
            buff.append(dbname);
        } else {
            buff.append("The database instance '").append(instName);
            buff.append("' from '").append(oh).append("', in host'").append(host);
            buff.append("' is not running. SQL changes, if any,  will not be " + (this.getPatchSession().isAnalyze() ? "analyzed." : (this.getPatchSession().isRollback() ? "rolled back." : "applied.")));
            buff.append("\nTo " + (this.getPatchSession().isAnalyze() ? "analyze" : (this.getPatchSession().isRollback() ? "roll back." : "apply.") + " the SQL changes, bring up the database instance and run the command manually from any one node "));
            buff.append("(run as ").append(owner).append(").\n");
            buff.append("Refer to the readme to get the correct steps for applying the sql changes.\n");
        }
        DBPatchingSummaryCreator summaryCreator = this.getProductSupport().getDBPatchingSummaryCreator(this.getPatchSession().getCommand());
        if (this.getSupportedProductTypes().contains(patchTarget.getProductType().getType())) {
            summaryCreator.storePatchingSummary(0, SummaryID.patching_warning, patchTarget, buff.toString());
        }
    }

    protected List<ExecutionStep> getStopStartOracleHomeCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget, String commandType, String targetHome, ServiceStatus status, String acts_on, String readMeTitleKey, String readMeMsgKey) throws OPatchAutoException {
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, commandType);
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON, acts_on);
        argList.put(CommandDetailsGenerator.ActionTypeParams.SERVICE_STATUS, status);
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_NAME, "oracle.server");
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_TARGETHOME, targetHome);
        ArrayList<String> dependency_type = new ArrayList<String>();
        dependency_type.add("OracleHome");
        argList.put(CommandDetailsGenerator.ActionTypeParams.DEPENDENCY_TYPE, dependency_type);
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, readMeTitleKey);
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_MSG_KEY, readMeMsgKey);
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.LIFECYCLE_ACTION, argList);
        PatchingPhase phase = this.getPatchingPhase();
        Command stopStartOracleHomeCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(configGraph, patchTarget, actionType, stopStartOracleHomeCommand);
        return steps;
    }

    protected List<ExecutionStep> getStartPDBStateCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget, String acts_on) throws OPatchAutoException {
        PDBActions pdbAction = new PDBActions(this.getPatchSession().isRollback());
        PDBActions.PDBCOmmandModel startPDBCommandModel = pdbAction.getStartPDBStateCommand(configGraph, patchTarget, acts_on);
        List<ExecutionStep> steps = this.getPDBStateCommand(configGraph, patchTarget, startPDBCommandModel.getActionType(), startPDBCommandModel.getPdbCommand());
        return steps;
    }

    protected List<ExecutionStep> getUpgradePDBStateCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget, String acts_on) throws OPatchAutoException {
        PDBActions pdbAction = new PDBActions(this.getPatchSession().isRollback());
        PDBActions.PDBCOmmandModel startPDBCommandModel = pdbAction.getUpgradePDBStateCommand(configGraph, patchTarget, acts_on);
        List<ExecutionStep> steps = this.getPDBStateCommand(configGraph, patchTarget, startPDBCommandModel.getActionType(), startPDBCommandModel.getPdbCommand());
        return steps;
    }

    protected boolean isSQLUpgrdeModeCommandRequired(List<ExecutionStep> steps) {
        boolean isRequired = false;
        if (steps != null) {
            for (ExecutionStep step : steps) {
                if (step.getCommand() == null || step.getCommand().size() <= 0) continue;
                isRequired = true;
            }
        }
        this._logger.info("Is sql upgrde mode commands required: " + isRequired);
        return isRequired;
    }

    protected List<ExecutionStep> getPDBStateCommand(ConfigGraph configGraph, PatchTarget patchTarget, ActionType actionType, Command pdbStateCommand) throws OPatchAutoException {
        List<ExecutionStep> steps = this.getsteps(configGraph, patchTarget, actionType, pdbStateCommand);
        block0: for (ExecutionStep step : steps) {
            boolean isRequired = true;
            for (ExecutionStep.Command command : step.getCommand()) {
                String version = DBPatchingHelper.getDBVersion(step.getActsOnTarget());
                if (!command.getValue().startsWith("echo")) {
                    PDBActions pdbAction = new PDBActions(this.getPatchSession().isRollback());
                    isRequired = pdbAction.isPDBCommandNeedToBeExecuted(this.getPatchSession(), patchTarget, step.getRunsOnOracleHome().getPath(), step.getUser().getValue(), command.getValue(), actionType.getActsOn(), version);
                }
                if (isRequired) continue;
                step.getCommand().clear();
                continue block0;
            }
        }
        return steps;
    }
}

