/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.CommandDetailsGenerator;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandParameters;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.PatchingPhase;
import oracle.opatch.system.db.automation.jaxb.PhaseType;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public abstract class PrePostScriptAction
extends DBCommonPatchAction {
    private static final String POSTPATCH_SH = "postpatch.sh";
    private static final String PREPATCH_SH = "prepatch.sh";

    public PrePostScriptAction(Goal ... goals) {
        super(goals);
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        boolean isRollbackPatchID = DBPatchingHelper.isRollbackUsingPatchId(this.getPatchSession());
        String patchInformation = null;
        if (isRollbackPatchID) {
            patchInformation = this.getPatchSession().getPatchId();
            this._logger.info("Rollback patch ids ::" + patchInformation);
        }
        if (isActionRequired && (DBPatchingHelper.isOOPSwitchPatchingSession(this.getPatchSession().getOptions()) || DBPatchingHelper.isOOPPatchingSession(this.getPatchSession().getOptions()) && patchTarget.getHome().isSharedHome() && !OOPSessionInfoHandler.getInstance().isFirstNode(patchTarget))) {
            isActionRequired = false;
        }
        return isActionRequired;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    protected List<ExecutionStep> getPrePostScriptSteps(PatchTarget patchTarget, String stripeName, String stripeTargetHome) throws OPatchAutoException {
        ActionType actionType = this.constructActionType(stripeName, stripeTargetHome);
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        PatchingPhase phase = this.getpatchingPhase();
        Command prePostScriptCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(configGraph, patchTarget, actionType, prePostScriptCommand);
        return steps;
    }

    @Override
    protected PatchActionResult executeSteps(List<ExecutionStep> executionSteps, PatchTarget patchTarget) throws OPatchAutoException {
        String patchLocation = DBPatchingHelper.getPatchLocation(this.getPatchSession());
        if (!DBPatchingHelper.isGenerateStepCommand(this.getPatchSession().getOptions()) && this.isUpdatedPatchLocationRequired(executionSteps)) {
            patchLocation = this.findUpdatedPatchLocation(executionSteps, patchTarget);
        }
        for (ExecutionStep executionStep : executionSteps) {
            List<ExecutionStep.Command> commands = executionStep.getCommand();
            for (ExecutionStep.Command cmd : commands) {
                cmd.setValue(cmd.getValue().replaceAll(DBCommandParameters.TEMP_PATCH_LOC.getValue(), patchLocation));
            }
        }
        this._logger.info("Updated patch location is " + patchLocation);
        return super.executeSteps(executionSteps, patchTarget);
    }

    private ActionType constructActionType(String stripeName, String stripeTargetHome) {
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, this.getCommandActionType());
        String prePostScriptCommandStr = this.getScriptName();
        HashMap commandDetails = new HashMap();
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(DBCommandParameters.DBHOME.getValue());
        paramList.add("%OracleHome.path%");
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_NAME, stripeName);
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_TARGETHOME, stripeTargetHome);
        if (this.getPatchSession().isRollback()) {
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "OPatch-Rollback-Title");
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_MSG_KEY, "OPatch-Rollback-Message");
        } else {
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "OPatch-Apply-Title");
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_MSG_KEY, "OPatch-Apply-Message");
        }
        commandDetails.put(prePostScriptCommandStr, paramList);
        argList.put(CommandDetailsGenerator.ActionTypeParams.COMMAND_DETAILS, commandDetails);
        ActionType actionType = CommandDetailsGenerator.generateActionType(this.getActionType(), argList);
        return actionType;
    }

    protected CommandDetailsGenerator.ActionTypes getActionType() {
        return CommandDetailsGenerator.ActionTypes.COMMAND_ACTION;
    }

    protected String getCommandActionType() {
        return DBCommandActionType.PrePostScript.toString();
    }

    protected String getScriptName() {
        String prePostScriptCommandStr = OfflinePhase.Goal.prepare.equals((Object)this.getCurrentGoal()) ? PREPATCH_SH : POSTPATCH_SH;
        return prePostScriptCommandStr;
    }

    protected PatchingPhase getpatchingPhase() {
        PatchingPhase phase = null;
        phase = this.getPatchSession().isRollback() ? CommandDetailsGenerator.generatePatchingPhase(PhaseType.ROLLBACK, ServiceStatus.LIMITED) : CommandDetailsGenerator.generatePatchingPhase(PhaseType.APPLY, ServiceStatus.LIMITED);
        return phase;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("PrePostScriptAction." + this.getCurrentGoal().getName() + ".start.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("PrePostScriptAction." + this.getCurrentGoal().getName() + ".failure.message", patchTarget.toReportingString());
                break;
            }
            case warning: {
                statusMsg = "";
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("PrePostScriptAction." + this.getCurrentGoal().getName() + ".success.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }
}

