/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.User;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.common.Host;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;

public class RunRootRemoveRDBMSPatchAction
extends DBCommonPatchAction {
    Logger _logger = Logger.getLogger(RunRootRemoveRDBMSPatchAction.class.getName());

    public RunRootRemoveRDBMSPatchAction() {
        super(new Goal[]{OfflinePhase.Goal.binary_patching});
    }

    public int getOrderingWeight(Goal goal) {
        return 85;
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        String minVersion = "23.0.0.0.0";
        String primaryVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        if (!DBPatchingUtil.isVersionEqalOrlater(primaryVersion, minVersion)) {
            this._logger.info("rootremove_rdbms.sh script will not be executed for version below " + minVersion);
            return false;
        }
        OPatchAutoOptions options = this.getPatchSession().getOptions();
        if (this.getPatchSession().isAnalyze()) {
            this._logger.info("Analyze mode does not require rootremove_rdbms.sh script execution.");
            return false;
        }
        if (!DBPatchingHelper.isOOPPatchingSession(options)) {
            this._logger.info("rootremove_rdbms.sh script will be run for in-place sessions.");
            return true;
        }
        if (DBPatchingHelper.isOOPSwitchbackSession(options)) {
            this._logger.info("rootremove_rdbms.sh script will not be executed for switch-back sessions.");
            return false;
        }
        if (DBPatchingHelper.isOOPPreparePatchingSession(options) || DBPatchingHelper.isSingleOOPPatchingSession(options)) {
            this._logger.info("rootremove_rdbms.sh script will be executed on the newly prepared home.");
            return true;
        }
        if (DBPatchingHelper.isOOPApplySwitchCloneSession(options)) {
            this._logger.info("rootremove_rdbms.sh script will be skipped for the already prepared home.");
            return false;
        }
        this._logger.info("rootremove_rdbms.sh script will be skipped by default.");
        return false;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        return targetList;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    public boolean isAnalyzeSupported() {
        return false;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ArrayList<ExecutionStep> executionList = new ArrayList<ExecutionStep>();
        String home = patchTarget.getHome().getLocation();
        StringBuilder rootremoveRdbmsCmd = new StringBuilder();
        rootremoveRdbmsCmd.append(home).append("/rdbms/install/rootremove_rdbms.sh");
        String cmd = rootremoveRdbmsCmd.toString();
        ActionType actionType = new ActionType();
        ExecutionStep executionStep = new ExecutionStep(actionType);
        executionStep.getCommand().add(new ExecutionStep.Command(cmd));
        User user = new User();
        user.setValue("root");
        executionStep.setUser(user);
        Host host = new Host();
        host.setDisplayName(patchTarget.getHost().getHost());
        host.setName(patchTarget.getHost().getHost());
        executionStep.setHost(host);
        executionList.add(executionStep);
        return executionList;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("RunRootRemoveRDBMSPatchAction.start.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("RunRootRemoveRDBMSPatchAction.success.message", patchTarget.toReportingString());
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("RunRootRemoveRDBMSPatchAction.warning.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("RunRootRemoveRDBMSPatchAction.failure.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }

    @Override
    public PatchAction clone() throws CloneNotSupportedException {
        PatchAction patchAction = super.clone();
        return patchAction;
    }
}

