/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHelper;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.StartupPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class UpdateRuntimeData
extends DBCommonPatchAction {
    Logger logger = Logger.getLogger(UpdateRuntimeData.class.getName());

    public UpdateRuntimeData() {
        super(new Goal[]{StartupPhase.Goal.startup});
    }

    public int getOrderingWeight(Goal goal) {
        return 10;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        return targetList;
    }

    @Override
    protected void displayNoStepMessage(PatchTarget target) {
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        OPatchAutoOptions options = this.getPatchSession().getOptions();
        String homeLocation = patchTarget.getHome(true).getLocation();
        boolean isGenerateStepCmd = DBPatchingHelper.isGenerateStepCommand(this.getPatchSession().getOptions());
        try {
            isActionRequired = !isGenerateStepCmd && DBPatchingHelper.compareFilePath(homeLocation, OPatchAutoHelper.getOPatchAutoHome()) && !patchTarget.isRemote();
        }
        catch (OPatchAutoException e) {
            throw new PatchActionException((Throwable)e);
        }
        return isActionRequired;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        return new ArrayList<ExecutionStep>();
    }

    @Override
    public PatchActionResult execute(PatchTarget patchTarget) {
        PatchActionResult patchActionResult = new PatchActionResult();
        try {
            OPatchAutoOptions options = this.getPatchSession().getOptions();
            if (DBPatchingHelper.isOOPPatchingSession(options)) {
                return this.executeOOP(patchTarget);
            }
            return this.executeInPlace(patchTarget);
        }
        catch (OPatchAutoException e) {
            patchActionResult = new PatchActionResult(PatchActionStatus.failure);
            return patchActionResult;
        }
    }

    private PatchActionResult executeInPlace(PatchTarget patchTarget) throws OPatchAutoException {
        PatchActionResult patchActionResult = new PatchActionResult();
        SessionData sessionData = SessionData.getInstance();
        String localhost = DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost());
        String baseHome = OPatchAutoHelper.getOPatchAutoHome();
        if (!sessionData.isMultiNodeEnv()) {
            sessionData.setPatchingCompletedOnAllNodes(true);
            sessionData.setSelectedFinalHost(true);
            return patchActionResult;
        }
        Set patchTargetList = this.getPatchSession().getPatchPlanManager().getPatchTargets();
        try {
            this.logger.info("Waiting before identifying last session.");
            Thread.sleep(10000L);
            this.logger.info("Preparing to identify last session.");
        }
        catch (InterruptedException e) {
            this.logger.info("Interrupted during the sleep.");
        }
        HashMap<String, String> parallel_sessions = DBPatchingHelper.getIPParallelSessionInfo(patchTargetList, localhost, baseHome);
        sessionData.setActiveSessions(parallel_sessions);
        DBPatchingHelper.updateRuntimePatchMap(patchTargetList, localhost);
        DBPatchingHelper.deleteLocalActiveLock(baseHome, localhost, false);
        return patchActionResult;
    }

    private PatchActionResult executeOOP(PatchTarget patchTarget) throws OPatchAutoException {
        PatchActionResult patchActionResult = new PatchActionResult();
        SessionData sessionData = SessionData.getInstance();
        String localhost = DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost());
        String sessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE;
        sessionInfoFile = sessionInfoFile.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
        String oopSessionFilePath = OPatchAutoHelper.getOPatchAutoHome() + sessionInfoFile;
        OOPSessionInfoHandler oopSessionInfoHandler = OOPSessionInfoHandler.getInstance();
        Set patchTargetList = this.getPatchSession().getPatchPlanManager().getPatchTargets();
        this.logger.info("Updating status of local homes in the cookie.");
        for (PatchTarget target : patchTargetList) {
            oopSessionInfoHandler.updateHomeSessionStatus(target, true);
        }
        this.logger.info("Successfully updated the status of local homes in the cookie.");
        oopSessionInfoHandler.saveOOPSessionCookie(oopSessionFilePath);
        oopSessionInfoHandler.distributeSessionFileLocal();
        boolean isNonRollingMode = DBPatchingHelper.isNonRollingMode(this.getPatchSession().getOptions());
        oopSessionInfoHandler.distributeSystemInfo(isNonRollingMode);
        if (!sessionData.isMultiNodeEnv()) {
            sessionData.setPatchingCompletedOnAllNodes(true);
            sessionData.setSelectedFinalHost(true);
            return patchActionResult;
        }
        try {
            this.logger.info("Waiting before identifying last session.");
            Thread.sleep(10000L);
            this.logger.info("Preparing to identify last session.");
        }
        catch (InterruptedException e) {
            this.logger.info("Interrupted during the sleep.");
        }
        HashMap<String, String> parallel_sessions = oopSessionInfoHandler.getParallelSessionInfo();
        sessionData.setActiveSessions(parallel_sessions);
        if (OOPSessionInfoHelper.isSessionCompletedOnAllNodesAtRuntime()) {
            boolean active_remotes;
            sessionData.setPatchingCompletedOnAllNodes(true);
            boolean bl = active_remotes = parallel_sessions.size() > 1;
            if (active_remotes) {
                Set<String> parallel_nodes = parallel_sessions.keySet();
                String station_host = oopSessionInfoHandler.getStationHostForParallelPatching(parallel_nodes);
                sessionData.setStationHost(station_host);
                OOPSessionInfoHelper.registerWithStationHost(localhost, station_host, parallel_sessions.get(station_host));
                String selected_host = OOPSessionInfoHelper.getSelectedHost(localhost, station_host, parallel_sessions.get(station_host));
                if (localhost.equals(selected_host)) {
                    sessionData.setSelectedFinalHost(true);
                    this.logger.info("Localhost will handle the operations to close OOP session.");
                } else {
                    this.logger.info(selected_host + " will handle the operations to close OOP session.");
                }
            } else {
                sessionData.setSelectedFinalHost(true);
                this.logger.info("Localhost will handle the operations to close OOP session as this is the final and only active session.");
            }
        }
        return patchActionResult;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        return "";
    }
}

