/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.crs;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBShutDownStartupAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.StartupPhase;
import com.oracle.glcm.patch.auto.plan.PatchPlanManager;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.HomeImpl;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;

public class RACStartupAction
extends DBShutDownStartupAction {
    public RACStartupAction() {
        super(new Goal[]{StartupPhase.Goal.startup});
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isRequired = super.isActionRequired(patchTarget);
        if (!isRequired) {
            return isRequired;
        }
        if (((HomeImpl)patchTarget.getHome()).isGIMRHome()) {
            return false;
        }
        PatchPlanManager patchPlanManager = this.getPatchSession().getPatchPlanManager();
        Set patchTargetList = patchPlanManager.getPatchTargets();
        boolean hasCRSPatching = DBPatchingHelper.hasCRSPatching(patchTargetList);
        boolean isRHPPatching = DBPatchingHelper.hasRHPPatching(patchTargetList, this.getPatchSession());
        boolean isCRSPatchingSkipped = DBPatchingHelper.isCRSPatchingSkipped(patchTargetList, isRHPPatching);
        boolean oopPatchingSession = DBPatchingHelper.isOOPPatchingSession(this.getPatchSession().getOptions());
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        boolean isNonRollingMode = DBPatchingHelper.isNonRollingMode(this.getPatchSession().getOptions());
        isRequired = isNonRollingMode || patchTarget.getType().equals(DBProductTypes.PRODUCT_TYPE_RAC_SHARED.getValue()) || !DBPatchingHelper.areAllRacOneDatabase(patchTarget) && (oopPatchingSession || !this.isGIPatchingRequestedForTwelveDB(primarypatchVersion, isCRSPatchingSkipped));
        boolean bl = isRequired = isRequired && ClusterInformationLoader.getInstance().isStackRunning();
        if (!hasCRSPatching && oopPatchingSession) {
            isRequired = false;
        }
        if (oopPatchingSession) {
            isRequired = false;
        }
        return isRequired;
    }

    @Override
    public List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        List<ExecutionStep> generatedSteps = super.generateSteps(patchTarget);
        List<ExecutionStep> steps = this.getStartOracleHomeCommandExecutionSteps(this.configGraph, patchTarget, "rac", "OracleHome");
        if (!DBPatchingHelper.isNoRestartEnable(this.getPatchSession().getOptions())) {
            generatedSteps.addAll(steps);
        } else {
            Reporting.report((String)this.getLocalizedString("StartAction.norestart.database.warning", patchTarget.getHome().getLocation()));
            for (ExecutionStep step : steps) {
                for (ExecutionStep.Command command : step.getCommand()) {
                    Reporting.report((String)(command.getValue() + "\n"));
                }
            }
        }
        return generatedSteps;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC_SHARED.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC_NONSHARED.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        return targetList;
    }
}

