/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.oop;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.User;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.SqlPatchCommand;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.common.Host;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.opatch.system.db.automation.jaxb.ActionType;

public class CopyDatapatchLibsAction
extends DBCommonPatchAction {
    Logger logger = Logger.getLogger(SqlPatchCommand.class.getName());

    public CopyDatapatchLibsAction() {
        super(new Goal[]{OfflinePhase.Goal.binary_patching});
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        return targetList;
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        OPatchAutoOptions options = this.getPatchSession().getOptions();
        isActionRequired = DBPatchingHelper.isOOPPatchingSession(options) && this.getPatchSession().isRollback() && !this.getPatchSession().isAnalyze();
        return isActionRequired;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ArrayList<ExecutionStep> executionList = new ArrayList<ExecutionStep>();
        String cmd = this.generateCommand(patchTarget);
        if (!StringUtil.isNullOrEmpty((String)cmd, (boolean)true)) {
            this._logger.fine("Command generated ::" + cmd);
            ActionType actionType = new ActionType();
            ExecutionStep executionStep = new ExecutionStep(actionType);
            executionStep.getCommand().add(new ExecutionStep.Command(cmd));
            String ohOwner = null;
            ohOwner = !DBPatchingHelper.isStaticConfiguration(this.getPatchSession().getOptions()) ? OUIDriver.checkFileOwner((File)new File(patchTarget.getHome(true).getLocation(), "oraInst.loc")) : System.getProperty("user.name");
            User user = new User();
            user.setValue(ohOwner);
            executionStep.setUser(user);
            Host host = new Host();
            host.setDisplayName(patchTarget.getHost().getHost());
            host.setName(patchTarget.getHost().getHost());
            executionStep.setHost(host);
            executionList.add(executionStep);
        } else {
            this.logger.fine("Skipping action to update datapatch libraries");
        }
        return executionList;
    }

    private String generateCommand(PatchTarget patchTarget) {
        StringBuilder copySqlpatchCmd = new StringBuilder();
        String sourceHome = patchTarget.getHome(true).getLocation();
        String destHome = patchTarget.getHomeClone().getLocation();
        copySqlpatchCmd.append(sourceHome + "/perl/bin/perl " + sourceHome + "/sqlpatch/copy_sqlpatch_files.pl -src_home " + sourceHome + " -dest_home " + destHome);
        File copySqlpatchScript = new File(sourceHome + "/sqlpatch/copy_sqlpatch_files.pl");
        if (copySqlpatchScript.exists()) {
            return copySqlpatchCmd.toString();
        }
        this.logger.info("Script for copying sqlpatch is not available.");
        return null;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    public boolean isAnalyzeSupported() {
        boolean isAnalyzeSupported = false;
        return isAnalyzeSupported;
    }

    public boolean isLocalParallelExecutionSupported() {
        return true;
    }

    public int getOrderingWeight(Goal goal) {
        return 90;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("CopyDatapatchLibsAction.start.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("CopyDatapatchLibsAction.success.message", patchTarget.toReportingString());
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("CopyDatapatchLibsAction.warning.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("CopyDatapatchLibsAction.failure.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }

    @Override
    public void prepareRemoteActionExecutionHost(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws RemoteConnectionException, PatchActionException {
        super.prepareRemoteActionExecutionHost(handler, container);
    }

    @Override
    public void setupRemoteActionExecutionEnvironment(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws PatchActionException {
        super.setupRemoteActionExecutionEnvironment(patchSession, container);
    }

    @Override
    public PatchAction clone() throws CloneNotSupportedException {
        PatchAction patchAction = super.clone();
        return patchAction;
    }
}

