/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.oop;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHelper;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.lifecycle.FinalizePhase;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class CopyOOPSessionFilePatchAction
extends DBCommonPatchAction {
    Logger logger = Logger.getLogger(CopyOOPSessionFilePatchAction.class.getName());

    public CopyOOPSessionFilePatchAction() {
        super(new Goal[]{FinalizePhase.Goal.finalize});
    }

    public int getOrderingWeight(Goal goal) {
        return 215;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        return targetList;
    }

    @Override
    protected void displayNoStepMessage(PatchTarget target) {
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        OPatchAutoOptions options = this.getPatchSession().getOptions();
        String homeLocation = patchTarget.getHome(true).getLocation();
        boolean isGenerateStepCmd = DBPatchingHelper.isGenerateStepCommand(this.getPatchSession().getOptions());
        try {
            isActionRequired = DBPatchingHelper.isOOPPatchingSession(options) && !isGenerateStepCmd && DBPatchingHelper.compareFilePath(homeLocation, OPatchAutoHelper.getOPatchAutoHome()) && !patchTarget.isRemote();
        }
        catch (OPatchAutoException e) {
            throw new PatchActionException((Throwable)e);
        }
        return isActionRequired;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        boolean active_remotes;
        ArrayList<ExecutionStep> executionSteps = new ArrayList<ExecutionStep>();
        SessionData sessionData = SessionData.getInstance();
        String baseHome = OPatchAutoHelper.getOPatchAutoHome();
        String localhost = DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost());
        String sessionInfoFile = DBCommonPatchingConstants.OOP_SESSION_INFO_FILE;
        sessionInfoFile = sessionInfoFile.replace("$HOST_NAME", DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost()));
        String oopSessionFilePath = baseHome + sessionInfoFile;
        OOPSessionInfoHandler oopSessionInfoHandler = OOPSessionInfoHandler.getInstance();
        boolean multi_node = sessionData.isMultiNodeEnv();
        if (!multi_node) {
            oopSessionInfoHandler.setSessionCompleted();
            oopSessionInfoHandler.saveOOPSessionCookie(oopSessionFilePath);
            oopSessionInfoHandler.distributeSessionFileLocal();
            DBPatchingHelper.deleteLocalActiveLock(baseHome, localhost, true);
            return executionSteps;
        }
        HashMap<String, String> parallel_sessions = sessionData.getActiveSessions();
        boolean bl = active_remotes = parallel_sessions.size() > 1;
        if (!sessionData.isPatchingCompletedOnAllNodes()) {
            DBPatchingHelper.deleteLocalActiveLock(baseHome, localhost, true);
            OOPSessionInfoHelper.deleteLocalCopyOfRemoteCookies();
            return executionSteps;
        }
        oopSessionInfoHandler.setSessionCompleted();
        if (!active_remotes) {
            DBPatchingHelper.deleteLocalActiveLock(baseHome, localhost, true);
            OOPSessionInfoHelper.deleteLocalCopyOfRemoteCookies();
            oopSessionInfoHandler.saveOOPSessionCookie(oopSessionFilePath);
            oopSessionInfoHandler.distributeSessionFileLocal();
            oopSessionInfoHandler.distributeSessionFileRemote();
            return executionSteps;
        }
        String station_host = sessionData.getStationHost();
        if (!sessionData.isSelectedFinalHost()) {
            OOPSessionInfoHelper.deleteLocalCopyOfRemoteCookies();
            return executionSteps;
        }
        DBPatchingHelper.deleteLocalActiveLock(baseHome, localhost, true);
        OOPSessionInfoHelper.deleteLocalCopyOfRemoteCookies();
        oopSessionInfoHandler.saveOOPSessionCookie(oopSessionFilePath);
        oopSessionInfoHandler.distributeSessionFileLocal();
        oopSessionInfoHandler.distributeSessionFileRemote();
        OOPSessionInfoHelper.deleteTransferLock(localhost, station_host, parallel_sessions.get(station_host));
        DBPatchingHelper.deleteRemoteActiveLocks(parallel_sessions, localhost, true);
        return executionSteps;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        return "";
    }

    @Override
    public void postExecute(PatchTarget patchTarget, PatchActionResult patchActionResult) throws OPatchAutoException {
        super.postExecute(patchTarget, patchActionResult);
        if (patchActionResult.isFailure()) {
            return;
        }
        if (this.getPatchSession().getPatchTracking() != null) {
            Set patchTargetList = this.getPatchSession().getPatchPlanManager().getPatchTargets();
            DBPatchingSummaryCreator summaryCreator = this.getProductSupport().getDBPatchingSummaryCreator(this.getPatchSession().getCommand());
            for (PatchTarget target : patchTargetList) {
                if (!this.getSupportedProductTypes().contains(target.getProductType().getType())) continue;
                summaryCreator.storePatchingSummary(0, SummaryID.oop_summary, target, "clone information");
            }
        }
    }
}

