/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.oop;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandActionType;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.SIDBProductType;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.CommandDetailsGenerator;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHelper;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OnlinePhase;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.session.MutablePatchTarget;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.session.PatchTargetImpl;
import com.oracle.glcm.patch.auto.topology.HomeImpl;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.PatchingPhase;
import oracle.opatch.system.db.automation.jaxb.PhaseType;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class DatabaseStartupFinalizeAction
extends DBCommonPatchAction {
    private static final String RAC_DATABASE_TYPE = "%RACDatabase.databaseName%";
    private static final String SI_DATABASE_TYPE = "%SIDatabase.databaseName%";
    private static String CONFIG_DATABASE = "%OracleHome.path%/bin/srvctl config database";
    private static String MODIFY_DATABASE = "%OracleHome.path%/bin/srvctl modify database";
    private static String RELOCATE_RAC_ONE_DATABASE_INSTANCE = "%OracleHome.path%/bin/srvctl relocate database";
    private static final Logger logger = Logger.getLogger(DatabaseStartupFinalizeAction.class.getName());
    List<RACDatabase> racDBsReady;

    public DatabaseStartupFinalizeAction() {
        super(new Goal[]{OnlinePhase.Goal.product_patching});
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        if (((HomeImpl)patchTarget.getHome()).isGIMRHome()) {
            return false;
        }
        isActionRequired = DBPatchingHelper.isSingleOOPPatchingSession(this.getPatchSession().getOptions()) || DBPatchingHelper.isOOPSwitchPatchingSession(this.getPatchSession().getOptions());
        try {
            if (isActionRequired) {
                isActionRequired = !this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB.getValue()).isSwitchEnabled();
            }
            String targetHome = DBPatchingHelper.getTargetHomeFromProductType(patchTarget);
            if (isActionRequired && targetHome.equals("rac")) {
                boolean hasSingleInstanceDBs = !this.getSingleInstanceDB(patchTarget).isEmpty();
                boolean lastNodeDBTarget = OOPSessionInfoHelper.canExecuteDBSteps(patchTarget, this.getPatchSession().getOptions().getOption(DBProductParameterConstants.REMOTE_KEY.getValue()).isSwitchEnabled());
                isActionRequired = lastNodeDBTarget || hasSingleInstanceDBs;
            }
        }
        catch (OPatchAutoException e) {
            throw new PatchActionException((Throwable)e);
        }
        return isActionRequired;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    public int getOrderingWeight(Goal goal) {
        return 20;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        return targetList;
    }

    @Override
    public List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ArrayList<ExecutionStep> generatedSteps = new ArrayList<ExecutionStep>();
        String targetHome = DBPatchingHelper.getTargetHomeFromProductType(patchTarget);
        logger.info("targetHome: " + targetHome);
        if (targetHome.equals("sidb")) {
            this.handleSIDatabase(patchTarget, generatedSteps);
        } else if (targetHome.equals("rac")) {
            boolean hasSingleInstanceDBs;
            boolean bl = hasSingleInstanceDBs = !this.getSingleInstanceDB(patchTarget).isEmpty();
            if (hasSingleInstanceDBs) {
                logger.info("Found single instance DB for home: " + targetHome);
                PatchTargetImpl tempTarget = new PatchTargetImpl((ProductType)new SIDBProductType(), patchTarget.getHome(true));
                ((MutablePatchTarget)tempTarget).setHomeClone(patchTarget.getHomeClone());
                ((MutablePatchTarget)tempTarget).setUsingHomeClone(patchTarget.isUsingHomeClone());
                this.handleSIDatabase((PatchTarget)tempTarget, generatedSteps);
            }
            if (OOPSessionInfoHelper.canExecuteDBSteps(patchTarget, this.getPatchSession().getOptions().getOption(DBProductParameterConstants.REMOTE_KEY.getValue()).isSwitchEnabled())) {
                this.handleRACDatabase(patchTarget, generatedSteps);
            }
        }
        return generatedSteps;
    }

    private List<SIDatabase> getSingleInstanceDB(PatchTarget patchTarget) {
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<SIDatabase> siDBs = configGraph.getTargets(SIDatabase.class);
        ArrayList<SIDatabase> singleInstances = new ArrayList<SIDatabase>();
        for (SIDatabase sidb : siDBs) {
            if (!sidb.getOracleHome().equalsIgnoreCase(patchTarget.getHome(true).getLocation())) continue;
            singleInstances.add(sidb);
        }
        return singleInstances;
    }

    private void handleSIDatabase(PatchTarget patchTarget, List<ExecutionStep> generatedSteps) throws OPatchAutoException {
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<SIDatabase> sidbs = configGraph.getTargets(SIDatabase.class);
        String spfileLoc = null;
        logger.info("list of databases is " + sidbs);
        for (SIDatabase sidb : sidbs) {
            if (!sidb.getOracleHome().equalsIgnoreCase(patchTarget.getHome(true).getLocation())) continue;
            logger.info("current database is " + sidb);
            if (DBPatchingHelper.compareFilePath(sidb.getOracleHome(), patchTarget.getHome(true).getLocation())) {
                logger.info("Original spfile location is " + sidb.getSpFileLoc());
                if (sidb.getSpFileLoc() != null && sidb.getSpFileLoc().contains(sidb.getOracleHome())) {
                    spfileLoc = this.getNewSPFileLoc(sidb.getSpFileLoc(), sidb.getOracleHome());
                    logger.info("Location of the new spfile " + spfileLoc);
                }
            }
            generatedSteps.addAll(this.getConfigureDatabaseSteps(patchTarget, sidb.getDatabaseName()));
            generatedSteps.addAll(this.getModifyDatabaseSteps(patchTarget, sidb.getDatabaseName(), spfileLoc));
            generatedSteps.addAll(this.getConfigureDatabaseSteps(patchTarget, sidb.getDatabaseName()));
            if (!DBPatchingHelper.compareFilePath(sidb.getOracleHome(), patchTarget.getHome(true).getLocation())) continue;
            if (sidb.getAvailability().equals("yes")) {
                generatedSteps.addAll(this.getStopStartDatabase(patchTarget, SI_DATABASE_TYPE, sidb.getDatabaseName(), false, true));
                generatedSteps.addAll(this.getStopStartDatabase(patchTarget, SI_DATABASE_TYPE, sidb.getDatabaseName(), true, false));
                continue;
            }
            String summary = "[Warning] Following database is not running " + sidb.getInstanceName() + ". Please start the database manually from the new home " + patchTarget.getHome().getLocation() + ".\nExecute the following command: " + patchTarget.getHome().getLocation() + "/bin/srvctl start database -db " + sidb.getInstanceName();
            DBPatchingSummaryCreator summaryCreator = this.getProductSupport().getDBPatchingSummaryCreator(this.getPatchSession().getCommand());
            if (!this.getSupportedProductTypes().contains(patchTarget.getProductType().getType())) continue;
            summaryCreator.storePatchingSummary(0, SummaryID.patching_warning, patchTarget, summary);
        }
    }

    private String getNewSpfileForSIDB(PatchTarget patchTarget) {
        String filePath = null;
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<SIDatabase> sidbs = configGraph.getTargets(SIDatabase.class);
        for (SIDatabase sidb : sidbs) {
            if (!DBPatchingHelper.compareFilePath(sidb.getOracleHome(), patchTarget.getHome(true).getLocation()) || sidb.getSpFileLoc() == null || !sidb.getSpFileLoc().contains(sidb.getOracleHome())) continue;
            filePath = this.getNewSPFileLoc(sidb.getSpFileLoc(), sidb.getOracleHome());
        }
        return filePath;
    }

    public String getNewSPFileLoc(String spfileloc, String originalHome) {
        String clonePath = OOPSessionInfoHandler.getInstance().getCloneHomePath(originalHome);
        return spfileloc.replace(originalHome, clonePath);
    }

    private void handleRACDatabase(PatchTarget patchTarget, List<ExecutionStep> generatedSteps) throws OPatchAutoException {
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<RACDatabase> racDBs = configGraph.getTargets(RACDatabase.class);
        for (RACDatabase racDB : racDBs) {
            boolean isNonRollingMode;
            logger.info("racDB.getOracleHome(): " + racDB.getOracleHome());
            logger.info("racDB.getDatabaseName(): " + racDB.getDatabaseName());
            if (!DBPatchingHelper.compareFilePath(racDB.getOracleHome(), patchTarget.getHome(true).getLocation())) continue;
            generatedSteps.addAll(this.getConfigureDatabaseSteps(patchTarget, racDB.getDatabaseName()));
            String spfile = null;
            if (racDB.getSpFileLoc() != null && racDB.getSpFileLoc().contains(racDB.getOracleHome())) {
                spfile = this.getNewSPFileLoc(racDB.getSpFileLoc(), racDB.getOracleHome());
            }
            if (isNonRollingMode = DBPatchingHelper.isNonRollingMode(this.getPatchSession().getOptions())) {
                generatedSteps.addAll(this.getStopStartDatabase(patchTarget, RAC_DATABASE_TYPE, racDB.getDatabaseName(), false, true));
                generatedSteps.addAll(this.getModifyDatabaseSteps(patchTarget, racDB.getDatabaseName(), spfile));
                generatedSteps.addAll(this.getStopStartDatabase(patchTarget, RAC_DATABASE_TYPE, racDB.getDatabaseName(), true, false));
                generatedSteps.addAll(this.getConfigureDatabaseSteps(patchTarget, racDB.getDatabaseName()));
                continue;
            }
            boolean isRacOneDB = DBPatchingHelper.isRacOneDatabase(racDB, patchTarget);
            if (isRacOneDB) {
                generatedSteps.addAll(this.getModifyDatabaseSteps(patchTarget, racDB.getDatabaseName(), spfile));
                generatedSteps.addAll(this.getRACOneDBSteps(patchTarget, false, false));
                generatedSteps.addAll(this.getRACOneDBSteps(patchTarget, true, true));
                generatedSteps.addAll(this.getConfigureDatabaseSteps(patchTarget, racDB.getDatabaseName()));
                continue;
            }
            String instanceList = "";
            String inactiveInstanceList = "";
            StringBuffer activeInstance = new StringBuffer();
            StringBuffer inactiveInstance = new StringBuffer();
            List instances = racDB.getDbInstances();
            for (String[] inst : instances) {
                if (inst.getIsRunning().equals("yes")) {
                    activeInstance.append(inst.getInstanceName());
                    activeInstance.append(",");
                    continue;
                }
                inactiveInstance.append(inst.getInstanceName());
                inactiveInstance.append(",");
            }
            if (!activeInstance.toString().isEmpty()) {
                instanceList = activeInstance.toString();
                instanceList = instanceList.substring(0, instanceList.lastIndexOf(","));
            }
            if (!inactiveInstance.toString().isEmpty()) {
                inactiveInstanceList = inactiveInstance.toString();
                inactiveInstanceList = inactiveInstanceList.substring(0, inactiveInstanceList.lastIndexOf(","));
            }
            logger.info("instanceList: " + instanceList);
            if (!instanceList.isEmpty()) {
                String[] instanceArr;
                generatedSteps.addAll(this.getModifyDatabaseSteps(patchTarget, racDB.getDatabaseName(), spfile));
                for (String instance : instanceArr = instanceList.split(",")) {
                    generatedSteps.addAll(this.getStopStartDBInstanceStepsForRACDatabase(patchTarget, false, true, racDB.getDatabaseName(), instance));
                    generatedSteps.addAll(this.getStopStartDBInstanceStepsForRACDatabase(patchTarget, true, false, racDB.getDatabaseName(), instance));
                }
                generatedSteps.addAll(this.getConfigureDatabaseSteps(patchTarget, racDB.getDatabaseName()));
            } else {
                generatedSteps.addAll(this.getModifyDatabaseSteps(patchTarget, racDB.getDatabaseName(), spfile));
                generatedSteps.addAll(this.getConfigureDatabaseSteps(patchTarget, racDB.getDatabaseName()));
            }
            if (inactiveInstanceList.isEmpty()) continue;
            String summary = "[Warning] Following instance(s) are not running on database " + racDB.getDatabaseName() + ": " + inactiveInstance + ". Please start the instance(s) manually from the new home " + patchTarget.getHome().getLocation() + ".\nExecute the following command: " + patchTarget.getHome().getLocation() + "/bin/srvctl start instance -db " + racDB.getDatabaseName() + " -instance " + inactiveInstance;
            DBPatchingSummaryCreator summaryCreator = this.getProductSupport().getDBPatchingSummaryCreator(this.getPatchSession().getCommand());
            if (!this.getSupportedProductTypes().contains(patchTarget.getProductType().getType())) continue;
            summaryCreator.storePatchingSummary(0, SummaryID.patching_warning, patchTarget, summary);
        }
    }

    private Collection<? extends ExecutionStep> getStopStartDatabase(PatchTarget patchTarget, String dbType, String dbName, boolean actsOnClone, boolean isStop) throws OPatchAutoException {
        String command = null;
        String readMeTitle = null;
        ArrayList<String> params = new ArrayList<String>();
        params.add("-db");
        params.add(dbName);
        if (isStop && !StringUtil.isNullOrEmpty((String)SessionData.getInstance().getDrainTimeout())) {
            params.add(SessionData.getInstance().getDrainTimeout());
        }
        readMeTitle = dbType.equalsIgnoreCase(SI_DATABASE_TYPE) ? (isStop ? "Stop-SIDB-Title" : "Start-SIDB-Title") : (isStop ? "Stop-Database-Title" : "Start-Database-Title");
        command = (isStop ? DBCommandActionType.StopDB : DBCommandActionType.StartDB).toString();
        List<ExecutionStep> stopStartDBInstanceSteps = this.getStopStartDBInstanceSteps(patchTarget, actsOnClone, params, command, readMeTitle);
        return stopStartDBInstanceSteps;
    }

    private Collection<? extends ExecutionStep> getStopStartDBInstanceStepsForRACDatabase(PatchTarget patchTarget, boolean actsOnClone, boolean isStop, String dbName, String instanceName) throws OPatchAutoException {
        String command = null;
        String readMeTitle = null;
        ArrayList<String> params = new ArrayList<String>();
        params.add("-db");
        params.add(dbName);
        params.add("-instance");
        params.add(instanceName);
        if (isStop && !StringUtil.isNullOrEmpty((String)SessionData.getInstance().getDrainTimeout())) {
            params.add(SessionData.getInstance().getDrainTimeout());
        }
        readMeTitle = isStop ? "Stop-Database-Instance-Title" : "Start-Database-Instance-Title";
        command = (isStop ? DBCommandActionType.StopDBInst : DBCommandActionType.StartDBInst).toString();
        List<ExecutionStep> stopStartDBInstanceSteps = this.getStopStartDBInstanceSteps(patchTarget, actsOnClone, params, command, readMeTitle);
        return stopStartDBInstanceSteps;
    }

    private List<ExecutionStep> getStopStartDBInstanceSteps(PatchTarget patchTarget, boolean actsOnClone, List<String> params, String command, String readMeTitle) throws OPatchAutoException {
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, command);
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON_CLONE, actsOnClone);
        String targetHome = DBPatchingHelper.getTargetHomeFromProductType(patchTarget);
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, readMeTitle);
        this.setCommonActionParams(argList, patchTarget, targetHome.equals("rac"));
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON, "OracleHome");
        HashMap commandDetails = new HashMap();
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.addAll(params);
        commandDetails.put(command, paramList);
        argList.put(CommandDetailsGenerator.ActionTypeParams.COMMAND_DETAILS, commandDetails);
        List<ExecutionStep> steps = this.getSteps(patchTarget, configGraph, argList);
        return steps;
    }

    private Collection<? extends ExecutionStep> getRACOneDBSteps(PatchTarget patchTarget, boolean actsOnClone, boolean isRelocateBack) throws OPatchAutoException {
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, DBCommandActionType.racOneDBshell.toString());
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON, "RACDBInstance");
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON_CLONE, actsOnClone);
        argList.put(CommandDetailsGenerator.ActionTypeParams.SERVICE_STATUS, isRelocateBack ? ServiceStatus.UP : ServiceStatus.DOWN);
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Relocate-Database-Title");
        HashMap commandDetails = new HashMap();
        String command = RELOCATE_RAC_ONE_DATABASE_INSTANCE;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("-db");
        paramList.add(RAC_DATABASE_TYPE);
        paramList.add("-n");
        paramList.add(isRelocateBack ? "oldHostname" : "newHostname");
        if (!StringUtil.isNullOrEmpty((String)SessionData.getInstance().getDrainTimeout())) {
            paramList.add(SessionData.getInstance().getDrainTimeout());
        }
        paramList.add("-w");
        paramList.add("30");
        paramList.add("-v");
        commandDetails.put(command, paramList);
        HashMap commandEnvDetails = new HashMap();
        HashMap<String, String> envVariables = new HashMap<String, String>();
        envVariables.put("ORACLE_HOME", "%OracleHome.path%");
        commandEnvDetails.put(command, envVariables);
        argList.put(CommandDetailsGenerator.ActionTypeParams.COMMAND_DETAILS, commandDetails);
        argList.put(CommandDetailsGenerator.ActionTypeParams.COMMAND_ENV_DETAILS, commandEnvDetails);
        List<ExecutionStep> steps = this.getSteps(patchTarget, configGraph, argList);
        return steps;
    }

    private List<ExecutionStep> getConfigureDatabaseSteps(PatchTarget patchTarget, String dbName) throws OPatchAutoException {
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, CommandActionType.shell.toString());
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Confirm-Config-Title");
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_MSG_KEY, "Confirm-Config-Message");
        this.setCommonActionParams(argList, patchTarget, false);
        argList.put(CommandDetailsGenerator.ActionTypeParams.COMMAND_DETAILS, this.getConfigDatabaseCommand(dbName));
        List<ExecutionStep> steps = this.getSteps(patchTarget, configGraph, argList);
        return steps;
    }

    private Map<String, List<String>> getConfigDatabaseCommand(String dbName) {
        ArrayList<String> params = new ArrayList<String>();
        params.add("-d");
        params.add(dbName);
        params.add("-a");
        HashMap<String, List<String>> commandDetails = new HashMap<String, List<String>>();
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.addAll(params);
        commandDetails.put(CONFIG_DATABASE, paramList);
        return commandDetails;
    }

    private List<ExecutionStep> getModifyDatabaseSteps(PatchTarget patchTarget, String dbName, String spfileLoc) throws OPatchAutoException {
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, CommandActionType.shell.toString());
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON_CLONE, true);
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Confirm-Config-Title");
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_MSG_KEY, "Confirm-Config-Message");
        this.setCommonActionParams(argList, patchTarget, false);
        argList.put(CommandDetailsGenerator.ActionTypeParams.COMMAND_DETAILS, this.getModifyDatabaseCommand(dbName, spfileLoc));
        List<ExecutionStep> steps = this.getSteps(patchTarget, configGraph, argList);
        String newGridHome = System.getProperty("NEW_GRID_HOME");
        if (this.getPatchSession().isRollback()) {
            for (ExecutionStep step : steps) {
                for (ExecutionStep.Command command : step.getCommand()) {
                    if (command.getValue().indexOf("srvctl modify") == -1) continue;
                    String modifyCommand = command.getValue();
                    if (!StringUtil.isNullOrEmpty((String)newGridHome)) {
                        String ldLibPath = DBPatchingUtil.getLibPathEnv(newGridHome);
                        modifyCommand = ldLibPath + " " + modifyCommand;
                    }
                    logger.info("Setting ORACLE_HOME to " + patchTarget.getHome().getLocation() + " for modifying the database");
                    String setORACLEHOME = "ORACLE_HOME=" + patchTarget.getHome().getLocation();
                    modifyCommand = setORACLEHOME + " " + modifyCommand;
                    modifyCommand = "bash -c \"" + modifyCommand + "\"";
                    command.setValue(modifyCommand);
                }
            }
        }
        return steps;
    }

    private Map<String, List<String>> getModifyDatabaseCommand(String dbName, String spfileLoc) {
        ArrayList<String> params = new ArrayList<String>();
        params.add("-d");
        params.add(dbName);
        params.add("-o");
        params.add("%OracleHome.path%");
        if (spfileLoc != null) {
            params.add("-spfile");
            params.add(spfileLoc);
        }
        HashMap<String, List<String>> commandDetails = new HashMap<String, List<String>>();
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.addAll(params);
        commandDetails.put(MODIFY_DATABASE, paramList);
        return commandDetails;
    }

    private void setCommonActionParams(HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList, PatchTarget patchTarget, boolean actsOnInstance) {
        String targetHome = DBPatchingHelper.getTargetHomeFromProductType(patchTarget);
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_TARGETHOME, targetHome);
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_HOMETYPE, targetHome);
        String actsOn = "SIDatabase";
        if (targetHome.equals("rac")) {
            actsOn = "OracleHome";
        }
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON, actsOn);
    }

    private List<ExecutionStep> getSteps(PatchTarget patchTarget, ConfigGraph configGraph, HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList) throws OPatchAutoException {
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        PatchingPhase phase = this.getpatchingPhase();
        Command clonePLCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(configGraph, patchTarget, actionType, clonePLCommand);
        return steps;
    }

    private PatchingPhase getpatchingPhase() {
        PatchingPhase phase = CommandDetailsGenerator.generatePatchingPhase(PhaseType.MIGRATE, ServiceStatus.UP);
        return phase;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("DatabaseStartupFinalizeAction.start.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("DatabaseStartupFinalizeAction.success.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("DatabaseStartupFinalizeAction.failure.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }

    public boolean isRollbackSupported() {
        return true;
    }
}

