/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.oop;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandActionType;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.CommandDetailsGenerator;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandParameters;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.PatchingPhase;
import oracle.opatch.system.db.automation.jaxb.PhaseType;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class PostCloneOracleHomeAction
extends DBCommonPatchAction {
    private static final String ROOT_SH = "%OracleHome.path%/root.sh";
    private ConfigGraph configGraph = null;

    public PostCloneOracleHomeAction() {
        super(new Goal[]{OfflinePhase.Goal.prepare});
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        return DBPatchingHelper.isOOPPreparePatchingSession(this.getPatchSession().getOptions()) || DBPatchingHelper.isSingleOOPPatchingSession(this.getPatchSession().getOptions());
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        return targetList;
    }

    public int getOrderingWeight(Goal goal) {
        return 50;
    }

    public boolean isLocalParallelExecutionSupported() {
        return false;
    }

    public boolean isRemoteParallelExecutionSupported() {
        return true;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        this.configGraph = PatchPlanner.getInstance().getConfigGraph();
        ArrayList<ExecutionStep> generatedSteps = new ArrayList<ExecutionStep>();
        List<ExecutionStep> steps = null;
        String targetHome = DBPatchingHelper.getTargetHomeFromProductType(patchTarget);
        if (this.getPatchSession().getProductSupportManager().getOptions().getOption("relink.extreme.performance").isSwitchEnabled()) {
            SessionData.getInstance().setExtremePerf(true);
        }
        if (targetHome.equals("rac")) {
            steps = this.getRelinkBinaryExecutionStep(patchTarget, targetHome, DBCommandActionType.RelinkBinaryRacOn.toString(), "Relink-Binary-Rac-On-Title", "Relink-Binary-Rac-On-Message");
            generatedSteps.addAll(steps);
        }
        steps = this.getRelinkBinaryExecutionStep(patchTarget, targetHome, DBCommandActionType.RelinkBinary.toString(), "Relink-Binary-Title", "Relink-Binary-Message");
        generatedSteps.addAll(steps);
        steps = this.getRootSHExecutionStep(patchTarget, targetHome);
        generatedSteps.addAll(steps);
        return generatedSteps;
    }

    private List<ExecutionStep> getRelinkBinaryExecutionStep(PatchTarget patchTarget, String targetHome, String commandActionType, String readMeTitle, String readMeMsg) throws OPatchAutoException {
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, commandActionType);
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_TARGETHOME, targetHome);
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, readMeTitle);
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_MSG_KEY, readMeMsg);
        String stripeName = DBPatchingHelper.getStripeName(patchTarget);
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_NAME, stripeName);
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        PatchingPhase phase = this.getpatchingPhase();
        Command relinkBinary = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(this.configGraph, patchTarget, actionType, relinkBinary);
        return steps;
    }

    private List<ExecutionStep> getRootSHExecutionStep(PatchTarget patchTarget, String targetHome) throws OPatchAutoException {
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, CommandActionType.shell.toString());
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON_CLONE, Boolean.TRUE);
        argList.put(CommandDetailsGenerator.ActionTypeParams.RUN_AS, DBCommandParameters.GLOBAL_ROOT_USER.getValue());
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Run-Rootscript-Title");
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_TARGETHOME, targetHome);
        String stripeName = DBPatchingHelper.getStripeName(patchTarget);
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_NAME, stripeName);
        ArrayList params = new ArrayList();
        String rootSHScript = ROOT_SH;
        HashMap commandDetails = new HashMap();
        ArrayList paramList = new ArrayList();
        paramList.addAll(params);
        commandDetails.put(rootSHScript, paramList);
        argList.put(CommandDetailsGenerator.ActionTypeParams.COMMAND_DETAILS, commandDetails);
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        PatchingPhase phase = this.getpatchingPhase();
        Command rootSHCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(this.configGraph, patchTarget, actionType, rootSHCommand);
        return steps;
    }

    private PatchingPhase getpatchingPhase() {
        PatchingPhase phase = CommandDetailsGenerator.generatePatchingPhase(PhaseType.APPLY, ServiceStatus.UP);
        return phase;
    }

    @Override
    public void postExecute(PatchTarget patchTarget, PatchActionResult patchActionResult) throws OPatchAutoException {
        super.postExecute(patchTarget, patchActionResult);
        if (patchActionResult.isFailure()) {
            return;
        }
        if (this.getPatchSession().getPatchTracking() != null && patchTarget.getHomeClone() != null) {
            patchTarget.setUsingHomeClone(true);
        }
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("PostCloneOracleHomeAction.start.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("PostCloneOracleHomeAction.success.message", patchTarget.toOrigReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("PostCloneOracleHomeAction.failure.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }
}

