/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.oop;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.User;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.lifecycle.FinalizePhase;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.common.Host;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatchauto.core.binary.OPatchPatchInfo;
import oracle.opatchauto.core.binary.SessionPatches;

public class TwoStagePostApplyOOPAction
extends DBCommonPatchAction {
    Logger logger = Logger.getLogger(TwoStagePostApplyOOPAction.class.getName());

    public TwoStagePostApplyOOPAction() {
        super(new Goal[]{FinalizePhase.Goal.finalize});
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        return targetList;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        String minVersion = "23.0.0.0.0";
        String primaryVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        OPatchAutoOptions options = this.getPatchSession().getOptions();
        try {
            if (!DBPatchingHelper.isOOPPatchingSession(options)) {
                isActionRequired = false;
            } else if (DBPatchingHelper.isOOPPreparePatchingSession(options)) {
                isActionRequired = false;
            } else if (this.getPatchSession().isAnalyze() || this.getPatchSession().isRollback()) {
                isActionRequired = false;
            } else if (!DBPatchingUtil.isVersionEqalOrlater(primaryVersion, minVersion)) {
                isActionRequired = false;
            } else if (!this.getPatchSession().getProductSupportManager().getOptions().getOption("post.twostage.enable").isSwitchEnabled()) {
                this.logger.info("Skipping action since post-patch enable option was not selected.");
                isActionRequired = false;
            } else if (this.getPatchSession().getProductSupportManager().getOptions().getOption("skip.rrpatch").isSwitchEnabled()) {
                this.logger.info("Skipping action since skip-rrp option was selected.");
                isActionRequired = false;
            } else if (!OOPSessionInfoHandler.getInstance().isSessionCompletedOnAllNode()) {
                this.logger.info("Skipping action since this is not the last node for this home");
                isActionRequired = false;
            } else {
                isActionRequired = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isActionRequired;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ArrayList<ExecutionStep> executionList = new ArrayList<ExecutionStep>();
        this.logger.info("Identifying details based on " + patchTarget.getHome(true).getLocation());
        String version_num = DBPatchingHelper.getRUVersionForApply(patchTarget.getHome(true).getLocation());
        boolean two_stage_rolling = this.isTwoStagePatchForApply(patchTarget.getHome(true).getLocation());
        StringBuilder twoStageEnableCmd = new StringBuilder();
        twoStageEnableCmd.append(patchTarget.getHome().getLocation()).append("/perl/bin/perl ");
        twoStageEnableCmd.append(patchTarget.getHome().getLocation());
        twoStageEnableCmd.append(File.separator).append("bin").append(File.separator);
        twoStageEnableCmd.append("rrpatch.pl enable_all -oh ");
        twoStageEnableCmd.append(patchTarget.getHome().getLocation());
        twoStageEnableCmd.append(" -two_stage_rolling ");
        if (two_stage_rolling) {
            twoStageEnableCmd.append("TRUE ");
        } else {
            twoStageEnableCmd.append("FALSE ");
        }
        if (!StringUtil.isNullOrEmpty((String)version_num, (boolean)true)) {
            twoStageEnableCmd.append("-db_version ").append(version_num);
        }
        twoStageEnableCmd.append(" -currentVersion ");
        String cmd = twoStageEnableCmd.toString();
        this.logger.info("Command generated ::" + cmd);
        ActionType actionType = new ActionType();
        ExecutionStep executionStep = new ExecutionStep(actionType);
        executionStep.getCommand().add(new ExecutionStep.Command(cmd));
        String ohOwner = null;
        ohOwner = !DBPatchingHelper.isStaticConfiguration(this.getPatchSession().getOptions()) ? OUIDriver.checkFileOwner((File)new File(patchTarget.getHome(true).getLocation(), "oraInst.loc")) : System.getProperty("user.name");
        User user = new User();
        user.setValue(ohOwner);
        executionStep.setUser(user);
        Host host = new Host();
        host.setDisplayName(patchTarget.getHost().getHost());
        host.setName(patchTarget.getHost().getHost());
        executionStep.setHost(host);
        executionList.add(executionStep);
        return executionList;
    }

    private boolean isTwoStagePatchForApply(String home) {
        for (OPatchPatchInfo patchInfo : SessionData.getInstance().getAnalyzedPatchList(home)) {
            String patchLocation = patchInfo.getPatchLocation();
            if (!SessionPatches.isTwoStageRPForApply((String)patchLocation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void prepareRemoteActionExecutionHost(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws RemoteConnectionException, PatchActionException {
        super.prepareRemoteActionExecutionHost(handler, container);
    }

    @Override
    public PatchActionResult execute(PatchTarget patchTarget) {
        PatchActionResult result = new PatchActionResult();
        try {
            result = super.execute(patchTarget);
            if (result.isFailure()) {
                this.logger.info("Ignoring the failure in executing the action to enable two-stage patches.");
                result = new PatchActionResult(PatchActionStatus.success);
            }
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
            this.logger.info("Ignoring the failure in executing the action to enable two-stage patches.");
            result = new PatchActionResult(PatchActionStatus.success);
        }
        return result;
    }

    public boolean isRollbackSupported() {
        return false;
    }

    public boolean isLocalParallelExecutionSupported() {
        return true;
    }

    public boolean isAnalyzeSupported() {
        boolean isAnalyzeSupported = false;
        return isAnalyzeSupported;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("RRPEnablePatchAction.start.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("RRPEnablePatchAction.success.message", patchTarget.toReportingString());
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("RRPEnablePatchAction.warning.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("RRPEnablePatchAction.failure.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }

    public int getOrderingWeight(Goal goal) {
        return 230;
    }

    @Override
    public void setupRemoteActionExecutionEnvironment(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws PatchActionException {
        super.setupRemoteActionExecutionEnvironment(patchSession, container);
    }

    @Override
    public PatchAction clone() throws CloneNotSupportedException {
        PatchAction patchAction = super.clone();
        return patchAction;
    }
}

