/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.oop.sidb;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.User;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.CommandFailureException;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.CommandDetailsGenerator;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.executor.ExecutionResult;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OnlinePhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.common.Host;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.PatchingPhase;
import oracle.opatch.system.db.automation.jaxb.PhaseType;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class SIDBSwitchAction
extends DBCommonPatchAction {
    public SIDBSwitchAction() {
        super(new Goal[]{OnlinePhase.Goal.product_patching});
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    private boolean isDBUp(PatchTarget patchTarget) {
        return true;
    }

    public int getOrderingWeight(Goal goal) {
        return 20;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        ArrayList<ExecutionStep> generatedSteps = new ArrayList<ExecutionStep>();
        List<ExecutionStep> steps = null;
        String targetHome = DBPatchingHelper.getTargetHomeFromProductType(patchTarget);
        if (DBPatchingUtil.isVersionEqalOrlater(patchTarget.getHome().getVersion(), "23.0.0.0.0")) {
            steps = this.getDatabaseModicationStepsFor23cDB(patchTarget, targetHome);
            generatedSteps.addAll(steps);
        } else if (this.isDBUp(patchTarget)) {
            steps = this.getDatabaseModificationSteps(configGraph, patchTarget, DBCommandActionType.moveDB.toString(), "SIDatabase", "Confirm-Config-Title", true);
            generatedSteps.addAll(steps);
            steps = this.getDatabaseModificationSteps(configGraph, patchTarget, DBCommandActionType.moveDB.toString(), "SIDatabase", "Confirm-Config-Title", true);
            generatedSteps.addAll(steps);
        }
        return generatedSteps;
    }

    private List<ExecutionStep> getDatabaseModicationStepsFor23cDB(PatchTarget patchTarget, String targetHome) throws OPatchAutoException {
        ArrayList<ExecutionStep> generatedSteps = new ArrayList<ExecutionStep>();
        String original_home = patchTarget.getHome(true).getLocation();
        String target_home = OOPSessionInfoHandler.getInstance().getCloneHomePath(original_home);
        File oraInst = new File(target_home, "oraInst.loc");
        String ohOwner = OUIDriver.checkFileOwner((File)oraInst);
        String OracleSid = this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SID.getValue()).getValue();
        String dbuaCmd = "cd " + target_home + "; " + target_home + File.separator + "bin" + File.separator + "dbca -silent -moveDatabase -sourceDB " + OracleSid + " -skipDatapatch";
        ActionType actionType = new ActionType();
        ExecutionStep executionStep = new ExecutionStep(actionType);
        executionStep.getCommand().add(new ExecutionStep.Command(dbuaCmd));
        User user = new User();
        user.setValue(ohOwner);
        executionStep.setUser(user);
        Host host = new Host();
        host.setDisplayName(patchTarget.getHost().getHost());
        host.setName(patchTarget.getHost().getHost());
        executionStep.setHost(host);
        generatedSteps.add(executionStep);
        return generatedSteps;
    }

    @Override
    protected ExecutionResult runCommand(PatchTarget patchTarget, ExecutionStep executionStep) throws CommandFailureException {
        boolean canExecute = true;
        Set<Map.Entry<String, String>> dbToOhMap = DBPatchingUtil.getDatabaseNames().entrySet();
        for (Map.Entry<String, String> entry : dbToOhMap) {
            if (!DBPatchingHelper.compareFilePath(entry.getValue(), patchTarget.getHomeClone().getLocation())) continue;
            canExecute = false;
            break;
        }
        ExecutionResult status = null;
        if (canExecute) {
            status = super.runCommand(patchTarget, executionStep);
        } else {
            this._logger.info("Database is already migrated to new home::" + patchTarget.getHomeClone().getLocation());
        }
        return status;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        return targetList;
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        isActionRequired = DBPatchingHelper.isSingleOOPPatchingSession(this.getPatchSession().getOptions()) || DBPatchingHelper.isOOPSwitchPatchingSession(this.getPatchSession().getOptions());
        try {
            if (isActionRequired) {
                isActionRequired = this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB.getValue()).isSwitchEnabled();
            }
        }
        catch (OPatchAutoException e) {
            new PatchActionException((Throwable)e);
        }
        return isActionRequired;
    }

    protected List<ExecutionStep> getDatabaseModificationSteps(ConfigGraph configGraph, PatchTarget patchTarget, String commandType, String acts_on, String readmeTitle, boolean actsOnClone) throws OPatchAutoException {
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, commandType);
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON, acts_on);
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON_CLONE, actsOnClone);
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Confirm-Config-Title");
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_MSG_KEY, "Confirm-Config-Message");
        String targetHome = DBPatchingHelper.getTargetHomeFromProductType(patchTarget);
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_TARGETHOME, targetHome);
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_HOMETYPE, targetHome);
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        PatchingPhase phase = this.getpatchingPhase();
        Command sqlPatchApplyCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(configGraph, patchTarget, actionType, sqlPatchApplyCommand);
        return steps;
    }

    private PatchingPhase getpatchingPhase() {
        PatchingPhase phase = CommandDetailsGenerator.generatePatchingPhase(PhaseType.MIGRATE, ServiceStatus.UP);
        return phase;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString(((Object)((Object)this)).getClass().getSimpleName() + ".start.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString(((Object)((Object)this)).getClass().getSimpleName() + ".success.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString(((Object)((Object)this)).getClass().getSimpleName() + ".failure.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }

    public boolean isRollbackSupported() {
        return true;
    }
}

