/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.sdb;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.CommonPatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.topology.DBHomeImpl;
import com.oracle.glcm.patch.auto.db.integration.controller.action.sdb.helper.SDBPatchActionHelper;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBFamily;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.ExecutionResult;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.InitPhase;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.helper.util.HelperUtility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public abstract class SDBCommonPatchAction
extends CommonPatchAction {
    protected SDBPatchActionHelper helper = null;
    protected String oracleHomeLoc = "";
    protected String patchZipLocation = "";
    boolean reportAnalyzeFailure = false;

    public SDBCommonPatchAction(Goal ... goals) {
        super(goals);
    }

    public final PatchActionResult execute(PatchTarget patchTarget) {
        PatchActionResult patchActionResult = new PatchActionResult();
        String generatedStep = null;
        this.helper = new SDBPatchActionHelper();
        try {
            generatedStep = this.createSteps(patchTarget);
            if (generatedStep != null && !generatedStep.isEmpty()) {
                patchActionResult = this.executeAndCollectOutput(generatedStep, patchTarget);
            } else {
                this._logger.info("No steps found on " + patchTarget.getHost());
                Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"PatchAction.no.step.execution", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            this._logger.warning("Exception while generating step: " + e.getMessage());
            patchActionResult = new PatchActionResult((Throwable)e);
            this._logger.throwing("Detailed Execption while generating steps : ", e.getMessage(), e);
            StringBuilder builder = new StringBuilder();
            ArrayList<String> details = new ArrayList<String>();
            builder = this.helper.makeFailureOutput(patchTarget, patchActionResult.getException().toString(), this.getPatchSession());
            details.add(builder.toString());
            patchActionResult.setDetails(details);
        }
        return patchActionResult;
    }

    protected PatchActionResult executeAndCollectOutput(String executionStep, PatchTarget patchTarget) throws OPatchAutoException {
        ExecutionResult.CommandExecutionResult result = null;
        PatchActionResult patchActionResult = null;
        ArrayList<String> details = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        this.helper = new SDBPatchActionHelper();
        result = this.executeScript(patchTarget, executionStep);
        if (result != null) {
            this._logger.finest("result status : " + (Object)((Object)result.getStatus()));
            this._logger.finest("result message : " + result.getMessage() + " result message end : ");
            this._logger.finest("result error message : " + result.getErrorMessage() + " result error message end : ");
            if (result.getStatus().equals((Object)ExecutionResult.ExecutionStatus.FAILURE)) {
                patchActionResult = new PatchActionResult(PatchActionStatus.failure);
                if (StringUtil.isNullOrEmpty((String)result.getMessage().trim())) {
                    builder.append((CharSequence)this.helper.makeFailureOutput(patchTarget, result.getErrorMessage(), this.getPatchSession()));
                } else {
                    builder.append((CharSequence)this.processCommandFailure(patchTarget, result.getMessage()));
                }
            } else {
                patchActionResult = new PatchActionResult(PatchActionStatus.success);
                builder.append(result.getMessage());
            }
            details.add(builder.toString());
            patchActionResult.setDetails(details);
        }
        return patchActionResult;
    }

    protected StringBuilder processOHCommandOutput(DBPatchingSummaryCreator summaryCreator, PatchTarget target, String outputMsg, boolean issdb) throws OPatchAutoException {
        this.helper = new SDBPatchActionHelper();
        String logFile = this.helper.getLogFileFrmConsole(outputMsg);
        StringBuilder outputBuff = new StringBuilder();
        outputBuff.append((CharSequence)this.helper.getSummarySubHeader(target, issdb, this.getPatchSession()));
        if (outputMsg.lastIndexOf(this.getLocalizedString("PatchAction.opatchauto.failed.message", new Object[0])) != -1) {
            outputBuff.append((CharSequence)this.processCommandFailure(target, outputMsg));
        }
        if (outputMsg.lastIndexOf("Home:") != -1) {
            String summaryFileName = "patchingsummary";
            this.helper.populateSummary(summaryCreator, target, outputBuff, summaryFileName);
        } else if (outputMsg.lastIndexOf(this.getLocalizedString("PatchAction.opatchauto.successful.message", new Object[0])) != -1 && outputMsg.indexOf(this.getLocalizedString("PatchAction.no.step.execution.message", new Object[0])) != -1) {
            if (this.getPatchSession().isAnalyze()) {
                outputBuff.append(this.getLocalizedString("PatchAction.no.patch.analyze.message", new Object[0]));
            } else if (this.getPatchSession().isRollback()) {
                outputBuff.append(this.getLocalizedString("PatchAction.no.patch.rollback.message", new Object[0]));
            } else {
                outputBuff.append(this.getLocalizedString("PatchAction.no.patch.apply.message", new Object[0]));
            }
        }
        String fileMsg = "";
        if (logFile != null) {
            fileMsg = "\n" + this.getLocalizedString("PatchAction.log.summary.host", target.getHost().getHost(), logFile);
        }
        outputBuff.append(fileMsg);
        return outputBuff;
    }

    protected StringBuilder processCommandFailure(PatchTarget target, String outputMsg) {
        int index;
        int hostindex;
        int failureIndex;
        StringBuilder finalResult = new StringBuilder();
        this.helper = new SDBPatchActionHelper();
        String logFile = this.helper.getLogFileFrmConsole(outputMsg);
        boolean isremote = false;
        String hostname = null;
        DBHomeImpl homeImpl = (DBHomeImpl)target.getHome();
        try {
            isremote = homeImpl.getHost().isRemote();
        }
        catch (OPatchAutoException e) {
            this._logger.warning("Exception while trying to identify whether remote host: " + e.getMessage());
        }
        if (outputMsg != null && outputMsg.indexOf(this.getLocalizedString("PatchAction.patch.failure.message", new Object[0])) != -1 && (outputMsg = outputMsg.substring(failureIndex = outputMsg.indexOf(this.getLocalizedString("PatchAction.patch.failure.message", new Object[0]))).trim()).indexOf("host:") != -1 && (outputMsg = outputMsg.substring((hostindex = outputMsg.indexOf("host:")) + 1).trim()).indexOf(":") != -1) {
            index = outputMsg.indexOf(":");
            hostname = outputMsg.substring(index + 1, outputMsg.indexOf("\n")).trim();
        }
        finalResult.append((CharSequence)this.helper.createTargetSummary(target, hostname));
        finalResult.append("\nstatus : ");
        if (this.getPatchSession().isAnalyze()) {
            finalResult.append(this.getLocalizedString("PatchAction.log.failure.analyze.summary", new Object[0]));
        } else if (this.getPatchSession().isRollback()) {
            finalResult.append(this.getLocalizedString("PatchAction.log.failure.rollback.summary", new Object[0]));
        } else {
            finalResult.append(this.getLocalizedString("PatchAction.log.failure.apply.summary", new Object[0]));
        }
        finalResult.append("\nreason : ");
        StringBuilder failureReason = new StringBuilder();
        if (null != outputMsg) {
            int colonIndex;
            int lineindex;
            int index2;
            int failureIndex2;
            if (outputMsg.indexOf(this.getLocalizedString("PatchAction.command.failure.message", new Object[0])) != -1) {
                failureIndex2 = outputMsg.indexOf(this.getLocalizedString("PatchAction.command.failure.message", new Object[0]));
                if ((outputMsg = outputMsg.substring(failureIndex2).trim()).indexOf(":") != -1) {
                    index = outputMsg.indexOf(":");
                    if ((outputMsg = outputMsg.substring(index + 1).trim()).indexOf(this.getLocalizedString("PatchAction.after.failure.fix.message", new Object[0])) != -1) {
                        int finalIndex = outputMsg.indexOf(this.getLocalizedString("PatchAction.after.failure.fix.message", new Object[0]));
                        outputMsg = outputMsg.substring(0, finalIndex).trim();
                        failureReason.append(outputMsg);
                    } else if (outputMsg.lastIndexOf(this.getLocalizedString("PatchAction.opatchauto.message", new Object[0])) != -1) {
                        int finalIndex = outputMsg.indexOf(this.getLocalizedString("PatchAction.opatchauto.message", new Object[0]));
                        outputMsg = outputMsg.substring(0, finalIndex).trim();
                        failureReason.append(outputMsg.trim());
                    }
                }
            } else if (outputMsg.indexOf(this.getLocalizedString("PatchAction.failure.summary.message", new Object[0])) != -1) {
                failureIndex2 = outputMsg.indexOf(this.getLocalizedString("PatchAction.failure.summary.message", new Object[0]));
                if ((outputMsg = outputMsg.substring(failureIndex2).trim()).indexOf(":") != -1 && (outputMsg = outputMsg.substring((index = outputMsg.indexOf(":")) + 1).trim()).lastIndexOf(this.getLocalizedString("PatchAction.opatchauto.message", new Object[0])) != -1) {
                    int finalIndex = outputMsg.indexOf(this.getLocalizedString("PatchAction.opatchauto.message", new Object[0]));
                    outputMsg = outputMsg.substring(0, finalIndex).trim();
                    failureReason.append(outputMsg.trim());
                }
            } else if (outputMsg.lastIndexOf(this.getLocalizedString("PatchAction.opatchauto.bootstrap.failed.message", new Object[0])) != -1) {
                index2 = outputMsg.indexOf(this.getLocalizedString("PatchAction.opatchauto.bootstrap.failed.message", new Object[0]));
                outputMsg = outputMsg.substring(0, index2).trim();
                failureReason.append("\n" + outputMsg.trim());
            } else if (outputMsg.lastIndexOf(this.getLocalizedString("PatchAction.opatchauto.failed.message", new Object[0])) != -1) {
                if (outputMsg.lastIndexOf(this.getLocalizedString("PatchAction.exception.message", new Object[0])) != -1) {
                    index2 = outputMsg.indexOf(this.getLocalizedString("PatchAction.exception.message", new Object[0]));
                    if ((outputMsg = outputMsg.substring(index2).trim()).indexOf(this.getLocalizedString("\n", new Object[0])) != -1) {
                        outputMsg = outputMsg.substring(0, outputMsg.indexOf(this.getLocalizedString("\n", new Object[0]))).trim();
                        failureReason.append(outputMsg.trim());
                    }
                } else if (outputMsg.lastIndexOf(this.getLocalizedString("PatchAction.summary.message", new Object[0])) != -1) {
                    index2 = outputMsg.indexOf(this.getLocalizedString("PatchAction.summary.message", new Object[0]));
                    if ((outputMsg = outputMsg.substring(index2).trim()).lastIndexOf("\n") != -1 && (outputMsg = outputMsg.substring(lineindex = outputMsg.indexOf("\n")).trim()).lastIndexOf(this.getLocalizedString("PatchAction.opatchauto.failed.message", new Object[0])) != -1) {
                        outputMsg = outputMsg.substring(0, outputMsg.lastIndexOf(this.getLocalizedString("PatchAction.opatchauto.failed.message", new Object[0]))).trim();
                        failureReason.append(outputMsg.trim());
                    }
                } else if (outputMsg.lastIndexOf(this.getLocalizedString("PatchAction.opatchauto.message", new Object[0])) != -1 && (outputMsg = outputMsg.substring(index2 = outputMsg.indexOf(this.getLocalizedString("PatchAction.opatchauto.message", new Object[0]))).trim()).indexOf(":") != -1 && (outputMsg = outputMsg.substring((colonIndex = outputMsg.indexOf(":")) + 1).trim()).indexOf("\n") != -1) {
                    int finalIndex = outputMsg.indexOf("\n");
                    outputMsg = outputMsg.substring(0, finalIndex).trim();
                    failureReason.append(outputMsg.trim());
                }
            } else if (outputMsg.lastIndexOf(this.getLocalizedString("PatchAction.failures.message", new Object[0])) != -1) {
                index2 = outputMsg.indexOf(this.getLocalizedString("PatchAction.failures.message", new Object[0]));
                if ((outputMsg = outputMsg.substring(index2).trim()).lastIndexOf(":") != -1 && (outputMsg = outputMsg.substring((lineindex = outputMsg.indexOf(":")) + 1).trim()).indexOf("-----") != -1) {
                    outputMsg = outputMsg.substring(0, outputMsg.indexOf("-----")).trim();
                    failureReason.append(outputMsg.trim());
                }
            } else if (outputMsg.lastIndexOf(this.getLocalizedString("PatchAction.opatchauto.message", new Object[0])) != -1 && (outputMsg = outputMsg.substring(index2 = outputMsg.indexOf(this.getLocalizedString("PatchAction.opatchauto.message", new Object[0]))).trim()).indexOf(":") != -1 && (outputMsg = outputMsg.substring((colonIndex = outputMsg.indexOf(":")) + 1).trim()).indexOf("\n") != -1) {
                int finalIndex = outputMsg.indexOf("\n");
                outputMsg = outputMsg.substring(0, finalIndex).trim();
                failureReason.append(outputMsg.trim());
            }
        }
        if (!StringUtil.isNullOrEmpty((String)failureReason.toString()) && failureReason.indexOf("reason : ") == -1) {
            finalResult.append((CharSequence)failureReason);
        } else {
            finalResult = new StringBuilder();
        }
        finalResult.append("\n");
        String fileMsg = "";
        if (logFile != null) {
            fileMsg = isremote ? "\n" + this.getLocalizedString("PatchAction.log.summary.host", hostname, logFile) : "\n" + this.getLocalizedString("PatchAction.log.summary.host", homeImpl.getHost().getHost(), logFile);
        }
        finalResult.append(fileMsg);
        finalResult.append("\n");
        return finalResult;
    }

    protected String getLocalizedString(String name, Object ... messageFormatting) {
        return OPatchAutoHelper.getLocalizedString((String)name, (Object[])messageFormatting);
    }

    protected abstract ExecutionResult.CommandExecutionResult executeScript(PatchTarget var1, String var2) throws OPatchAutoException;

    protected String createOhSteps(PatchTarget patchTarget) throws OPatchAutoException {
        String cmd = "";
        String oh = patchTarget.getHome().getLocation();
        String sessionId = this.getPatchSession().getProductSupportManager().getOptions().getOption("session").getValue();
        if (this.getPatchSession().getCommand().isResumed()) {
            try {
                if (!this.getPatchSession().getCurrentGoal().equals(InitPhase.Goal.init) && SDBPatchActionHelper.isChildSessionPresent(oh, sessionId, false, this.getPatchSession().getCurrentGoal())) {
                    cmd = oh + File.separator + DBCommonPatchingConstants.OPATCHAUTO_SCRIPT + " " + OPatchAutoCommand.resume + " -parentid " + sessionId;
                    this._logger.info("WARNING: This resume command must not be executed manually in the command line : " + cmd);
                    return cmd;
                }
            }
            catch (IOException e) {
                throw new OPatchAutoException((Throwable)e);
            }
        }
        String operation = "";
        if (this.getPatchSession().getCommand().isApply()) {
            operation = "apply";
        } else if (this.getPatchSession().getCommand().isRollback()) {
            operation = "rollback";
        }
        DBHomeImpl homeImpl = (DBHomeImpl)patchTarget.getHome();
        cmd = cmd + this.getInitialCommand(patchTarget, operation);
        this.helper = new SDBPatchActionHelper();
        cmd = cmd + " -parentid " + sessionId;
        String ohKey = this.getPatchSession().getProductSupportManager().getOptions().getOption("home").getArg();
        cmd = cmd + " " + ohKey + " " + oh;
        if (homeImpl.isSharedHome()) {
            String nonRollingKey = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.NONROLLING_MODE_KEY.getValue()).getArg();
            cmd = cmd + " " + nonRollingKey;
        }
        return cmd;
    }

    public boolean isAnalyzeSupported() {
        return true;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    protected abstract String createSteps(PatchTarget var1) throws OPatchAutoException;

    public void prepareRemoteActionExecutionHost(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws RemoteConnectionException, PatchActionException {
        this.oracleHomeLoc = ((PatchTarget)container.getPatchTargets().iterator().next()).getHome().getLocation();
        this.saveCmdOptionsToContainer(container);
        String dbTmpLocation = this.getDBTmpLocation();
        if (this.getPatchSession().isRollback() && DBPatchingHelper.isRollbackUsingPatchId(this.getPatchSession())) {
            container.addPatchActionParameter("id", (Object)this.getPatchSession().getPatchId());
        } else {
            this.copyPatchToContainer(handler, container);
        }
        this.writeWalletToContainer(container, dbTmpLocation);
    }

    private void saveCmdOptionsToContainer(PatchActionExecutorContainer container) throws PatchActionException {
        try {
            DBHomeImpl homeImpl;
            String dbName;
            String reportAnalyzeFailOption;
            String deployOnlyOption;
            String dgOption;
            String shardSpaceOption;
            String shardGroupOption;
            String family = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.FAMILY.getValue()).getValue();
            if (!StringUtil.isNullOrEmpty((String)family)) {
                container.addPatchActionParameter(DBProductParameterConstants.FAMILY.getValue(), (Object)family);
            }
            if (!StringUtil.isNullOrEmpty((String)(shardGroupOption = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.SHARD_GROUP.getValue()).getValue()))) {
                container.addPatchActionParameter(DBProductParameterConstants.SHARD_GROUP.getValue(), (Object)shardGroupOption);
            }
            if (!StringUtil.isNullOrEmpty((String)(shardSpaceOption = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.SHARD_SPACE.getValue()).getValue()))) {
                container.addPatchActionParameter(DBProductParameterConstants.SHARD_SPACE.getValue(), (Object)shardSpaceOption);
            }
            if (!StringUtil.isNullOrEmpty((String)(dgOption = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.DG.getValue()).getValue()))) {
                container.addPatchActionParameter(DBProductParameterConstants.DG.getValue(), (Object)dgOption);
            }
            if (!StringUtil.isNullOrEmpty((String)(deployOnlyOption = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.DEPLOY_ONLY.getValue()).getValue()))) {
                container.addPatchActionParameter(DBProductParameterConstants.DEPLOY_ONLY.getValue(), (Object)deployOnlyOption);
            }
            if (!StringUtil.isNullOrEmpty((String)(reportAnalyzeFailOption = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.REPORT_ANALYZE_FAILURE.getValue()).getValue()))) {
                container.addPatchActionParameter(DBProductParameterConstants.REPORT_ANALYZE_FAILURE.getValue(), (Object)reportAnalyzeFailOption);
            }
            if (null != this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.IN_PLACE_KEY.getValue()).getValue()) {
                container.addPatchActionParameter(DBProductParameterConstants.IN_PLACE_KEY.getValue(), (Object)this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.IN_PLACE_KEY.getValue()).getValue());
            }
            if (null != (dbName = (homeImpl = (DBHomeImpl)((PatchTarget)container.getPatchTargets().iterator().next()).getHome()).getTargetName())) {
                container.addPatchActionParameter(DBProductParameterConstants.DATABASE_KEY.getValue(), (Object)dbName);
            }
            container.addPatchActionParameter(OPatchAutoCommand.resume.toString(), (Object)container.getCommand().isResumed());
            container.addPatchActionParameter("session", (Object)this.getPatchSession().getPatchTracking().getSessionId());
            String patchWithFiles = System.getProperty("OPatchauto.PATCH_WITH_FILES_FROM_LOC");
            container.addPatchActionParameter(DBProductParameterConstants.PATCH_WITH_FILES_FROM_LOC.getValue(), (Object)patchWithFiles);
            String giHomePath = System.getProperty("OPatchauto.GI_HOME_PATH");
            if (!StringUtil.isNullOrEmpty((String)giHomePath, (boolean)true)) {
                container.addPatchActionParameter(DBProductParameterConstants.GRID_HOME.getValue(), (Object)giHomePath);
            }
            container.addPatchActionParameter(DBProductParameterConstants.SKIP_GRID_HOME.getValue(), (Object)true);
        }
        catch (OPatchAutoException e) {
            throw new PatchActionException((Throwable)e);
        }
    }

    protected String getDBTmpLocation() {
        String dbTmpLocation = null;
        if (this.getPatchSession().isRollback() && DBPatchingHelper.isRollbackUsingPatchId(this.getPatchSession())) {
            dbTmpLocation = this.oracleHomeLoc + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB;
        } else {
            String zipLoc = System.getProperty("patch.zip.location");
            String[] pathsplit = zipLoc.split("/");
            String patchName = pathsplit[pathsplit.length - 1];
            this.patchZipLocation = HelperUtility.detectOraBaseConfig((String)this.oracleHomeLoc) + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + patchName;
            File localPatchLocationFile = new File(this.patchZipLocation);
            dbTmpLocation = localPatchLocationFile.getParentFile().getParent() + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB_DIR;
        }
        return dbTmpLocation;
    }

    private void copyPatchToContainer(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws PatchActionException, RemoteConnectionException {
        String patchLocation = this.getPatchSession().getPatchLocation();
        String parameterKey = "patch.location";
        if (StringUtil.isNullOrEmpty((String)patchLocation, (boolean)true)) {
            patchLocation = this.getPatchSession().getPatchBaseDirectory();
            parameterKey = "patch.base.directory";
        }
        if (StringUtil.isNullOrEmpty((String)patchLocation, (boolean)true)) {
            throw new PatchActionException("The patch location or patch base location were not set.", new Object[0]);
        }
        String patchZipLocation = System.getProperty("patch.zip.location");
        String destLocation = this.patchZipLocation;
        File destLocationFile = new File(destLocation);
        String patchName = destLocationFile.getName().split("\\.")[0];
        String remotePatchLocation = destLocationFile.getParentFile().getParent() + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB_DIR + patchName;
        container.addPatchActionParameter(DBProductParameterConstants.PATCH_ZIP_FILE_LOC.getValue(), (Object)patchZipLocation);
        container.addPatchActionParameter(parameterKey, (Object)remotePatchLocation);
    }

    public void setupRemoteActionExecutionEnvironment(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws PatchActionException {
        super.setupRemoteActionExecutionEnvironment(patchSession, container);
        this.helper = new SDBPatchActionHelper();
        this.helper.setupRemoteActionExecutionEnvironment(patchSession, container);
    }

    protected void writeWalletToContainer(PatchActionExecutorContainer container, String dbTmpLocation) throws RemoteConnectionException, PatchActionException {
        File wallet = this.getPatchSession().getCredentialManager().getWalletLocation();
        if (wallet != null) {
            String remoteWalletDir = dbTmpLocation + "wallet";
            String remoteWalletLocation = remoteWalletDir + File.separator + wallet.getName();
            container.addPatchActionParameter("wallet", (Object)remoteWalletLocation);
            try {
                container.addPatchActionParameter("value.holder", (Object)this.getPatchSession().getCredentialManager().getValueHolder());
            }
            catch (OPatchAutoException e) {
                throw new PatchActionException((Throwable)e);
            }
        }
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    protected String getInitialCommand(PatchTarget patchTarget, String operation) throws OPatchAutoException {
        DBHomeImpl homeImpl;
        this.helper = new SDBPatchActionHelper();
        String patchLocation = DBPatchingHelper.getPatchLocation(this.getPatchSession());
        String oh = patchTarget.getHome().getLocation();
        File wallet = this.getPatchSession().getCredentialManager().getWalletLocation();
        String walletKey = this.getPatchSession().getProductSupportManager().getOptions().getOption("wallet").getArg();
        String patchParam = null;
        if (this.getPatchSession().isRollback() && !StringUtil.isNullOrEmpty((String)this.getPatchSession().getPatchId())) {
            patchParam = this.getPatchSession().getProductSupportManager().getOptions().getOption("id").getArg() + " " + this.getPatchSession().getPatchId();
        } else {
            patchParam = patchLocation;
            if (this.helper.isPatchBaseDir(this.getPatchSession().getPatchBaseDirectory())) {
                patchParam = this.getPatchSession().getProductSupportManager().getOptions().getOption("patch.base.directory").getArg() + " " + patchLocation;
            }
        }
        String cmd = oh + File.separator + DBCommonPatchingConstants.OPATCHAUTO_SCRIPT + " " + operation + " " + patchParam + " " + walletKey + " " + wallet.getAbsolutePath();
        String logLevelKey = this.getPatchSession().getProductSupportManager().getOptions().getOption(OPatchAutoOptions.LOG_LEVEL_KEY).getArg();
        LogFactory logFactory = LogFactory.getFactory();
        String logLevelValue = logFactory.getRootLevel().toString();
        if (!StringUtil.isNullOrEmpty((String)logLevelValue)) {
            cmd = cmd + " " + logLevelKey + " " + logLevelValue;
        }
        String noRestartKey = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.NORESTART_KEY.getValue()).getArg();
        if (Boolean.parseBoolean(this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.NORESTART_KEY.getValue()).getValue())) {
            cmd = cmd + " " + noRestartKey;
        }
        if ((homeImpl = (DBHomeImpl)patchTarget.getHome()).getTargetType() != null && homeImpl.getTargetType().equalsIgnoreCase("crs") || homeImpl.getTargetType().equalsIgnoreCase("rac")) {
            cmd = cmd + " -shardremote ";
        }
        cmd = cmd + " " + this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.FAMILY.getValue()).getArg() + " " + DBFamily.SHARDING.getValue() + " ";
        if (Boolean.parseBoolean(this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.IN_PLACE_KEY.getValue()).getValue())) {
            cmd = cmd + " " + this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.IN_PLACE_KEY.getValue()).getArg() + " ";
        }
        return cmd;
    }

    protected String addTag(String statusMsg) {
        String updatedMsg = statusMsg;
        try {
            String dbproduct;
            if (!StringUtil.isNullOrEmpty((String)statusMsg) && this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.FAMILY.getValue()) != null && !StringUtil.isNullOrEmpty((String)(dbproduct = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.FAMILY.getValue()).getValue())) && dbproduct.equalsIgnoreCase(DBFamily.SHARDING.getValue())) {
                updatedMsg = "<sharding>" + statusMsg + "</sharding>";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return updatedMsg;
    }
}

