/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.sdb;

import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.topology.DBHomeImpl;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.integration.controller.action.sdb.SDBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.sdb.helper.SDBPatchActionHelper;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductSupport;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.shard.ShardDBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.ExecutionResult;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.InitPhase;
import com.oracle.glcm.patch.auto.lifecycle.OnlinePhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.HostImpl;
import java.io.File;
import java.util.ArrayList;

public abstract class SDBPatchAction
extends SDBCommonPatchAction {
    public SDBPatchAction() {
        super(new Goal[]{InitPhase.Goal.init, OnlinePhase.Goal.product_patching});
    }

    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        try {
            boolean isRequired = false;
            String sdbOption = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.SDB.getValue()).getValue();
            if (Boolean.parseBoolean(sdbOption)) {
                isRequired = this.getPatchSession().isAnalyze() ? this.getPatchSession().getCurrentGoal().equals(InitPhase.Goal.init) : true;
            }
            return isRequired;
        }
        catch (OPatchAutoException e) {
            throw new PatchActionException("Exception : " + e.getMessage(), new Object[0]);
        }
    }

    @Override
    protected abstract String createSteps(PatchTarget var1) throws OPatchAutoException;

    @Override
    public void prepareRemoteActionExecutionHost(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws RemoteConnectionException, PatchActionException {
        super.prepareRemoteActionExecutionHost(handler, container);
        this.writeInstanceFileToContainer(container, this.getDBTmpLocation());
    }

    protected void writeInstanceFileToContainer(PatchActionExecutorContainer container, String dbTmpLocation) throws PatchActionException {
        String remoteInstanceDir = dbTmpLocation + "instance" + File.separator;
        container.addPatchActionParameter("topology", (Object)remoteInstanceDir);
    }

    protected String getSystemInstanceFilePath() {
        String patchId = new File(DBPatchingHelper.getPatchLocation(this.getPatchSession())).getName();
        return SessionData.getConfigDir() + File.separator + patchId + File.separator;
    }

    protected StringBuilder processCommandOutput(DBPatchingSummaryCreator summaryCreator, PatchTarget target, String outputMsg) throws OPatchAutoException {
        StringBuilder outputBuff = new StringBuilder();
        this.helper = new SDBPatchActionHelper();
        outputBuff.append((CharSequence)this.helper.getSummarySubHeader(target, true, this.getPatchSession()));
        String summaryFileName = "shardpatchingsummary";
        String summaryFile = "/tmp/" + summaryFileName + ".xml";
        RemoteConnectionHandler handler = null;
        String remoteLoc = "";
        if (target.isRemote()) {
            HostImpl host = (HostImpl)target.getHome().getHost();
            handler = PatchActionUtil.getHandler(host);
            remoteLoc = target.getHome().getLocation() + DBCommonPatchingConstants.OPATCH_AUTO_DBSESSIONINFO + summaryFileName + ".xml";
            summaryFile = this.helper.copySummaryFileFromTmp(summaryFileName, handler, remoteLoc, host);
        }
        outputBuff.append((CharSequence)this.helper.createSummary(summaryCreator, target, summaryFile, false, true));
        outputBuff.append((CharSequence)this.helper.logOutput(target, outputMsg));
        this.helper.deleteCopiedSummaryFile(target, summaryFileName, handler, remoteLoc);
        return outputBuff;
    }

    @Override
    protected ExecutionResult.CommandExecutionResult executeScript(PatchTarget patchTarget, String executionStep) throws OPatchAutoException {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(PatchActionUtil.getBashCmd());
        cmds.add("-c");
        cmds.add(executionStep);
        boolean reportAnalyzeFailure = false;
        if (executionStep.contains(this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.REPORT_ANALYZE_FAILURE.getValue()).getArg())) {
            reportAnalyzeFailure = true;
        }
        ExecutionResult.CommandExecutionResult result = PatchActionUtil.execute(cmds, null, patchTarget, reportAnalyzeFailure, this.getPatchSession().getCredentialManager());
        return result;
    }

    protected void populateFailureSummary(DBPatchingSummaryCreator summaryCreator, PatchTarget target, StringBuilder outputBuff, String summaryFileName) throws OPatchAutoException {
        this.helper = new SDBPatchActionHelper();
        String summaryFile = "/tmp/" + summaryFileName + ".xml";
        RemoteConnectionHandler handler = null;
        String remoteLoc = "";
        if (target.isRemote()) {
            HostImpl host = (HostImpl)target.getHome().getHost();
            handler = PatchActionUtil.getHandler(host);
            remoteLoc = target.getHome().getLocation() + DBCommonPatchingConstants.OPATCH_AUTO_DBSESSIONINFO + summaryFileName + ".xml";
            summaryFile = this.helper.copySummaryFileFromTmp(summaryFileName, handler, remoteLoc, host);
        }
        outputBuff.append((CharSequence)this.helper.createSummary(summaryCreator, target, summaryFile, true, false));
        this.helper.deleteCopiedSummaryFile(target, summaryFileName, handler, remoteLoc);
    }

    protected void postExecute(PatchTarget patchTarget, PatchActionResult patchActionResult, StringBuilder summary) throws OPatchAutoException {
        if (patchActionResult != null) {
            this._logger.info("IS RESUMED : " + this.getPatchSession().getCommand().isResumed());
            DBPatchingSummaryCreator summaryCreator = ((DBProductSupport)this.getPatchSession().getProductSupportManager().getProductSupport("db")).getDBPatchingSummaryCreator(this.getPatchSession().getCommand());
            if (patchActionResult.getDetailsList() != null && !patchActionResult.getDetailsList().isEmpty() && this.getPatchSession().getPatchTracking() != null) {
                SummaryID summaryID = this.getPatchSession().getCurrentGoal().equals(InitPhase.Goal.init) ? SummaryID.sdb_analyze_patching : SummaryID.sdb_patching;
                if (this.getPatchSession().getCommand().isResumed()) {
                    summaryCreator.storePatchingSummary(2, summaryID, patchTarget, summary.toString());
                } else if (patchActionResult.isFailure() && !this.getPatchSession().isAnalyze()) {
                    if (!summary.toString().contains(this.getLocalizedString("PatchAction.command.failure.resume", new Object[0]))) {
                        summary.append(this.getLocalizedString("PatchAction.command.failure.resume", new Object[0]));
                    }
                    summaryCreator.storePatchingSummary(0, summaryID, patchTarget, summary.toString());
                } else {
                    summaryCreator.storePatchingSummary(0, summaryID, patchTarget, summary.toString());
                }
            }
        }
    }

    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        DBHomeImpl homeImpl = (DBHomeImpl)patchTarget.getHome();
        String dbType = patchTarget.getProductType().getType();
        String execStartTime = PatchActionUtil.getCurrentDate();
        String execEndTime = PatchActionUtil.getCurrentDate();
        boolean isShdSpcOption = false;
        try {
            if (this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.SHARD_SPACE.getValue()).getValue() != null) {
                isShdSpcOption = true;
            }
        }
        catch (OPatchAutoException oPatchAutoException) {
            // empty catch block
        }
        switch (status) {
            case incomplete: {
                if (dbType.equals(ShardDBProductTypes.PRODUCT_TYPE_SIHA_SDB.getValue()) || dbType.equals(ShardDBProductTypes.PRODUCT_TYPE_CRS_SDB.getValue())) {
                    statusMsg = this.getLocalizedString("SDBPatchAction.start.grid.message", homeImpl.getLocation(), execStartTime);
                    break;
                }
                if (homeImpl.isOgg()) {
                    if (homeImpl.getShardingType().equalsIgnoreCase("user-defined") || isShdSpcOption) {
                        statusMsg = this.getLocalizedString("SDBPatchAction.start.shardspace.message", homeImpl.getShardSpaceName(), execStartTime);
                        break;
                    }
                    statusMsg = this.getLocalizedString("SDBPatchAction.start.shardgroup.message", homeImpl.getShardGroupName(), execStartTime);
                    break;
                }
                statusMsg = this.getLocalizedString("SDBPatchAction.start.dg.message", homeImpl.getDrsetNumber(), execStartTime);
                break;
            }
            case failure: {
                if (dbType.equals(ShardDBProductTypes.PRODUCT_TYPE_SIHA_SDB.getValue()) || dbType.equals(ShardDBProductTypes.PRODUCT_TYPE_CRS_SDB.getValue())) {
                    statusMsg = this.getLocalizedString("SDBPatchAction.failure.grid.message", homeImpl.getLocation(), execEndTime);
                    break;
                }
                if (homeImpl.isOgg()) {
                    if (homeImpl.getShardingType().equalsIgnoreCase("user-defined") || isShdSpcOption) {
                        statusMsg = this.getLocalizedString("SDBPatchAction.failure.shardspace.message", homeImpl.getShardSpaceName(), execEndTime);
                        break;
                    }
                    statusMsg = this.getLocalizedString("SDBPatchAction.failure.shardgroup.message", homeImpl.getShardGroupName(), execEndTime);
                    break;
                }
                statusMsg = this.getLocalizedString("SDBPatchAction.failure.dg.message", homeImpl.getDrsetNumber(), execEndTime);
                break;
            }
            case warning: {
                if (dbType.equals(ShardDBProductTypes.PRODUCT_TYPE_SIHA_SDB.getValue()) || dbType.equals(ShardDBProductTypes.PRODUCT_TYPE_CRS_SDB.getValue())) {
                    statusMsg = this.getLocalizedString("SDBPatchAction.warning.grid.message", homeImpl.getLocation(), execEndTime);
                    break;
                }
                if (homeImpl.isOgg()) {
                    if (homeImpl.getShardingType().equalsIgnoreCase("user-defined") || isShdSpcOption) {
                        statusMsg = this.getLocalizedString("SDBPatchAction.warning.shardspace.message", homeImpl.getShardSpaceName(), execEndTime);
                        break;
                    }
                    statusMsg = this.getLocalizedString("SDBPatchAction.warning.shardgroup.message", homeImpl.getShardGroupName(), execEndTime);
                    break;
                }
                statusMsg = this.getLocalizedString("SDBPatchAction.warning.dg.message", homeImpl.getDrsetNumber(), execEndTime);
                break;
            }
            case success: {
                if (dbType.equals(ShardDBProductTypes.PRODUCT_TYPE_SIHA_SDB.getValue()) || dbType.equals(ShardDBProductTypes.PRODUCT_TYPE_CRS_SDB.getValue())) {
                    statusMsg = this.getLocalizedString("SDBPatchAction.success.grid.message", homeImpl.getLocation(), execEndTime);
                    break;
                }
                if (homeImpl.isOgg()) {
                    if (homeImpl.getShardingType().equalsIgnoreCase("user-defined") || isShdSpcOption) {
                        statusMsg = this.getLocalizedString("SDBPatchAction.success.shardspace.message", homeImpl.getShardSpaceName(), execEndTime);
                        break;
                    }
                    statusMsg = this.getLocalizedString("SDBPatchAction.success.shardgroup.message", homeImpl.getShardGroupName(), execEndTime);
                    break;
                }
                statusMsg = this.getLocalizedString("SDBPatchAction.success.dg.message", homeImpl.getDrsetNumber(), execEndTime);
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }
}

