/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.sdb;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.topology.DBHomeImpl;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.integration.controller.action.sdb.SDBPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.sdb.helper.SDBPatchActionHelper;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductSupport;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.shard.ShardDBProductTypes;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.lifecycle.InitPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class SDBShardEntityPatchAction
extends SDBPatchAction {
    @Override
    protected String createSteps(PatchTarget patchTarget) throws OPatchAutoException {
        String cmd = "";
        String oh = patchTarget.getHome().getLocation();
        String sessionId = this.getPatchSession().getProductSupportManager().getOptions().getOption("session").getValue();
        if (this.getPatchSession().getCommand().isResumed()) {
            try {
                if (SDBPatchActionHelper.isChildSessionPresent(oh, sessionId, true, this.getPatchSession().getCurrentGoal())) {
                    cmd = patchTarget.getHome().getLocation() + File.separator + DBCommonPatchingConstants.OPATCHAUTO_SCRIPT + " " + OPatchAutoCommand.resume + " -parentid " + sessionId;
                    this._logger.info("WARNING: This resume command must not be executed manually in the command line : " + cmd);
                    return cmd;
                }
            }
            catch (IOException e) {
                throw new OPatchAutoException((Throwable)e);
            }
        }
        String operation = "";
        if (this.getPatchSession().getCommand().isApply()) {
            operation = "apply";
        } else if (this.getPatchSession().getCommand().isRollback()) {
            operation = "rollback";
        }
        DBHomeImpl homeImpl = (DBHomeImpl)patchTarget.getHome();
        String dbName = homeImpl.getTargetName();
        cmd = this.getInitialCommand(patchTarget, operation);
        this.helper = new SDBPatchActionHelper();
        cmd = cmd + " -parentid " + sessionId;
        String dgKey = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.DG.getValue()).getArg();
        String shrdGrpKey = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.SHARD_GROUP.getValue()).getArg();
        String shrdSpcKey = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.SHARD_SPACE.getValue()).getArg();
        String shardGroupOption = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.SHARD_GROUP.getValue()).getValue();
        String shardSpaceOption = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.SHARD_SPACE.getValue()).getValue();
        String dgOption = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.DG.getValue()).getValue();
        cmd = !StringUtil.isNullOrEmpty((String)dgOption) ? cmd + " " + dgKey + " " + dbName : (!StringUtil.isNullOrEmpty((String)shardGroupOption) ? cmd + " " + shrdGrpKey + " " + homeImpl.getShardGroupName() : (!StringUtil.isNullOrEmpty((String)shardSpaceOption) ? (homeImpl.isOgg() ? cmd + " " + shrdSpcKey + " " + homeImpl.getShardSpaceName() : cmd + " " + dgKey + " " + dbName) : (homeImpl.isOgg() ? ("user-defined".equalsIgnoreCase(homeImpl.getShardingType()) ? cmd + " " + shrdSpcKey + " " + homeImpl.getShardSpaceName() : cmd + " " + shrdGrpKey + " " + homeImpl.getShardGroupName()) : cmd + " " + dgKey + " " + dbName)));
        String topologyKey = this.getPatchSession().getProductSupportManager().getOptions().getOption("topology").getArg();
        String dbTmpLocation = OPatchAutoHelper.getOPatchAutoHome() + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB_INSTANCE;
        String topologyFile = " " + topologyKey + " " + dbTmpLocation + "opatch_sdb_config.xml ";
        cmd = cmd + " " + topologyFile + " ";
        if (this.getPatchSession().getCurrentGoal().equals(InitPhase.Goal.init)) {
            cmd = cmd + " " + this.getPatchSession().getProductSupportManager().getOptions().getOption("analyze").getArg();
            if (!this.getPatchSession().isAnalyze()) {
                cmd = cmd + " " + this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.REPORT_ANALYZE_FAILURE.getValue()).getArg();
            }
        } else {
            cmd = cmd + " " + this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.DEPLOY_ONLY.getValue()).getArg();
        }
        if (!homeImpl.getOwner().equals(System.getProperty("user.name"))) {
            cmd = PatchActionUtil.runAsOwner(cmd, patchTarget, homeImpl.getOwner(), this.getPatchSession().getCredentialManager());
        }
        this._logger.info("WARNING: This command must not be executed manually in the command line : " + PatchActionUtil.replacePwdFrmCmd(cmd));
        return cmd;
    }

    @Override
    protected StringBuilder processCommandFailure(PatchTarget target, String outputMsg) {
        StringBuilder outputBuff = new StringBuilder();
        this.helper = new SDBPatchActionHelper();
        outputBuff.append((CharSequence)super.processCommandFailure(target, outputMsg));
        outputBuff.append("\n");
        return outputBuff;
    }

    protected StringBuilder processFailureOutput(DBPatchingSummaryCreator summaryCreator, PatchTarget target) throws OPatchAutoException {
        StringBuilder outputBuff = new StringBuilder();
        String summaryFileName = "shardpatchingsummary";
        this.populateFailureSummary(summaryCreator, target, outputBuff, summaryFileName);
        return outputBuff;
    }

    public void postExecute(PatchTarget patchTarget, PatchActionResult patchActionResult) throws OPatchAutoException {
        this.helper = new SDBPatchActionHelper();
        if (patchActionResult != null) {
            this._logger.info("IS RESUMED : " + this.getPatchSession().getCommand().isResumed());
            DBPatchingSummaryCreator summaryCreator = ((DBProductSupport)this.getPatchSession().getProductSupportManager().getProductSupport("db")).getDBPatchingSummaryCreator(this.getPatchSession().getCommand());
            StringBuilder summary = new StringBuilder();
            if (patchActionResult.getDetailsList() != null && !patchActionResult.getDetailsList().isEmpty() && this.getPatchSession().getPatchTracking() != null) {
                if (StringUtil.isNullOrEmpty((String)summary.toString())) {
                    for (String tmp : patchActionResult.getDetailsList()) {
                        StringBuilder summaryOutput = new StringBuilder();
                        if (patchActionResult.isFailure()) {
                            DBHomeImpl homeImpl = (DBHomeImpl)patchTarget.getHome();
                            if (!tmp.contains(this.getLocalizedString("PatchAction.patch.summaryfor.message", new Object[0]))) {
                                summary.append((CharSequence)this.helper.getSummarySubHeader(patchTarget, true, this.getPatchSession()));
                            }
                            summaryOutput = this.processFailureOutput(summaryCreator, patchTarget);
                            summary.append((CharSequence)summaryOutput);
                            if (summaryOutput == null || summaryOutput != null && !summaryOutput.toString().contains(homeImpl.getTargetName())) {
                                summary.append(tmp);
                                continue;
                            }
                            String dataGuardLog = this.getLocalizedString("PatchAction.dg.log.host", new Object[0]);
                            String shardGroupLog = this.getLocalizedString("PatchAction.shardgroup.log.host", new Object[0]);
                            String shardSpaceLog = this.getLocalizedString("PatchAction.shardspace.log.host", new Object[0]);
                            if (summaryOutput.indexOf(shardGroupLog) != -1 || summaryOutput.indexOf(shardSpaceLog) != -1 || summaryOutput.indexOf(dataGuardLog) != -1 || !tmp.contains(shardGroupLog) && !tmp.contains(shardSpaceLog) && !tmp.contains(dataGuardLog)) continue;
                            int index = 0;
                            String tempLogText = "";
                            if (tmp.contains(shardGroupLog)) {
                                index = tmp.indexOf(shardGroupLog);
                            } else if (tmp.contains(shardSpaceLog)) {
                                index = tmp.indexOf(shardSpaceLog);
                            } else if (tmp.contains(dataGuardLog)) {
                                index = tmp.indexOf(dataGuardLog);
                            }
                            tempLogText = tmp.substring(index);
                            summary.append("\n");
                            summary.append(tempLogText.substring(0, tempLogText.indexOf("\n")));
                            continue;
                        }
                        summaryOutput = this.processCommandOutput(summaryCreator, patchTarget, tmp);
                        summary.append((CharSequence)summaryOutput);
                    }
                }
                super.postExecute(patchTarget, patchActionResult, summary);
            }
        }
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        DBHomeImpl homeImpl = (DBHomeImpl)patchTarget.getHome();
        String execStartTime = PatchActionUtil.getCurrentDate();
        String execEndTime = PatchActionUtil.getCurrentDate();
        boolean isShdSpcOption = false;
        try {
            if (this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.SHARD_SPACE.getValue()).getValue() != null) {
                isShdSpcOption = true;
            }
        }
        catch (OPatchAutoException oPatchAutoException) {
            // empty catch block
        }
        switch (status) {
            case incomplete: {
                if (homeImpl.isOgg()) {
                    if (homeImpl.getShardingType().equalsIgnoreCase("user-defined") || isShdSpcOption) {
                        statusMsg = this.getLocalizedString("SDBPatchAction.start.shardspace.message", homeImpl.getShardSpaceName(), execStartTime);
                        break;
                    }
                    statusMsg = this.getLocalizedString("SDBPatchAction.start.shardgroup.message", homeImpl.getShardGroupName(), execStartTime);
                    break;
                }
                statusMsg = this.getLocalizedString("SDBPatchAction.start.dg.message", homeImpl.getDrsetNumber(), execStartTime);
                break;
            }
            case failure: {
                if (homeImpl.isOgg()) {
                    if (homeImpl.getShardingType().equalsIgnoreCase("user-defined") || isShdSpcOption) {
                        statusMsg = this.getLocalizedString("SDBPatchAction.failure.shardspace.message", homeImpl.getShardSpaceName(), execEndTime);
                        break;
                    }
                    statusMsg = this.getLocalizedString("SDBPatchAction.failure.shardgroup.message", homeImpl.getShardGroupName(), execEndTime);
                    break;
                }
                statusMsg = this.getLocalizedString("SDBPatchAction.failure.dg.message", homeImpl.getDrsetNumber(), execEndTime);
                break;
            }
            case warning: {
                if (homeImpl.isOgg()) {
                    if (homeImpl.getShardingType().equalsIgnoreCase("user-defined") || isShdSpcOption) {
                        statusMsg = this.getLocalizedString("SDBPatchAction.warning.shardspace.message", homeImpl.getShardSpaceName(), execEndTime);
                        break;
                    }
                    statusMsg = this.getLocalizedString("SDBPatchAction.warning.shardgroup.message", homeImpl.getShardGroupName(), execEndTime);
                    break;
                }
                statusMsg = this.getLocalizedString("SDBPatchAction.warning.dg.message", homeImpl.getDrsetNumber(), execEndTime);
                break;
            }
            case success: {
                if (homeImpl.isOgg()) {
                    if (homeImpl.getShardingType().equalsIgnoreCase("user-defined") || isShdSpcOption) {
                        statusMsg = this.getLocalizedString("SDBPatchAction.success.shardspace.message", homeImpl.getShardSpaceName(), execEndTime);
                        break;
                    }
                    statusMsg = this.getLocalizedString("SDBPatchAction.success.shardgroup.message", homeImpl.getShardGroupName(), execEndTime);
                    break;
                }
                statusMsg = this.getLocalizedString("SDBPatchAction.success.dg.message", homeImpl.getDrsetNumber(), execEndTime);
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(ShardDBProductTypes.PRODUCT_TYPE_PRIMARY.getValue());
        targetList.add(ShardDBProductTypes.PRODUCT_TYPE_OGG_DATABASE.getValue());
        return targetList;
    }
}

