/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.siha;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.TrackOOPSessions;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.OnlineAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OnlinePhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;

public class SIDBOnlineAction
extends OnlineAction {
    public SIDBOnlineAction() {
        super((Goal)OnlinePhase.Goal.product_patching);
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isRequired = super.isActionRequired(patchTarget);
        if (!isRequired) {
            return isRequired;
        }
        try {
            Boolean isSidb = Boolean.parseBoolean(this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB.getValue()).getValue());
            this._logger.info("isSidb: " + isSidb);
            if (isSidb != null && !isSidb.booleanValue()) {
                isRequired = false;
            }
        }
        catch (Exception e) {
            throw new PatchActionException("Exception : " + e.getMessage(), new Object[0]);
        }
        this._logger.info("isRequired: " + isRequired);
        return isRequired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public PatchActionResult execute(PatchTarget patchTarget) {
        PatchActionResult patchActionResult;
        block26: {
            patchActionResult = new PatchActionResult();
            ArrayList<ExecutionStep> preDatapatchSteps = new ArrayList<ExecutionStep>();
            List<ExecutionStep> datapatchSteps = new ArrayList<ExecutionStep>();
            ArrayList<ExecutionStep> postDatapatchSteps = new ArrayList<ExecutionStep>();
            ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
            String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
            boolean isTwelveVersion = DBPatchingUtil.isDBVersionTweleveOrLater(primarypatchVersion);
            List<ExecutionStep> steps = null;
            try {
                if (isTwelveVersion) {
                    steps = this.getStartRedoApplyCommandExecutionSteps(configGraph, patchTarget, null, "SIDatabase");
                    preDatapatchSteps.addAll(steps);
                }
                boolean actsOnClone = patchTarget.isUsingHomeClone();
                if (isTwelveVersion) {
                    List<ExecutionStep> tmpSteps;
                    boolean isSQLPatchInUpgradeMode = DBCommandUtils.isSQLPatchUpgradeMode();
                    boolean skipDatapatch = this.getPatchSession().getProductSupportManager().getOptions().getOption("skip.datapatch").isSwitchEnabled();
                    if (skipDatapatch) {
                        this._logger.info("Datapatch steps will be skipped since the option -skip_datapatch has been used.\n");
                    }
                    boolean isSidbOnlyPatching = this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB.getValue()).isSwitchEnabled();
                    Boolean isShardSidbOnlyPatching = this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB_ONLY.getValue()).isSwitchEnabled();
                    if (isSQLPatchInUpgradeMode && !isSidbOnlyPatching && !isShardSidbOnlyPatching.booleanValue() && this.isSQLUpgrdeModeCommandRequired(tmpSteps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchStartupUpgradeMode.toString(), "SIDatabase", "SQL-Startup-Upgrade-Mode-Step-Title", actsOnClone))) {
                        steps = this.getStopStartOracleHomeCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.stop.toString(), "sidb", ServiceStatus.DOWN, "OracleHome", "Stop-Home-Title", "Stop-Home-Message");
                        preDatapatchSteps.addAll(steps);
                        preDatapatchSteps.addAll(tmpSteps);
                        steps = this.getUpgradePDBStateCommandExecutionSteps(configGraph, patchTarget, "SIDatabase");
                        preDatapatchSteps.addAll(steps);
                    }
                    if (!skipDatapatch) {
                        datapatchSteps = this.getPatchSession().isRollback() ? this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchRollback.toString(), "SIDatabase", actsOnClone) : this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchApply.toString(), "SIDatabase", actsOnClone);
                    }
                    if (datapatchSteps.isEmpty()) {
                        this.sqlActionNotRequired = true;
                        String msg = "No sqlpatch operations are required on the local node for this home";
                        this._logger.info(msg + " : " + patchTarget.getHome(true).getLocation());
                    } else {
                        this._logger.info("datapatch will be run on " + datapatchSteps.size() + " instances.");
                    }
                    if (isSQLPatchInUpgradeMode && !isSidbOnlyPatching && !isShardSidbOnlyPatching.booleanValue() && this.isSQLUpgrdeModeCommandRequired(datapatchSteps)) {
                        steps = this.getStopStartOracleHomeCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.start.toString(), "sidb", ServiceStatus.UP, "OracleHome", "Start-Home-Title", "Start-Home-Message");
                        postDatapatchSteps.addAll(steps);
                        steps = this.getStartPDBStateCommandExecutionSteps(configGraph, patchTarget, "SIDatabase");
                        postDatapatchSteps.addAll(steps);
                    }
                }
            }
            catch (OPatchAutoException e) {
                this._logger.info(e.getMessage());
                patchActionResult = new PatchActionResult((Throwable)e);
                return patchActionResult;
            }
            boolean stepsGenerated = false;
            if (preDatapatchSteps != null && !preDatapatchSteps.isEmpty() || datapatchSteps != null && !datapatchSteps.isEmpty() || postDatapatchSteps != null && !postDatapatchSteps.isEmpty()) {
                stepsGenerated = true;
            }
            if (stepsGenerated) {
                this.preOperation(patchTarget);
                TrackOOPSessions.startPatchAction(patchTarget.getHome().getLocation(), ((Object)((Object)this)).getClass().getName());
            }
            if (preDatapatchSteps != null && !preDatapatchSteps.isEmpty()) {
                patchActionResult = this.executeSteps(preDatapatchSteps, patchTarget);
            }
            if (datapatchSteps != null && !datapatchSteps.isEmpty() && !patchActionResult.isFailure() && (patchActionResult = this.executeStepsInParallel(datapatchSteps, patchTarget)).isFailure()) {
                String session = this.getPatchSession().isRollback() ? this.getLocalizedString("rolledback.session.value", new Object[0]) : this.getLocalizedString("applied.session.value", new Object[0]);
                Reporting.report((String)this.getLocalizedString("SQLAction.sql.patch.warning", patchActionResult.getDetails(), session));
                patchActionResult = new PatchActionResult(PatchActionStatus.success);
            }
            if (postDatapatchSteps != null && !postDatapatchSteps.isEmpty() && !patchActionResult.isFailure()) {
                patchActionResult = this.executeSteps(postDatapatchSteps, patchTarget);
            }
            if (!stepsGenerated) break block26;
            try {
                this.postOperation(patchTarget);
            }
            catch (OPatchAutoException e) {
                this._logger.info(e.getMessage());
                patchActionResult = new PatchActionResult((Throwable)e);
            }
            TrackOOPSessions.endPatchAction(patchTarget.getHome().getLocation(), ((Object)((Object)this)).getClass().getName(), !patchActionResult.isFailure());
            break block26;
            catch (OPatchAutoException e) {
                try {
                    this._logger.info(e.getMessage());
                    patchActionResult = new PatchActionResult((Throwable)e);
                    if (!stepsGenerated) break block26;
                }
                catch (Throwable throwable) {
                    if (stepsGenerated) {
                        try {
                            this.postOperation(patchTarget);
                        }
                        catch (OPatchAutoException e2) {
                            this._logger.info(e2.getMessage());
                            patchActionResult = new PatchActionResult((Throwable)e2);
                        }
                        TrackOOPSessions.endPatchAction(patchTarget.getHome().getLocation(), ((Object)((Object)this)).getClass().getName(), !patchActionResult.isFailure());
                    }
                    throw throwable;
                }
                try {
                    this.postOperation(patchTarget);
                }
                catch (OPatchAutoException e3) {
                    this._logger.info(e3.getMessage());
                    patchActionResult = new PatchActionResult((Throwable)e3);
                }
                TrackOOPSessions.endPatchAction(patchTarget.getHome().getLocation(), ((Object)((Object)this)).getClass().getName(), !patchActionResult.isFailure());
            }
        }
        return patchActionResult;
    }

    @Override
    public List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ArrayList<ExecutionStep> generatedSteps = new ArrayList<ExecutionStep>();
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        boolean isTwelveVersion = DBPatchingUtil.isDBVersionTweleveOrLater(primarypatchVersion);
        List<ExecutionStep> steps = null;
        if (isTwelveVersion) {
            steps = this.getStartRedoApplyCommandExecutionSteps(configGraph, patchTarget, null, "SIDatabase");
            generatedSteps.addAll(steps);
        }
        boolean actsOnClone = patchTarget.isUsingHomeClone();
        if (isTwelveVersion) {
            List<ExecutionStep> tmpSteps;
            boolean isSQLPatchInUpgradeMode = DBCommandUtils.isSQLPatchUpgradeMode();
            boolean isSidbOnlyPatching = this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB.getValue()).isSwitchEnabled();
            Boolean isShardSidbOnlyPatching = this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB_ONLY.getValue()).isSwitchEnabled();
            if (isSQLPatchInUpgradeMode && !isSidbOnlyPatching && !isShardSidbOnlyPatching.booleanValue() && this.isSQLUpgrdeModeCommandRequired(tmpSteps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchStartupUpgradeMode.toString(), "SIDatabase", "SQL-Startup-Upgrade-Mode-Step-Title", actsOnClone))) {
                steps = this.getStopStartOracleHomeCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.stop.toString(), "sidb", ServiceStatus.DOWN, "OracleHome", "Stop-Home-Title", "Stop-Home-Message");
                generatedSteps.addAll(steps);
                generatedSteps.addAll(tmpSteps);
                steps = this.getUpgradePDBStateCommandExecutionSteps(configGraph, patchTarget, "SIDatabase");
                generatedSteps.addAll(steps);
            }
            steps = this.getPatchSession().isRollback() ? this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchRollback.toString(), "SIDatabase", actsOnClone) : this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchApply.toString(), "SIDatabase", actsOnClone);
            generatedSteps.addAll(steps);
            if (isSQLPatchInUpgradeMode && !isSidbOnlyPatching && !isShardSidbOnlyPatching.booleanValue() && this.isSQLUpgrdeModeCommandRequired(steps)) {
                steps = this.getStopStartOracleHomeCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.start.toString(), "sidb", ServiceStatus.UP, "OracleHome", "Start-Home-Title", "Start-Home-Message");
                generatedSteps.addAll(steps);
                steps = this.getStartPDBStateCommandExecutionSteps(configGraph, patchTarget, "SIDatabase");
                generatedSteps.addAll(steps);
            }
        }
        return generatedSteps;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        return targetList;
    }
}

