/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.siha;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.User;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.common.Host;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class SIDBPrePostScriptAction
extends DBCommonPatchAction {
    Logger logger = Logger.getLogger(SIDBPrePostScriptAction.class.getName());
    private static final String POSTPATCH_SH = "postpatch.sh";
    private static final String PREPATCH_SH = "prepatch.sh";

    public SIDBPrePostScriptAction() {
        super(new Goal[]{OfflinePhase.Goal.prepare, OfflinePhase.Goal.finalize});
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        boolean isRollbackPatchID = SessionData.getInstance().isRollbackPatchID();
        String patchInformation = null;
        if (isRollbackPatchID) {
            patchInformation = this.getPatchSession().getPatchId();
            this.logger.info("Rollback patch ids ::" + patchInformation);
        }
        if (isActionRequired && DBPatchingHelper.isOOPSwitchPatchingSession(this.getPatchSession().getOptions())) {
            isActionRequired = false;
        }
        return isActionRequired;
    }

    protected String getScriptName() {
        String prePostScriptCommandStr = OfflinePhase.Goal.prepare.equals((Object)this.getCurrentGoal()) ? PREPATCH_SH : POSTPATCH_SH;
        return prePostScriptCommandStr;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        String sourceHome = patchTarget.getHome(true).getLocation();
        this.logger.info("sourceHome ::" + sourceHome);
        String targetHome = patchTarget.getHome().getLocation();
        this.logger.info("targetHome ::" + targetHome);
        sourceHome = sourceHome.replaceAll("/+$", "");
        ArrayList<ExecutionStep> executionList = new ArrayList<ExecutionStep>();
        ArrayList<String> filePath = new ArrayList<String>();
        StringBuilder prepostScriptCmd = new StringBuilder();
        String mainPatchLoc = "";
        boolean isRollbackPatchID = SessionData.getInstance().isRollbackPatchID();
        if (!isRollbackPatchID) {
            mainPatchLoc = PatchPlanner.getInstance().getOPlanEnv().getBundlePatchloc().getAbsolutePath();
        }
        for (OPatchPatchInfo patchInfo : SessionData.getInstance().getAnalyzedPatchList(sourceHome)) {
            String patchLocation = patchInfo.getPatchLocation();
            String patchId = patchInfo.getPatchID();
            if (this.getPatchSession().isRollback()) {
                if (!isRollbackPatchID) {
                    patchLocation = mainPatchLoc + File.separator + patchId;
                    File f = new File(patchLocation);
                    if (!f.exists()) {
                        patchLocation = mainPatchLoc;
                    }
                } else {
                    try {
                        DBPatchingHelper.copyLatestPatchScripts(patchId, sourceHome);
                        patchLocation = sourceHome + "/opatchautocfg/db/dbtmp" + File.separator + patchId;
                    }
                    catch (Exception f) {
                        // empty catch block
                    }
                }
            }
            Logger.getLogger(SIDBPrePostScriptAction.class.getName()).info("PatchRoot: " + patchLocation);
            String path = patchLocation + File.separator + "custom" + File.separator + "scripts" + File.separator + this.getScriptName();
            File f = new File(path);
            if (!f.exists() || f.isDirectory()) continue;
            Logger.getLogger(SIDBPrePostScriptAction.class.getName()).info("path: " + path);
            filePath.add(path);
            StringBuilder cmd = new StringBuilder(path);
            cmd.append(" ");
            cmd.append("-dbhome");
            cmd.append(" ");
            cmd.append(targetHome);
            this.logger.info("SIDB PrePost script command generated ::" + cmd);
            ActionType actionType = new ActionType();
            ExecutionStep executionStep = new ExecutionStep(actionType);
            executionStep.getCommand().add(new ExecutionStep.Command(cmd.toString()));
            String ohOwner = null;
            ohOwner = !DBPatchingHelper.isStaticConfiguration(this.getPatchSession().getOptions()) ? OUIDriver.checkFileOwner((File)new File(patchTarget.getHome(true).getLocation(), "oraInst.loc")) : System.getProperty("user.name");
            User user = new User();
            user.setValue(ohOwner);
            executionStep.setUser(user);
            Host host = new Host();
            host.setDisplayName(patchTarget.getHost().getHost());
            host.setName(patchTarget.getHost().getHost());
            executionStep.setHost(host);
            executionList.add(executionStep);
        }
        return executionList;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        return targetList;
    }

    public boolean isAnalyzeSupported() {
        boolean isAnalyzeSupported = false;
        return isAnalyzeSupported;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("PrePostScriptAction." + this.getCurrentGoal().getName() + ".start.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("PrePostScriptAction." + this.getCurrentGoal().getName() + ".failure.message", patchTarget.toReportingString());
                break;
            }
            case warning: {
                statusMsg = "";
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("PrePostScriptAction." + this.getCurrentGoal().getName() + ".success.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }
}

