/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.siha;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBShutDownStartupAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.lifecycle.ShutdownPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SIDBPrepareShutDownAction
extends DBShutDownStartupAction {
    public SIDBPrepareShutDownAction() {
        super(new Goal[]{ShutdownPhase.Goal.prepare_shutdown, OfflinePhase.Goal.finalize_binary_patching});
    }

    public int getOrderingWeight(Goal goal) {
        if (goal.equals(OfflinePhase.Goal.finalize_binary_patching)) {
            return 30;
        }
        return super.getOrderingWeight(goal);
    }

    @Override
    public List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        List<ExecutionStep> generatedSteps = super.generateSteps(patchTarget);
        String primaryPatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        List<ExecutionStep> steps = null;
        if (DBPatchingUtil.isDBVersionEleven(primaryPatchVersion)) {
            steps = this.getStopStartDBConsoleCommandExecutionSteps(this.configGraph, patchTarget, "SIDatabase", DBShutDownStartupAction.StopStartOperation.STOP);
            generatedSteps.addAll(steps);
        }
        if (DBPatchingUtil.isVersionEqalOrlater(primaryPatchVersion, "12.1.0.2")) {
            steps = this.getSavePDBStateCommandExecutionSteps(this.configGraph, patchTarget, "SIDatabase");
            generatedSteps.addAll(steps);
        }
        return generatedSteps;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        return targetList;
    }
}

